/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.types.basic;

import java.util.HashMap;
import java.util.Map;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.SymbolLookup;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.basic.VtblAccess;

public abstract class BasicVtblAccess
implements VtblAccess {
    protected SymbolLookup symbolLookup;
    protected String[] dllNames;
    private Map typeToVtblMap = new HashMap();
    static Object nullAddress = new Object();

    public BasicVtblAccess(SymbolLookup symbolLookup, String[] dllNames) {
        this.symbolLookup = symbolLookup;
        this.dllNames = dllNames;
    }

    @Override
    public Address getVtblForType(Type type) {
        if (type == null) {
            return null;
        }
        Object result = this.typeToVtblMap.get(type);
        if (result == nullAddress) {
            return null;
        }
        if (result != null) {
            return (Address)result;
        }
        String vtblSymbol = this.vtblSymbolForType(type);
        if (vtblSymbol == null) {
            this.typeToVtblMap.put(type, nullAddress);
            return null;
        }
        for (int i = 0; i < this.dllNames.length; ++i) {
            Address addr = this.symbolLookup.lookup(this.dllNames[i], vtblSymbol);
            if (addr == null) continue;
            this.typeToVtblMap.put(type, addr);
            return addr;
        }
        this.typeToVtblMap.put(type, nullAddress);
        return null;
    }

    @Override
    public void clearCaches() {
        this.typeToVtblMap.clear();
    }

    protected abstract String vtblSymbolForType(Type var1);
}

