/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.enterprise.client;

import ca.sqlpower.object.AbstractSPObject;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.annotation.Accessor;
import ca.sqlpower.object.annotation.Constructor;
import ca.sqlpower.object.annotation.ConstructorParameter;
import ca.sqlpower.object.annotation.Mutator;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Grant
extends AbstractSPObject {
    public static List<Class<? extends SPObject>> allowedChildTypes = Collections.emptyList();
    private final String type;
    private final String subject;
    private final boolean createPrivilege;
    private final boolean modifyPrivilege;
    private final boolean deletePrivilege;
    private final boolean executePrivilege;
    private final boolean grantPrivilege;

    public Grant(@Nonnull Grant grant) {
        this(grant.getSubject(), grant.getType(), grant.isCreatePrivilege(), grant.isModifyPrivilege(), grant.isDeletePrivilege(), grant.isExecutePrivilege(), grant.isGrantPrivilege());
    }

    @Constructor
    public Grant(@Nullable @ConstructorParameter(propertyName="subject") String subject, @Nonnull @ConstructorParameter(propertyName="type") String type, @ConstructorParameter(propertyName="createPrivilege") boolean create, @ConstructorParameter(propertyName="modifyPrivilege") boolean modify, @ConstructorParameter(propertyName="deletePrivilege") boolean delete, @ConstructorParameter(propertyName="executePrivilege") boolean execute, @ConstructorParameter(propertyName="grantPrivilege") boolean grant) {
        this.subject = subject;
        this.type = type;
        this.createPrivilege = create;
        this.modifyPrivilege = modify;
        this.deletePrivilege = delete;
        this.executePrivilege = execute;
        this.grantPrivilege = grant;
    }

    public Grant(SPObject subject, boolean create, boolean modify, boolean delete, boolean execute, boolean grant) {
        this(subject.getUUID(), subject.getClass().getName(), create, modify, delete, execute, grant);
    }

    public Grant(String type, boolean create, boolean modify, boolean delete, boolean execute, boolean grant) {
        this(null, type, create, modify, delete, execute, grant);
    }

    @Override
    @Mutator
    public void setName(String name) {
    }

    @Override
    @Accessor
    public String getName() {
        if (this.subject != null) {
            return this.subject.concat(" - ").concat(this.getPermsString());
        }
        if (this.type != null) {
            return "All ".concat(this.type).concat(" - ").concat(this.getPermsString());
        }
        throw new RuntimeException("Badly constructed grant object.");
    }

    @Override
    protected boolean removeChildImpl(SPObject child) {
        return false;
    }

    @Override
    public List<Class<? extends SPObject>> getAllowedChildTypes() {
        return Collections.emptyList();
    }

    @Override
    public List<? extends SPObject> getChildren() {
        return Collections.emptyList();
    }

    public List<SPObject> getDependencies() {
        return Collections.emptyList();
    }

    @Override
    public void removeDependency(SPObject dependency) {
    }

    @Accessor
    public boolean isCreatePrivilege() {
        return this.createPrivilege;
    }

    @Accessor
    public boolean isModifyPrivilege() {
        return this.modifyPrivilege;
    }

    @Accessor
    public boolean isDeletePrivilege() {
        return this.deletePrivilege;
    }

    @Accessor
    public boolean isExecutePrivilege() {
        return this.executePrivilege;
    }

    @Accessor
    public boolean isGrantPrivilege() {
        return this.grantPrivilege;
    }

    public boolean isReadOnly() {
        return this.executePrivilege && !this.createPrivilege && !this.modifyPrivilege && !this.deletePrivilege && !this.grantPrivilege;
    }

    public boolean hasPermissions() {
        return this.executePrivilege || this.createPrivilege || this.modifyPrivilege || this.deletePrivilege || this.grantPrivilege;
    }

    @Accessor
    public String getType() {
        return this.type;
    }

    @Accessor
    public String getSubject() {
        return this.subject;
    }

    public String getPermsString() {
        StringBuilder sb = new StringBuilder("");
        if (this.createPrivilege) {
            sb.append("C");
        }
        if (this.modifyPrivilege) {
            sb.append("M");
        }
        if (this.deletePrivilege) {
            sb.append("D");
        }
        if (this.executePrivilege) {
            sb.append("E");
        }
        if (this.grantPrivilege) {
            sb.append("G");
        }
        return sb.toString();
    }

    public boolean isSystemLevel() {
        return this.subject == null;
    }
}

