/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.xmpp;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jitsi.jicofo.ConferenceStore;
import org.jitsi.jicofo.JicofoServices;
import org.jitsi.jicofo.conference.JitsiMeetConference;
import org.jitsi.jicofo.xmpp.AbstractIqHandler;
import org.jitsi.jicofo.xmpp.IqProcessingResult;
import org.jitsi.jicofo.xmpp.IqRequest;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.xmpp.extensions.jibri.JibriIq;
import org.jitsi.xmpp.util.XmlStringBuilderUtil;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/jitsi/jicofo/xmpp/JibriIqHandler;", "Lorg/jitsi/jicofo/xmpp/AbstractIqHandler;", "Lorg/jitsi/xmpp/extensions/jibri/JibriIq;", "connections", "", "Lorg/jivesoftware/smack/AbstractXMPPConnection;", "conferenceStore", "Lorg/jitsi/jicofo/ConferenceStore;", "(Ljava/util/Set;Lorg/jitsi/jicofo/ConferenceStore;)V", "logger", "Lorg/jitsi/utils/logging2/Logger;", "getLogger", "()Lorg/jitsi/utils/logging2/Logger;", "handleRequest", "Lorg/jitsi/jicofo/xmpp/IqProcessingResult;", "request", "Lorg/jitsi/jicofo/xmpp/IqRequest;", "jicofo"})
@SourceDebugExtension(value={"SMAP\nJibriIqHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JibriIqHandler.kt\norg/jitsi/jicofo/xmpp/JibriIqHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n1855#2,2:78\n*S KotlinDebug\n*F\n+ 1 JibriIqHandler.kt\norg/jitsi/jicofo/xmpp/JibriIqHandler\n*L\n60#1:78,2\n*E\n"})
public final class JibriIqHandler
extends AbstractIqHandler<JibriIq> {
    @NotNull
    private final ConferenceStore conferenceStore;
    @NotNull
    private final Logger logger;

    public JibriIqHandler(@NotNull Set<? extends AbstractXMPPConnection> connections, @NotNull ConferenceStore conferenceStore) {
        Intrinsics.checkNotNullParameter(connections, "connections");
        Intrinsics.checkNotNullParameter(conferenceStore, "conferenceStore");
        super(connections, "jibri", "http://jitsi.org/protocol/jibri", SetsKt.setOf(IQ.Type.set), IQRequestHandler.Mode.sync);
        this.conferenceStore = conferenceStore;
        this.logger = LoggerExtensionsKt.createLogger$default(this, null, null, 3, null);
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @Override
    @NotNull
    public IqProcessingResult handleRequest(@NotNull IqRequest<JibriIq> request) {
        Intrinsics.checkNotNullParameter(request, "request");
        Iterable $this$forEach$iv = this.conferenceStore.getAllConferences();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IqProcessingResult result;
            JitsiMeetConference conference = (JitsiMeetConference)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(conference.handleJibriRequest(request), "handleJibriRequest(...)");
            if (!((result instanceof IqProcessingResult.AcceptedWithResponse ? true : result instanceof IqProcessingResult.AcceptedWithNoResponse) ? true : result instanceof IqProcessingResult.RejectedWithError)) continue;
            return result;
        }
        this.logger.warn("Jibri IQ not accepted by any conference: " + XmlStringBuilderUtil.Companion.toStringOpt(request.getIq()));
        JicofoServices jicofoServices = JicofoServices.Companion.getJicofoServicesSingleton();
        if ((jicofoServices != null ? jicofoServices.getJibriDetector() : null) == null) {
            JicofoServices jicofoServices2 = JicofoServices.Companion.getJicofoServicesSingleton();
            if ((jicofoServices2 != null ? jicofoServices2.getSipJibriDetector() : null) == null) {
                this.logger.warn("No jibri detectors configured.");
            }
        }
        return new IqProcessingResult.RejectedWithError(request, StanzaError.Condition.item_not_found);
    }
}

