/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Component;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.actions.SaveActionBase;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.gui.widgets.NativeFileChooser;
import org.openstreetmap.josm.gui.widgets.SwingFileChooser;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.PlatformManager;

public class FileChooserManager {
    public static final BooleanProperty PROP_USE_NATIVE_FILE_DIALOG = new BooleanProperty("use.native.file.dialog", PlatformManager.isPlatformOsx());
    private final boolean open;
    private final String lastDirProperty;
    private final String curDir;
    private boolean multiple;
    private String title;
    private Collection<? extends FileFilter> filters;
    private FileFilter defaultFilter;
    private int selectionMode = 0;
    private String extension;
    private Predicate<ExtensionFileFilter> additionalTypes = ignore -> false;
    private File file;
    private AbstractFileChooser fc;

    public FileChooserManager() {
        this(false, null, null);
    }

    public FileChooserManager(boolean open) {
        this(open, null);
    }

    public FileChooserManager(boolean open, String lastDirProperty) {
        this(open, lastDirProperty, null);
    }

    public FileChooserManager(boolean open, String lastDirProperty, String defaultDir) {
        this.open = open;
        String string = this.lastDirProperty = lastDirProperty == null || lastDirProperty.isEmpty() ? "lastDirectory" : lastDirProperty;
        this.curDir = Config.getPref().get(this.lastDirProperty).isEmpty() ? (defaultDir == null || defaultDir.isEmpty() ? "." : defaultDir) : Config.getPref().get(this.lastDirProperty);
    }

    public final AbstractFileChooser getFileChooser() {
        return this.fc;
    }

    public final String getInitialDirectory() {
        return this.curDir;
    }

    public final FileChooserManager createFileChooser() {
        return this.doCreateFileChooser();
    }

    public final FileChooserManager createFileChooser(boolean multiple, String title, FileFilter filter, int selectionMode) {
        this.multiple(multiple);
        this.title(title);
        this.filters(Collections.singleton(filter));
        this.defaultFilter(filter);
        this.selectionMode(selectionMode);
        this.doCreateFileChooser();
        this.fc.setAcceptAllFileFilterUsed(false);
        return this;
    }

    public final FileChooserManager createFileChooser(boolean multiple, String title, Collection<? extends FileFilter> filters, FileFilter defaultFilter, int selectionMode) {
        this.multiple(multiple);
        this.title(title);
        this.filters(filters);
        this.defaultFilter(defaultFilter);
        this.selectionMode(selectionMode);
        return this.doCreateFileChooser();
    }

    public final FileChooserManager createFileChooser(boolean multiple, String title, String extension, boolean allTypes, int selectionMode) {
        this.multiple(multiple);
        this.title(title);
        this.extension(extension);
        this.allTypes(allTypes);
        this.selectionMode(selectionMode);
        return this.doCreateFileChooser();
    }

    public FileChooserManager multiple(boolean value) {
        this.multiple = value;
        return this;
    }

    public FileChooserManager title(String value) {
        this.title = value;
        return this;
    }

    public FileChooserManager filters(Collection<? extends FileFilter> value) {
        this.filters = value;
        return this;
    }

    public FileChooserManager defaultFilter(FileFilter value) {
        this.defaultFilter = value;
        return this;
    }

    public FileChooserManager selectionMode(int value) {
        this.selectionMode = value;
        return this;
    }

    public FileChooserManager extension(String value) {
        this.extension = value;
        return this;
    }

    public FileChooserManager additionalTypes(Predicate<ExtensionFileFilter> value) {
        this.additionalTypes = value;
        return this;
    }

    public FileChooserManager allTypes(boolean value) {
        this.additionalTypes = ignore -> value;
        return this;
    }

    public FileChooserManager file(File value) {
        this.file = value;
        return this;
    }

    public FileChooserManager doCreateFileChooser() {
        File f = new File(this.curDir);
        this.fc = PROP_USE_NATIVE_FILE_DIALOG.get() != false && NativeFileChooser.supportsSelectionMode(this.selectionMode) ? new NativeFileChooser(f) : new SwingFileChooser(f);
        if (this.title != null) {
            this.fc.setDialogTitle(this.title);
        }
        this.fc.setFileSelectionMode(this.selectionMode);
        this.fc.setMultiSelectionEnabled(this.multiple);
        this.fc.setAcceptAllFileFilterUsed(false);
        this.fc.setSelectedFile(this.file);
        if (this.filters != null) {
            for (FileFilter fileFilter : this.filters) {
                this.fc.addChoosableFileFilter(fileFilter);
            }
            if (this.defaultFilter != null) {
                this.fc.setFileFilter(this.defaultFilter);
            }
        } else if (this.open) {
            ExtensionFileFilter.applyChoosableImportFileFilters(this.fc, this.extension, this.additionalTypes);
        } else {
            ExtensionFileFilter.applyChoosableExportFileFilters(this.fc, this.extension, this.additionalTypes);
        }
        return this;
    }

    public final AbstractFileChooser openFileChooser() {
        return this.openFileChooser(null);
    }

    public AbstractFileChooser openFileChooser(Component parent) {
        int answer;
        if (this.fc == null) {
            this.doCreateFileChooser();
        }
        if (parent == null) {
            parent = MainApplication.getMainFrame();
        }
        int n = answer = this.open ? this.fc.showOpenDialog(parent) : this.fc.showSaveDialog(parent);
        if (answer != 0) {
            return null;
        }
        if (!this.fc.getCurrentDirectory().getAbsolutePath().equals(this.curDir)) {
            Config.getPref().put(this.lastDirProperty, this.fc.getCurrentDirectory().getAbsolutePath());
        }
        if (!(this.open || PROP_USE_NATIVE_FILE_DIALOG.get().booleanValue() || SaveActionBase.confirmOverwrite(this.fc.getSelectedFile()))) {
            return null;
        }
        return this.fc;
    }

    public File getFileForSave() {
        return SaveActionBase.checkFileAndConfirmOverWrite(this.openFileChooser(), this.extension);
    }
}

