/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.component;

import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.MessageFactory;
import jakarta.faces.component.SelectItemsIterator;
import jakarta.faces.component.SelectUtils;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIForm;
import jakarta.faces.component.UIInput;
import jakarta.faces.component.visit.VisitContext;
import jakarta.faces.component.visit.VisitResult;
import jakarta.faces.context.FacesContext;
import java.io.Serializable;

public class UISelectOne
extends UIInput {
    public static final String COMPONENT_TYPE = "jakarta.faces.SelectOne";
    public static final String COMPONENT_FAMILY = "jakarta.faces.SelectOne";
    public static final String INVALID_MESSAGE_ID = "jakarta.faces.component.UISelectOne.INVALID";

    public UISelectOne() {
        this.setRendererType("jakarta.faces.Menu");
    }

    @Override
    public String getFamily() {
        return "jakarta.faces.SelectOne";
    }

    public String getGroup() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.group));
    }

    public void setGroup(String group) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.group), group);
    }

    @Override
    public void processValidators(FacesContext context) {
        String group = this.getGroup();
        if (group != null && UISelectOne.isEmpty(this.getSubmittedValue())) {
            String clientId = this.getClientId(context);
            UIComponent groupContainer = UISelectOne.getGroupContainer(context, this);
            boolean[] alreadySubmittedOrValidatedAsGroup = new boolean[1];
            groupContainer.visitTree(VisitContext.createVisitContext(context), (visitContext, target) -> {
                UISelectOne radio;
                if (target instanceof UISelectOne && UISelectOne.isOtherMemberOfSameGroup(context, group, clientId, radio = (UISelectOne)target) && UISelectOne.isAlreadySubmittedOrValidated(radio)) {
                    alreadySubmittedOrValidatedAsGroup[0] = true;
                    return VisitResult.COMPLETE;
                }
                return VisitResult.ACCEPT;
            });
            if (alreadySubmittedOrValidatedAsGroup[0]) {
                return;
            }
        }
        super.processValidators(context);
    }

    private static UIComponent getGroupContainer(FacesContext context, UISelectOne radio) {
        UIComponent namingContainer = radio.getNamingContainer();
        while (namingContainer != null && !(namingContainer instanceof UIForm) && namingContainer.getParent() != null) {
            namingContainer = namingContainer.getParent().getNamingContainer();
        }
        return namingContainer != null ? namingContainer : context.getViewRoot();
    }

    private static boolean isOtherMemberOfSameGroup(FacesContext context, String group, String clientId, UISelectOne radio) {
        return group.equals(radio.getGroup()) && !clientId.equals(radio.getClientId(context));
    }

    private static boolean isAlreadySubmittedOrValidated(EditableValueHolder input) {
        return !UISelectOne.isEmpty(input.getSubmittedValue()) || input.isLocalValueSet() || !input.isValid();
    }

    @Override
    protected void validateValue(FacesContext context, Object value) {
        super.validateValue(context, value);
        if (!this.isValid() || value == null) {
            return;
        }
        boolean found = SelectUtils.matchValue(this.getFacesContext(), this, value, new SelectItemsIterator(context, this), this.getConverter());
        boolean isNoSelection = SelectUtils.valueIsNoSelectionOption(this.getFacesContext(), this, value, new SelectItemsIterator(context, this), this.getConverter());
        if (!found || this.isRequired() && isNoSelection) {
            FacesMessage message = MessageFactory.getMessage(context, INVALID_MESSAGE_ID, MessageFactory.getLabel(context, this));
            context.addMessage(this.getClientId(context), message);
            this.setValid(false);
        }
    }

    static enum PropertyKeys {
        group;

    }
}

