/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.spi.project.ParentProjectProvider;
import org.netbeans.spi.project.RootProjectProvider;
import org.openide.filesystems.FileObject;

public class MavenParentRootImpl
implements ParentProjectProvider,
RootProjectProvider {
    private final Project project;
    private Reference<Project> parent = new WeakReference<Object>(null);
    private Reference<Project> root = new WeakReference<Object>(null);
    private static final WeakReference<Project> NO_PROJECT = new WeakReference<Object>(null);

    public MavenParentRootImpl(Project proj) {
        this.project = proj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project getPartentProject() {
        MavenParentRootImpl mavenParentRootImpl = this;
        synchronized (mavenParentRootImpl) {
            if (this.parent == NO_PROJECT) {
                return null;
            }
            Project fromCache = this.parent.get();
            if (fromCache != null) {
                return fromCache;
            }
        }
        Project found = MavenParentRootImpl.findParentProject(this.project, this.project);
        MavenParentRootImpl mavenParentRootImpl2 = this;
        synchronized (mavenParentRootImpl2) {
            this.parent = found == null ? NO_PROJECT : new WeakReference<Project>(found);
        }
        return found;
    }

    private static Project findParentProject(Project from, Project toFind) {
        FileObject dir = from.getProjectDirectory();
        FileObject findDir = toFind.getProjectDirectory();
        if (dir == null) {
            return null;
        }
        FileObject parentDir = dir.getParent();
        if (parentDir == null) {
            return null;
        }
        Project parentProj = FileOwnerQuery.getOwner((FileObject)parentDir);
        if (parentProj == null) {
            return null;
        }
        FileObject parentProjDir = parentProj.getProjectDirectory();
        NbMavenProject parentMaven = (NbMavenProject)parentProj.getLookup().lookup(NbMavenProject.class);
        if (parentMaven == null) {
            return null;
        }
        for (String s : parentMaven.getMavenProject().getModules()) {
            FileObject child = parentProjDir.getFileObject(s);
            if (!findDir.equals(child)) continue;
            return parentProj;
        }
        return MavenParentRootImpl.findParentProject(parentProj, toFind);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project getRootProject() {
        Project parent;
        MavenParentRootImpl mavenParentRootImpl = this;
        synchronized (mavenParentRootImpl) {
            if (this.root == NO_PROJECT) {
                return null;
            }
            Project r = this.root.get();
            if (r != null) {
                return r;
            }
        }
        Project that = this.project;
        while ((parent = MavenParentRootImpl.findParentProject(that, that)) != null && parent != that) {
            that = parent;
        }
        MavenParentRootImpl mavenParentRootImpl2 = this;
        synchronized (mavenParentRootImpl2) {
            this.root = new WeakReference<Project>(that);
        }
        return that;
    }
}

