/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.fish.payara.jakarta.transformer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.fish.payara.jakarta.transformer.TransformerWizardPanel;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class TransformerPanelVisual
extends JPanel {
    private final TransformerWizardPanel panel;
    private boolean override;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JCheckBox overrideCheckBox;
    private JButton selectSourceButton;
    private JButton selectTargetButton;
    private JTextField source;
    private JTextField target;

    public TransformerPanelVisual(final TransformerWizardPanel panel) {
        this.initComponents();
        this.panel = panel;
        DocumentListener updateListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                panel.fireChangeEvent();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                panel.fireChangeEvent();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                panel.fireChangeEvent();
            }
        };
        this.source.getDocument().addDocumentListener(updateListener);
        this.target.getDocument().addDocumentListener(updateListener);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.selectSourceButton = new JButton();
        this.source = new JTextField();
        this.target = new JTextField();
        this.selectTargetButton = new JButton();
        this.overrideCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(TransformerPanelVisual.class, (String)"transformerPanelVisual.jLabel1.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(TransformerPanelVisual.class, (String)"transformerPanelVisual.jLabel2.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.selectSourceButton, (String)NbBundle.getMessage(TransformerPanelVisual.class, (String)"transformerPanelVisual.selectSourceFolder.text"));
        this.selectSourceButton.setActionCommand(NbBundle.getMessage(TransformerPanelVisual.class, (String)"transformerPanelVisual.selectSourceFolder.actionCommand"));
        this.selectSourceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TransformerPanelVisual.this.selectSourceButtonActionPerformed(evt);
            }
        });
        this.source.setName("source");
        this.target.setName("target");
        Mnemonics.setLocalizedText((AbstractButton)this.selectTargetButton, (String)NbBundle.getMessage(TransformerPanelVisual.class, (String)"transformerPanelVisual.selectTargetFolder.text"));
        this.selectTargetButton.setActionCommand(NbBundle.getMessage(TransformerPanelVisual.class, (String)"transformerPanelVisual.selectTargetFolder.actionCommand"));
        this.selectTargetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TransformerPanelVisual.this.selectTargetButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.overrideCheckBox, (String)NbBundle.getMessage(TransformerPanelVisual.class, (String)"transformerPanelVisual.overrideCheckBox.text"));
        this.overrideCheckBox.setToolTipText(NbBundle.getMessage(TransformerPanelVisual.class, (String)"transformerPanelVisual.overrideCheckBox.tooltip"));
        this.overrideCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TransformerPanelVisual.this.overrideCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.source, -1, 310, Short.MAX_VALUE).addComponent(this.target)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.selectSourceButton, GroupLayout.Alignment.TRAILING).addComponent(this.selectTargetButton, GroupLayout.Alignment.TRAILING))).addGroup(layout.createSequentialGroup().addComponent(this.overrideCheckBox).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.selectSourceButton).addComponent(this.source, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.target, -2, -1, -2).addComponent(this.selectTargetButton)).addGap(18, 18, 18).addComponent(this.overrideCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void selectSourceButtonActionPerformed(ActionEvent evt) {
        String command = evt.getActionCommand();
        if ("BROWSE".equals(command)) {
            File f;
            JFileChooser chooser = new JFileChooser();
            chooser.setCurrentDirectory(chooser.getCurrentDirectory());
            chooser.setDialogTitle("Select source to transform");
            chooser.setFileSelectionMode(2);
            String path = this.source.getText();
            if (path.length() > 0 && (f = new File(path)).exists()) {
                chooser.setSelectedFile(f);
            }
            if (0 == chooser.showOpenDialog(this)) {
                File projectDir = chooser.getSelectedFile();
                this.source.setText(FileUtil.normalizeFile((File)projectDir).getAbsolutePath());
            }
            this.panel.fireChangeEvent();
        }
    }

    private void selectTargetButtonActionPerformed(ActionEvent evt) {
        String command = evt.getActionCommand();
        if ("BROWSE".equals(command)) {
            File f;
            JFileChooser chooser = new JFileChooser();
            chooser.setCurrentDirectory(chooser.getCurrentDirectory());
            chooser.setDialogTitle("Select Folder to Transform");
            chooser.setFileSelectionMode(2);
            String path = this.target.getText();
            if (path.length() > 0 && (f = new File(path)).exists()) {
                chooser.setSelectedFile(f);
            }
            if (0 == chooser.showOpenDialog(this)) {
                File projectDir = chooser.getSelectedFile();
                this.target.setText(FileUtil.normalizeFile((File)projectDir).getAbsolutePath());
            }
            this.panel.fireChangeEvent();
        }
    }

    private void overrideCheckBoxActionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equals("Override")) {
            if (this.overrideCheckBox.isSelected()) {
                this.target.setText("");
                this.target.setEnabled(false);
                this.selectTargetButton.setEnabled(false);
                this.override = true;
            } else {
                this.target.setEnabled(true);
                this.selectTargetButton.setEnabled(true);
                this.override = false;
            }
            this.panel.fireChangeEvent();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
    }

    boolean valid(WizardDescriptor wizardDescriptor) throws WizardValidationException {
        return this.validate(wizardDescriptor);
    }

    void store(WizardDescriptor d) {
        d.putProperty("sourceSelected", (Object)this.source.getText().trim());
        d.putProperty("targetSelected", (Object)this.target.getText().trim());
        d.putProperty("override", (Object)this.override);
    }

    void read(WizardDescriptor settings) {
    }

    boolean validate(WizardDescriptor d) throws WizardValidationException {
        String source = this.source.getText().trim();
        String target = this.target.getText().trim();
        File sourceFile = new File(source);
        File targetFile = new File(target);
        if (source.isEmpty()) {
            d.putProperty("WizardPanel_errorMessage", (Object)"You must select a source folder or file.");
            return false;
        }
        if (!sourceFile.exists()) {
            d.putProperty("WizardPanel_errorMessage", (Object)"You must select a valid source folder or file.");
            return false;
        }
        if (this.override && target.isEmpty()) {
            d.putProperty("WizardPanel_errorMessage", null);
            return true;
        }
        if (!this.override && target.isEmpty()) {
            d.putProperty("WizardPanel_errorMessage", (Object)"You must select a target folder or file.");
            return false;
        }
        if (!this.override && sourceFile.isDirectory()) {
            if (!targetFile.exists()) {
                d.putProperty("WizardPanel_errorMessage", (Object)"You must select a valid target folder.");
                return false;
            }
            if (!targetFile.isDirectory()) {
                d.putProperty("WizardPanel_errorMessage", (Object)"You must select a target folder.");
                return false;
            }
        }
        if (!this.override && sourceFile.isFile()) {
            if (!targetFile.exists()) {
                d.putProperty("WizardPanel_errorMessage", (Object)"You must select a valid target file.");
                return false;
            }
            if (!targetFile.isDirectory()) {
                d.putProperty("WizardPanel_errorMessage", (Object)"You must select a target directory.");
                return false;
            }
        }
        if (!source.isEmpty() && !target.isEmpty()) {
            d.putProperty("WizardPanel_errorMessage", null);
        }
        return true;
    }
}

