/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.spi.java.queries.CompilerOptionsQueryImplementation;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.WeakListeners;

public class CompilerOptionsQueryImpl
implements CompilerOptionsQueryImplementation {
    private final NbModuleProject project;
    private final AtomicReference<CompilerOptionsQueryImplementation.Result> cachedResult = new AtomicReference();

    public CompilerOptionsQueryImpl(NbModuleProject project) {
        this.project = project;
    }

    public CompilerOptionsQueryImplementation.Result getOptions(FileObject file) {
        CompilerOptionsQueryImplementation.Result result = this.cachedResult.get();
        if (result == null) {
            result = this.cachedResult.updateAndGet(existing -> existing != null ? existing : new ResultImpl(this.project));
        }
        return result;
    }

    private static class ResultImpl
    extends CompilerOptionsQueryImplementation.Result
    implements PropertyChangeListener {
        private static final Pattern SPACE_SPLIT = Pattern.compile(" +");
        private final PropertyEvaluator evaluator;
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private List<? extends String> cachedArguments;

        public ResultImpl(NbModuleProject project) {
            this.evaluator = project.evaluator();
            this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.evaluator));
        }

        public synchronized List<? extends String> getArguments() {
            List<String> result = this.cachedArguments;
            if (result == null) {
                Map properties = this.evaluator.getProperties();
                Object compilerArgs = properties.getOrDefault("javac.compilerargs", "") + " " + properties.getOrDefault("javac.internal.extra.compilerargs", "");
                result = ((String)(compilerArgs = ((String)compilerArgs).trim())).isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(SPACE_SPLIT.split((CharSequence)compilerArgs)));
                this.cachedArguments = result;
            }
            return result;
        }

        public void addChangeListener(ChangeListener listener) {
            this.cs.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.cs.removeChangeListener(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            ResultImpl resultImpl = this;
            synchronized (resultImpl) {
                this.cachedArguments = null;
            }
            this.cs.fireChange();
        }
    }
}

