/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.adm;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import org.openide.util.NbPreferences;

class DefaultKnowledgeBaseStorage
implements PreferenceChangeListener {
    private static final String KEY_KNOWLEDGEBASEID = "default_knowledge_base";
    private static final String KEY_COMPARTMENTID = "default_compartment";
    private static DefaultKnowledgeBaseStorage INSTANCE;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private String knowledgeBaseId;
    private String compartmentId;

    private DefaultKnowledgeBaseStorage() {
        NbPreferences.root().addPreferenceChangeListener(this);
        this.knowledgeBaseId = NbPreferences.root().get(KEY_KNOWLEDGEBASEID, null);
        this.compartmentId = NbPreferences.root().get(KEY_COMPARTMENTID, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultKnowledgeBaseStorage getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<DefaultKnowledgeBaseStorage> clazz = DefaultKnowledgeBaseStorage.class;
        synchronized (DefaultKnowledgeBaseStorage.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new DefaultKnowledgeBaseStorage();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public void setAsDefault(String compartmentId, String knowledgeBaseId) {
        NbPreferences.root().put(KEY_KNOWLEDGEBASEID, knowledgeBaseId);
        NbPreferences.root().put(KEY_COMPARTMENTID, compartmentId);
    }

    public String getDefaultKnowledgeBaseId() {
        return NbPreferences.root().get(KEY_KNOWLEDGEBASEID, null);
    }

    public String getDefaultCompartmentId() {
        return NbPreferences.root().get(KEY_COMPARTMENTID, null);
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt.getKey().equals(KEY_KNOWLEDGEBASEID)) {
            this.pcs.firePropertyChange(KEY_KNOWLEDGEBASEID, this.knowledgeBaseId, evt.getNewValue());
            this.knowledgeBaseId = evt.getNewValue();
        }
        if (evt.getKey().equals(KEY_COMPARTMENTID)) {
            this.pcs.firePropertyChange(KEY_COMPARTMENTID, this.compartmentId, evt.getNewValue());
            this.compartmentId = evt.getNewValue();
        }
    }

    public void addChangeListener(PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(pcl);
    }

    public void removeChangeListener(PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(pcl);
    }
}

