/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.refactoring;

import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.j2ee.jpa.refactoring.EntityAnnotationReference;
import org.netbeans.modules.j2ee.jpa.refactoring.RefactoringUtil;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.OneToMany;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;

public class EntityAssociationResolver {
    static final String ONE_TO_ONE = "javax.persistence.OneToOne";
    static final String ONE_TO_MANY = "javax.persistence.OneToMany";
    static final String MANY_TO_ONE = "javax.persistence.ManyToOne";
    static final String MANY_TO_MANY = "javax.persistence.ManyToMany";
    private static final List<String> ANNOTATIONS = Arrays.asList("javax.persistence.OneToOne", "javax.persistence.OneToMany", "javax.persistence.ManyToOne", "javax.persistence.ManyToMany");
    static final String MAPPED_BY = "mappedBy";
    static final String TARGET_ENTITY = "targetEntity";
    private final MetadataModel<EntityMappingsMetadata> entityMappingsModel;
    private final TreePathHandle refactoringSource;

    public EntityAssociationResolver(TreePathHandle refactoringSource, MetadataModel<EntityMappingsMetadata> entityMappingsModel) {
        Parameters.notNull((CharSequence)"entityMappingsModel", entityMappingsModel);
        Parameters.notNull((CharSequence)"refactoringSource", (Object)refactoringSource);
        this.entityMappingsModel = entityMappingsModel;
        this.refactoringSource = refactoringSource;
    }

    public List<EntityAnnotationReference> resolveReferences() throws IOException {
        final ArrayList<EntityAnnotationReference> result = new ArrayList<EntityAnnotationReference>();
        final List<Reference> references = this.getReferringProperties();
        this.entityMappingsModel.runReadAction((MetadataModelAction)new MetadataModelAction<EntityMappingsMetadata, Void>(){

            public Void run(EntityMappingsMetadata metadata) throws Exception {
                for (Reference reference : references) {
                    Entity entity = EntityAssociationResolver.this.getByClass(metadata.getRoot().getEntity(), reference.getClassName());
                    if (entity == null) continue;
                    result.addAll(EntityAssociationResolver.this.getOneToX(entity, reference));
                }
                return null;
            }
        });
        return result;
    }

    private List<EntityAnnotationReference> getOneToX(Entity entity, Reference reference) throws IOException {
        ArrayList<EntityAnnotationReference> result = new ArrayList<EntityAnnotationReference>();
        boolean fieldAccess = "FIELD".equals(entity.getAccess());
        TreePathHandle handle = RefactoringUtil.getTreePathHandle(reference.getPropertyName(), reference.getClassName(), this.refactoringSource.getFileObject());
        for (OneToMany oneToMany : entity.getAttributes().getOneToMany()) {
            if (!this.isMatching(oneToMany.getName(), fieldAccess, reference)) continue;
            result.add(new EntityAnnotationReference(reference.getClassName(), ONE_TO_MANY, MAPPED_BY, reference.getSourceProperty(), handle));
        }
        for (OneToMany oneToMany : entity.getAttributes().getOneToOne()) {
            if (!this.isMatching(oneToMany.getName(), fieldAccess, reference)) continue;
            result.add(new EntityAnnotationReference(reference.getClassName(), ONE_TO_ONE, MAPPED_BY, reference.getSourceProperty(), handle));
        }
        return result;
    }

    private boolean isMatching(String propertyName, boolean fieldAccess, Reference reference) {
        if (fieldAccess && reference.isField()) {
            return propertyName.equals(reference.getPropertyName());
        }
        if (!fieldAccess && !reference.isField()) {
            return propertyName.equals(RefactoringUtil.getPropertyName(reference.getPropertyName()));
        }
        return false;
    }

    private Entity getByClass(Entity[] entities, String clazz) {
        for (Entity entity : entities) {
            if (!entity.getClass2().equals(clazz)) continue;
            return entity;
        }
        return null;
    }

    List<Reference> getReferringProperties() throws IOException {
        final ArrayList<Reference> result = new ArrayList<Reference>();
        JavaSource source = JavaSource.forFileObject((FileObject)this.refactoringSource.getFileObject());
        source.runUserActionTask((Task)new CancellableTask<CompilationController>(){

            public void cancel() {
            }

            private List<IdentifierTree> getTypeArgs(ParameterizedTypeTree ptt) {
                ArrayList<IdentifierTree> result2 = new ArrayList<IdentifierTree>();
                for (Tree tree : ptt.getTypeArguments()) {
                    if (Tree.Kind.IDENTIFIER != tree.getKind()) continue;
                    IdentifierTree it = (IdentifierTree)tree;
                    result2.add(it);
                }
                return result2;
            }

            private List<IdentifierTree> getIdentifier(Tree tree) {
                if (Tree.Kind.PARAMETERIZED_TYPE == tree.getKind()) {
                    return this.getTypeArgs((ParameterizedTypeTree)tree);
                }
                if (Tree.Kind.IDENTIFIER == tree.getKind()) {
                    return Collections.singletonList((IdentifierTree)tree);
                }
                return Collections.emptyList();
            }

            public void run(CompilationController info) throws Exception {
                info.toPhase(JavaSource.Phase.RESOLVED);
                Element refactoringTargetProperty = EntityAssociationResolver.this.refactoringSource.resolveElement((CompilationInfo)info);
                if (refactoringTargetProperty == null || refactoringTargetProperty.getEnclosingElement() == null) {
                    return;
                }
                String sourceClass = refactoringTargetProperty.getEnclosingElement().asType().toString();
                String propertyName = refactoringTargetProperty.getSimpleName().toString();
                String targetClass = refactoringTargetProperty.asType().toString();
                TypeElement te = info.getElements().getTypeElement(targetClass);
                if (te == null) {
                    return;
                }
                for (Element element : te.getEnclosedElements()) {
                    Tree propertyTree = info.getTrees().getTree(element);
                    if (propertyTree == null) continue;
                    List<Object> identifiers = new ArrayList();
                    boolean field = false;
                    if (element.getKind() == ElementKind.FIELD) {
                        field = true;
                        if (Tree.Kind.VARIABLE == propertyTree.getKind()) {
                            VariableTree vt = (VariableTree)propertyTree;
                            identifiers = this.getIdentifier(vt.getType());
                        }
                    } else if (element.getKind() == ElementKind.METHOD) {
                        MethodTree mt = (MethodTree)propertyTree;
                        identifiers = this.getIdentifier(mt.getReturnType());
                    }
                    for (IdentifierTree it : identifiers) {
                        TypeMirror type = info.getTreeUtilities().parseType(it.getName().toString(), te);
                        if (!sourceClass.equals(type.toString())) continue;
                        result.add(new Reference(element.getSimpleName().toString(), propertyName, targetClass, field));
                    }
                }
            }
        }, false);
        return result;
    }

    static class Reference {
        private final String className;
        private final String propertyName;
        private final String sourceProperty;
        private final boolean field;

        public Reference(String propertyName, String sourceProperty, String clazz, boolean field) {
            this.propertyName = propertyName;
            this.sourceProperty = sourceProperty;
            this.className = clazz;
            this.field = field;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getClassName() {
            return this.className;
        }

        public String getSourceProperty() {
            return this.sourceProperty;
        }

        public boolean isField() {
            return this.field;
        }
    }
}

