/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.tree;

import java.awt.Color;
import javax.swing.Icon;
import org.netbeans.modules.diff.tree.TreeEntry;
import org.netbeans.swing.outline.RenderDataProvider;

public class TreeEntryRenderDataProvider
implements RenderDataProvider {
    public static final Color COLOR_MISSING = new Color(255, 160, 180);
    public static final Color COLOR_ADDED = new Color(180, 255, 180);
    public static final Color COLOR_CHANGED = new Color(160, 200, 255);
    private final boolean useRelativePath;

    public TreeEntryRenderDataProvider(boolean useRelativePath) {
        this.useRelativePath = useRelativePath;
    }

    public String getDisplayName(Object o) {
        TreeEntry te = (TreeEntry)o;
        StringBuilder sb = new StringBuilder();
        if (te.isModified()) {
            sb.append("<b>");
        }
        if (this.useRelativePath) {
            sb.append(te.getRelativePath());
        } else {
            sb.append(te.getName());
        }
        if (te.isModified()) {
            sb.append("</b>");
        }
        return sb.toString();
    }

    public boolean isHtmlDisplayName(Object o) {
        return true;
    }

    public Color getBackground(Object o) {
        TreeEntry te = (TreeEntry)o;
        if (!te.isFilesIdentical()) {
            if (te.getFile1() == null) {
                return COLOR_ADDED;
            }
            if (te.getFile2() == null) {
                return COLOR_MISSING;
            }
            return COLOR_CHANGED;
        }
        return null;
    }

    public Color getForeground(Object o) {
        return null;
    }

    public String getTooltipText(Object o) {
        if (!this.useRelativePath) {
            return ((TreeEntry)o).getRelativePath();
        }
        return ((TreeEntry)o).getName();
    }

    public Icon getIcon(Object o) {
        return null;
    }
}

