/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.languages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.Language;

public class ASTItem {
    private Language language;
    private int offset;
    private int length = -1;
    private List<ASTItem> children;
    private TreeMap<Integer, ASTItem> childrenMap = null;

    ASTItem(Language language, int offset, int length, List<? extends ASTItem> children) {
        this.language = language;
        this.offset = offset;
        this.length = length;
        this.children = children != null ? children : Collections.emptyList();
    }

    public int getOffset() {
        return this.offset;
    }

    public Language getLanguage() {
        return this.language;
    }

    public String getMimeType() {
        if (this.language == null) {
            return null;
        }
        return this.language.getMimeType();
    }

    public List<ASTItem> getChildren() {
        return this.children;
    }

    void addChildren(ASTItem item) {
        if (this.children == Collections.emptyList()) {
            this.children = new ArrayList<ASTItem>();
        }
        this.children.add(item);
        if (this.childrenMap != null) {
            this.childrenMap.put(item.getOffset(), item);
        }
        this.length = -1;
    }

    void removeChildren(ASTItem item) {
        if (this.children == Collections.emptyList()) {
            return;
        }
        this.children.remove(item);
        if (this.childrenMap != null) {
            this.childrenMap.remove(item.getOffset());
        }
        this.length = -1;
    }

    void setChildren(int index, ASTItem item) {
        if (this.children == Collections.emptyList()) {
            return;
        }
        int oldOffset = this.children.get(index).getOffset();
        this.children.set(index, item);
        if (this.childrenMap != null) {
            this.childrenMap.remove(oldOffset);
            this.childrenMap.put(item.getOffset(), item);
        }
        this.length = -1;
    }

    public void lock() {
        this.children = Collections.unmodifiableList(this.children);
    }

    public int getEndOffset() {
        return this.getOffset() + this.getLength();
    }

    public int getLength() {
        if (this.length < 0) {
            List<ASTItem> l = this.getChildren();
            if (l.isEmpty()) {
                this.length = 0;
            } else {
                ASTItem last = l.get(l.size() - 1);
                this.length = last.getEndOffset() - this.getOffset();
            }
        }
        return this.length;
    }

    public ASTPath findPath(int offset) {
        return this.findPath(new ArrayList<ASTItem>(), offset);
    }

    ASTPath findPath(List<ASTItem> path, int offset) {
        if (offset < this.getOffset()) {
            return ASTPath.create(path);
        }
        if (offset > this.getEndOffset()) {
            return ASTPath.create(path);
        }
        path.add(this);
        if (this.getChildren().isEmpty()) {
            return ASTPath.create(path);
        }
        if (this.getChildren().size() > 10) {
            return this.findPath2(path, offset);
        }
        for (ASTItem item : this.getChildren()) {
            if (offset >= item.getEndOffset() || item.getOffset() > offset) continue;
            return item.findPath(path, offset);
        }
        return ASTPath.create(path);
    }

    private ASTPath findPath2(List<ASTItem> path, int offset) {
        TreeMap<Integer, ASTItem> childrenMap = this.getChildrenMap();
        SortedMap<Integer, ASTItem> headMap = childrenMap.headMap(offset + 1);
        if (headMap.isEmpty()) {
            return ASTPath.create(path);
        }
        Integer key = headMap.lastKey();
        ASTItem item = childrenMap.get(key);
        ASTPath path2 = item.findPath(path, offset);
        if (path2 == null) {
            return ASTPath.create(path);
        }
        return path2;
    }

    private TreeMap<Integer, ASTItem> getChildrenMap() {
        if (this.childrenMap == null) {
            this.childrenMap = new TreeMap();
            for (ASTItem item : this.getChildren()) {
                this.childrenMap.put(item.getOffset(), item);
            }
        }
        return this.childrenMap;
    }
}

