/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.fasterxml.jackson.dataformat.smile.SmileGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.BinaryResponseWriter;
import org.apache.solr.response.JSONWriter;
import org.apache.solr.response.SolrQueryResponse;

public class SmileResponseWriter
extends BinaryResponseWriter {
    @Override
    public void write(OutputStream out, SolrQueryRequest request, SolrQueryResponse response) throws IOException {
        try (SmileWriter sw = new SmileWriter(out, request, response);){
            sw.writeResponse();
        }
    }

    public static class SmileWriter
    extends JSONWriter {
        protected final SmileGenerator gen;
        protected final OutputStream out;

        public SmileWriter(OutputStream out, SolrQueryRequest req, SolrQueryResponse rsp) {
            super(null, req, rsp);
            this.out = out;
            SmileFactory smileFactory = new SmileFactory();
            smileFactory.enable(SmileGenerator.Feature.CHECK_SHARED_NAMES);
            try {
                this.gen = smileFactory.createGenerator(this.out, null);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void writeResponse() throws IOException {
            super.writeNamedList(null, this.rsp.getValues());
            this.gen.close();
        }

        public void writeNumber(String name, Number val) throws IOException {
            if (val instanceof Integer) {
                this.gen.writeNumber(val.intValue());
            } else if (val instanceof Long) {
                this.gen.writeNumber(val.longValue());
            } else if (val instanceof Float) {
                this.gen.writeNumber(val.floatValue());
            } else if (val instanceof Double) {
                this.gen.writeNumber(val.floatValue());
            } else if (val instanceof Short) {
                this.gen.writeNumber(val.shortValue());
            } else if (val instanceof Byte) {
                this.gen.writeNumber((short)val.byteValue());
            } else if (val instanceof BigInteger) {
                this.gen.writeNumber((BigInteger)val);
            } else if (val instanceof BigDecimal) {
                this.gen.writeNumber((BigDecimal)val);
            } else {
                this.gen.writeString(val.getClass().getName() + ":" + val.toString());
            }
        }

        public void writeBool(String name, Boolean val) throws IOException {
            this.gen.writeBoolean(val.booleanValue());
        }

        public void writeNull(String name) throws IOException {
            this.gen.writeNull();
        }

        public void writeStr(String name, String val, boolean needsEscaping) throws IOException {
            this.gen.writeString(val);
        }

        public void writeLong(String name, long val) throws IOException {
            this.gen.writeNumber(val);
        }

        public void writeInt(String name, int val) throws IOException {
            this.gen.writeNumber(val);
        }

        public void writeBool(String name, boolean val) throws IOException {
            this.gen.writeBoolean(val);
        }

        public void writeFloat(String name, float val) throws IOException {
            this.gen.writeNumber(val);
        }

        public void writeArrayCloser() throws IOException {
            this.gen.writeEndArray();
        }

        public void writeArraySeparator() throws IOException {
        }

        public void writeArrayOpener(int size) throws IOException, IllegalArgumentException {
            this.gen.writeStartArray();
        }

        public void writeMapCloser() throws IOException {
            this.gen.writeEndObject();
        }

        public void writeMapSeparator() throws IOException {
        }

        public void writeMapOpener(int size) throws IOException, IllegalArgumentException {
            this.gen.writeStartObject();
        }

        public void writeKey(String fname, boolean needsEscaping) throws IOException {
            this.gen.writeFieldName(fname);
        }

        public void writeByteArr(String name, byte[] buf, int offset, int len) throws IOException {
            this.gen.writeBinary(buf, offset, len);
        }

        @Override
        public void setLevel(int level) {
        }

        @Override
        public int level() {
            return 0;
        }

        public void indent() throws IOException {
        }

        public void indent(int lev) throws IOException {
        }

        @Override
        public int incLevel() {
            return 0;
        }

        @Override
        public int decLevel() {
            return 0;
        }

        @Override
        public void close() throws IOException {
            this.gen.close();
        }
    }
}

