/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.api.endpoint;

import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import org.apache.solr.client.api.model.ListLevelsResponse;
import org.apache.solr.client.api.model.LogLevelChange;
import org.apache.solr.client.api.model.LogMessagesResponse;
import org.apache.solr.client.api.model.LoggingResponse;
import org.apache.solr.client.api.model.SetThresholdRequestBody;

@Path(value="/node/logging")
public interface NodeLoggingApis {
    @GET
    @Path(value="/levels")
    @Operation(summary="List all log-levels for the target node.", tags={"logging"})
    public ListLevelsResponse listAllLoggersAndLevels();

    @PUT
    @Path(value="/levels")
    @Operation(summary="Set one or more logger levels on the target node.", tags={"logging"})
    public LoggingResponse modifyLocalLogLevel(List<LogLevelChange> var1);

    @GET
    @Path(value="/messages")
    @Operation(summary="Fetch recent log messages on the targeted node.", tags={"logging"})
    public LogMessagesResponse fetchLocalLogMessages(@QueryParam(value="since") Long var1);

    @PUT
    @Path(value="/messages/threshold")
    @Operation(summary="Set a threshold level for the targeted node's log message watcher.", tags={"logging"})
    public LoggingResponse setMessageThreshold(SetThresholdRequestBody var1);
}

