/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ruleconfig;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.parosproxy.paros.common.AbstractParam;
import org.zaproxy.zap.extension.ruleconfig.RuleConfig;

public class RuleConfigParam
extends AbstractParam {
    public static final String RULE_COMMON_SLEEP_TIME = "rules.common.sleep";
    public static final String RULE_CSRF_IGNORE_LIST = "rules.csrf.ignorelist";
    public static final String RULE_CSRF_IGNORE_ATT_NAME = "rules.csrf.ignore.attname";
    public static final String RULE_CSRF_IGNORE_ATT_VALUE = "rules.csrf.ignore.attvalue";
    public static final String RULE_COOKIE_IGNORE_LIST = "rules.cookie.ignorelist";
    public static final String RULE_DOMAINS_TRUSTED = "rules.domains.trusted";
    public static final String RULE_DOMXSS_BROWSER_ID = "rules.domxss.browserid";
    public static final int RULE_DEFAULT_COMMON_SLEEP_TIME = 15;
    private static final String RULES_BASE_KEY = "rules";
    private static final String RULES_DEFAULT_KEY_EXT = ".default";
    private Map<String, RuleConfig> ruleConfigs = new HashMap<String, RuleConfig>();

    @Override
    protected void parse() {
        this.addRuleConfig(new RuleConfig(RULE_COMMON_SLEEP_TIME, Integer.toString(15)));
        this.addRuleConfig(new RuleConfig(RULE_CSRF_IGNORE_LIST, ""));
        this.addRuleConfig(new RuleConfig(RULE_CSRF_IGNORE_ATT_NAME, ""));
        this.addRuleConfig(new RuleConfig(RULE_CSRF_IGNORE_ATT_VALUE, ""));
        this.addRuleConfig(new RuleConfig(RULE_COOKIE_IGNORE_LIST, ""));
        this.addRuleConfig(new RuleConfig(RULE_DOMAINS_TRUSTED, ""));
        this.addRuleConfig(new RuleConfig(RULE_DOMXSS_BROWSER_ID, ""));
        Iterator<String> iter = this.getConfig().getKeys(RULES_BASE_KEY);
        while (iter.hasNext()) {
            String key = iter.next();
            if (this.ruleConfigs.containsKey(key)) {
                this.ruleConfigs.get(key).setValue(this.getConfig().getString(key));
                continue;
            }
            RuleConfig rc = new RuleConfig(key, this.getConfig().getString(key + RULES_DEFAULT_KEY_EXT, ""), this.getConfig().getString(key));
            this.ruleConfigs.put(rc.getKey(), rc);
        }
    }

    public void addRuleConfig(RuleConfig rc) {
        this.ruleConfigs.put(rc.getKey(), rc);
        if (!this.getConfig().containsKey(rc.getKey())) {
            this.getConfig().setProperty(rc.getKey(), rc.getValue());
        }
    }

    public void addRuleConfig(String key, String defaultValue, String value) {
        this.ruleConfigs.put(key, new RuleConfig(key, defaultValue, value));
        if (!this.getConfig().containsKey(key)) {
            this.getConfig().setProperty(key, value);
        }
    }

    public RuleConfig getRuleConfig(String key) {
        if (this.ruleConfigs.containsKey(key)) {
            return this.ruleConfigs.get(key).clone();
        }
        return null;
    }

    public List<RuleConfig> getAllRuleConfigs() {
        ArrayList<RuleConfig> list = new ArrayList<RuleConfig>();
        for (RuleConfig rc : this.ruleConfigs.values()) {
            list.add(rc.clone());
        }
        return list;
    }

    public String getRuleConfigValue(String key) {
        if (this.ruleConfigs.containsKey(key)) {
            return this.ruleConfigs.get(key).getValue();
        }
        return null;
    }

    public String getRuleConfigDefaultValue(String key) {
        if (this.ruleConfigs.containsKey(key)) {
            return this.ruleConfigs.get(key).getDefaultValue();
        }
        return null;
    }

    public void setRuleConfigValue(String key, String value) {
        if (!this.ruleConfigs.containsKey(key)) {
            throw new IllegalArgumentException("No such key");
        }
        this.ruleConfigs.get(key).setValue(value);
        this.getConfig().setProperty(key, value);
    }

    public void resetRuleConfigValue(String key) {
        if (!this.ruleConfigs.containsKey(key)) {
            throw new IllegalArgumentException("No such key");
        }
        String value = this.ruleConfigs.get(key).getDefaultValue();
        this.ruleConfigs.get(key).setValue(value);
        this.getConfig().setProperty(key, value);
    }

    public void resetAllRuleConfigValues() {
        for (RuleConfig rc : this.ruleConfigs.values()) {
            rc.reset();
            this.getConfig().setProperty(rc.getKey(), rc.getValue());
        }
    }
}

