/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import com.google.common.base.Objects;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.LibraryBinaryIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.DefaultProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyFactoryInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.BuildIdentifierSerializer;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenUniqueSnapshotComponentIdentifier;
import org.gradle.api.internal.project.ProjectIdentity;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.local.model.DefaultLibraryBinaryIdentifier;
import org.gradle.internal.component.local.model.OpaqueComponentArtifactIdentifier;
import org.gradle.internal.component.local.model.OpaqueComponentIdentifier;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.util.Path;

public class ComponentIdentifierSerializer
extends AbstractSerializer<ComponentIdentifier> {
    private final BuildIdentifierSerializer buildIdentifierSerializer = new BuildIdentifierSerializer();

    public ComponentIdentifier read(Decoder decoder) throws IOException {
        byte id = decoder.readByte();
        Implementation implementation = Implementation.valueOf(id);
        if (implementation == null) {
            throw new IllegalArgumentException("Unable to find component identifier type with id: " + id);
        }
        switch (implementation) {
            case ROOT_PROJECT: {
                BuildIdentifier buildIdentifier = this.buildIdentifierSerializer.read(decoder);
                String projectName = decoder.readString();
                ProjectIdentity projectIdentity = new ProjectIdentity(buildIdentifier, Path.ROOT, Path.ROOT, projectName);
                return new DefaultProjectComponentIdentifier(projectIdentity);
            }
            case ROOT_BUILD_PROJECT: {
                BuildIdentifier buildIdentifier = this.buildIdentifierSerializer.read(decoder);
                Path projectPath = Path.path((String)decoder.readString());
                ProjectIdentity projectIdentity = new ProjectIdentity(buildIdentifier, projectPath, projectPath, projectPath.getName());
                return new DefaultProjectComponentIdentifier(projectIdentity);
            }
            case OTHER_BUILD_ROOT_PROJECT: {
                BuildIdentifier buildIdentifier = this.buildIdentifierSerializer.read(decoder);
                Path identityPath = Path.path((String)decoder.readString());
                ProjectIdentity projectIdentity = new ProjectIdentity(buildIdentifier, identityPath, Path.ROOT, identityPath.getName());
                return new DefaultProjectComponentIdentifier(projectIdentity);
            }
            case OTHER_BUILD_PROJECT: {
                BuildIdentifier buildIdentifier = this.buildIdentifierSerializer.read(decoder);
                Path identityPath = Path.path((String)decoder.readString());
                Path projectPath = Path.path((String)decoder.readString());
                ProjectIdentity projectIdentity = new ProjectIdentity(buildIdentifier, identityPath, projectPath, identityPath.getName());
                return new DefaultProjectComponentIdentifier(projectIdentity);
            }
            case MODULE: {
                return new DefaultModuleComponentIdentifier(DefaultModuleIdentifier.newId(decoder.readString(), decoder.readString()), decoder.readString());
            }
            case SNAPSHOT: {
                return new MavenUniqueSnapshotComponentIdentifier(DefaultModuleIdentifier.newId(decoder.readString(), decoder.readString()), decoder.readString(), decoder.readString());
            }
            case LIBRARY: {
                return new DefaultLibraryBinaryIdentifier(decoder.readString(), decoder.readString(), decoder.readString());
            }
            case OPAQUE: {
                return new OpaqueComponentArtifactIdentifier(new File(decoder.readString()));
            }
            case OPAQUE_NOTATION: {
                return new OpaqueComponentIdentifier(ComponentIdentifierSerializer.readClassPathNotation(decoder));
            }
        }
        throw new IllegalArgumentException("Unsupported component identifier implementation: " + (Object)((Object)implementation));
    }

    public void write(Encoder encoder, ComponentIdentifier value) throws IOException {
        if (value == null) {
            throw new IllegalArgumentException("Provided component identifier may not be null");
        }
        Implementation implementation = this.resolveImplementation(value);
        encoder.writeByte(implementation.id);
        switch (implementation) {
            case MODULE: {
                ModuleComponentIdentifier moduleComponentIdentifier = (ModuleComponentIdentifier)value;
                encoder.writeString((CharSequence)moduleComponentIdentifier.getGroup());
                encoder.writeString((CharSequence)moduleComponentIdentifier.getModule());
                encoder.writeString((CharSequence)moduleComponentIdentifier.getVersion());
                break;
            }
            case SNAPSHOT: {
                MavenUniqueSnapshotComponentIdentifier snapshotIdentifier = (MavenUniqueSnapshotComponentIdentifier)value;
                encoder.writeString((CharSequence)snapshotIdentifier.getGroup());
                encoder.writeString((CharSequence)snapshotIdentifier.getModule());
                encoder.writeString((CharSequence)snapshotIdentifier.getVersion());
                encoder.writeString((CharSequence)snapshotIdentifier.getTimestamp());
                break;
            }
            case ROOT_PROJECT: {
                ProjectComponentIdentifier projectComponentIdentifier = (ProjectComponentIdentifier)value;
                this.writeBuildIdentifierOf(projectComponentIdentifier, encoder);
                encoder.writeString((CharSequence)projectComponentIdentifier.getProjectName());
                break;
            }
            case ROOT_BUILD_PROJECT: {
                ProjectComponentIdentifier projectComponentIdentifier = (ProjectComponentIdentifier)value;
                this.writeBuildIdentifierOf(projectComponentIdentifier, encoder);
                encoder.writeString((CharSequence)projectComponentIdentifier.getProjectPath());
                break;
            }
            case OTHER_BUILD_ROOT_PROJECT: {
                DefaultProjectComponentIdentifier projectComponentIdentifier = (DefaultProjectComponentIdentifier)value;
                this.writeBuildIdentifierOf((ProjectComponentIdentifier)projectComponentIdentifier, encoder);
                encoder.writeString((CharSequence)projectComponentIdentifier.getIdentityPath().getPath());
                break;
            }
            case OTHER_BUILD_PROJECT: {
                DefaultProjectComponentIdentifier projectComponentIdentifier = (DefaultProjectComponentIdentifier)value;
                this.writeBuildIdentifierOf((ProjectComponentIdentifier)projectComponentIdentifier, encoder);
                encoder.writeString((CharSequence)projectComponentIdentifier.getIdentityPath().getPath());
                encoder.writeString((CharSequence)projectComponentIdentifier.getProjectPath());
                break;
            }
            case LIBRARY: {
                LibraryBinaryIdentifier libraryIdentifier = (LibraryBinaryIdentifier)value;
                encoder.writeString((CharSequence)libraryIdentifier.getProjectPath());
                encoder.writeString((CharSequence)libraryIdentifier.getLibraryName());
                encoder.writeString((CharSequence)libraryIdentifier.getVariant());
                break;
            }
            case OPAQUE: {
                OpaqueComponentArtifactIdentifier opaqueIdentifier = (OpaqueComponentArtifactIdentifier)value;
                encoder.writeString((CharSequence)opaqueIdentifier.getFile().getPath());
                break;
            }
            case OPAQUE_NOTATION: {
                OpaqueComponentIdentifier opaqueIdentifier = (OpaqueComponentIdentifier)value;
                ComponentIdentifierSerializer.writeClassPathNotation(encoder, opaqueIdentifier.getClassPathNotation());
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported implementation type: " + (Object)((Object)implementation));
            }
        }
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ComponentIdentifierSerializer rhs = (ComponentIdentifierSerializer)((Object)obj);
        return Objects.equal((Object)((Object)this.buildIdentifierSerializer), (Object)((Object)rhs.buildIdentifierSerializer));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.buildIdentifierSerializer});
    }

    private static void writeClassPathNotation(Encoder encoder, DependencyFactoryInternal.ClassPathNotation classPathNotation) throws IOException {
        encoder.writeSmallInt(classPathNotation.ordinal());
    }

    private static DependencyFactoryInternal.ClassPathNotation readClassPathNotation(Decoder decoder) throws IOException {
        int ordinal = decoder.readSmallInt();
        return DependencyFactoryInternal.ClassPathNotation.values()[ordinal];
    }

    private void writeBuildIdentifierOf(ProjectComponentIdentifier projectComponentIdentifier, Encoder encoder) throws IOException {
        this.buildIdentifierSerializer.write(encoder, projectComponentIdentifier.getBuild());
    }

    private Implementation resolveImplementation(ComponentIdentifier value) {
        if (value instanceof MavenUniqueSnapshotComponentIdentifier) {
            return Implementation.SNAPSHOT;
        }
        if (value instanceof ModuleComponentIdentifier) {
            return Implementation.MODULE;
        }
        if (value instanceof DefaultProjectComponentIdentifier) {
            DefaultProjectComponentIdentifier projectComponentIdentifier = (DefaultProjectComponentIdentifier)value;
            Path projectPath = projectComponentIdentifier.getProjectIdentity().getProjectPath();
            boolean isARootProject = projectPath.equals((Object)Path.ROOT);
            if (projectComponentIdentifier.getIdentityPath().equals((Object)Path.ROOT) && isARootProject) {
                return Implementation.ROOT_PROJECT;
            }
            if (projectComponentIdentifier.getIdentityPath().equals((Object)projectPath) && projectPath.getName().equals(projectComponentIdentifier.getProjectName())) {
                return Implementation.ROOT_BUILD_PROJECT;
            }
            if (isARootProject && projectComponentIdentifier.getProjectName().equals(projectComponentIdentifier.getIdentityPath().getName())) {
                return Implementation.OTHER_BUILD_ROOT_PROJECT;
            }
            return Implementation.OTHER_BUILD_PROJECT;
        }
        if (value instanceof LibraryBinaryIdentifier) {
            return Implementation.LIBRARY;
        }
        if (value instanceof OpaqueComponentArtifactIdentifier) {
            return Implementation.OPAQUE;
        }
        if (value instanceof OpaqueComponentIdentifier) {
            return Implementation.OPAQUE_NOTATION;
        }
        throw new IllegalArgumentException("Unsupported component identifier class: " + value.getClass());
    }

    private static enum Implementation {
        MODULE(1),
        ROOT_PROJECT(2),
        ROOT_BUILD_PROJECT(3),
        OTHER_BUILD_ROOT_PROJECT(4),
        OTHER_BUILD_PROJECT(5),
        LIBRARY(6),
        SNAPSHOT(7),
        OPAQUE(8),
        OPAQUE_NOTATION(9);

        private final byte id;

        @Nullable
        public static Implementation valueOf(int id) {
            Implementation[] values = Implementation.values();
            if (id >= values[0].id && id <= values[values.length - 1].id) {
                return values[id - 1];
            }
            return null;
        }

        private Implementation(int id) {
            this.id = (byte)id;
        }
    }
}

