/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jd.core.v1.model.javasyntax.expression.AbstractNopExpressionVisitor;
import org.jd.core.v1.model.javasyntax.expression.BaseExpression;
import org.jd.core.v1.model.javasyntax.expression.BinaryOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.CastExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.FieldReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.LocalVariableReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.MethodInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.NewExpression;
import org.jd.core.v1.model.javasyntax.expression.ObjectTypeReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.SuperExpression;
import org.jd.core.v1.model.javasyntax.expression.TernaryOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.ThisExpression;
import org.jd.core.v1.model.javasyntax.type.BaseType;
import org.jd.core.v1.model.javasyntax.type.BaseTypeArgument;
import org.jd.core.v1.model.javasyntax.type.BaseTypeParameter;
import org.jd.core.v1.model.javasyntax.type.GenericType;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.model.javasyntax.type.TypeArgument;
import org.jd.core.v1.model.javasyntax.type.TypeArguments;
import org.jd.core.v1.model.javasyntax.type.TypeParameter;
import org.jd.core.v1.model.javasyntax.type.Types;
import org.jd.core.v1.model.javasyntax.type.WildcardTypeArgument;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileConstructorOrMethodDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileConstructorInvocationExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileLocalVariableReferenceExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileMethodInvocationExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileNewExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileSuperConstructorInvocationExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.AbstractLocalVariable;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.TypeMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.BaseTypeToTypeArgumentVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.BindTypeParametersToNonWildcardTypeArgumentsVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.BindTypesToTypesVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.PopulateBindingsWithTypeArgumentVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.PopulateBindingsWithTypeParameterVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.SearchInTypeArgumentVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.TypeArgumentToTypeVisitor;

public class TypeParametersToTypeArgumentsBinder {
    protected static final RemoveNonWildcardTypeArgumentsVisitor REMOVE_NON_WILDCARD_TYPE_ARGUMENTS_VISITOR = new RemoveNonWildcardTypeArgumentsVisitor();
    protected PopulateBindingsWithTypeParameterVisitor populateBindingsWithTypeParameterVisitor = new PopulateBindingsWithTypeParameterVisitor();
    protected BindTypesToTypesVisitor bindTypesToTypesVisitor = new BindTypesToTypesVisitor();
    protected SearchInTypeArgumentVisitor searchInTypeArgumentVisitor = new SearchInTypeArgumentVisitor();
    protected TypeArgumentToTypeVisitor typeArgumentToTypeVisitor = new TypeArgumentToTypeVisitor();
    protected BaseTypeToTypeArgumentVisitor baseTypeToTypeArgumentVisitor = new BaseTypeToTypeArgumentVisitor();
    protected BindTypeParametersToNonWildcardTypeArgumentsVisitor bindTypeParametersToNonWildcardTypeArgumentsVisitor = new BindTypeParametersToNonWildcardTypeArgumentsVisitor();
    protected BindVisitor bindVisitor = new BindVisitor();
    protected TypeMaker typeMaker;
    protected String internalTypeName;
    protected boolean staticMethod;
    protected PopulateBindingsWithTypeArgumentVisitor populateBindingsWithTypeArgumentVisitor;
    protected Map<String, TypeArgument> contextualBindings;
    protected Map<String, BaseType> contextualTypeBounds;

    public TypeParametersToTypeArgumentsBinder(TypeMaker typeMaker, String internalTypeName, ClassFileConstructorOrMethodDeclaration comd) {
        this.typeMaker = typeMaker;
        this.internalTypeName = internalTypeName;
        this.staticMethod = (comd.getFlags() & 8) != 0;
        this.populateBindingsWithTypeArgumentVisitor = new PopulateBindingsWithTypeArgumentVisitor(typeMaker);
        this.contextualBindings = comd.getBindings();
        this.contextualTypeBounds = comd.getTypeBounds();
    }

    public ClassFileConstructorInvocationExpression newConstructorInvocationExpression(int lineNumber, ObjectType objectType, String descriptor, TypeMaker.MethodTypes methodTypes, BaseExpression parameters) {
        BaseType parameterTypes = this.clone(methodTypes.parameterTypes);
        Map<String, TypeArgument> bindings = this.createBindings(null, null, null, methodTypes.typeParameters, ObjectType.TYPE_OBJECT, null, parameterTypes, parameters);
        parameterTypes = this.bind(bindings, parameterTypes);
        this.bindParameters(parameterTypes, parameters);
        return new ClassFileConstructorInvocationExpression(lineNumber, objectType, descriptor, parameterTypes, parameters);
    }

    public ClassFileSuperConstructorInvocationExpression newSuperConstructorInvocationExpression(int lineNumber, ObjectType objectType, String descriptor, TypeMaker.MethodTypes methodTypes, BaseExpression parameters) {
        TypeMaker.TypeTypes superTypeTypes;
        BaseType parameterTypes = this.clone(methodTypes.parameterTypes);
        Map<String, TypeArgument> bindings = this.contextualBindings;
        TypeMaker.TypeTypes typeTypes = this.typeMaker.makeTypeTypes(this.internalTypeName);
        if (typeTypes != null && typeTypes.superType != null && typeTypes.superType.getTypeArguments() != null && (superTypeTypes = this.typeMaker.makeTypeTypes(objectType.getInternalName())) != null) {
            BaseTypeParameter typeParameters = superTypeTypes.typeParameters;
            BaseTypeArgument typeArguments = typeTypes.superType.getTypeArguments();
            BaseTypeParameter methodTypeParameters = methodTypes.typeParameters;
            bindings = this.createBindings(null, typeParameters, typeArguments, methodTypeParameters, ObjectType.TYPE_OBJECT, null, parameterTypes, parameters);
        }
        parameterTypes = this.bind(bindings, parameterTypes);
        this.bindParameters(parameterTypes, parameters);
        return new ClassFileSuperConstructorInvocationExpression(lineNumber, objectType, descriptor, parameterTypes, parameters);
    }

    public ClassFileMethodInvocationExpression newMethodInvocationExpression(int lineNumber, Expression expression, ObjectType objectType, String name, String descriptor, TypeMaker.MethodTypes methodTypes, BaseExpression parameters) {
        return new ClassFileMethodInvocationExpression(this, lineNumber, methodTypes.typeParameters, methodTypes.returnedType, expression, objectType.getInternalName(), name, descriptor, this.clone(methodTypes.parameterTypes), parameters);
    }

    public FieldReferenceExpression newFieldReferenceExpression(int lineNumber, Type type, Expression expression, ObjectType objectType, String name, String descriptor) {
        Type expressionType = expression.getType();
        if (expressionType.isObject()) {
            ObjectType ot;
            ObjectType expressionObjectType = (ObjectType)expressionType;
            if ((this.staticMethod || !expressionObjectType.getInternalName().equals(this.internalTypeName)) && type.isObject() && (ot = (ObjectType)type).getTypeArguments() != null) {
                Map<String, TypeArgument> bindings;
                TypeMaker.TypeTypes typeTypes = this.typeMaker.makeTypeTypes(expressionObjectType.getInternalName());
                if (typeTypes == null) {
                    bindings = this.contextualBindings;
                } else {
                    BaseTypeParameter typeParameters = typeTypes.typeParameters;
                    BaseTypeArgument typeArguments = expressionObjectType.getTypeArguments();
                    bindings = this.createBindings(expression, typeParameters, typeArguments, null, ObjectType.TYPE_OBJECT, null, null, null);
                }
                type = (Type)this.bind(bindings, type);
            }
        }
        return new FieldReferenceExpression(lineNumber, type, expression, objectType.getInternalName(), name, descriptor);
    }

    public void updateNewExpression(ClassFileNewExpression ne, String descriptor, TypeMaker.MethodTypes methodTypes, BaseExpression parameters) {
        ne.set(descriptor, this.clone(methodTypes.parameterTypes), parameters);
    }

    public void bindParameterTypesWithArgumentTypes(Type type, Expression expression) {
        this.bindVisitor.init(type);
        expression.accept(this.bindVisitor);
        expression.accept(REMOVE_NON_WILDCARD_TYPE_ARGUMENTS_VISITOR);
    }

    protected Type checkTypeArguments(Type type, AbstractLocalVariable localVariable) {
        ObjectType localVariableObjectType;
        TypeMaker.TypeTypes typeTypes;
        Type localVariableType;
        ObjectType objectType;
        if (type.isObject() && (objectType = (ObjectType)type).getTypeArguments() != null && (localVariableType = localVariable.getType()).isObject() && (typeTypes = this.typeMaker.makeTypeTypes((localVariableObjectType = (ObjectType)localVariableType).getInternalName())) != null && typeTypes.typeParameters == null) {
            type = ((ObjectType)type).createType(null);
        }
        return type;
    }

    protected void bind(Type type, ClassFileMethodInvocationExpression mie) {
        TypeMaker.TypeTypes typeTypes;
        BaseType parameterTypes = mie.getParameterTypes();
        BaseExpression parameters = mie.getParameters();
        Expression expression = mie.getExpression();
        Type expressionType = expression.getType();
        if ((this.staticMethod || mie.getTypeParameters() != null || expressionType.isGeneric() || expression.getClass() != ThisExpression.class) && (typeTypes = this.typeMaker.makeTypeTypes(mie.getInternalTypeName())) != null) {
            Type t;
            BaseTypeArgument typeArguments;
            BaseTypeParameter typeParameters = typeTypes.typeParameters;
            BaseTypeParameter methodTypeParameters = mie.getTypeParameters();
            if (expression.getClass() == SuperExpression.class) {
                typeTypes = this.typeMaker.makeTypeTypes(this.internalTypeName);
                typeArguments = typeTypes.superType == null ? null : typeTypes.superType.getTypeArguments();
            } else {
                typeArguments = expression.getClass() == ClassFileMethodInvocationExpression.class ? ((t = this.getExpressionType((ClassFileMethodInvocationExpression)expression)) != null && t.isObject() ? ((ObjectType)t).getTypeArguments() : null) : (expressionType.isGeneric() ? null : ((ObjectType)expressionType).getTypeArguments());
            }
            t = mie.getType();
            if (type.isObject() && t.isObject()) {
                ObjectType objectType = (ObjectType)type;
                ObjectType mieTypeObjectType = (ObjectType)t;
                t = this.typeMaker.searchSuperParameterizedType(objectType, mieTypeObjectType);
            }
            Map<String, TypeArgument> bindings = this.createBindings(expression, typeParameters, typeArguments, methodTypeParameters, type, t, parameterTypes, parameters);
            boolean bindingsContainsNull = bindings.containsValue(null);
            parameterTypes = this.bind(bindings, parameterTypes);
            mie.setParameterTypes(parameterTypes);
            mie.setType((Type)this.bind(bindings, mie.getType()));
            if (methodTypeParameters != null && !bindingsContainsNull) {
                this.bindTypeParametersToNonWildcardTypeArgumentsVisitor.init(bindings);
                methodTypeParameters.accept(this.bindTypeParametersToNonWildcardTypeArgumentsVisitor);
                mie.setNonWildcardTypeArguments(this.bindTypeParametersToNonWildcardTypeArgumentsVisitor.getTypeArgument());
            }
            if (expressionType.isObject()) {
                ObjectType expressionObjectType = (ObjectType)expressionType;
                if (bindingsContainsNull) {
                    expressionType = expressionObjectType.createType(null);
                } else {
                    boolean statik;
                    boolean bl = statik = expression.getClass() == ObjectTypeReferenceExpression.class;
                    if (statik || typeParameters == null) {
                        expressionType = expressionObjectType.createType(null);
                    } else if (typeParameters.isList()) {
                        TypeArguments tas = new TypeArguments(typeParameters.size());
                        for (TypeParameter typeParameter : typeParameters) {
                            tas.add(bindings.get(typeParameter.getIdentifier()));
                        }
                        expressionType = expressionObjectType.createType(tas);
                    } else {
                        expressionType = expressionObjectType.createType(bindings.get(((TypeParameter)typeParameters.getFirst()).getIdentifier()));
                    }
                }
            }
        }
        this.bindVisitor.init(expressionType);
        expression.accept(this.bindVisitor);
        this.bindParameters(parameterTypes, parameters);
    }

    protected void bind(Type type, ClassFileNewExpression ne) {
        TypeMaker.TypeTypes typeTypes;
        BaseType parameterTypes = ne.getParameterTypes();
        BaseExpression parameters = ne.getParameters();
        ObjectType neObjectType = ne.getObjectType();
        if ((this.staticMethod || !neObjectType.getInternalName().equals(this.internalTypeName)) && (typeTypes = this.typeMaker.makeTypeTypes(neObjectType.getInternalName())) != null) {
            BaseTypeParameter typeParameters = typeTypes.typeParameters;
            BaseTypeArgument typeArguments = neObjectType.getTypeArguments();
            if (typeParameters != null && typeArguments == null) {
                if (typeParameters.isList()) {
                    TypeArguments tas = new TypeArguments(typeParameters.size());
                    for (TypeParameter typeParameter : typeParameters) {
                        tas.add(new GenericType(typeParameter.getIdentifier()));
                    }
                    neObjectType = neObjectType.createType(tas);
                } else {
                    neObjectType = neObjectType.createType(new GenericType(((TypeParameter)typeParameters.getFirst()).getIdentifier()));
                }
            }
            ObjectType t = neObjectType;
            if (type.isObject()) {
                ObjectType objectType = (ObjectType)type;
                t = this.typeMaker.searchSuperParameterizedType(objectType, neObjectType);
            }
            Map<String, TypeArgument> bindings = this.createBindings(null, typeParameters, typeArguments, null, type, t, parameterTypes, parameters);
            parameterTypes = this.bind(bindings, parameterTypes);
            ne.setParameterTypes(parameterTypes);
            for (Map.Entry<String, TypeArgument> entry : bindings.entrySet()) {
                this.typeArgumentToTypeVisitor.init();
                entry.getValue().accept(this.typeArgumentToTypeVisitor);
                entry.setValue(this.typeArgumentToTypeVisitor.getType());
            }
            ne.setType((ObjectType)this.bind(bindings, neObjectType));
        }
        this.bindParameters(parameterTypes, parameters);
    }

    protected void bindParameters(BaseType parameterTypes, BaseExpression parameters) {
        if (parameterTypes != null) {
            if (parameterTypes.isList() && parameters.isList()) {
                Iterator parameterTypesIterator = parameterTypes.iterator();
                for (Expression parameter : parameters) {
                    this.bindVisitor.init((Type)parameterTypesIterator.next());
                    parameter.accept(this.bindVisitor);
                    parameter.accept(REMOVE_NON_WILDCARD_TYPE_ARGUMENTS_VISITOR);
                }
            } else {
                Expression parameter = (Expression)parameters.getFirst();
                this.bindVisitor.init((Type)parameterTypes.getFirst());
                parameter.accept(this.bindVisitor);
                parameter.accept(REMOVE_NON_WILDCARD_TYPE_ARGUMENTS_VISITOR);
            }
        }
    }

    public static void staticBindParameterTypesWithArgumentTypes(Type type, Expression expression) {
        ClassFileMethodInvocationExpression mie;
        TypeParametersToTypeArgumentsBinder binder;
        if (expression.getClass() == ClassFileMethodInvocationExpression.class && (binder = (mie = (ClassFileMethodInvocationExpression)expression).getBinder()) != null) {
            binder.bindParameterTypesWithArgumentTypes(type, mie);
        }
    }

    protected Map<String, TypeArgument> createBindings(Expression expression, BaseTypeParameter typeParameters, BaseTypeArgument typeArguments, BaseTypeParameter methodTypeParameters, Type returnType, Type returnExpressionType, BaseType parameterTypes, BaseExpression parameters) {
        HashMap<String, TypeArgument> bindings;
        block17: {
            boolean statik;
            bindings = new HashMap<String, TypeArgument>();
            HashMap<String, BaseType> typeBounds = new HashMap<String, BaseType>();
            boolean bl = statik = expression != null && expression.getClass() == ObjectTypeReferenceExpression.class;
            if (!statik) {
                bindings.putAll(this.contextualBindings);
                if (typeParameters != null) {
                    this.populateBindingsWithTypeParameterVisitor.init(bindings, typeBounds);
                    typeParameters.accept(this.populateBindingsWithTypeParameterVisitor);
                    if (typeArguments != null) {
                        if (typeParameters.isList() && typeArguments.isTypeArgumentList()) {
                            Iterator iteratorTypeParameter = typeParameters.iterator();
                            Iterator iterator = typeArguments.getTypeArgumentList().iterator();
                            while (iteratorTypeParameter.hasNext()) {
                                bindings.put(((TypeParameter)iteratorTypeParameter.next()).getIdentifier(), (TypeArgument)iterator.next());
                            }
                        } else {
                            bindings.put(((TypeParameter)typeParameters.getFirst()).getIdentifier(), typeArguments.getTypeArgumentFirst());
                        }
                    }
                }
            }
            if (methodTypeParameters != null) {
                this.populateBindingsWithTypeParameterVisitor.init(bindings, typeBounds);
                methodTypeParameters.accept(this.populateBindingsWithTypeParameterVisitor);
            }
            if (!ObjectType.TYPE_OBJECT.equals(returnType) && returnExpressionType != null) {
                this.populateBindingsWithTypeArgumentVisitor.init(this.contextualTypeBounds, bindings, typeBounds, returnType);
                returnExpressionType.accept(this.populateBindingsWithTypeArgumentVisitor);
            }
            if (parameterTypes != null) {
                if (parameterTypes.isList() && parameters.isList()) {
                    Iterator parameterTypesIterator = parameterTypes.iterator();
                    Iterator iterator = parameters.iterator();
                    while (iterator.hasNext()) {
                        this.populateBindingsWithTypeArgument(bindings, typeBounds, (Type)parameterTypesIterator.next(), (Expression)iterator.next());
                    }
                } else {
                    this.populateBindingsWithTypeArgument(bindings, typeBounds, (Type)parameterTypes.getFirst(), (Expression)parameters.getFirst());
                }
            }
            if (!bindings.containsValue(null)) break block17;
            if (this.eraseTypeArguments(expression, typeParameters, typeArguments)) {
                for (Map.Entry entry : bindings.entrySet()) {
                    entry.setValue(null);
                }
            } else {
                for (Map.Entry entry : bindings.entrySet()) {
                    if (entry.getValue() != null) continue;
                    BaseType baseType = (BaseType)typeBounds.get(entry.getKey());
                    if (baseType == null) {
                        entry.setValue(WildcardTypeArgument.WILDCARD_TYPE_ARGUMENT);
                        continue;
                    }
                    this.bindTypesToTypesVisitor.setBindings(bindings);
                    this.bindTypesToTypesVisitor.init();
                    baseType.accept(this.bindTypesToTypesVisitor);
                    baseType = this.bindTypesToTypesVisitor.getType();
                    this.baseTypeToTypeArgumentVisitor.init();
                    baseType.accept(this.baseTypeToTypeArgumentVisitor);
                    entry.setValue(this.baseTypeToTypeArgumentVisitor.getTypeArgument());
                }
            }
        }
        return bindings;
    }

    protected boolean eraseTypeArguments(Expression expression, BaseTypeParameter typeParameters, BaseTypeArgument typeArguments) {
        if (typeParameters != null && typeArguments == null && expression != null) {
            Class<?> expressionClass = expression.getClass();
            if (expressionClass == CastExpression.class) {
                expression = ((CastExpression)expression).getExpression();
                expressionClass = expression.getClass();
            }
            if (expressionClass == FieldReferenceExpression.class || expressionClass == ClassFileMethodInvocationExpression.class || expressionClass == ClassFileLocalVariableReferenceExpression.class) {
                return true;
            }
        }
        return false;
    }

    protected void populateBindingsWithTypeArgument(Map<String, TypeArgument> bindings, Map<String, BaseType> typeBounds, Type type, Expression expression) {
        Type t = this.getExpressionType(expression);
        if (t != null && t != ObjectType.TYPE_UNDEFINED_OBJECT) {
            this.populateBindingsWithTypeArgumentVisitor.init(this.contextualTypeBounds, bindings, typeBounds, t);
            type.accept(this.populateBindingsWithTypeArgumentVisitor);
        }
    }

    protected BaseType bind(Map<String, TypeArgument> bindings, BaseType parameterTypes) {
        if (parameterTypes != null && !bindings.isEmpty()) {
            this.bindTypesToTypesVisitor.setBindings(bindings);
            this.bindTypesToTypesVisitor.init();
            parameterTypes.accept(this.bindTypesToTypesVisitor);
            parameterTypes = this.bindTypesToTypesVisitor.getType();
        }
        return parameterTypes;
    }

    protected BaseType clone(BaseType parameterTypes) {
        if (parameterTypes != null && parameterTypes.isList()) {
            switch (parameterTypes.size()) {
                case 0: {
                    parameterTypes = null;
                    break;
                }
                case 1: {
                    parameterTypes = (BaseType)parameterTypes.getFirst();
                    break;
                }
                default: {
                    parameterTypes = new Types((Collection<Type>)parameterTypes.getList());
                }
            }
        }
        return parameterTypes;
    }

    protected Type getExpressionType(Expression expression) {
        Class<?> expressionClass = expression.getClass();
        if (expressionClass == ClassFileMethodInvocationExpression.class) {
            return this.getExpressionType((ClassFileMethodInvocationExpression)expression);
        }
        if (expressionClass == ClassFileNewExpression.class) {
            return this.getExpressionType((ClassFileNewExpression)expression);
        }
        return expression.getType();
    }

    protected Type getExpressionType(ClassFileMethodInvocationExpression mie) {
        TypeMaker.TypeTypes typeTypes;
        Type t = mie.getType();
        this.searchInTypeArgumentVisitor.init();
        t.accept(this.searchInTypeArgumentVisitor);
        if (!this.searchInTypeArgumentVisitor.containsGeneric()) {
            return t;
        }
        if (mie.getTypeParameters() != null) {
            return null;
        }
        if ((this.staticMethod || mie.getExpression().getClass() != ThisExpression.class) && (typeTypes = this.typeMaker.makeTypeTypes(mie.getInternalTypeName())) != null && typeTypes.typeParameters != null) {
            return null;
        }
        return t;
    }

    protected Type getExpressionType(ClassFileNewExpression ne) {
        TypeMaker.TypeTypes typeTypes;
        ObjectType ot = ne.getObjectType();
        if ((this.staticMethod || !ot.getInternalName().equals(this.internalTypeName)) && (typeTypes = this.typeMaker.makeTypeTypes(ot.getInternalName())) != null && typeTypes.typeParameters != null) {
            return null;
        }
        return ot;
    }

    protected static class RemoveNonWildcardTypeArgumentsVisitor
    extends AbstractNopExpressionVisitor {
        protected RemoveNonWildcardTypeArgumentsVisitor() {
        }

        @Override
        public void visit(MethodInvocationExpression expression) {
            expression.setNonWildcardTypeArguments(null);
        }
    }

    protected class BindVisitor
    extends AbstractNopExpressionVisitor {
        protected Type type;

        protected BindVisitor() {
        }

        public void init(Type type) {
            this.type = type;
        }

        @Override
        public void visit(MethodInvocationExpression expression) {
            ClassFileMethodInvocationExpression mie = (ClassFileMethodInvocationExpression)expression;
            TypeParametersToTypeArgumentsBinder.this.bind(this.type, mie);
        }

        @Override
        public void visit(LocalVariableReferenceExpression expression) {
            if (!this.type.isPrimitive()) {
                AbstractLocalVariable localVariable = ((ClassFileLocalVariableReferenceExpression)expression).getLocalVariable();
                localVariable.typeOnLeft(TypeParametersToTypeArgumentsBinder.this.contextualTypeBounds, TypeParametersToTypeArgumentsBinder.this.checkTypeArguments(this.type, localVariable));
            }
        }

        @Override
        public void visit(NewExpression expression) {
            ClassFileNewExpression ne = (ClassFileNewExpression)expression;
            TypeParametersToTypeArgumentsBinder.this.bind(this.type, ne);
        }

        @Override
        public void visit(CastExpression expression) {
            ObjectType objectType;
            assert (ObjectType.TYPE_OBJECT.equals(this.type) || this.type.getDimension() == expression.getType().getDimension()) : "TypeParametersToTypeArgumentsBinder.visit(CastExpression ce) : invalid array type";
            if (this.type.isObject() && (objectType = (ObjectType)this.type).getTypeArguments() != null && !objectType.getTypeArguments().equals(WildcardTypeArgument.WILDCARD_TYPE_ARGUMENT)) {
                assert (expression.getType().isObject()) : "TypeParametersToTypeArgumentsBinder.visit(CastExpression ce) : invalid object type";
                ObjectType expressionObjectType = (ObjectType)expression.getType();
                if (objectType.getInternalName().equals(expressionObjectType.getInternalName())) {
                    Type expressionExpressionType = expression.getExpression().getType();
                    if (expressionExpressionType.isObject()) {
                        ObjectType expressionExpressionObjectType = (ObjectType)expressionExpressionType;
                        if (expressionExpressionObjectType.getTypeArguments() == null) {
                            expression.setType(objectType);
                        } else if (objectType.getTypeArguments().isTypeArgumentAssignableFrom(TypeParametersToTypeArgumentsBinder.this.contextualTypeBounds, expressionExpressionObjectType.getTypeArguments())) {
                            expression.setType(objectType);
                        }
                    } else if (expressionExpressionType.isGeneric()) {
                        expression.setType(objectType);
                    }
                }
            }
            this.type = expression.getType();
            expression.getExpression().accept(this);
        }

        @Override
        public void visit(TernaryOperatorExpression expression) {
            Type t = this.type;
            expression.setType(t);
            expression.getExpressionTrue().accept(this);
            this.type = t;
            expression.getExpressionFalse().accept(this);
        }

        @Override
        public void visit(BinaryOperatorExpression expression) {
            Type t = this.type;
            expression.getLeftExpression().accept(this);
            this.type = t;
            expression.getRightExpression().accept(this);
        }
    }
}

