/*
 * Decompiled with CFR 0.152.
 */
package sun.text.bidi;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.AttributedCharacterIterator;
import java.text.Bidi;
import java.util.Arrays;
import java.util.MissingResourceException;
import sun.text.bidi.BidiLine;
import sun.text.bidi.BidiRun;
import sun.text.normalizer.UBiDiProps;
import sun.text.normalizer.UCharacter;
import sun.text.normalizer.UTF16;

public class BidiBase {
    public static final byte INTERNAL_LEVEL_DEFAULT_LTR = 126;
    public static final byte INTERNAL_LEVEL_DEFAULT_RTL = 127;
    public static final byte MAX_EXPLICIT_LEVEL = 61;
    public static final byte INTERNAL_LEVEL_OVERRIDE = -128;
    public static final int MAP_NOWHERE = -1;
    public static final byte MIXED = 2;
    public static final short DO_MIRRORING = 2;
    private static final short REORDER_DEFAULT = 0;
    private static final short REORDER_NUMBERS_SPECIAL = 1;
    private static final short REORDER_GROUP_NUMBERS_WITH_R = 2;
    private static final short REORDER_RUNS_ONLY = 3;
    private static final short REORDER_INVERSE_NUMBERS_AS_L = 4;
    private static final short REORDER_INVERSE_LIKE_DIRECT = 5;
    private static final short REORDER_INVERSE_FOR_NUMBERS_SPECIAL = 6;
    private static final short REORDER_LAST_LOGICAL_TO_VISUAL = 1;
    private static final int OPTION_INSERT_MARKS = 1;
    private static final int OPTION_REMOVE_CONTROLS = 2;
    private static final int OPTION_STREAMING = 4;
    private static final byte L = 0;
    private static final byte R = 1;
    private static final byte EN = 2;
    private static final byte ES = 3;
    private static final byte ET = 4;
    private static final byte AN = 5;
    private static final byte CS = 6;
    static final byte B = 7;
    private static final byte S = 8;
    private static final byte WS = 9;
    private static final byte ON = 10;
    private static final byte LRE = 11;
    private static final byte LRO = 12;
    private static final byte AL = 13;
    private static final byte RLE = 14;
    private static final byte RLO = 15;
    private static final byte PDF = 16;
    private static final byte NSM = 17;
    private static final byte BN = 18;
    private static final int MASK_R_AL = 8194;
    private static final char CR = '\r';
    private static final char LF = '\n';
    static final int LRM_BEFORE = 1;
    static final int LRM_AFTER = 2;
    static final int RLM_BEFORE = 4;
    static final int RLM_AFTER = 8;
    BidiBase paraBidi;
    final UBiDiProps bdp;
    char[] text;
    int originalLength;
    public int length;
    int resultLength;
    boolean mayAllocateText;
    boolean mayAllocateRuns;
    byte[] dirPropsMemory = new byte[1];
    byte[] levelsMemory = new byte[1];
    byte[] dirProps;
    byte[] levels;
    boolean orderParagraphsLTR;
    byte paraLevel;
    byte defaultParaLevel;
    ImpTabPair impTabPair;
    byte direction;
    int flags;
    int lastArabicPos;
    int trailingWSStart;
    int paraCount;
    int[] parasMemory = new int[1];
    int[] paras;
    int[] simpleParas = new int[]{0};
    int runCount;
    BidiRun[] runsMemory = new BidiRun[0];
    BidiRun[] runs;
    BidiRun[] simpleRuns = new BidiRun[]{new BidiRun()};
    int[] logicalToVisualRunsMap;
    boolean isGoodLogicalToVisualRunsMap;
    InsertPoints insertPoints = new InsertPoints();
    int controlCount;
    static final byte CONTEXT_RTL_SHIFT = 6;
    static final byte CONTEXT_RTL = 64;
    static final int DirPropFlagMultiRuns = BidiBase.DirPropFlag((byte)31);
    static final int[] DirPropFlagLR = new int[]{BidiBase.DirPropFlag((byte)0), BidiBase.DirPropFlag((byte)1)};
    static final int[] DirPropFlagE = new int[]{BidiBase.DirPropFlag((byte)11), BidiBase.DirPropFlag((byte)14)};
    static final int[] DirPropFlagO = new int[]{BidiBase.DirPropFlag((byte)12), BidiBase.DirPropFlag((byte)15)};
    static final int MASK_LTR = BidiBase.DirPropFlag((byte)0) | BidiBase.DirPropFlag((byte)2) | BidiBase.DirPropFlag((byte)5) | BidiBase.DirPropFlag((byte)11) | BidiBase.DirPropFlag((byte)12);
    static final int MASK_RTL = BidiBase.DirPropFlag((byte)1) | BidiBase.DirPropFlag((byte)13) | BidiBase.DirPropFlag((byte)14) | BidiBase.DirPropFlag((byte)15);
    private static final int MASK_LRX = BidiBase.DirPropFlag((byte)11) | BidiBase.DirPropFlag((byte)12);
    private static final int MASK_RLX = BidiBase.DirPropFlag((byte)14) | BidiBase.DirPropFlag((byte)15);
    private static final int MASK_EXPLICIT = MASK_LRX | MASK_RLX | BidiBase.DirPropFlag((byte)16);
    private static final int MASK_BN_EXPLICIT = BidiBase.DirPropFlag((byte)18) | MASK_EXPLICIT;
    private static final int MASK_B_S = BidiBase.DirPropFlag((byte)7) | BidiBase.DirPropFlag((byte)8);
    static final int MASK_WS = MASK_B_S | BidiBase.DirPropFlag((byte)9) | MASK_BN_EXPLICIT;
    private static final int MASK_N = BidiBase.DirPropFlag((byte)10) | MASK_WS;
    private static final int MASK_POSSIBLE_N = BidiBase.DirPropFlag((byte)6) | BidiBase.DirPropFlag((byte)3) | BidiBase.DirPropFlag((byte)4) | MASK_N;
    static final int MASK_EMBEDDING = BidiBase.DirPropFlag((byte)17) | MASK_POSSIBLE_N;
    private static final int IMPTABPROPS_COLUMNS = 14;
    private static final int IMPTABPROPS_RES = 13;
    private static final short[] groupProp = new short[]{0, 1, 2, 7, 8, 3, 9, 6, 5, 4, 4, 10, 10, 12, 10, 10, 10, 11, 10};
    private static final short _L = 0;
    private static final short _R = 1;
    private static final short _EN = 2;
    private static final short _AN = 3;
    private static final short _ON = 4;
    private static final short _S = 5;
    private static final short _B = 6;
    private static final short[][] impTabProps = new short[][]{{1, 2, 4, 5, 7, 15, 17, 7, 9, 7, 0, 7, 3, 4}, {1, 34, 36, 37, 39, 47, 49, 39, 41, 39, 1, 1, 35, 0}, {33, 2, 36, 37, 39, 47, 49, 39, 41, 39, 2, 2, 35, 1}, {33, 34, 38, 38, 40, 48, 49, 40, 40, 40, 3, 3, 3, 1}, {33, 34, 4, 37, 39, 47, 49, 74, 11, 74, 4, 4, 35, 2}, {33, 34, 36, 5, 39, 47, 49, 39, 41, 76, 5, 5, 35, 3}, {33, 34, 6, 6, 40, 48, 49, 40, 40, 77, 6, 6, 35, 3}, {33, 34, 36, 37, 7, 47, 49, 7, 78, 7, 7, 7, 35, 4}, {33, 34, 38, 38, 8, 48, 49, 8, 8, 8, 8, 8, 35, 4}, {33, 34, 4, 37, 7, 47, 49, 7, 9, 7, 9, 9, 35, 4}, {97, 98, 4, 101, 135, 111, 113, 135, 142, 135, 10, 135, 99, 2}, {33, 34, 4, 37, 39, 47, 49, 39, 11, 39, 11, 11, 35, 2}, {97, 98, 100, 5, 135, 111, 113, 135, 142, 135, 12, 135, 99, 3}, {97, 98, 6, 6, 136, 112, 113, 136, 136, 136, 13, 136, 99, 3}, {33, 34, 132, 37, 7, 47, 49, 7, 14, 7, 14, 14, 35, 4}, {33, 34, 36, 37, 39, 15, 49, 39, 41, 39, 15, 39, 35, 5}, {33, 34, 38, 38, 40, 16, 49, 40, 40, 40, 16, 40, 35, 5}, {33, 34, 36, 37, 39, 47, 17, 39, 41, 39, 17, 39, 35, 6}};
    private static final int IMPTABLEVELS_COLUMNS = 8;
    private static final int IMPTABLEVELS_RES = 7;
    private static final byte[][] impTabL_DEFAULT = new byte[][]{{0, 1, 0, 2, 0, 0, 0, 0}, {0, 1, 3, 3, 20, 20, 0, 1}, {0, 1, 0, 2, 21, 21, 0, 2}, {0, 1, 3, 3, 20, 20, 0, 2}, {32, 1, 3, 3, 4, 4, 32, 1}, {32, 1, 32, 2, 5, 5, 32, 1}};
    private static final byte[][] impTabR_DEFAULT = new byte[][]{{1, 0, 2, 2, 0, 0, 0, 0}, {1, 0, 1, 3, 20, 20, 0, 1}, {1, 0, 2, 2, 0, 0, 0, 1}, {1, 0, 1, 3, 5, 5, 0, 1}, {33, 0, 33, 3, 4, 4, 0, 0}, {1, 0, 1, 3, 5, 5, 0, 0}};
    private static final short[] impAct0 = new short[]{0, 1, 2, 3, 4, 5, 6};
    private static final ImpTabPair impTab_DEFAULT = new ImpTabPair(impTabL_DEFAULT, impTabR_DEFAULT, impAct0, impAct0);
    private static final byte[][] impTabL_NUMBERS_SPECIAL = new byte[][]{{0, 2, 1, 1, 0, 0, 0, 0}, {0, 2, 1, 1, 0, 0, 0, 2}, {0, 2, 4, 4, 19, 0, 0, 1}, {32, 2, 4, 4, 3, 3, 32, 1}, {0, 2, 4, 4, 19, 19, 0, 2}};
    private static final ImpTabPair impTab_NUMBERS_SPECIAL = new ImpTabPair(impTabL_NUMBERS_SPECIAL, impTabR_DEFAULT, impAct0, impAct0);
    private static final byte[][] impTabL_GROUP_NUMBERS_WITH_R = new byte[][]{{0, 3, 17, 17, 0, 0, 0, 0}, {32, 3, 1, 1, 2, 32, 32, 2}, {32, 3, 1, 1, 2, 32, 32, 1}, {0, 3, 5, 5, 20, 0, 0, 1}, {32, 3, 5, 5, 4, 32, 32, 1}, {0, 3, 5, 5, 20, 0, 0, 2}};
    private static final byte[][] impTabR_GROUP_NUMBERS_WITH_R = new byte[][]{{2, 0, 1, 1, 0, 0, 0, 0}, {2, 0, 1, 1, 0, 0, 0, 1}, {2, 0, 20, 20, 19, 0, 0, 1}, {34, 0, 4, 4, 3, 0, 0, 0}, {34, 0, 4, 4, 3, 0, 0, 1}};
    private static final ImpTabPair impTab_GROUP_NUMBERS_WITH_R = new ImpTabPair(impTabL_GROUP_NUMBERS_WITH_R, impTabR_GROUP_NUMBERS_WITH_R, impAct0, impAct0);
    private static final byte[][] impTabL_INVERSE_NUMBERS_AS_L = new byte[][]{{0, 1, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 0, 20, 20, 0, 1}, {0, 1, 0, 0, 21, 21, 0, 2}, {0, 1, 0, 0, 20, 20, 0, 2}, {32, 1, 32, 32, 4, 4, 32, 1}, {32, 1, 32, 32, 5, 5, 32, 1}};
    private static final byte[][] impTabR_INVERSE_NUMBERS_AS_L = new byte[][]{{1, 0, 1, 1, 0, 0, 0, 0}, {1, 0, 1, 1, 20, 20, 0, 1}, {1, 0, 1, 1, 0, 0, 0, 1}, {1, 0, 1, 1, 5, 5, 0, 1}, {33, 0, 33, 33, 4, 4, 0, 0}, {1, 0, 1, 1, 5, 5, 0, 0}};
    private static final ImpTabPair impTab_INVERSE_NUMBERS_AS_L = new ImpTabPair(impTabL_INVERSE_NUMBERS_AS_L, impTabR_INVERSE_NUMBERS_AS_L, impAct0, impAct0);
    private static final byte[][] impTabR_INVERSE_LIKE_DIRECT = new byte[][]{{1, 0, 2, 2, 0, 0, 0, 0}, {1, 0, 1, 2, 19, 19, 0, 1}, {1, 0, 2, 2, 0, 0, 0, 1}, {33, 48, 6, 4, 3, 3, 48, 0}, {33, 48, 6, 4, 5, 5, 48, 3}, {33, 48, 6, 4, 5, 5, 48, 2}, {33, 48, 6, 4, 3, 3, 48, 1}};
    private static final short[] impAct1 = new short[]{0, 1, 11, 12};
    private static final ImpTabPair impTab_INVERSE_LIKE_DIRECT = new ImpTabPair(impTabL_DEFAULT, impTabR_INVERSE_LIKE_DIRECT, impAct0, impAct1);
    private static final byte[][] impTabL_INVERSE_LIKE_DIRECT_WITH_MARKS = new byte[][]{{0, 99, 0, 1, 0, 0, 0, 0}, {0, 99, 0, 1, 18, 48, 0, 4}, {32, 99, 32, 1, 2, 48, 32, 3}, {0, 99, 85, 86, 20, 48, 0, 3}, {48, 67, 85, 86, 4, 48, 48, 3}, {48, 67, 5, 86, 20, 48, 48, 4}, {48, 67, 85, 6, 20, 48, 48, 4}};
    private static final byte[][] impTabR_INVERSE_LIKE_DIRECT_WITH_MARKS = new byte[][]{{19, 0, 1, 1, 0, 0, 0, 0}, {35, 0, 1, 1, 2, 64, 0, 1}, {35, 0, 1, 1, 2, 64, 0, 0}, {3, 0, 3, 54, 20, 64, 0, 1}, {83, 64, 5, 54, 4, 64, 64, 0}, {83, 64, 5, 54, 4, 64, 64, 1}, {83, 64, 6, 6, 4, 64, 64, 3}};
    private static final short[] impAct2 = new short[]{0, 1, 7, 8, 9, 10};
    private static final ImpTabPair impTab_INVERSE_LIKE_DIRECT_WITH_MARKS = new ImpTabPair(impTabL_INVERSE_LIKE_DIRECT_WITH_MARKS, impTabR_INVERSE_LIKE_DIRECT_WITH_MARKS, impAct0, impAct2);
    private static final ImpTabPair impTab_INVERSE_FOR_NUMBERS_SPECIAL = new ImpTabPair(impTabL_NUMBERS_SPECIAL, impTabR_INVERSE_LIKE_DIRECT, impAct0, impAct1);
    private static final byte[][] impTabL_INVERSE_FOR_NUMBERS_SPECIAL_WITH_MARKS = new byte[][]{{0, 98, 1, 1, 0, 0, 0, 0}, {0, 98, 1, 1, 0, 48, 0, 4}, {0, 98, 84, 84, 19, 48, 0, 3}, {48, 66, 84, 84, 3, 48, 48, 3}, {48, 66, 4, 4, 19, 48, 48, 4}};
    private static final ImpTabPair impTab_INVERSE_FOR_NUMBERS_SPECIAL_WITH_MARKS = new ImpTabPair(impTabL_INVERSE_FOR_NUMBERS_SPECIAL_WITH_MARKS, impTabR_INVERSE_LIKE_DIRECT_WITH_MARKS, impAct0, impAct2);
    static final int FIRSTALLOC = 10;
    private static final int INTERNAL_DIRECTION_DEFAULT_LEFT_TO_RIGHT = 126;
    private static final int INTERMAL_DIRECTION_DEFAULT_RIGHT_TO_LEFT = 127;

    static int DirPropFlag(byte by) {
        return 1 << by;
    }

    static byte NoContextRTL(byte by) {
        return (byte)(by & 0xFFFFFFBF);
    }

    static int DirPropFlagNC(byte by) {
        return 1 << (by & 0xFFFFFFBF);
    }

    static final int DirPropFlagLR(byte by) {
        return DirPropFlagLR[by & 1];
    }

    static final int DirPropFlagE(byte by) {
        return DirPropFlagE[by & 1];
    }

    static final int DirPropFlagO(byte by) {
        return DirPropFlagO[by & 1];
    }

    private static byte GetLRFromLevel(byte by) {
        return (byte)(by & 1);
    }

    private static boolean IsDefaultLevel(byte by) {
        return (by & 0x7E) == 126;
    }

    byte GetParaLevelAt(int n) {
        return this.defaultParaLevel != 0 ? (byte)(this.dirProps[n] >> 6) : this.paraLevel;
    }

    static boolean IsBidiControlChar(int n) {
        return (n & 0xFFFFFFFC) == 8204 || n >= 8234 && n <= 8238;
    }

    public void verifyValidPara() {
        if (this != this.paraBidi) {
            throw new IllegalStateException("");
        }
    }

    public void verifyValidParaOrLine() {
        BidiBase bidiBase = this.paraBidi;
        if (this == bidiBase) {
            return;
        }
        if (bidiBase == null || bidiBase != bidiBase.paraBidi) {
            throw new IllegalStateException();
        }
    }

    public void verifyRange(int n, int n2, int n3) {
        if (n < n2 || n >= n3) {
            throw new IllegalArgumentException("Value " + n + " is out of range " + n2 + " to " + n3);
        }
    }

    public void verifyIndex(int n, int n2, int n3) {
        if (n < n2 || n >= n3) {
            throw new ArrayIndexOutOfBoundsException("Index " + n + " is out of range " + n2 + " to " + n3);
        }
    }

    public BidiBase(int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException();
        }
        try {
            this.bdp = UBiDiProps.getSingleton();
        }
        catch (IOException iOException) {
            throw new MissingResourceException(iOException.getMessage(), "(BidiProps)", "");
        }
        if (n > 0) {
            this.getInitialDirPropsMemory(n);
            this.getInitialLevelsMemory(n);
        } else {
            this.mayAllocateText = true;
        }
        if (n2 > 0) {
            if (n2 > 1) {
                this.getInitialRunsMemory(n2);
            }
        } else {
            this.mayAllocateRuns = true;
        }
    }

    private Object getMemory(String string, Object object, Class<?> clazz, boolean bl, int n) {
        int n2 = Array.getLength(object);
        if (n == n2) {
            return object;
        }
        if (!bl) {
            if (n <= n2) {
                return object;
            }
            throw new OutOfMemoryError("Failed to allocate memory for " + string);
        }
        try {
            return Array.newInstance(clazz, n);
        }
        catch (Exception exception) {
            throw new OutOfMemoryError("Failed to allocate memory for " + string);
        }
    }

    private void getDirPropsMemory(boolean bl, int n) {
        Object object = this.getMemory("DirProps", this.dirPropsMemory, Byte.TYPE, bl, n);
        this.dirPropsMemory = (byte[])object;
    }

    void getDirPropsMemory(int n) {
        this.getDirPropsMemory(this.mayAllocateText, n);
    }

    private void getLevelsMemory(boolean bl, int n) {
        Object object = this.getMemory("Levels", this.levelsMemory, Byte.TYPE, bl, n);
        this.levelsMemory = (byte[])object;
    }

    void getLevelsMemory(int n) {
        this.getLevelsMemory(this.mayAllocateText, n);
    }

    private void getRunsMemory(boolean bl, int n) {
        Object object = this.getMemory("Runs", this.runsMemory, BidiRun.class, bl, n);
        this.runsMemory = (BidiRun[])object;
    }

    void getRunsMemory(int n) {
        this.getRunsMemory(this.mayAllocateRuns, n);
    }

    private void getInitialDirPropsMemory(int n) {
        this.getDirPropsMemory(true, n);
    }

    private void getInitialLevelsMemory(int n) {
        this.getLevelsMemory(true, n);
    }

    private void getInitialParasMemory(int n) {
        Object object = this.getMemory("Paras", this.parasMemory, Integer.TYPE, true, n);
        this.parasMemory = (int[])object;
    }

    private void getInitialRunsMemory(int n) {
        this.getRunsMemory(true, n);
    }

    private void getDirProps() {
        int n;
        int n2;
        int n3 = 0;
        this.flags = 0;
        int n4 = 0;
        boolean bl = BidiBase.IsDefaultLevel(this.paraLevel);
        this.lastArabicPos = -1;
        this.controlCount = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (bl) {
            n2 = n4 = (this.paraLevel & 1) != 0 ? 64 : 0;
            n6 = n4;
            n = 1;
        } else {
            n = 0;
            n2 = 0;
        }
        n3 = 0;
        while (n3 < this.originalLength) {
            int n8 = n3;
            int n9 = UTF16.charAt(this.text, 0, this.originalLength, n3);
            int n10 = (n3 += Character.charCount(n9)) - 1;
            byte by = (byte)this.bdp.getClass(n9);
            this.flags |= BidiBase.DirPropFlag(by);
            this.dirProps[n10] = (byte)(by | n2);
            if (n10 > n8) {
                this.flags |= BidiBase.DirPropFlag((byte)18);
                do {
                    this.dirProps[--n10] = (byte)(0x12 | n2);
                } while (n10 > n8);
            }
            if (n == 1) {
                if (by == 0) {
                    n = 2;
                    if (n2 == 0) continue;
                    n2 = 0;
                    n10 = n5;
                    while (n10 < n3) {
                        int n11 = n10++;
                        this.dirProps[n11] = (byte)(this.dirProps[n11] & 0xFFFFFFBF);
                    }
                    continue;
                }
                if (by == 1 || by == 13) {
                    n = 2;
                    if (n2 != 0) continue;
                    n2 = 64;
                    n10 = n5;
                    while (n10 < n3) {
                        int n12 = n10++;
                        this.dirProps[n12] = (byte)(this.dirProps[n12] | 0x40);
                    }
                    continue;
                }
            }
            if (by == 0) {
                n6 = 0;
                n7 = n3;
                continue;
            }
            if (by == 1) {
                n6 = 64;
                continue;
            }
            if (by == 13) {
                n6 = 64;
                this.lastArabicPos = n3 - 1;
                continue;
            }
            if (by != 7 || n3 >= this.originalLength) continue;
            if (n9 != 13 || this.text[n3] != '\n') {
                ++this.paraCount;
            }
            if (!bl) continue;
            n = 1;
            n5 = n3;
            n2 = n4;
            n6 = n4;
        }
        if (bl) {
            this.paraLevel = this.GetParaLevelAt(0);
        }
        this.flags |= BidiBase.DirPropFlagLR(this.paraLevel);
        if (this.orderParagraphsLTR && (this.flags & BidiBase.DirPropFlag((byte)7)) != 0) {
            this.flags |= BidiBase.DirPropFlag((byte)0);
        }
    }

    private byte directionFromFlags() {
        if ((this.flags & MASK_RTL) == 0 && ((this.flags & BidiBase.DirPropFlag((byte)5)) == 0 || (this.flags & MASK_POSSIBLE_N) == 0)) {
            return 0;
        }
        if ((this.flags & MASK_LTR) == 0) {
            return 1;
        }
        return 2;
    }

    private byte resolveExplicitLevels() {
        int n = 0;
        byte by = this.GetParaLevelAt(0);
        int n2 = 0;
        byte by2 = this.directionFromFlags();
        if (by2 == 2 || this.paraCount != 1) {
            if (this.paraCount == 1 && (this.flags & MASK_EXPLICIT) == 0) {
                for (n = 0; n < this.length; ++n) {
                    this.levels[n] = by;
                }
            } else {
                byte by3 = by;
                int n3 = 0;
                byte[] byArray = new byte[61];
                int n4 = 0;
                int n5 = 0;
                this.flags = 0;
                for (n = 0; n < this.length; ++n) {
                    byte by4 = BidiBase.NoContextRTL(this.dirProps[n]);
                    switch (by4) {
                        case 11: 
                        case 12: {
                            byte by5 = (byte)(by3 + 2 & 0x7E);
                            if (by5 <= 61) {
                                byArray[n3] = by3;
                                n3 = (byte)(n3 + 1);
                                by3 = by5;
                                if (by4 == 12) {
                                    by3 = (byte)(by3 | 0xFFFFFF80);
                                }
                            } else if ((by3 & 0x7F) == 61) {
                                ++n5;
                            } else {
                                ++n4;
                            }
                            this.flags |= BidiBase.DirPropFlag((byte)18);
                            break;
                        }
                        case 14: 
                        case 15: {
                            byte by5 = (byte)((by3 & 0x7F) + 1 | 1);
                            if (by5 <= 61) {
                                byArray[n3] = by3;
                                n3 = (byte)(n3 + 1);
                                by3 = by5;
                                if (by4 == 15) {
                                    by3 = (byte)(by3 | 0xFFFFFF80);
                                }
                            } else {
                                ++n5;
                            }
                            this.flags |= BidiBase.DirPropFlag((byte)18);
                            break;
                        }
                        case 16: {
                            if (n5 > 0) {
                                --n5;
                            } else if (n4 > 0 && (by3 & 0x7F) != 61) {
                                --n4;
                            } else if (n3 > 0) {
                                n3 = (byte)(n3 - 1);
                                by3 = byArray[n3];
                            }
                            this.flags |= BidiBase.DirPropFlag((byte)18);
                            break;
                        }
                        case 7: {
                            n3 = 0;
                            n4 = 0;
                            n5 = 0;
                            by = this.GetParaLevelAt(n);
                            if (n + 1 < this.length) {
                                by3 = this.GetParaLevelAt(n + 1);
                                if (this.text[n] != '\r' || this.text[n + 1] != '\n') {
                                    this.paras[n2++] = n + 1;
                                }
                            }
                            this.flags |= BidiBase.DirPropFlag((byte)7);
                            break;
                        }
                        case 18: {
                            this.flags |= BidiBase.DirPropFlag((byte)18);
                            break;
                        }
                        default: {
                            if (by != by3) {
                                by = by3;
                                this.flags = (by & 0xFFFFFF80) != 0 ? (this.flags |= BidiBase.DirPropFlagO(by) | DirPropFlagMultiRuns) : (this.flags |= BidiBase.DirPropFlagE(by) | DirPropFlagMultiRuns);
                            }
                            if ((by & 0xFFFFFF80) != 0) break;
                            this.flags |= BidiBase.DirPropFlag(by4);
                        }
                    }
                    this.levels[n] = by;
                }
                if ((this.flags & MASK_EMBEDDING) != 0) {
                    this.flags |= BidiBase.DirPropFlagLR(this.paraLevel);
                }
                if (this.orderParagraphsLTR && (this.flags & BidiBase.DirPropFlag((byte)7)) != 0) {
                    this.flags |= BidiBase.DirPropFlag((byte)0);
                }
                by2 = this.directionFromFlags();
            }
        }
        return by2;
    }

    private byte checkExplicitLevels() {
        this.flags = 0;
        int n = 0;
        for (int i = 0; i < this.length; ++i) {
            if (this.levels[i] == 0) {
                this.levels[i] = this.paraLevel;
            }
            if (61 < (this.levels[i] & 0x7F)) {
                this.levels[i] = (this.levels[i] & 0xFFFFFF80) != 0 ? (byte)(this.paraLevel | 0xFFFFFF80) : this.paraLevel;
            }
            byte by = this.levels[i];
            byte by2 = BidiBase.NoContextRTL(this.dirProps[i]);
            if ((by & 0xFFFFFF80) != 0) {
                by = (byte)(by & 0x7F);
                this.flags |= BidiBase.DirPropFlagO(by);
            } else {
                this.flags |= BidiBase.DirPropFlagE(by) | BidiBase.DirPropFlag(by2);
            }
            if (by < this.GetParaLevelAt(i) && (0 != by || by2 != 7) || 61 < by) {
                throw new IllegalArgumentException("level " + by + " out of bounds at index " + i);
            }
            if (by2 != 7 || i + 1 >= this.length || this.text[i] == '\r' && this.text[i + 1] == '\n') continue;
            this.paras[n++] = i + 1;
        }
        if ((this.flags & MASK_EMBEDDING) != 0) {
            this.flags |= BidiBase.DirPropFlagLR(this.paraLevel);
        }
        return this.directionFromFlags();
    }

    private static short GetStateProps(short s) {
        return (short)(s & 0x1F);
    }

    private static short GetActionProps(short s) {
        return (short)(s >> 5);
    }

    private static short GetState(byte by) {
        return (short)(by & 0xF);
    }

    private static short GetAction(byte by) {
        return (short)(by >> 4);
    }

    private void addPoint(int n, int n2) {
        Point point = new Point();
        int n3 = this.insertPoints.points.length;
        if (n3 == 0) {
            this.insertPoints.points = new Point[10];
            n3 = 10;
        }
        if (this.insertPoints.size >= n3) {
            Point[] pointArray = this.insertPoints.points;
            this.insertPoints.points = new Point[n3 * 2];
            System.arraycopy(pointArray, 0, this.insertPoints.points, 0, n3);
        }
        point.pos = n;
        point.flag = n2;
        this.insertPoints.points[this.insertPoints.size] = point;
        ++this.insertPoints.size;
    }

    private void processPropertySeq(LevState levState, short s, int n, int n2) {
        int n3;
        byte by;
        byte[][] byArray = levState.impTab;
        short[] sArray = levState.impAct;
        int n4 = n;
        short s2 = levState.state;
        byte by2 = byArray[s2][s];
        levState.state = BidiBase.GetState(by2);
        short s3 = sArray[BidiBase.GetAction(by2)];
        byte by3 = byArray[levState.state][7];
        if (s3 != 0) {
            switch (s3) {
                case 1: {
                    levState.startON = n4;
                    break;
                }
                case 2: {
                    n = levState.startON;
                    break;
                }
                case 3: {
                    if (levState.startL2EN >= 0) {
                        this.addPoint(levState.startL2EN, 1);
                    }
                    levState.startL2EN = -1;
                    if (this.insertPoints.points.length == 0 || this.insertPoints.size <= this.insertPoints.confirmed) {
                        levState.lastStrongRTL = -1;
                        by = byArray[s2][7];
                        if ((by & 1) != 0 && levState.startON > 0) {
                            n = levState.startON;
                        }
                        if (s != 5) break;
                        this.addPoint(n4, 1);
                        this.insertPoints.confirmed = this.insertPoints.size;
                        break;
                    }
                    for (n3 = levState.lastStrongRTL + 1; n3 < n4; ++n3) {
                        this.levels[n3] = (byte)(this.levels[n3] - 2 & 0xFFFFFFFE);
                    }
                    this.insertPoints.confirmed = this.insertPoints.size;
                    levState.lastStrongRTL = -1;
                    if (s != 5) break;
                    this.addPoint(n4, 1);
                    this.insertPoints.confirmed = this.insertPoints.size;
                    break;
                }
                case 4: {
                    if (this.insertPoints.points.length > 0) {
                        this.insertPoints.size = this.insertPoints.confirmed;
                    }
                    levState.startON = -1;
                    levState.startL2EN = -1;
                    levState.lastStrongRTL = n2 - 1;
                    break;
                }
                case 5: {
                    if (s == 3 && BidiBase.NoContextRTL(this.dirProps[n4]) == 5) {
                        if (levState.startL2EN == -1) {
                            levState.lastStrongRTL = n2 - 1;
                            break;
                        }
                        if (levState.startL2EN >= 0) {
                            this.addPoint(levState.startL2EN, 1);
                            levState.startL2EN = -2;
                        }
                        this.addPoint(n4, 1);
                        break;
                    }
                    if (levState.startL2EN != -1) break;
                    levState.startL2EN = n4;
                    break;
                }
                case 6: {
                    levState.lastStrongRTL = n2 - 1;
                    levState.startON = -1;
                    break;
                }
                case 7: {
                    for (n3 = n4 - 1; n3 >= 0 && (this.levels[n3] & 1) == 0; --n3) {
                    }
                    if (n3 >= 0) {
                        this.addPoint(n3, 4);
                        this.insertPoints.confirmed = this.insertPoints.size;
                    }
                    levState.startON = n4;
                    break;
                }
                case 8: {
                    this.addPoint(n4, 1);
                    this.addPoint(n4, 2);
                    break;
                }
                case 9: {
                    this.insertPoints.size = this.insertPoints.confirmed;
                    if (s != 5) break;
                    this.addPoint(n4, 4);
                    this.insertPoints.confirmed = this.insertPoints.size;
                    break;
                }
                case 10: {
                    by = (byte)(levState.runLevel + by3);
                    for (n3 = levState.startON; n3 < n4; ++n3) {
                        if (this.levels[n3] >= by) continue;
                        this.levels[n3] = by;
                    }
                    this.insertPoints.confirmed = this.insertPoints.size;
                    levState.startON = n4;
                    break;
                }
                case 11: {
                    by = levState.runLevel;
                    for (n3 = n4 - 1; n3 >= levState.startON; --n3) {
                        if (this.levels[n3] == by + 3) {
                            while (this.levels[n3] == by + 3) {
                                int n5 = n3--;
                                this.levels[n5] = (byte)(this.levels[n5] - 2);
                            }
                            while (this.levels[n3] == by) {
                                --n3;
                            }
                        }
                        this.levels[n3] = this.levels[n3] == by + 2 ? by : (byte)(by + 1);
                    }
                    break;
                }
                case 12: {
                    by = (byte)(levState.runLevel + 1);
                    for (n3 = n4 - 1; n3 >= levState.startON; --n3) {
                        if (this.levels[n3] <= by) continue;
                        int n6 = n3;
                        this.levels[n6] = (byte)(this.levels[n6] - 2);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Internal ICU error in processPropertySeq");
                }
            }
        }
        if (by3 != 0 || n < n4) {
            by = (byte)(levState.runLevel + by3);
            for (n3 = n; n3 < n2; ++n3) {
                this.levels[n3] = by;
            }
        }
    }

    private void resolveImplicitLevels(int n, int n2, short s, short s2) {
        LevState levState = new LevState();
        boolean bl = true;
        int n3 = -1;
        levState.startL2EN = -1;
        levState.lastStrongRTL = -1;
        levState.state = 0;
        levState.runLevel = this.levels[n];
        levState.impTab = this.impTabPair.imptab[levState.runLevel & 1];
        levState.impAct = this.impTabPair.impact[levState.runLevel & 1];
        this.processPropertySeq(levState, s, n, n);
        short s3 = this.dirProps[n] == 17 ? (short)(1 + s) : (short)0;
        int n4 = n;
        int n5 = 0;
        block6: for (int i = n; i <= n2; ++i) {
            short s4;
            if (i >= n2) {
                s4 = s2;
            } else {
                short s5 = BidiBase.NoContextRTL(this.dirProps[i]);
                s4 = groupProp[s5];
            }
            short s6 = s3;
            short s7 = impTabProps[s6][s4];
            s3 = BidiBase.GetStateProps(s7);
            short s8 = BidiBase.GetActionProps(s7);
            if (i == n2 && s8 == 0) {
                s8 = 1;
            }
            if (s8 == 0) continue;
            short s9 = impTabProps[s6][13];
            switch (s8) {
                case 1: {
                    this.processPropertySeq(levState, s9, n4, i);
                    n4 = i;
                    continue block6;
                }
                case 2: {
                    n5 = i;
                    continue block6;
                }
                case 3: {
                    this.processPropertySeq(levState, s9, n4, n5);
                    this.processPropertySeq(levState, (short)4, n5, i);
                    n4 = i;
                    continue block6;
                }
                case 4: {
                    this.processPropertySeq(levState, s9, n4, n5);
                    n4 = n5;
                    n5 = i;
                    continue block6;
                }
                default: {
                    throw new IllegalStateException("Internal ICU error in resolveImplicitLevels");
                }
            }
        }
        this.processPropertySeq(levState, s2, n2, n2);
    }

    private void adjustWSLevels() {
        if ((this.flags & MASK_WS) != 0) {
            int n = this.trailingWSStart;
            block0: while (n > 0) {
                int n2;
                while (n > 0 && ((n2 = BidiBase.DirPropFlagNC(this.dirProps[--n])) & MASK_WS) != 0) {
                    if (this.orderParagraphsLTR && (n2 & BidiBase.DirPropFlag((byte)7)) != 0) {
                        this.levels[n] = 0;
                        continue;
                    }
                    this.levels[n] = this.GetParaLevelAt(n);
                }
                while (n > 0) {
                    if (((n2 = BidiBase.DirPropFlagNC(this.dirProps[--n])) & MASK_BN_EXPLICIT) != 0) {
                        this.levels[n] = this.levels[n + 1];
                        continue;
                    }
                    if (this.orderParagraphsLTR && (n2 & BidiBase.DirPropFlag((byte)7)) != 0) {
                        this.levels[n] = 0;
                        continue block0;
                    }
                    if ((n2 & MASK_B_S) == 0) continue;
                    this.levels[n] = this.GetParaLevelAt(n);
                    continue block0;
                }
            }
        }
    }

    private int Bidi_Min(int n, int n2) {
        return n < n2 ? n : n2;
    }

    private int Bidi_Abs(int n) {
        return n >= 0 ? n : -n;
    }

    void setPara(String string, byte by, byte[] byArray) {
        if (string == null) {
            this.setPara(new char[0], by, byArray);
        } else {
            this.setPara(string.toCharArray(), by, byArray);
        }
    }

    public void setPara(char[] cArray, byte by, byte[] byArray) {
        if (by < 126) {
            this.verifyRange(by, 0, 62);
        }
        if (cArray == null) {
            cArray = new char[]{};
        }
        this.paraBidi = null;
        this.text = cArray;
        this.originalLength = this.resultLength = this.text.length;
        this.length = this.resultLength;
        this.paraLevel = by;
        this.direction = 0;
        this.paraCount = 1;
        this.dirProps = new byte[0];
        this.levels = new byte[0];
        this.runs = new BidiRun[0];
        this.isGoodLogicalToVisualRunsMap = false;
        this.insertPoints.size = 0;
        this.insertPoints.confirmed = 0;
        this.defaultParaLevel = BidiBase.IsDefaultLevel(by) ? by : (byte)0;
        if (this.length == 0) {
            if (BidiBase.IsDefaultLevel(by)) {
                this.paraLevel = (byte)(this.paraLevel & 1);
                this.defaultParaLevel = 0;
            }
            if ((this.paraLevel & 1) != 0) {
                this.flags = BidiBase.DirPropFlag((byte)1);
                this.direction = 1;
            } else {
                this.flags = BidiBase.DirPropFlag((byte)0);
                this.direction = 0;
            }
            this.runCount = 0;
            this.paraCount = 0;
            this.paraBidi = this;
            return;
        }
        this.runCount = -1;
        this.getDirPropsMemory(this.length);
        this.dirProps = this.dirPropsMemory;
        this.getDirProps();
        this.trailingWSStart = this.length;
        if (this.paraCount > 1) {
            this.getInitialParasMemory(this.paraCount);
            this.paras = this.parasMemory;
            this.paras[this.paraCount - 1] = this.length;
        } else {
            this.paras = this.simpleParas;
            this.simpleParas[0] = this.length;
        }
        if (byArray == null) {
            this.getLevelsMemory(this.length);
            this.levels = this.levelsMemory;
            this.direction = this.resolveExplicitLevels();
        } else {
            this.levels = byArray;
            this.direction = this.checkExplicitLevels();
        }
        switch (this.direction) {
            case 0: {
                by = (byte)(by + 1 & 0xFFFFFFFE);
                this.trailingWSStart = 0;
                break;
            }
            case 1: {
                by = (byte)(by | 1);
                this.trailingWSStart = 0;
                break;
            }
            default: {
                this.impTabPair = impTab_DEFAULT;
                if (byArray == null && this.paraCount <= 1 && (this.flags & DirPropFlagMultiRuns) == 0) {
                    this.resolveImplicitLevels(0, this.length, BidiBase.GetLRFromLevel(this.GetParaLevelAt(0)), BidiBase.GetLRFromLevel(this.GetParaLevelAt(this.length - 1)));
                } else {
                    byte by2;
                    int n = 0;
                    byte by3 = this.GetParaLevelAt(0);
                    short s = by3 < (by2 = this.levels[0]) ? (short)BidiBase.GetLRFromLevel(by2) : (short)BidiBase.GetLRFromLevel(by3);
                    do {
                        int n2 = n;
                        by3 = by2;
                        short s2 = n2 > 0 && BidiBase.NoContextRTL(this.dirProps[n2 - 1]) == 7 ? (short)BidiBase.GetLRFromLevel(this.GetParaLevelAt(n2)) : s;
                        while (++n < this.length && this.levels[n] == by3) {
                        }
                        by2 = n < this.length ? this.levels[n] : this.GetParaLevelAt(this.length - 1);
                        s = (by3 & 0x7F) < (by2 & 0x7F) ? (short)BidiBase.GetLRFromLevel(by2) : (short)BidiBase.GetLRFromLevel(by3);
                        if ((by3 & 0xFFFFFF80) == 0) {
                            this.resolveImplicitLevels(n2, n, s2, s);
                            continue;
                        }
                        do {
                            int n3 = n2++;
                            this.levels[n3] = (byte)(this.levels[n3] & 0x7F);
                        } while (n2 < n);
                    } while (n < this.length);
                }
                this.adjustWSLevels();
            }
        }
        this.resultLength += this.insertPoints.size;
        this.paraBidi = this;
    }

    public void setPara(AttributedCharacterIterator attributedCharacterIterator) {
        char c = attributedCharacterIterator.first();
        Boolean bl = (Boolean)attributedCharacterIterator.getAttribute(TextAttributeConstants.RUN_DIRECTION);
        Object object = attributedCharacterIterator.getAttribute(TextAttributeConstants.NUMERIC_SHAPING);
        byte by = bl == null ? (byte)126 : (bl.equals(TextAttributeConstants.RUN_DIRECTION_LTR) ? (byte)0 : 1);
        byte[] byArray = null;
        int n = attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex();
        byte[] byArray2 = new byte[n];
        char[] cArray = new char[n];
        int n2 = 0;
        while (c != '\uffff') {
            byte by2;
            cArray[n2] = c;
            Integer n3 = (Integer)attributedCharacterIterator.getAttribute(TextAttributeConstants.BIDI_EMBEDDING);
            if (n3 != null && (by2 = n3.byteValue()) != 0) {
                if (by2 < 0) {
                    byArray = byArray2;
                    byArray2[n2] = (byte)(0 - by2 | 0xFFFFFF80);
                } else {
                    byArray = byArray2;
                    byArray2[n2] = by2;
                }
            }
            c = attributedCharacterIterator.next();
            ++n2;
        }
        if (object != null) {
            NumericShapings.shape(object, cArray, 0, n);
        }
        this.setPara(cArray, by, byArray);
    }

    private void orderParagraphsLTR(boolean bl) {
        this.orderParagraphsLTR = bl;
    }

    private byte getDirection() {
        this.verifyValidParaOrLine();
        return this.direction;
    }

    public int getLength() {
        this.verifyValidParaOrLine();
        return this.originalLength;
    }

    public byte getParaLevel() {
        this.verifyValidParaOrLine();
        return this.paraLevel;
    }

    public int getParagraphIndex(int n) {
        this.verifyValidParaOrLine();
        BidiBase bidiBase = this.paraBidi;
        this.verifyRange(n, 0, bidiBase.length);
        int n2 = 0;
        while (n >= bidiBase.paras[n2]) {
            ++n2;
        }
        return n2;
    }

    public Bidi setLine(Bidi bidi, BidiBase bidiBase, Bidi bidi2, BidiBase bidiBase2, int n, int n2) {
        this.verifyValidPara();
        this.verifyRange(n, 0, n2);
        this.verifyRange(n2, 0, this.length + 1);
        return BidiLine.setLine(bidi, this, bidi2, bidiBase2, n, n2);
    }

    public byte getLevelAt(int n) {
        if (n < 0 || n >= this.length) {
            return (byte)this.getBaseLevel();
        }
        this.verifyValidParaOrLine();
        this.verifyRange(n, 0, this.length);
        return BidiLine.getLevelAt(this, n);
    }

    private byte[] getLevels() {
        this.verifyValidParaOrLine();
        if (this.length <= 0) {
            return new byte[0];
        }
        return BidiLine.getLevels(this);
    }

    public int countRuns() {
        this.verifyValidParaOrLine();
        BidiLine.getRuns(this);
        return this.runCount;
    }

    private int[] getVisualMap() {
        this.countRuns();
        if (this.resultLength <= 0) {
            return new int[0];
        }
        return BidiLine.getVisualMap(this);
    }

    private static int[] reorderVisual(byte[] byArray) {
        return BidiLine.reorderVisual(byArray);
    }

    public BidiBase(char[] cArray, int n, byte[] byArray, int n2, int n3, int n4) {
        this(0, 0);
        byte[] byArray2;
        byte by;
        switch (n4) {
            default: {
                by = 0;
                break;
            }
            case 1: {
                by = 1;
                break;
            }
            case -2: {
                by = 126;
                break;
            }
            case -1: {
                by = 127;
            }
        }
        if (byArray == null) {
            byArray2 = null;
        } else {
            byArray2 = new byte[n3];
            for (int i = 0; i < n3; ++i) {
                byte by2 = byArray[i + n2];
                if (by2 < 0) {
                    by2 = (byte)(-by2 | 0xFFFFFF80);
                } else if (by2 == 0) {
                    by2 = by;
                    if (by > 61) {
                        by2 = (byte)(by2 & 1);
                    }
                }
                byArray2[i] = by2;
            }
        }
        if (n == 0 && n2 == 0 && n3 == cArray.length) {
            this.setPara(cArray, by, byArray2);
        } else {
            char[] cArray2 = new char[n3];
            System.arraycopy(cArray, n, cArray2, 0, n3);
            this.setPara(cArray2, by, byArray2);
        }
    }

    public boolean isMixed() {
        return !this.isLeftToRight() && !this.isRightToLeft();
    }

    public boolean isLeftToRight() {
        return this.getDirection() == 0 && (this.paraLevel & 1) == 0;
    }

    public boolean isRightToLeft() {
        return this.getDirection() == 1 && (this.paraLevel & 1) == 1;
    }

    public boolean baseIsLeftToRight() {
        return this.getParaLevel() == 0;
    }

    public int getBaseLevel() {
        return this.getParaLevel();
    }

    private void getLogicalToVisualRunsMap() {
        int n;
        if (this.isGoodLogicalToVisualRunsMap) {
            return;
        }
        int n2 = this.countRuns();
        if (this.logicalToVisualRunsMap == null || this.logicalToVisualRunsMap.length < n2) {
            this.logicalToVisualRunsMap = new int[n2];
        }
        long[] lArray = new long[n2];
        for (n = 0; n < n2; ++n) {
            lArray[n] = ((long)this.runs[n].start << 32) + (long)n;
        }
        Arrays.sort(lArray);
        for (n = 0; n < n2; ++n) {
            this.logicalToVisualRunsMap[n] = (int)(lArray[n] & 0xFFFFFFFFFFFFFFFFL);
        }
        lArray = null;
        this.isGoodLogicalToVisualRunsMap = true;
    }

    public int getRunLevel(int n) {
        this.verifyValidParaOrLine();
        BidiLine.getRuns(this);
        if (n < 0 || n >= this.runCount) {
            return this.getParaLevel();
        }
        this.getLogicalToVisualRunsMap();
        return this.runs[this.logicalToVisualRunsMap[n]].level;
    }

    public int getRunStart(int n) {
        this.verifyValidParaOrLine();
        BidiLine.getRuns(this);
        if (this.runCount == 1) {
            return 0;
        }
        if (n == this.runCount) {
            return this.length;
        }
        this.verifyIndex(n, 0, this.runCount);
        this.getLogicalToVisualRunsMap();
        return this.runs[this.logicalToVisualRunsMap[n]].start;
    }

    public int getRunLimit(int n) {
        this.verifyValidParaOrLine();
        BidiLine.getRuns(this);
        if (this.runCount == 1) {
            return this.length;
        }
        this.verifyIndex(n, 0, this.runCount);
        this.getLogicalToVisualRunsMap();
        int n2 = this.logicalToVisualRunsMap[n];
        int n3 = n2 == 0 ? this.runs[n2].limit : this.runs[n2].limit - this.runs[n2 - 1].limit;
        return this.runs[n2].start + n3;
    }

    public static boolean requiresBidi(char[] cArray, int n, int n2) {
        if (0 > n || n > n2 || n2 > cArray.length) {
            throw new IllegalArgumentException("Value start " + n + " is out of range 0 to " + n2);
        }
        for (int i = n; i < n2; ++i) {
            if (!(Character.isHighSurrogate(cArray[i]) && i < n2 - 1 && Character.isLowSurrogate(cArray[i + 1]) ? (1 << UCharacter.getDirection(Character.codePointAt(cArray, i)) & 0xE022) != 0 : (1 << UCharacter.getDirection(cArray[i]) & 0xE022) != 0)) continue;
            return true;
        }
        return false;
    }

    public static void reorderVisually(byte[] byArray, int n, Object[] objectArray, int n2, int n3) {
        if (0 > n || byArray.length <= n) {
            throw new IllegalArgumentException("Value levelStart " + n + " is out of range 0 to " + (byArray.length - 1));
        }
        if (0 > n2 || objectArray.length <= n2) {
            throw new IllegalArgumentException("Value objectStart " + n + " is out of range 0 to " + (objectArray.length - 1));
        }
        if (0 > n3 || objectArray.length - n3 < n2) {
            throw new IllegalArgumentException("Value count " + n + " is out of range 0 to " + (objectArray.length - n2));
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n, byArray2, 0, n3);
        int[] nArray = BidiBase.reorderVisual(byArray2);
        Object[] objectArray2 = new Object[n3];
        System.arraycopy(objectArray, n2, objectArray2, 0, n3);
        for (int i = 0; i < n3; ++i) {
            objectArray[n2 + i] = objectArray2[nArray[i]];
        }
    }

    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getName());
        stringBuilder.append("[dir: ");
        stringBuilder.append(this.direction);
        stringBuilder.append(" baselevel: ");
        stringBuilder.append(this.paraLevel);
        stringBuilder.append(" length: ");
        stringBuilder.append(this.length);
        stringBuilder.append(" runs: ");
        if (this.levels == null) {
            stringBuilder.append("none");
        } else {
            stringBuilder.append('[');
            stringBuilder.append(this.levels[0]);
            for (n = 1; n < this.levels.length; ++n) {
                stringBuilder.append(' ');
                stringBuilder.append(this.levels[n]);
            }
            stringBuilder.append(']');
        }
        stringBuilder.append(" text: [0x");
        stringBuilder.append(Integer.toHexString(this.text[0]));
        for (n = 1; n < this.text.length; ++n) {
            stringBuilder.append(" 0x");
            stringBuilder.append(Integer.toHexString(this.text[n]));
        }
        stringBuilder.append("]]");
        return stringBuilder.toString();
    }

    private static class NumericShapings {
        private static final Class<?> clazz = NumericShapings.getClass("java.awt.font.NumericShaper");
        private static final Method shapeMethod = NumericShapings.getMethod(clazz, "shape", char[].class, Integer.TYPE, Integer.TYPE);

        private NumericShapings() {
        }

        private static Class<?> getClass(String string) {
            try {
                return Class.forName(string, true, null);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }

        private static Method getMethod(Class<?> clazz, String string, Class<?> ... classArray) {
            if (clazz != null) {
                try {
                    return clazz.getMethod(string, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new AssertionError((Object)noSuchMethodException);
                }
            }
            return null;
        }

        static void shape(Object object, char[] cArray, int n, int n2) {
            if (shapeMethod == null) {
                throw new AssertionError((Object)"Should not get here");
            }
            try {
                shapeMethod.invoke(object, cArray, n, n2);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw new AssertionError((Object)invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
        }
    }

    private static class TextAttributeConstants {
        private static final Class<?> clazz = TextAttributeConstants.getClass("java.awt.font.TextAttribute");
        static final AttributedCharacterIterator.Attribute RUN_DIRECTION = TextAttributeConstants.getTextAttribute("RUN_DIRECTION");
        static final AttributedCharacterIterator.Attribute NUMERIC_SHAPING = TextAttributeConstants.getTextAttribute("NUMERIC_SHAPING");
        static final AttributedCharacterIterator.Attribute BIDI_EMBEDDING = TextAttributeConstants.getTextAttribute("BIDI_EMBEDDING");
        static final Boolean RUN_DIRECTION_LTR = clazz == null ? Boolean.FALSE : (Boolean)TextAttributeConstants.getStaticField(clazz, "RUN_DIRECTION_LTR");

        private TextAttributeConstants() {
        }

        private static Class<?> getClass(String string) {
            try {
                return Class.forName(string, true, null);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }

        private static Object getStaticField(Class<?> clazz, String string) {
            try {
                Field field = clazz.getField(string);
                return field.get(null);
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                throw new AssertionError((Object)reflectiveOperationException);
            }
        }

        private static AttributedCharacterIterator.Attribute getTextAttribute(String string) {
            if (clazz == null) {
                return new AttributedCharacterIterator.Attribute(string){};
            }
            return (AttributedCharacterIterator.Attribute)TextAttributeConstants.getStaticField(clazz, string);
        }
    }

    private class LevState {
        byte[][] impTab;
        short[] impAct;
        int startON;
        int startL2EN;
        int lastStrongRTL;
        short state;
        byte runLevel;

        private LevState() {
        }
    }

    private static class ImpTabPair {
        byte[][][] imptab;
        short[][] impact;

        ImpTabPair(byte[][] byArray, byte[][] byArray2, short[] sArray, short[] sArray2) {
            this.imptab = new byte[][][]{byArray, byArray2};
            this.impact = new short[][]{sArray, sArray2};
        }
    }

    class InsertPoints {
        int size;
        int confirmed;
        Point[] points = new Point[0];

        InsertPoints() {
        }
    }

    class Point {
        int pos;
        int flag;

        Point() {
        }
    }
}

