/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.record;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.biginteger.ModifiableBigInteger;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.modifiablevariable.singlebyte.ModifiableByte;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.ProtocolMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.record.AbstractRecord;
import de.rub.nds.tlsattacker.core.record.RecordCryptoComputations;
import de.rub.nds.tlsattacker.core.record.compressor.RecordCompressor;
import de.rub.nds.tlsattacker.core.record.crypto.Encryptor;
import de.rub.nds.tlsattacker.core.record.parser.RecordParser;
import de.rub.nds.tlsattacker.core.record.preparator.RecordPreparator;
import de.rub.nds.tlsattacker.core.record.serializer.RecordSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.math.BigInteger;
import java.util.Objects;

public class Record
extends AbstractRecord {
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.TLS_CONSTANT)
    private ModifiableByte contentType;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.TLS_CONSTANT)
    private ModifiableByteArray protocolVersion;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.LENGTH)
    private ModifiableInteger length;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.COUNT)
    private ModifiableInteger epoch;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.COUNT)
    private ModifiableBigInteger sequenceNumber;
    private RecordCryptoComputations computations;

    public Record(Config config) {
        super(config);
    }

    public Record() {
    }

    public ModifiableInteger getLength() {
        return this.length;
    }

    public ModifiableByte getContentType() {
        return this.contentType;
    }

    public ModifiableByteArray getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setLength(ModifiableInteger length) {
        this.length = length;
    }

    public void setContentType(ModifiableByte contentType) {
        this.contentType = contentType;
    }

    public void setProtocolVersion(ModifiableByteArray protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public void setLength(int length) {
        this.length = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.length, (Integer)length);
    }

    public void setContentType(byte contentType) {
        this.contentType = ModifiableVariableFactory.safelySetValue((ModifiableByte)this.contentType, (Byte)contentType);
    }

    public void setProtocolVersion(byte[] array) {
        this.protocolVersion = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.protocolVersion, (byte[])array);
    }

    public ModifiableInteger getEpoch() {
        return this.epoch;
    }

    public void setEpoch(ModifiableInteger epoch) {
        this.epoch = epoch;
    }

    public void setEpoch(Integer epoch) {
        this.epoch = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.epoch, (Integer)epoch);
    }

    public ModifiableBigInteger getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(ModifiableBigInteger sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public void setSequenceNumber(BigInteger sequenceNumber) {
        this.sequenceNumber = ModifiableVariableFactory.safelySetValue((ModifiableBigInteger)this.sequenceNumber, (BigInteger)sequenceNumber);
    }

    @Override
    public RecordPreparator getRecordPreparator(Chooser chooser, Encryptor encryptor, RecordCompressor compressor, ProtocolMessageType type) {
        return new RecordPreparator(chooser, this, encryptor, type, compressor);
    }

    @Override
    public RecordParser getRecordParser(int startposition, byte[] array, ProtocolVersion version) {
        return new RecordParser(0, array, version);
    }

    @Override
    public RecordSerializer getRecordSerializer() {
        return new RecordSerializer(this);
    }

    @Override
    public void adjustContext(TlsContext context) {
        ProtocolVersion version = ProtocolVersion.getProtocolVersion((byte[])this.getProtocolVersion().getValue());
        context.setLastRecordVersion(version);
    }

    public RecordCryptoComputations getComputations() {
        return this.computations;
    }

    public void setComputations(RecordCryptoComputations computations) {
        this.computations = computations;
    }

    @Override
    public void prepareComputations() {
        if (this.computations == null) {
            this.computations = new RecordCryptoComputations();
        }
    }

    public String toString() {
        return "Record{contentType=" + this.contentType + ", protocolVersion=" + this.protocolVersion + ", length=" + this.length + '}';
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + Objects.hashCode(this.contentType);
        hash = 41 * hash + Objects.hashCode(this.protocolVersion);
        hash = 41 * hash + Objects.hashCode(this.length);
        hash = 41 * hash + Objects.hashCode(this.epoch);
        hash = 41 * hash + Objects.hashCode(this.sequenceNumber);
        hash = 41 * hash + Objects.hashCode(this.computations);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Record other = (Record)obj;
        if (!Objects.equals(this.contentType, other.contentType)) {
            return false;
        }
        if (!Objects.equals(this.protocolVersion, other.protocolVersion)) {
            return false;
        }
        if (!Objects.equals(this.length, other.length)) {
            return false;
        }
        if (!Objects.equals(this.epoch, other.epoch)) {
            return false;
        }
        if (!Objects.equals(this.sequenceNumber, other.sequenceNumber)) {
            return false;
        }
        return Objects.equals(this.computations, other.computations);
    }
}

