/* This file is public domain. Author: Fredrik Johansson. */

#include <string.h>
#include "profiler.h"
#include "ca.h"
#include "gr.h"

int gr_sqrt_ui(gr_ptr x, ulong y, gr_ctx_t ctx)
{
    int status = gr_set_ui(x, y, ctx);
    status |= gr_sqrt(x, x, ctx);
    return status;
}

void CONST_I(gr_ptr r, gr_ctx_t ctx) { GR_MUST_SUCCEED(gr_i(r, ctx)); }
void SET_SI(gr_ptr r, slong x, gr_ctx_t ctx) { GR_MUST_SUCCEED(gr_set_si(r, x, ctx)); }
void NEG(gr_ptr r, gr_srcptr x, gr_ctx_t ctx) { GR_MUST_SUCCEED(gr_neg(r, x, ctx)); }
void ABS(gr_ptr r, gr_srcptr x, gr_ctx_t ctx) { GR_MUST_SUCCEED(gr_abs(r, x, ctx)); }
void INV(gr_ptr r, gr_srcptr x, gr_ctx_t ctx) { GR_MUST_SUCCEED(gr_inv(r, x, ctx)); }
void SQRT(gr_ptr r, gr_srcptr x, gr_ctx_t ctx) { GR_MUST_SUCCEED(gr_sqrt(r, x, ctx)); }
void ADD(gr_ptr r, gr_srcptr x, gr_srcptr y, gr_ctx_t ctx) { GR_MUST_SUCCEED(gr_add(r, x, y, ctx)); }
void SUB(gr_ptr r, gr_srcptr x, gr_srcptr y, gr_ctx_t ctx) { GR_MUST_SUCCEED(gr_sub(r, x, y, ctx)); }
void MUL(gr_ptr r, gr_srcptr x, gr_srcptr y, gr_ctx_t ctx) { GR_MUST_SUCCEED(gr_mul(r, x, y, ctx)); }
void DIV(gr_ptr r, gr_srcptr x, gr_srcptr y, gr_ctx_t ctx) { GR_MUST_SUCCEED(gr_div(r, x, y, ctx)); }
void POW(gr_ptr r, gr_srcptr x, gr_srcptr y, gr_ctx_t ctx) { GR_MUST_SUCCEED(gr_pow(r, x, y, ctx)); }
void ADD_SI(gr_ptr r, gr_srcptr x, slong y, gr_ctx_t ctx) { GR_MUST_SUCCEED(gr_add_si(r, x, y, ctx)); }
void SUB_SI(gr_ptr r, gr_srcptr x, slong y, gr_ctx_t ctx) { GR_MUST_SUCCEED(gr_sub_si(r, x, y, ctx)); }
void MUL_SI(gr_ptr r, gr_srcptr x, slong y, gr_ctx_t ctx) { GR_MUST_SUCCEED(gr_mul_si(r, x, y, ctx)); }
void DIV_SI(gr_ptr r, gr_srcptr x, slong y, gr_ctx_t ctx) { GR_MUST_SUCCEED(gr_div_si(r, x, y, ctx)); }
void SQRT_UI(gr_ptr r, ulong x, gr_ctx_t ctx) { GR_MUST_SUCCEED(gr_sqrt_ui(r, x, ctx)); }
void POW_UI(gr_ptr r, gr_srcptr x, ulong y, gr_ctx_t ctx) { GR_MUST_SUCCEED(gr_pow_ui(r, x, y, ctx)); }


void doit(gr_ctx_t ctx)
{
    gr_ptr N, M, E;
    gr_ptr tmp0, tmp1, tmp2, tmp3, tmp4, tmp5, tmp6, tmp7, tmp8, tmp9,
        tmp10, tmp11, tmp12, tmp13, tmp14, tmp15, tmp16, tmp17, tmp18,
        tmp19, tmp20, tmp21, tmp22, tmp23, tmp24, tmp25, tmp26, tmp27,
        tmp28, tmp29, tmp30, tmp31, tmp32, tmp33, tmp34;
    truth_t equal;
    int status = GR_SUCCESS;

    gr_ctx_println(ctx);

    GR_TMP_INIT3(N, M, E, ctx);
    GR_TMP_INIT5(tmp0, tmp1, tmp2, tmp3, tmp4, ctx);
    GR_TMP_INIT5(tmp5, tmp6, tmp7, tmp8, tmp9, ctx);
    GR_TMP_INIT5(tmp10, tmp11, tmp12, tmp13, tmp14, ctx);
    GR_TMP_INIT5(tmp15, tmp16, tmp17, tmp18, tmp19, ctx);
    GR_TMP_INIT5(tmp20, tmp21, tmp22, tmp23, tmp24, ctx);
    GR_TMP_INIT5(tmp25, tmp26, tmp27, tmp28, tmp29, ctx);
    GR_TMP_INIT5(tmp30, tmp31, tmp32, tmp33, tmp34, ctx);

    flint_printf("Evaluating N...\n");
    TIMEIT_ONCE_START
    SET_SI(tmp3, 1, ctx);
    DIV_SI(tmp3, tmp3, 16, ctx);
    SQRT_UI(tmp11, 2, ctx);
    MUL_SI(tmp11, tmp11, 7, ctx);
    SUB_SI(tmp11, tmp11, 10, ctx);
    MUL_SI(tmp11, tmp11, 44, ctx);
    SQRT_UI(tmp12, 2, ctx);
    ADD_SI(tmp12, tmp12, 2, ctx);
    SQRT(tmp12, tmp12, ctx);
    MUL(tmp10, tmp11, tmp12, ctx);
    SQRT_UI(tmp11, 2, ctx);
    MUL_SI(tmp11, tmp11, -17, ctx);
    ADD_SI(tmp11, tmp11, 26, ctx);
    SQRT(tmp11, tmp11, ctx);
    MUL(tmp9, tmp10, tmp11, ctx);
    SQRT_UI(tmp16, 2, ctx);
    MUL_SI(tmp16, tmp16, 7, ctx);
    SUB_SI(tmp16, tmp16, 10, ctx);
    MUL_SI(tmp16, tmp16, 11, ctx);
    SQRT_UI(tmp17, 2, ctx);
    ADD_SI(tmp17, tmp17, 2, ctx);
    SQRT(tmp17, tmp17, ctx);
    MUL(tmp15, tmp16, tmp17, ctx);
    SQRT_UI(tmp16, 2, ctx);
    MUL_SI(tmp16, tmp16, -17, ctx);
    ADD_SI(tmp16, tmp16, 26, ctx);
    SQRT(tmp16, tmp16, ctx);
    MUL(tmp14, tmp15, tmp16, ctx);
    SQRT_UI(tmp16, 2, ctx);
    MUL_SI(tmp16, tmp16, 63, ctx);
    SUB_SI(tmp16, tmp16, 89, ctx);
    MUL_SI(tmp16, tmp16, 10, ctx);
    SQRT_UI(tmp17, 2, ctx);
    ADD_SI(tmp17, tmp17, 2, ctx);
    SQRT(tmp17, tmp17, ctx);
    MUL(tmp15, tmp16, tmp17, ctx);
    SUB(tmp13, tmp14, tmp15, ctx);
    SQRT_UI(tmp18, 2, ctx);
    MUL_SI(tmp18, tmp18, 3, ctx);
    SUB_SI(tmp18, tmp18, 4, ctx);
    MUL_SI(tmp18, tmp18, 3, ctx);
    SQRT_UI(tmp19, 2, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp18, 2, ctx);
    MUL_SI(tmp18, tmp18, -17, ctx);
    ADD_SI(tmp18, tmp18, 26, ctx);
    SQRT(tmp18, tmp18, ctx);
    MUL(tmp16, tmp17, tmp18, ctx);
    SQRT_UI(tmp18, 2, ctx);
    MUL_SI(tmp18, tmp18, 85, ctx);
    SUB_SI(tmp18, tmp18, 122, ctx);
    SQRT_UI(tmp19, 2, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    SUB(tmp15, tmp16, tmp17, ctx);
    SQRT_UI(tmp16, 2, ctx);
    NEG(tmp16, tmp16, ctx);
    ADD_SI(tmp16, tmp16, 2, ctx);
    SQRT(tmp16, tmp16, ctx);
    MUL(tmp14, tmp15, tmp16, ctx);
    SUB(tmp12, tmp13, tmp14, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, 3, ctx);
    SUB_SI(tmp19, tmp19, 4, ctx);
    MUL_SI(tmp19, tmp19, 3, ctx);
    SQRT_UI(tmp20, 2, ctx);
    MUL_SI(tmp20, tmp20, -17, ctx);
    ADD_SI(tmp20, tmp20, 26, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, 85, ctx);
    SUB(tmp17, tmp18, tmp19, ctx);
    ADD_SI(tmp17, tmp17, 122, ctx);
    SQRT_UI(tmp18, 2, ctx);
    NEG(tmp18, tmp18, ctx);
    ADD_SI(tmp18, tmp18, 2, ctx);
    SQRT(tmp18, tmp18, ctx);
    MUL(tmp16, tmp17, tmp18, ctx);
    SQRT_UI(tmp18, 2, ctx);
    MUL_SI(tmp18, tmp18, 7, ctx);
    SUB_SI(tmp18, tmp18, 10, ctx);
    MUL_SI(tmp18, tmp18, 11, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, -17, ctx);
    ADD_SI(tmp19, tmp19, 26, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    SUB(tmp15, tmp16, tmp17, ctx);
    SQRT_UI(tmp16, 2, ctx);
    MUL_SI(tmp16, tmp16, 630, ctx);
    ADD(tmp14, tmp15, tmp16, ctx);
    SUB_SI(tmp14, tmp14, 890, ctx);
    MUL_SI(tmp14, tmp14, 2, ctx);
    SQRT_UI(tmp15, 2, ctx);
    ADD_SI(tmp15, tmp15, 2, ctx);
    SQRT(tmp15, tmp15, ctx);
    SUB_SI(tmp15, tmp15, 1, ctx);
    SQRT(tmp15, tmp15, ctx);
    MUL(tmp13, tmp14, tmp15, ctx);
    ADD(tmp11, tmp12, tmp13, ctx);
    MUL_SI(tmp11, tmp11, 2, ctx);
    SQRT_UI(tmp13, 2, ctx);
    MUL_SI(tmp13, tmp13, 3, ctx);
    SQRT_UI(tmp14, 2, ctx);
    MUL_SI(tmp14, tmp14, -17, ctx);
    ADD_SI(tmp14, tmp14, 26, ctx);
    SQRT(tmp14, tmp14, ctx);
    ADD(tmp12, tmp13, tmp14, ctx);
    SUB_SI(tmp12, tmp12, 3, ctx);
    SQRT(tmp12, tmp12, ctx);
    MUL(tmp10, tmp11, tmp12, ctx);
    ADD(tmp8, tmp9, tmp10, ctx);
    SQRT_UI(tmp10, 2, ctx);
    MUL_SI(tmp10, tmp10, 63, ctx);
    SUB_SI(tmp10, tmp10, 89, ctx);
    MUL_SI(tmp10, tmp10, 40, ctx);
    SQRT_UI(tmp11, 2, ctx);
    ADD_SI(tmp11, tmp11, 2, ctx);
    SQRT(tmp11, tmp11, ctx);
    MUL(tmp9, tmp10, tmp11, ctx);
    SUB(tmp7, tmp8, tmp9, ctx);
    SQRT_UI(tmp12, 2, ctx);
    MUL_SI(tmp12, tmp12, 3, ctx);
    SUB_SI(tmp12, tmp12, 4, ctx);
    MUL_SI(tmp12, tmp12, 3, ctx);
    SQRT_UI(tmp13, 2, ctx);
    ADD_SI(tmp13, tmp13, 2, ctx);
    SQRT(tmp13, tmp13, ctx);
    MUL(tmp11, tmp12, tmp13, ctx);
    SQRT_UI(tmp12, 2, ctx);
    MUL_SI(tmp12, tmp12, -17, ctx);
    ADD_SI(tmp12, tmp12, 26, ctx);
    SQRT(tmp12, tmp12, ctx);
    MUL(tmp10, tmp11, tmp12, ctx);
    SQRT_UI(tmp12, 2, ctx);
    MUL_SI(tmp12, tmp12, 85, ctx);
    SUB_SI(tmp12, tmp12, 122, ctx);
    SQRT_UI(tmp13, 2, ctx);
    ADD_SI(tmp13, tmp13, 2, ctx);
    SQRT(tmp13, tmp13, ctx);
    MUL(tmp11, tmp12, tmp13, ctx);
    SUB(tmp9, tmp10, tmp11, ctx);
    MUL_SI(tmp9, tmp9, 4, ctx);
    SQRT_UI(tmp10, 2, ctx);
    NEG(tmp10, tmp10, ctx);
    ADD_SI(tmp10, tmp10, 2, ctx);
    SQRT(tmp10, tmp10, ctx);
    MUL(tmp8, tmp9, tmp10, ctx);
    SUB(tmp6, tmp7, tmp8, ctx);
    SQRT_UI(tmp14, 2, ctx);
    MUL_SI(tmp14, tmp14, 5, ctx);
    SUB_SI(tmp14, tmp14, 7, ctx);
    MUL_SI(tmp14, tmp14, 22, ctx);
    SQRT_UI(tmp15, 2, ctx);
    ADD_SI(tmp15, tmp15, 2, ctx);
    SQRT(tmp15, tmp15, ctx);
    MUL(tmp13, tmp14, tmp15, ctx);
    SQRT_UI(tmp14, 2, ctx);
    MUL_SI(tmp14, tmp14, -17, ctx);
    ADD_SI(tmp14, tmp14, 26, ctx);
    SQRT(tmp14, tmp14, ctx);
    MUL(tmp12, tmp13, tmp14, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, 5, ctx);
    SUB_SI(tmp19, tmp19, 7, ctx);
    MUL_SI(tmp19, tmp19, 11, ctx);
    SQRT_UI(tmp20, 2, ctx);
    ADD_SI(tmp20, tmp20, 2, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, -17, ctx);
    ADD_SI(tmp19, tmp19, 26, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, 89, ctx);
    SUB_SI(tmp19, tmp19, 126, ctx);
    MUL_SI(tmp19, tmp19, 5, ctx);
    SQRT_UI(tmp20, 2, ctx);
    ADD_SI(tmp20, tmp20, 2, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL(tmp18, tmp19, tmp20, ctx);
    SUB(tmp16, tmp17, tmp18, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, 2, ctx);
    SUB_SI(tmp21, tmp21, 3, ctx);
    MUL_SI(tmp21, tmp21, 3, ctx);
    SQRT_UI(tmp22, 2, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, -17, ctx);
    ADD_SI(tmp21, tmp21, 26, ctx);
    SQRT(tmp21, tmp21, ctx);
    MUL(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, 61, ctx);
    SUB_SI(tmp21, tmp21, 85, ctx);
    SQRT_UI(tmp22, 2, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SUB(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp19, 2, ctx);
    NEG(tmp19, tmp19, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    SUB(tmp15, tmp16, tmp17, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, 2, ctx);
    SUB_SI(tmp22, tmp22, 3, ctx);
    MUL_SI(tmp22, tmp22, 3, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, -17, ctx);
    ADD_SI(tmp23, tmp23, 26, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, 61, ctx);
    SUB(tmp20, tmp21, tmp22, ctx);
    ADD_SI(tmp20, tmp20, 85, ctx);
    SQRT_UI(tmp21, 2, ctx);
    NEG(tmp21, tmp21, ctx);
    ADD_SI(tmp21, tmp21, 2, ctx);
    SQRT(tmp21, tmp21, ctx);
    MUL(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, 5, ctx);
    SUB_SI(tmp21, tmp21, 7, ctx);
    MUL_SI(tmp21, tmp21, 11, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, -17, ctx);
    ADD_SI(tmp22, tmp22, 26, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SUB(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, 445, ctx);
    ADD(tmp17, tmp18, tmp19, ctx);
    SUB_SI(tmp17, tmp17, 630, ctx);
    MUL_SI(tmp17, tmp17, 2, ctx);
    SQRT_UI(tmp18, 2, ctx);
    ADD_SI(tmp18, tmp18, 2, ctx);
    SQRT(tmp18, tmp18, ctx);
    SUB_SI(tmp18, tmp18, 1, ctx);
    SQRT(tmp18, tmp18, ctx);
    MUL(tmp16, tmp17, tmp18, ctx);
    ADD(tmp14, tmp15, tmp16, ctx);
    SQRT_UI(tmp16, 2, ctx);
    MUL_SI(tmp16, tmp16, 3, ctx);
    SQRT_UI(tmp17, 2, ctx);
    MUL_SI(tmp17, tmp17, -17, ctx);
    ADD_SI(tmp17, tmp17, 26, ctx);
    SQRT(tmp17, tmp17, ctx);
    ADD(tmp15, tmp16, tmp17, ctx);
    SUB_SI(tmp15, tmp15, 3, ctx);
    SQRT(tmp15, tmp15, ctx);
    MUL(tmp13, tmp14, tmp15, ctx);
    ADD(tmp11, tmp12, tmp13, ctx);
    SQRT_UI(tmp13, 2, ctx);
    MUL_SI(tmp13, tmp13, 89, ctx);
    SUB_SI(tmp13, tmp13, 126, ctx);
    MUL_SI(tmp13, tmp13, 10, ctx);
    SQRT_UI(tmp14, 2, ctx);
    ADD_SI(tmp14, tmp14, 2, ctx);
    SQRT(tmp14, tmp14, ctx);
    MUL(tmp12, tmp13, tmp14, ctx);
    SUB(tmp10, tmp11, tmp12, ctx);
    SQRT_UI(tmp15, 2, ctx);
    MUL_SI(tmp15, tmp15, 2, ctx);
    SUB_SI(tmp15, tmp15, 3, ctx);
    MUL_SI(tmp15, tmp15, 3, ctx);
    SQRT_UI(tmp16, 2, ctx);
    ADD_SI(tmp16, tmp16, 2, ctx);
    SQRT(tmp16, tmp16, ctx);
    MUL(tmp14, tmp15, tmp16, ctx);
    SQRT_UI(tmp15, 2, ctx);
    MUL_SI(tmp15, tmp15, -17, ctx);
    ADD_SI(tmp15, tmp15, 26, ctx);
    SQRT(tmp15, tmp15, ctx);
    MUL(tmp13, tmp14, tmp15, ctx);
    SQRT_UI(tmp15, 2, ctx);
    MUL_SI(tmp15, tmp15, 61, ctx);
    SUB_SI(tmp15, tmp15, 85, ctx);
    SQRT_UI(tmp16, 2, ctx);
    ADD_SI(tmp16, tmp16, 2, ctx);
    SQRT(tmp16, tmp16, ctx);
    MUL(tmp14, tmp15, tmp16, ctx);
    SUB(tmp12, tmp13, tmp14, ctx);
    MUL_SI(tmp12, tmp12, 2, ctx);
    SQRT_UI(tmp13, 2, ctx);
    NEG(tmp13, tmp13, ctx);
    ADD_SI(tmp13, tmp13, 2, ctx);
    SQRT(tmp13, tmp13, ctx);
    MUL(tmp11, tmp12, tmp13, ctx);
    SUB(tmp9, tmp10, tmp11, ctx);
    SQRT_UI(tmp16, 2, ctx);
    MUL_SI(tmp16, tmp16, 2, ctx);
    SUB_SI(tmp16, tmp16, 3, ctx);
    MUL_SI(tmp16, tmp16, 3, ctx);
    SQRT_UI(tmp17, 2, ctx);
    MUL_SI(tmp17, tmp17, -17, ctx);
    ADD_SI(tmp17, tmp17, 26, ctx);
    SQRT(tmp17, tmp17, ctx);
    MUL(tmp15, tmp16, tmp17, ctx);
    SQRT_UI(tmp16, 2, ctx);
    MUL_SI(tmp16, tmp16, 61, ctx);
    SUB(tmp14, tmp15, tmp16, ctx);
    ADD_SI(tmp14, tmp14, 85, ctx);
    SQRT_UI(tmp15, 2, ctx);
    NEG(tmp15, tmp15, ctx);
    ADD_SI(tmp15, tmp15, 2, ctx);
    SQRT(tmp15, tmp15, ctx);
    MUL(tmp13, tmp14, tmp15, ctx);
    SQRT_UI(tmp15, 2, ctx);
    MUL_SI(tmp15, tmp15, 5, ctx);
    SUB_SI(tmp15, tmp15, 7, ctx);
    MUL_SI(tmp15, tmp15, 11, ctx);
    SQRT_UI(tmp16, 2, ctx);
    MUL_SI(tmp16, tmp16, -17, ctx);
    ADD_SI(tmp16, tmp16, 26, ctx);
    SQRT(tmp16, tmp16, ctx);
    MUL(tmp14, tmp15, tmp16, ctx);
    SUB(tmp12, tmp13, tmp14, ctx);
    SQRT_UI(tmp13, 2, ctx);
    MUL_SI(tmp13, tmp13, 445, ctx);
    ADD(tmp11, tmp12, tmp13, ctx);
    SUB_SI(tmp11, tmp11, 630, ctx);
    MUL_SI(tmp11, tmp11, 4, ctx);
    SQRT_UI(tmp12, 2, ctx);
    ADD_SI(tmp12, tmp12, 2, ctx);
    SQRT(tmp12, tmp12, ctx);
    SUB_SI(tmp12, tmp12, 1, ctx);
    SQRT(tmp12, tmp12, ctx);
    MUL(tmp10, tmp11, tmp12, ctx);
    ADD(tmp8, tmp9, tmp10, ctx);
    SQRT_UI(tmp11, 2, ctx);
    MUL_SI(tmp11, tmp11, -12, ctx);
    SQRT_UI(tmp12, 2, ctx);
    NEG(tmp12, tmp12, ctx);
    ADD_SI(tmp12, tmp12, 2, ctx);
    SQRT(tmp12, tmp12, ctx);
    MUL_SI(tmp12, tmp12, 2, ctx);
    SUB(tmp10, tmp11, tmp12, ctx);
    SQRT_UI(tmp11, 2, ctx);
    MUL_SI(tmp11, tmp11, -17, ctx);
    ADD_SI(tmp11, tmp11, 26, ctx);
    SQRT(tmp11, tmp11, ctx);
    MUL_SI(tmp11, tmp11, 2, ctx);
    SUB(tmp9, tmp10, tmp11, ctx);
    ADD_SI(tmp9, tmp9, 24, ctx);
    SQRT(tmp9, tmp9, ctx);
    MUL(tmp7, tmp8, tmp9, ctx);
    ADD(tmp5, tmp6, tmp7, ctx);
    SQRT_UI(tmp12, 2, ctx);
    MUL_SI(tmp12, tmp12, 3, ctx);
    SUB_SI(tmp12, tmp12, 4, ctx);
    MUL_SI(tmp12, tmp12, 3, ctx);
    SQRT_UI(tmp13, 2, ctx);
    MUL_SI(tmp13, tmp13, -17, ctx);
    ADD_SI(tmp13, tmp13, 26, ctx);
    SQRT(tmp13, tmp13, ctx);
    MUL(tmp11, tmp12, tmp13, ctx);
    SQRT_UI(tmp12, 2, ctx);
    MUL_SI(tmp12, tmp12, 85, ctx);
    SUB(tmp10, tmp11, tmp12, ctx);
    ADD_SI(tmp10, tmp10, 122, ctx);
    SQRT_UI(tmp11, 2, ctx);
    NEG(tmp11, tmp11, ctx);
    ADD_SI(tmp11, tmp11, 2, ctx);
    SQRT(tmp11, tmp11, ctx);
    MUL(tmp9, tmp10, tmp11, ctx);
    SQRT_UI(tmp11, 2, ctx);
    MUL_SI(tmp11, tmp11, 7, ctx);
    SUB_SI(tmp11, tmp11, 10, ctx);
    MUL_SI(tmp11, tmp11, 11, ctx);
    SQRT_UI(tmp12, 2, ctx);
    MUL_SI(tmp12, tmp12, -17, ctx);
    ADD_SI(tmp12, tmp12, 26, ctx);
    SQRT(tmp12, tmp12, ctx);
    MUL(tmp10, tmp11, tmp12, ctx);
    SUB(tmp8, tmp9, tmp10, ctx);
    SQRT_UI(tmp9, 2, ctx);
    MUL_SI(tmp9, tmp9, 630, ctx);
    ADD(tmp7, tmp8, tmp9, ctx);
    SUB_SI(tmp7, tmp7, 890, ctx);
    MUL_SI(tmp7, tmp7, 8, ctx);
    SQRT_UI(tmp8, 2, ctx);
    ADD_SI(tmp8, tmp8, 2, ctx);
    SQRT(tmp8, tmp8, ctx);
    SUB_SI(tmp8, tmp8, 1, ctx);
    SQRT(tmp8, tmp8, ctx);
    MUL(tmp6, tmp7, tmp8, ctx);
    ADD(tmp4, tmp5, tmp6, ctx);
    MUL(tmp2, tmp3, tmp4, ctx);
    SQRT_UI(tmp11, 2, ctx);
    SQRT_UI(tmp12, 2, ctx);
    ADD_SI(tmp12, tmp12, 2, ctx);
    SQRT(tmp12, tmp12, ctx);
    MUL(tmp10, tmp11, tmp12, ctx);
    SQRT_UI(tmp11, 2, ctx);
    SUB(tmp9, tmp10, tmp11, ctx);
    SUB_SI(tmp9, tmp9, 1, ctx);
    SQRT_UI(tmp10, 2, ctx);
    ADD_SI(tmp10, tmp10, 2, ctx);
    SQRT(tmp10, tmp10, ctx);
    SUB_SI(tmp10, tmp10, 1, ctx);
    SQRT(tmp10, tmp10, ctx);
    MUL(tmp8, tmp9, tmp10, ctx);
    SQRT_UI(tmp9, 2, ctx);
    ADD_SI(tmp9, tmp9, 2, ctx);
    SQRT(tmp9, tmp9, ctx);
    ADD(tmp7, tmp8, tmp9, ctx);
    SUB_SI(tmp7, tmp7, 1, ctx);
    SQRT_UI(tmp18, 2, ctx);
    MUL_SI(tmp18, tmp18, 89, ctx);
    SUB_SI(tmp18, tmp18, 126, ctx);
    MUL_SI(tmp18, tmp18, 5, ctx);
    SQRT_UI(tmp19, 2, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, 61, ctx);
    SUB_SI(tmp22, tmp22, 85, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, 2, ctx);
    SUB_SI(tmp25, tmp25, 3, ctx);
    SQRT_UI(tmp26, 2, ctx);
    ADD_SI(tmp26, tmp26, 2, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, 4, ctx);
    SUB(tmp23, tmp24, tmp25, ctx);
    ADD_SI(tmp23, tmp23, 6, ctx);
    MUL_SI(tmp23, tmp23, 3, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, -17, ctx);
    ADD_SI(tmp24, tmp24, 26, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    SUB(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, 122, ctx);
    SUB(tmp19, tmp20, tmp21, ctx);
    ADD_SI(tmp19, tmp19, 170, ctx);
    SQRT_UI(tmp20, 2, ctx);
    NEG(tmp20, tmp20, ctx);
    ADD_SI(tmp20, tmp20, 2, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL(tmp18, tmp19, tmp20, ctx);
    SUB(tmp16, tmp17, tmp18, ctx);
    SQRT_UI(tmp20, 2, ctx);
    MUL_SI(tmp20, tmp20, 5, ctx);
    SUB_SI(tmp20, tmp20, 7, ctx);
    SQRT_UI(tmp21, 2, ctx);
    ADD_SI(tmp21, tmp21, 2, ctx);
    SQRT(tmp21, tmp21, ctx);
    MUL(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp20, 2, ctx);
    MUL_SI(tmp20, tmp20, 10, ctx);
    SUB(tmp18, tmp19, tmp20, ctx);
    ADD_SI(tmp18, tmp18, 14, ctx);
    MUL_SI(tmp18, tmp18, 11, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, -17, ctx);
    ADD_SI(tmp19, tmp19, 26, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    SUB(tmp15, tmp16, tmp17, ctx);
    SQRT_UI(tmp16, 2, ctx);
    MUL_SI(tmp16, tmp16, 890, ctx);
    SUB(tmp14, tmp15, tmp16, ctx);
    ADD_SI(tmp14, tmp14, 1260, ctx);
    SQRT_UI(tmp16, 2, ctx);
    MUL_SI(tmp16, tmp16, 3, ctx);
    SQRT_UI(tmp17, 2, ctx);
    NEG(tmp17, tmp17, ctx);
    ADD_SI(tmp17, tmp17, 2, ctx);
    SQRT(tmp17, tmp17, ctx);
    ADD(tmp15, tmp16, tmp17, ctx);
    SUB_SI(tmp15, tmp15, 5, ctx);
    SQRT(tmp15, tmp15, ctx);
    MUL(tmp13, tmp14, tmp15, ctx);
    SQRT_UI(tmp16, 2, ctx);
    MUL_SI(tmp16, tmp16, -12, ctx);
    SQRT_UI(tmp17, 2, ctx);
    NEG(tmp17, tmp17, ctx);
    ADD_SI(tmp17, tmp17, 2, ctx);
    SQRT(tmp17, tmp17, ctx);
    MUL_SI(tmp17, tmp17, 2, ctx);
    SUB(tmp15, tmp16, tmp17, ctx);
    SQRT_UI(tmp16, 2, ctx);
    MUL_SI(tmp16, tmp16, -17, ctx);
    ADD_SI(tmp16, tmp16, 26, ctx);
    SQRT(tmp16, tmp16, ctx);
    MUL_SI(tmp16, tmp16, 2, ctx);
    SUB(tmp14, tmp15, tmp16, ctx);
    ADD_SI(tmp14, tmp14, 24, ctx);
    SQRT(tmp14, tmp14, ctx);
    MUL(tmp12, tmp13, tmp14, ctx);
    SQRT_UI(tmp18, 2, ctx);
    MUL_SI(tmp18, tmp18, 63, ctx);
    SUB_SI(tmp18, tmp18, 89, ctx);
    MUL_SI(tmp18, tmp18, 10, ctx);
    SQRT_UI(tmp19, 2, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, 85, ctx);
    SUB_SI(tmp22, tmp22, 122, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, 3, ctx);
    SUB_SI(tmp25, tmp25, 4, ctx);
    SQRT_UI(tmp26, 2, ctx);
    ADD_SI(tmp26, tmp26, 2, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, 6, ctx);
    SUB(tmp23, tmp24, tmp25, ctx);
    ADD_SI(tmp23, tmp23, 8, ctx);
    MUL_SI(tmp23, tmp23, 3, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, -17, ctx);
    ADD_SI(tmp24, tmp24, 26, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    SUB(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, 170, ctx);
    SUB(tmp19, tmp20, tmp21, ctx);
    ADD_SI(tmp19, tmp19, 244, ctx);
    SQRT_UI(tmp20, 2, ctx);
    NEG(tmp20, tmp20, ctx);
    ADD_SI(tmp20, tmp20, 2, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL(tmp18, tmp19, tmp20, ctx);
    SUB(tmp16, tmp17, tmp18, ctx);
    SQRT_UI(tmp20, 2, ctx);
    MUL_SI(tmp20, tmp20, 7, ctx);
    SUB_SI(tmp20, tmp20, 10, ctx);
    SQRT_UI(tmp21, 2, ctx);
    ADD_SI(tmp21, tmp21, 2, ctx);
    SQRT(tmp21, tmp21, ctx);
    MUL(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp20, 2, ctx);
    MUL_SI(tmp20, tmp20, 14, ctx);
    SUB(tmp18, tmp19, tmp20, ctx);
    ADD_SI(tmp18, tmp18, 20, ctx);
    MUL_SI(tmp18, tmp18, 11, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, -17, ctx);
    ADD_SI(tmp19, tmp19, 26, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    SUB(tmp15, tmp16, tmp17, ctx);
    SQRT_UI(tmp16, 2, ctx);
    MUL_SI(tmp16, tmp16, 1260, ctx);
    SUB(tmp14, tmp15, tmp16, ctx);
    ADD_SI(tmp14, tmp14, 1780, ctx);
    MUL_SI(tmp14, tmp14, 2, ctx);
    SQRT_UI(tmp16, 2, ctx);
    MUL_SI(tmp16, tmp16, 3, ctx);
    SQRT_UI(tmp17, 2, ctx);
    NEG(tmp17, tmp17, ctx);
    ADD_SI(tmp17, tmp17, 2, ctx);
    SQRT(tmp17, tmp17, ctx);
    ADD(tmp15, tmp16, tmp17, ctx);
    SUB_SI(tmp15, tmp15, 5, ctx);
    SQRT(tmp15, tmp15, ctx);
    MUL(tmp13, tmp14, tmp15, ctx);
    ADD(tmp11, tmp12, tmp13, ctx);
    MUL_SI(tmp11, tmp11, 8, ctx);
    SQRT_UI(tmp15, 2, ctx);
    ADD_SI(tmp15, tmp15, 2, ctx);
    SQRT(tmp15, tmp15, ctx);
    ADD_SI(tmp15, tmp15, 1, ctx);
    SQRT_UI(tmp16, 2, ctx);
    ADD_SI(tmp16, tmp16, 2, ctx);
    SQRT(tmp16, tmp16, ctx);
    SUB_SI(tmp16, tmp16, 1, ctx);
    SQRT(tmp16, tmp16, ctx);
    MUL(tmp14, tmp15, tmp16, ctx);
    SQRT_UI(tmp15, 2, ctx);
    ADD_SI(tmp15, tmp15, 2, ctx);
    SQRT(tmp15, tmp15, ctx);
    ADD(tmp13, tmp14, tmp15, ctx);
    ADD_SI(tmp13, tmp13, 1, ctx);
    INV(tmp13, tmp13, ctx);
    SQRT_UI(tmp21, 2, ctx);
    SQRT_UI(tmp22, 2, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    ADD(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp21, 2, ctx);
    ADD_SI(tmp21, tmp21, 2, ctx);
    SQRT(tmp21, tmp21, ctx);
    SUB_SI(tmp21, tmp21, 1, ctx);
    SQRT(tmp21, tmp21, ctx);
    MUL(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp20, 2, ctx);
    MUL_SI(tmp20, tmp20, 3, ctx);
    ADD(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp19, 2, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL_SI(tmp19, tmp19, 5, ctx);
    SUB(tmp17, tmp18, tmp19, ctx);
    ADD_SI(tmp17, tmp17, 8, ctx);
    SQRT_UI(tmp22, 2, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    ADD(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp22, 2, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    SUB_SI(tmp22, tmp22, 1, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, 3, ctx);
    SUB(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp20, 2, ctx);
    ADD_SI(tmp20, tmp20, 2, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL_SI(tmp20, tmp20, 5, ctx);
    ADD(tmp18, tmp19, tmp20, ctx);
    SUB_SI(tmp18, tmp18, 8, ctx);
    MUL(tmp16, tmp17, tmp18, ctx);
    SQRT_UI(tmp17, 2, ctx);
    ADD_SI(tmp17, tmp17, 2, ctx);
    SQRT(tmp17, tmp17, ctx);
    ADD_SI(tmp17, tmp17, 2, ctx);
    MUL(tmp15, tmp16, tmp17, ctx);
    SQRT_UI(tmp20, 2, ctx);
    ADD_SI(tmp20, tmp20, 2, ctx);
    SQRT(tmp20, tmp20, ctx);
    ADD_SI(tmp20, tmp20, 1, ctx);
    SQRT_UI(tmp21, 2, ctx);
    ADD_SI(tmp21, tmp21, 2, ctx);
    SQRT(tmp21, tmp21, ctx);
    SUB_SI(tmp21, tmp21, 1, ctx);
    SQRT(tmp21, tmp21, ctx);
    MUL(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp20, 2, ctx);
    ADD_SI(tmp20, tmp20, 2, ctx);
    SQRT(tmp20, tmp20, ctx);
    ADD(tmp18, tmp19, tmp20, ctx);
    ADD_SI(tmp18, tmp18, 1, ctx);
    POW_UI(tmp18, tmp18, 2, ctx);
    SQRT_UI(tmp22, 2, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    ADD_SI(tmp22, tmp22, 1, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    SUB_SI(tmp23, tmp23, 1, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp22, 2, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    SUB(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp28, 2, ctx);
    SQRT_UI(tmp29, 2, ctx);
    ADD_SI(tmp29, tmp29, 2, ctx);
    SQRT(tmp29, tmp29, ctx);
    ADD(tmp27, tmp28, tmp29, ctx);
    SQRT_UI(tmp28, 2, ctx);
    ADD_SI(tmp28, tmp28, 2, ctx);
    SQRT(tmp28, tmp28, ctx);
    SUB_SI(tmp28, tmp28, 1, ctx);
    SQRT(tmp28, tmp28, ctx);
    MUL(tmp26, tmp27, tmp28, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, 3, ctx);
    ADD(tmp25, tmp26, tmp27, ctx);
    SQRT_UI(tmp26, 2, ctx);
    ADD_SI(tmp26, tmp26, 2, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL_SI(tmp26, tmp26, 5, ctx);
    SUB(tmp24, tmp25, tmp26, ctx);
    ADD_SI(tmp24, tmp24, 8, ctx);
    SQRT_UI(tmp29, 2, ctx);
    SQRT_UI(tmp30, 2, ctx);
    ADD_SI(tmp30, tmp30, 2, ctx);
    SQRT(tmp30, tmp30, ctx);
    ADD(tmp28, tmp29, tmp30, ctx);
    SQRT_UI(tmp29, 2, ctx);
    ADD_SI(tmp29, tmp29, 2, ctx);
    SQRT(tmp29, tmp29, ctx);
    SUB_SI(tmp29, tmp29, 1, ctx);
    SQRT(tmp29, tmp29, ctx);
    MUL(tmp27, tmp28, tmp29, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, 3, ctx);
    SUB(tmp26, tmp27, tmp28, ctx);
    SQRT_UI(tmp27, 2, ctx);
    ADD_SI(tmp27, tmp27, 2, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL_SI(tmp27, tmp27, 5, ctx);
    ADD(tmp25, tmp26, tmp27, ctx);
    SUB_SI(tmp25, tmp25, 8, ctx);
    MUL(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp24, 2, ctx);
    ADD_SI(tmp24, tmp24, 2, ctx);
    SQRT(tmp24, tmp24, ctx);
    ADD_SI(tmp24, tmp24, 2, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp26, 2, ctx);
    ADD_SI(tmp26, tmp26, 2, ctx);
    SQRT(tmp26, tmp26, ctx);
    ADD_SI(tmp26, tmp26, 1, ctx);
    SQRT_UI(tmp27, 2, ctx);
    ADD_SI(tmp27, tmp27, 2, ctx);
    SQRT(tmp27, tmp27, ctx);
    SUB_SI(tmp27, tmp27, 1, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL(tmp25, tmp26, tmp27, ctx);
    SQRT_UI(tmp26, 2, ctx);
    ADD_SI(tmp26, tmp26, 2, ctx);
    SQRT(tmp26, tmp26, ctx);
    ADD(tmp24, tmp25, tmp26, ctx);
    ADD_SI(tmp24, tmp24, 1, ctx);
    SQRT_UI(tmp25, 2, ctx);
    ADD_SI(tmp25, tmp25, 2, ctx);
    SQRT(tmp25, tmp25, ctx);
    SUB_SI(tmp25, tmp25, 2, ctx);
    POW_UI(tmp25, tmp25, 3, ctx);
    MUL(tmp23, tmp24, tmp25, ctx);
    DIV(tmp21, tmp22, tmp23, ctx);
    SUB(tmp19, tmp20, tmp21, ctx);
    SUB_SI(tmp19, tmp19, 1, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp18, 2, ctx);
    ADD_SI(tmp18, tmp18, 2, ctx);
    SQRT(tmp18, tmp18, ctx);
    SUB_SI(tmp18, tmp18, 2, ctx);
    POW_UI(tmp18, tmp18, 3, ctx);
    MUL(tmp16, tmp17, tmp18, ctx);
    DIV(tmp14, tmp15, tmp16, ctx);
    ADD(tmp12, tmp13, tmp14, ctx);
    MUL(tmp10, tmp11, tmp12, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 3, ctx);
    SUB_SI(tmp23, tmp23, 4, ctx);
    MUL_SI(tmp23, tmp23, 3, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, -17, ctx);
    ADD_SI(tmp24, tmp24, 26, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 85, ctx);
    SUB(tmp21, tmp22, tmp23, ctx);
    ADD_SI(tmp21, tmp21, 122, ctx);
    SQRT_UI(tmp22, 2, ctx);
    NEG(tmp22, tmp22, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, 7, ctx);
    SUB_SI(tmp22, tmp22, 10, ctx);
    MUL_SI(tmp22, tmp22, 11, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, -17, ctx);
    ADD_SI(tmp23, tmp23, 26, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SUB(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp20, 2, ctx);
    MUL_SI(tmp20, tmp20, 630, ctx);
    ADD(tmp18, tmp19, tmp20, ctx);
    SUB_SI(tmp18, tmp18, 890, ctx);
    MUL_SI(tmp18, tmp18, 2, ctx);
    SQRT_UI(tmp20, 2, ctx);
    MUL_SI(tmp20, tmp20, 3, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, -17, ctx);
    ADD_SI(tmp21, tmp21, 26, ctx);
    SQRT(tmp21, tmp21, ctx);
    ADD(tmp19, tmp20, tmp21, ctx);
    SUB_SI(tmp19, tmp19, 3, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp18, 2, ctx);
    ADD_SI(tmp18, tmp18, 2, ctx);
    SQRT(tmp18, tmp18, ctx);
    SUB_SI(tmp18, tmp18, 1, ctx);
    SQRT(tmp18, tmp18, ctx);
    MUL(tmp16, tmp17, tmp18, ctx);
    SQRT_UI(tmp18, 2, ctx);
    MUL_SI(tmp18, tmp18, 4896, ctx);
    SUB_SI(tmp18, tmp18, 6923, ctx);
    MUL_SI(tmp18, tmp18, 2, ctx);
    SQRT_UI(tmp19, 2, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    SUB(tmp15, tmp16, tmp17, ctx);
    SQRT_UI(tmp20, 2, ctx);
    MUL_SI(tmp20, tmp20, 79, ctx);
    SUB_SI(tmp20, tmp20, 112, ctx);
    MUL_SI(tmp20, tmp20, 20, ctx);
    SQRT_UI(tmp21, 2, ctx);
    ADD_SI(tmp21, tmp21, 2, ctx);
    SQRT(tmp21, tmp21, ctx);
    MUL(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 27, ctx);
    SUB_SI(tmp23, tmp23, 38, ctx);
    MUL_SI(tmp23, tmp23, 7, ctx);
    SQRT_UI(tmp24, 2, ctx);
    ADD_SI(tmp24, tmp24, 2, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 342, ctx);
    SUB(tmp21, tmp22, tmp23, ctx);
    ADD_SI(tmp21, tmp21, 484, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, -17, ctx);
    ADD_SI(tmp22, tmp22, 26, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SUB(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, 2820, ctx);
    SUB(tmp17, tmp18, tmp19, ctx);
    ADD_SI(tmp17, tmp17, 3992, ctx);
    SQRT_UI(tmp18, 2, ctx);
    NEG(tmp18, tmp18, ctx);
    ADD_SI(tmp18, tmp18, 2, ctx);
    SQRT(tmp18, tmp18, ctx);
    MUL(tmp16, tmp17, tmp18, ctx);
    ADD(tmp14, tmp15, tmp16, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, 2, ctx);
    SUB_SI(tmp27, tmp27, 3, ctx);
    MUL_SI(tmp27, tmp27, 3, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, -17, ctx);
    ADD_SI(tmp28, tmp28, 26, ctx);
    SQRT(tmp28, tmp28, ctx);
    MUL(tmp26, tmp27, tmp28, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, 61, ctx);
    SUB(tmp25, tmp26, tmp27, ctx);
    ADD_SI(tmp25, tmp25, 85, ctx);
    SQRT_UI(tmp26, 2, ctx);
    NEG(tmp26, tmp26, ctx);
    ADD_SI(tmp26, tmp26, 2, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, 5, ctx);
    SUB_SI(tmp26, tmp26, 7, ctx);
    MUL_SI(tmp26, tmp26, 11, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, -17, ctx);
    ADD_SI(tmp27, tmp27, 26, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL(tmp25, tmp26, tmp27, ctx);
    SUB(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, 445, ctx);
    ADD(tmp22, tmp23, tmp24, ctx);
    SUB_SI(tmp22, tmp22, 630, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, 3, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, -17, ctx);
    ADD_SI(tmp25, tmp25, 26, ctx);
    SQRT(tmp25, tmp25, ctx);
    ADD(tmp23, tmp24, tmp25, ctx);
    SUB_SI(tmp23, tmp23, 3, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp22, 2, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    SUB_SI(tmp22, tmp22, 1, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, 89, ctx);
    SUB_SI(tmp22, tmp22, 126, ctx);
    MUL_SI(tmp22, tmp22, 10, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SUB(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, 61, ctx);
    SUB_SI(tmp24, tmp24, 85, ctx);
    SQRT_UI(tmp25, 2, ctx);
    ADD_SI(tmp25, tmp25, 2, ctx);
    SQRT(tmp25, tmp25, ctx);
    MUL(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, 2, ctx);
    SUB_SI(tmp27, tmp27, 3, ctx);
    SQRT_UI(tmp28, 2, ctx);
    ADD_SI(tmp28, tmp28, 2, ctx);
    SQRT(tmp28, tmp28, ctx);
    MUL(tmp26, tmp27, tmp28, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, 2, ctx);
    SUB(tmp25, tmp26, tmp27, ctx);
    ADD_SI(tmp25, tmp25, 3, ctx);
    MUL_SI(tmp25, tmp25, 3, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, -17, ctx);
    ADD_SI(tmp26, tmp26, 26, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    SUB(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 61, ctx);
    SUB(tmp21, tmp22, tmp23, ctx);
    ADD_SI(tmp21, tmp21, 85, ctx);
    MUL_SI(tmp21, tmp21, 2, ctx);
    SQRT_UI(tmp22, 2, ctx);
    NEG(tmp22, tmp22, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    ADD(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, 5, ctx);
    SUB_SI(tmp22, tmp22, 7, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, 5, ctx);
    SUB(tmp20, tmp21, tmp22, ctx);
    ADD_SI(tmp20, tmp20, 7, ctx);
    MUL_SI(tmp20, tmp20, 22, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, -17, ctx);
    ADD_SI(tmp21, tmp21, 26, ctx);
    SQRT(tmp21, tmp21, ctx);
    MUL(tmp19, tmp20, tmp21, ctx);
    ADD(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp18, 2, ctx);
    MUL_SI(tmp18, tmp18, 890, ctx);
    ADD(tmp16, tmp17, tmp18, ctx);
    SUB_SI(tmp16, tmp16, 1260, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, -12, ctx);
    SQRT_UI(tmp20, 2, ctx);
    NEG(tmp20, tmp20, ctx);
    ADD_SI(tmp20, tmp20, 2, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL_SI(tmp20, tmp20, 2, ctx);
    SUB(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, -17, ctx);
    ADD_SI(tmp19, tmp19, 26, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL_SI(tmp19, tmp19, 2, ctx);
    SUB(tmp17, tmp18, tmp19, ctx);
    ADD_SI(tmp17, tmp17, 24, ctx);
    SQRT(tmp17, tmp17, ctx);
    MUL(tmp15, tmp16, tmp17, ctx);
    ADD(tmp13, tmp14, tmp15, ctx);
    SQRT_UI(tmp17, 2, ctx);
    MUL_SI(tmp17, tmp17, 319, ctx);
    SUB_SI(tmp17, tmp17, 452, ctx);
    SQRT_UI(tmp18, 2, ctx);
    ADD_SI(tmp18, tmp18, 2, ctx);
    SQRT(tmp18, tmp18, ctx);
    MUL(tmp16, tmp17, tmp18, ctx);
    SQRT_UI(tmp17, 2, ctx);
    MUL_SI(tmp17, tmp17, 561, ctx);
    SUB(tmp15, tmp16, tmp17, ctx);
    ADD_SI(tmp15, tmp15, 794, ctx);
    MUL_SI(tmp15, tmp15, 4, ctx);
    SQRT_UI(tmp16, 2, ctx);
    MUL_SI(tmp16, tmp16, -17, ctx);
    ADD_SI(tmp16, tmp16, 26, ctx);
    SQRT(tmp16, tmp16, ctx);
    MUL(tmp14, tmp15, tmp16, ctx);
    ADD(tmp12, tmp13, tmp14, ctx);
    SQRT_UI(tmp13, 2, ctx);
    MUL_SI(tmp13, tmp13, 17064, ctx);
    ADD(tmp11, tmp12, tmp13, ctx);
    SUB_SI(tmp11, tmp11, 24132, ctx);
    DIV(tmp9, tmp10, tmp11, ctx);
    SQRT_UI(tmp20, 2, ctx);
    MUL_SI(tmp20, tmp20, 7, ctx);
    SUB_SI(tmp20, tmp20, 10, ctx);
    MUL_SI(tmp20, tmp20, 44, ctx);
    SQRT_UI(tmp21, 2, ctx);
    ADD_SI(tmp21, tmp21, 2, ctx);
    SQRT(tmp21, tmp21, ctx);
    MUL(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp20, 2, ctx);
    MUL_SI(tmp20, tmp20, -17, ctx);
    ADD_SI(tmp20, tmp20, 26, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, 7, ctx);
    SUB_SI(tmp25, tmp25, 10, ctx);
    MUL_SI(tmp25, tmp25, 11, ctx);
    SQRT_UI(tmp26, 2, ctx);
    ADD_SI(tmp26, tmp26, 2, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, -17, ctx);
    ADD_SI(tmp25, tmp25, 26, ctx);
    SQRT(tmp25, tmp25, ctx);
    MUL(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, 63, ctx);
    SUB_SI(tmp25, tmp25, 89, ctx);
    MUL_SI(tmp25, tmp25, 10, ctx);
    SQRT_UI(tmp26, 2, ctx);
    ADD_SI(tmp26, tmp26, 2, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    SUB(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, 3, ctx);
    SUB_SI(tmp27, tmp27, 4, ctx);
    MUL_SI(tmp27, tmp27, 3, ctx);
    SQRT_UI(tmp28, 2, ctx);
    ADD_SI(tmp28, tmp28, 2, ctx);
    SQRT(tmp28, tmp28, ctx);
    MUL(tmp26, tmp27, tmp28, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, -17, ctx);
    ADD_SI(tmp27, tmp27, 26, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL(tmp25, tmp26, tmp27, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, 85, ctx);
    SUB_SI(tmp27, tmp27, 122, ctx);
    SQRT_UI(tmp28, 2, ctx);
    ADD_SI(tmp28, tmp28, 2, ctx);
    SQRT(tmp28, tmp28, ctx);
    MUL(tmp26, tmp27, tmp28, ctx);
    SUB(tmp24, tmp25, tmp26, ctx);
    SQRT_UI(tmp25, 2, ctx);
    NEG(tmp25, tmp25, ctx);
    ADD_SI(tmp25, tmp25, 2, ctx);
    SQRT(tmp25, tmp25, ctx);
    MUL(tmp23, tmp24, tmp25, ctx);
    SUB(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, 3, ctx);
    SUB_SI(tmp28, tmp28, 4, ctx);
    MUL_SI(tmp28, tmp28, 3, ctx);
    SQRT_UI(tmp29, 2, ctx);
    MUL_SI(tmp29, tmp29, -17, ctx);
    ADD_SI(tmp29, tmp29, 26, ctx);
    SQRT(tmp29, tmp29, ctx);
    MUL(tmp27, tmp28, tmp29, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, 85, ctx);
    SUB(tmp26, tmp27, tmp28, ctx);
    ADD_SI(tmp26, tmp26, 122, ctx);
    SQRT_UI(tmp27, 2, ctx);
    NEG(tmp27, tmp27, ctx);
    ADD_SI(tmp27, tmp27, 2, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL(tmp25, tmp26, tmp27, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, 7, ctx);
    SUB_SI(tmp27, tmp27, 10, ctx);
    MUL_SI(tmp27, tmp27, 11, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, -17, ctx);
    ADD_SI(tmp28, tmp28, 26, ctx);
    SQRT(tmp28, tmp28, ctx);
    MUL(tmp26, tmp27, tmp28, ctx);
    SUB(tmp24, tmp25, tmp26, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, 630, ctx);
    ADD(tmp23, tmp24, tmp25, ctx);
    SUB_SI(tmp23, tmp23, 890, ctx);
    MUL_SI(tmp23, tmp23, 2, ctx);
    SQRT_UI(tmp24, 2, ctx);
    ADD_SI(tmp24, tmp24, 2, ctx);
    SQRT(tmp24, tmp24, ctx);
    SUB_SI(tmp24, tmp24, 1, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    ADD(tmp20, tmp21, tmp22, ctx);
    MUL_SI(tmp20, tmp20, 2, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, 3, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, -17, ctx);
    ADD_SI(tmp23, tmp23, 26, ctx);
    SQRT(tmp23, tmp23, ctx);
    ADD(tmp21, tmp22, tmp23, ctx);
    SUB_SI(tmp21, tmp21, 3, ctx);
    SQRT(tmp21, tmp21, ctx);
    MUL(tmp19, tmp20, tmp21, ctx);
    ADD(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, 63, ctx);
    SUB_SI(tmp19, tmp19, 89, ctx);
    MUL_SI(tmp19, tmp19, 40, ctx);
    SQRT_UI(tmp20, 2, ctx);
    ADD_SI(tmp20, tmp20, 2, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL(tmp18, tmp19, tmp20, ctx);
    SUB(tmp16, tmp17, tmp18, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, 3, ctx);
    SUB_SI(tmp21, tmp21, 4, ctx);
    MUL_SI(tmp21, tmp21, 3, ctx);
    SQRT_UI(tmp22, 2, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, -17, ctx);
    ADD_SI(tmp21, tmp21, 26, ctx);
    SQRT(tmp21, tmp21, ctx);
    MUL(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, 85, ctx);
    SUB_SI(tmp21, tmp21, 122, ctx);
    SQRT_UI(tmp22, 2, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SUB(tmp18, tmp19, tmp20, ctx);
    MUL_SI(tmp18, tmp18, 4, ctx);
    SQRT_UI(tmp19, 2, ctx);
    NEG(tmp19, tmp19, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    SUB(tmp15, tmp16, tmp17, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 5, ctx);
    SUB_SI(tmp23, tmp23, 7, ctx);
    MUL_SI(tmp23, tmp23, 22, ctx);
    SQRT_UI(tmp24, 2, ctx);
    ADD_SI(tmp24, tmp24, 2, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, -17, ctx);
    ADD_SI(tmp23, tmp23, 26, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, 5, ctx);
    SUB_SI(tmp28, tmp28, 7, ctx);
    MUL_SI(tmp28, tmp28, 11, ctx);
    SQRT_UI(tmp29, 2, ctx);
    ADD_SI(tmp29, tmp29, 2, ctx);
    SQRT(tmp29, tmp29, ctx);
    MUL(tmp27, tmp28, tmp29, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, -17, ctx);
    ADD_SI(tmp28, tmp28, 26, ctx);
    SQRT(tmp28, tmp28, ctx);
    MUL(tmp26, tmp27, tmp28, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, 89, ctx);
    SUB_SI(tmp28, tmp28, 126, ctx);
    MUL_SI(tmp28, tmp28, 5, ctx);
    SQRT_UI(tmp29, 2, ctx);
    ADD_SI(tmp29, tmp29, 2, ctx);
    SQRT(tmp29, tmp29, ctx);
    MUL(tmp27, tmp28, tmp29, ctx);
    SUB(tmp25, tmp26, tmp27, ctx);
    SQRT_UI(tmp30, 2, ctx);
    MUL_SI(tmp30, tmp30, 2, ctx);
    SUB_SI(tmp30, tmp30, 3, ctx);
    MUL_SI(tmp30, tmp30, 3, ctx);
    SQRT_UI(tmp31, 2, ctx);
    ADD_SI(tmp31, tmp31, 2, ctx);
    SQRT(tmp31, tmp31, ctx);
    MUL(tmp29, tmp30, tmp31, ctx);
    SQRT_UI(tmp30, 2, ctx);
    MUL_SI(tmp30, tmp30, -17, ctx);
    ADD_SI(tmp30, tmp30, 26, ctx);
    SQRT(tmp30, tmp30, ctx);
    MUL(tmp28, tmp29, tmp30, ctx);
    SQRT_UI(tmp30, 2, ctx);
    MUL_SI(tmp30, tmp30, 61, ctx);
    SUB_SI(tmp30, tmp30, 85, ctx);
    SQRT_UI(tmp31, 2, ctx);
    ADD_SI(tmp31, tmp31, 2, ctx);
    SQRT(tmp31, tmp31, ctx);
    MUL(tmp29, tmp30, tmp31, ctx);
    SUB(tmp27, tmp28, tmp29, ctx);
    SQRT_UI(tmp28, 2, ctx);
    NEG(tmp28, tmp28, ctx);
    ADD_SI(tmp28, tmp28, 2, ctx);
    SQRT(tmp28, tmp28, ctx);
    MUL(tmp26, tmp27, tmp28, ctx);
    SUB(tmp24, tmp25, tmp26, ctx);
    SQRT_UI(tmp31, 2, ctx);
    MUL_SI(tmp31, tmp31, 2, ctx);
    SUB_SI(tmp31, tmp31, 3, ctx);
    MUL_SI(tmp31, tmp31, 3, ctx);
    SQRT_UI(tmp32, 2, ctx);
    MUL_SI(tmp32, tmp32, -17, ctx);
    ADD_SI(tmp32, tmp32, 26, ctx);
    SQRT(tmp32, tmp32, ctx);
    MUL(tmp30, tmp31, tmp32, ctx);
    SQRT_UI(tmp31, 2, ctx);
    MUL_SI(tmp31, tmp31, 61, ctx);
    SUB(tmp29, tmp30, tmp31, ctx);
    ADD_SI(tmp29, tmp29, 85, ctx);
    SQRT_UI(tmp30, 2, ctx);
    NEG(tmp30, tmp30, ctx);
    ADD_SI(tmp30, tmp30, 2, ctx);
    SQRT(tmp30, tmp30, ctx);
    MUL(tmp28, tmp29, tmp30, ctx);
    SQRT_UI(tmp30, 2, ctx);
    MUL_SI(tmp30, tmp30, 5, ctx);
    SUB_SI(tmp30, tmp30, 7, ctx);
    MUL_SI(tmp30, tmp30, 11, ctx);
    SQRT_UI(tmp31, 2, ctx);
    MUL_SI(tmp31, tmp31, -17, ctx);
    ADD_SI(tmp31, tmp31, 26, ctx);
    SQRT(tmp31, tmp31, ctx);
    MUL(tmp29, tmp30, tmp31, ctx);
    SUB(tmp27, tmp28, tmp29, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, 445, ctx);
    ADD(tmp26, tmp27, tmp28, ctx);
    SUB_SI(tmp26, tmp26, 630, ctx);
    MUL_SI(tmp26, tmp26, 2, ctx);
    SQRT_UI(tmp27, 2, ctx);
    ADD_SI(tmp27, tmp27, 2, ctx);
    SQRT(tmp27, tmp27, ctx);
    SUB_SI(tmp27, tmp27, 1, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL(tmp25, tmp26, tmp27, ctx);
    ADD(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, 3, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, -17, ctx);
    ADD_SI(tmp26, tmp26, 26, ctx);
    SQRT(tmp26, tmp26, ctx);
    ADD(tmp24, tmp25, tmp26, ctx);
    SUB_SI(tmp24, tmp24, 3, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    ADD(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, 89, ctx);
    SUB_SI(tmp22, tmp22, 126, ctx);
    MUL_SI(tmp22, tmp22, 10, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SUB(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, 2, ctx);
    SUB_SI(tmp24, tmp24, 3, ctx);
    MUL_SI(tmp24, tmp24, 3, ctx);
    SQRT_UI(tmp25, 2, ctx);
    ADD_SI(tmp25, tmp25, 2, ctx);
    SQRT(tmp25, tmp25, ctx);
    MUL(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, -17, ctx);
    ADD_SI(tmp24, tmp24, 26, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, 61, ctx);
    SUB_SI(tmp24, tmp24, 85, ctx);
    SQRT_UI(tmp25, 2, ctx);
    ADD_SI(tmp25, tmp25, 2, ctx);
    SQRT(tmp25, tmp25, ctx);
    MUL(tmp23, tmp24, tmp25, ctx);
    SUB(tmp21, tmp22, tmp23, ctx);
    MUL_SI(tmp21, tmp21, 2, ctx);
    SQRT_UI(tmp22, 2, ctx);
    NEG(tmp22, tmp22, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SUB(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, 2, ctx);
    SUB_SI(tmp25, tmp25, 3, ctx);
    MUL_SI(tmp25, tmp25, 3, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, -17, ctx);
    ADD_SI(tmp26, tmp26, 26, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, 61, ctx);
    SUB(tmp23, tmp24, tmp25, ctx);
    ADD_SI(tmp23, tmp23, 85, ctx);
    SQRT_UI(tmp24, 2, ctx);
    NEG(tmp24, tmp24, ctx);
    ADD_SI(tmp24, tmp24, 2, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, 5, ctx);
    SUB_SI(tmp24, tmp24, 7, ctx);
    MUL_SI(tmp24, tmp24, 11, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, -17, ctx);
    ADD_SI(tmp25, tmp25, 26, ctx);
    SQRT(tmp25, tmp25, ctx);
    MUL(tmp23, tmp24, tmp25, ctx);
    SUB(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, 445, ctx);
    ADD(tmp20, tmp21, tmp22, ctx);
    SUB_SI(tmp20, tmp20, 630, ctx);
    MUL_SI(tmp20, tmp20, 4, ctx);
    SQRT_UI(tmp21, 2, ctx);
    ADD_SI(tmp21, tmp21, 2, ctx);
    SQRT(tmp21, tmp21, ctx);
    SUB_SI(tmp21, tmp21, 1, ctx);
    SQRT(tmp21, tmp21, ctx);
    MUL(tmp19, tmp20, tmp21, ctx);
    ADD(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp20, 2, ctx);
    MUL_SI(tmp20, tmp20, -12, ctx);
    SQRT_UI(tmp21, 2, ctx);
    NEG(tmp21, tmp21, ctx);
    ADD_SI(tmp21, tmp21, 2, ctx);
    SQRT(tmp21, tmp21, ctx);
    MUL_SI(tmp21, tmp21, 2, ctx);
    SUB(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp20, 2, ctx);
    MUL_SI(tmp20, tmp20, -17, ctx);
    ADD_SI(tmp20, tmp20, 26, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL_SI(tmp20, tmp20, 2, ctx);
    SUB(tmp18, tmp19, tmp20, ctx);
    ADD_SI(tmp18, tmp18, 24, ctx);
    SQRT(tmp18, tmp18, ctx);
    MUL(tmp16, tmp17, tmp18, ctx);
    ADD(tmp14, tmp15, tmp16, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, 3, ctx);
    SUB_SI(tmp21, tmp21, 4, ctx);
    MUL_SI(tmp21, tmp21, 3, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, -17, ctx);
    ADD_SI(tmp22, tmp22, 26, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, 85, ctx);
    SUB(tmp19, tmp20, tmp21, ctx);
    ADD_SI(tmp19, tmp19, 122, ctx);
    SQRT_UI(tmp20, 2, ctx);
    NEG(tmp20, tmp20, ctx);
    ADD_SI(tmp20, tmp20, 2, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp20, 2, ctx);
    MUL_SI(tmp20, tmp20, 7, ctx);
    SUB_SI(tmp20, tmp20, 10, ctx);
    MUL_SI(tmp20, tmp20, 11, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, -17, ctx);
    ADD_SI(tmp21, tmp21, 26, ctx);
    SQRT(tmp21, tmp21, ctx);
    MUL(tmp19, tmp20, tmp21, ctx);
    SUB(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp18, 2, ctx);
    MUL_SI(tmp18, tmp18, 630, ctx);
    ADD(tmp16, tmp17, tmp18, ctx);
    SUB_SI(tmp16, tmp16, 890, ctx);
    MUL_SI(tmp16, tmp16, 8, ctx);
    SQRT_UI(tmp17, 2, ctx);
    ADD_SI(tmp17, tmp17, 2, ctx);
    SQRT(tmp17, tmp17, ctx);
    SUB_SI(tmp17, tmp17, 1, ctx);
    SQRT(tmp17, tmp17, ctx);
    MUL(tmp15, tmp16, tmp17, ctx);
    ADD(tmp13, tmp14, tmp15, ctx);
    SQRT_UI(tmp18, 2, ctx);
    SQRT_UI(tmp19, 2, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    ADD(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp18, 2, ctx);
    ADD_SI(tmp18, tmp18, 2, ctx);
    SQRT(tmp18, tmp18, ctx);
    SUB_SI(tmp18, tmp18, 1, ctx);
    SQRT(tmp18, tmp18, ctx);
    MUL(tmp16, tmp17, tmp18, ctx);
    SQRT_UI(tmp17, 2, ctx);
    MUL_SI(tmp17, tmp17, 3, ctx);
    ADD(tmp15, tmp16, tmp17, ctx);
    SQRT_UI(tmp16, 2, ctx);
    ADD_SI(tmp16, tmp16, 2, ctx);
    SQRT(tmp16, tmp16, ctx);
    MUL_SI(tmp16, tmp16, 5, ctx);
    SUB(tmp14, tmp15, tmp16, ctx);
    ADD_SI(tmp14, tmp14, 8, ctx);
    MUL(tmp12, tmp13, tmp14, ctx);
    SQRT_UI(tmp13, 2, ctx);
    ADD_SI(tmp13, tmp13, 2, ctx);
    SQRT(tmp13, tmp13, ctx);
    ADD_SI(tmp13, tmp13, 2, ctx);
    SQRT(tmp13, tmp13, ctx);
    MUL(tmp11, tmp12, tmp13, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, 3, ctx);
    SUB_SI(tmp27, tmp27, 4, ctx);
    MUL_SI(tmp27, tmp27, 3, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, -17, ctx);
    ADD_SI(tmp28, tmp28, 26, ctx);
    SQRT(tmp28, tmp28, ctx);
    MUL(tmp26, tmp27, tmp28, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, 85, ctx);
    SUB(tmp25, tmp26, tmp27, ctx);
    ADD_SI(tmp25, tmp25, 122, ctx);
    SQRT_UI(tmp26, 2, ctx);
    NEG(tmp26, tmp26, ctx);
    ADD_SI(tmp26, tmp26, 2, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, 7, ctx);
    SUB_SI(tmp26, tmp26, 10, ctx);
    MUL_SI(tmp26, tmp26, 11, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, -17, ctx);
    ADD_SI(tmp27, tmp27, 26, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL(tmp25, tmp26, tmp27, ctx);
    SUB(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, 630, ctx);
    ADD(tmp22, tmp23, tmp24, ctx);
    SUB_SI(tmp22, tmp22, 890, ctx);
    MUL_SI(tmp22, tmp22, 2, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, 3, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, -17, ctx);
    ADD_SI(tmp25, tmp25, 26, ctx);
    SQRT(tmp25, tmp25, ctx);
    ADD(tmp23, tmp24, tmp25, ctx);
    SUB_SI(tmp23, tmp23, 3, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp22, 2, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    SUB_SI(tmp22, tmp22, 1, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, 4896, ctx);
    SUB_SI(tmp22, tmp22, 6923, ctx);
    MUL_SI(tmp22, tmp22, 2, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SUB(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, 79, ctx);
    SUB_SI(tmp24, tmp24, 112, ctx);
    MUL_SI(tmp24, tmp24, 20, ctx);
    SQRT_UI(tmp25, 2, ctx);
    ADD_SI(tmp25, tmp25, 2, ctx);
    SQRT(tmp25, tmp25, ctx);
    MUL(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, 27, ctx);
    SUB_SI(tmp27, tmp27, 38, ctx);
    MUL_SI(tmp27, tmp27, 7, ctx);
    SQRT_UI(tmp28, 2, ctx);
    ADD_SI(tmp28, tmp28, 2, ctx);
    SQRT(tmp28, tmp28, ctx);
    MUL(tmp26, tmp27, tmp28, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, 342, ctx);
    SUB(tmp25, tmp26, tmp27, ctx);
    ADD_SI(tmp25, tmp25, 484, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, -17, ctx);
    ADD_SI(tmp26, tmp26, 26, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    SUB(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 2820, ctx);
    SUB(tmp21, tmp22, tmp23, ctx);
    ADD_SI(tmp21, tmp21, 3992, ctx);
    SQRT_UI(tmp22, 2, ctx);
    NEG(tmp22, tmp22, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    ADD(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp31, 2, ctx);
    MUL_SI(tmp31, tmp31, 2, ctx);
    SUB_SI(tmp31, tmp31, 3, ctx);
    MUL_SI(tmp31, tmp31, 3, ctx);
    SQRT_UI(tmp32, 2, ctx);
    MUL_SI(tmp32, tmp32, -17, ctx);
    ADD_SI(tmp32, tmp32, 26, ctx);
    SQRT(tmp32, tmp32, ctx);
    MUL(tmp30, tmp31, tmp32, ctx);
    SQRT_UI(tmp31, 2, ctx);
    MUL_SI(tmp31, tmp31, 61, ctx);
    SUB(tmp29, tmp30, tmp31, ctx);
    ADD_SI(tmp29, tmp29, 85, ctx);
    SQRT_UI(tmp30, 2, ctx);
    NEG(tmp30, tmp30, ctx);
    ADD_SI(tmp30, tmp30, 2, ctx);
    SQRT(tmp30, tmp30, ctx);
    MUL(tmp28, tmp29, tmp30, ctx);
    SQRT_UI(tmp30, 2, ctx);
    MUL_SI(tmp30, tmp30, 5, ctx);
    SUB_SI(tmp30, tmp30, 7, ctx);
    MUL_SI(tmp30, tmp30, 11, ctx);
    SQRT_UI(tmp31, 2, ctx);
    MUL_SI(tmp31, tmp31, -17, ctx);
    ADD_SI(tmp31, tmp31, 26, ctx);
    SQRT(tmp31, tmp31, ctx);
    MUL(tmp29, tmp30, tmp31, ctx);
    SUB(tmp27, tmp28, tmp29, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, 445, ctx);
    ADD(tmp26, tmp27, tmp28, ctx);
    SUB_SI(tmp26, tmp26, 630, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, 3, ctx);
    SQRT_UI(tmp29, 2, ctx);
    MUL_SI(tmp29, tmp29, -17, ctx);
    ADD_SI(tmp29, tmp29, 26, ctx);
    SQRT(tmp29, tmp29, ctx);
    ADD(tmp27, tmp28, tmp29, ctx);
    SUB_SI(tmp27, tmp27, 3, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL(tmp25, tmp26, tmp27, ctx);
    SQRT_UI(tmp26, 2, ctx);
    ADD_SI(tmp26, tmp26, 2, ctx);
    SQRT(tmp26, tmp26, ctx);
    SUB_SI(tmp26, tmp26, 1, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, 89, ctx);
    SUB_SI(tmp26, tmp26, 126, ctx);
    MUL_SI(tmp26, tmp26, 10, ctx);
    SQRT_UI(tmp27, 2, ctx);
    ADD_SI(tmp27, tmp27, 2, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL(tmp25, tmp26, tmp27, ctx);
    SUB(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, 61, ctx);
    SUB_SI(tmp28, tmp28, 85, ctx);
    SQRT_UI(tmp29, 2, ctx);
    ADD_SI(tmp29, tmp29, 2, ctx);
    SQRT(tmp29, tmp29, ctx);
    MUL(tmp27, tmp28, tmp29, ctx);
    SQRT_UI(tmp31, 2, ctx);
    MUL_SI(tmp31, tmp31, 2, ctx);
    SUB_SI(tmp31, tmp31, 3, ctx);
    SQRT_UI(tmp32, 2, ctx);
    ADD_SI(tmp32, tmp32, 2, ctx);
    SQRT(tmp32, tmp32, ctx);
    MUL(tmp30, tmp31, tmp32, ctx);
    SQRT_UI(tmp31, 2, ctx);
    MUL_SI(tmp31, tmp31, 2, ctx);
    SUB(tmp29, tmp30, tmp31, ctx);
    ADD_SI(tmp29, tmp29, 3, ctx);
    MUL_SI(tmp29, tmp29, 3, ctx);
    SQRT_UI(tmp30, 2, ctx);
    MUL_SI(tmp30, tmp30, -17, ctx);
    ADD_SI(tmp30, tmp30, 26, ctx);
    SQRT(tmp30, tmp30, ctx);
    MUL(tmp28, tmp29, tmp30, ctx);
    SUB(tmp26, tmp27, tmp28, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, 61, ctx);
    SUB(tmp25, tmp26, tmp27, ctx);
    ADD_SI(tmp25, tmp25, 85, ctx);
    MUL_SI(tmp25, tmp25, 2, ctx);
    SQRT_UI(tmp26, 2, ctx);
    NEG(tmp26, tmp26, ctx);
    ADD_SI(tmp26, tmp26, 2, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    ADD(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, 5, ctx);
    SUB_SI(tmp26, tmp26, 7, ctx);
    SQRT_UI(tmp27, 2, ctx);
    ADD_SI(tmp27, tmp27, 2, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL(tmp25, tmp26, tmp27, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, 5, ctx);
    SUB(tmp24, tmp25, tmp26, ctx);
    ADD_SI(tmp24, tmp24, 7, ctx);
    MUL_SI(tmp24, tmp24, 22, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, -17, ctx);
    ADD_SI(tmp25, tmp25, 26, ctx);
    SQRT(tmp25, tmp25, ctx);
    MUL(tmp23, tmp24, tmp25, ctx);
    ADD(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, 890, ctx);
    ADD(tmp20, tmp21, tmp22, ctx);
    SUB_SI(tmp20, tmp20, 1260, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, -12, ctx);
    SQRT_UI(tmp24, 2, ctx);
    NEG(tmp24, tmp24, ctx);
    ADD_SI(tmp24, tmp24, 2, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL_SI(tmp24, tmp24, 2, ctx);
    SUB(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, -17, ctx);
    ADD_SI(tmp23, tmp23, 26, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL_SI(tmp23, tmp23, 2, ctx);
    SUB(tmp21, tmp22, tmp23, ctx);
    ADD_SI(tmp21, tmp21, 24, ctx);
    SQRT(tmp21, tmp21, ctx);
    MUL(tmp19, tmp20, tmp21, ctx);
    ADD(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, 319, ctx);
    SUB_SI(tmp21, tmp21, 452, ctx);
    SQRT_UI(tmp22, 2, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, 561, ctx);
    SUB(tmp19, tmp20, tmp21, ctx);
    ADD_SI(tmp19, tmp19, 794, ctx);
    MUL_SI(tmp19, tmp19, 4, ctx);
    SQRT_UI(tmp20, 2, ctx);
    MUL_SI(tmp20, tmp20, -17, ctx);
    ADD_SI(tmp20, tmp20, 26, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL(tmp18, tmp19, tmp20, ctx);
    ADD(tmp16, tmp17, tmp18, ctx);
    SQRT_UI(tmp17, 2, ctx);
    MUL_SI(tmp17, tmp17, 17064, ctx);
    ADD(tmp15, tmp16, tmp17, ctx);
    SUB_SI(tmp15, tmp15, 24132, ctx);
    SQRT_UI(tmp18, 2, ctx);
    ADD_SI(tmp18, tmp18, 2, ctx);
    SQRT(tmp18, tmp18, ctx);
    ADD_SI(tmp18, tmp18, 1, ctx);
    SQRT_UI(tmp19, 2, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    SUB_SI(tmp19, tmp19, 1, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp18, 2, ctx);
    ADD_SI(tmp18, tmp18, 2, ctx);
    SQRT(tmp18, tmp18, ctx);
    ADD(tmp16, tmp17, tmp18, ctx);
    ADD_SI(tmp16, tmp16, 1, ctx);
    MUL(tmp14, tmp15, tmp16, ctx);
    SQRT_UI(tmp18, 2, ctx);
    ADD_SI(tmp18, tmp18, 2, ctx);
    SQRT(tmp18, tmp18, ctx);
    ADD_SI(tmp18, tmp18, 1, ctx);
    SQRT_UI(tmp19, 2, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    SUB_SI(tmp19, tmp19, 1, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp18, 2, ctx);
    ADD_SI(tmp18, tmp18, 2, ctx);
    SQRT(tmp18, tmp18, ctx);
    SUB(tmp16, tmp17, tmp18, ctx);
    SQRT_UI(tmp24, 2, ctx);
    SQRT_UI(tmp25, 2, ctx);
    ADD_SI(tmp25, tmp25, 2, ctx);
    SQRT(tmp25, tmp25, ctx);
    ADD(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp24, 2, ctx);
    ADD_SI(tmp24, tmp24, 2, ctx);
    SQRT(tmp24, tmp24, ctx);
    SUB_SI(tmp24, tmp24, 1, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 3, ctx);
    ADD(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp22, 2, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL_SI(tmp22, tmp22, 5, ctx);
    SUB(tmp20, tmp21, tmp22, ctx);
    ADD_SI(tmp20, tmp20, 8, ctx);
    SQRT_UI(tmp25, 2, ctx);
    SQRT_UI(tmp26, 2, ctx);
    ADD_SI(tmp26, tmp26, 2, ctx);
    SQRT(tmp26, tmp26, ctx);
    ADD(tmp24, tmp25, tmp26, ctx);
    SQRT_UI(tmp25, 2, ctx);
    ADD_SI(tmp25, tmp25, 2, ctx);
    SQRT(tmp25, tmp25, ctx);
    SUB_SI(tmp25, tmp25, 1, ctx);
    SQRT(tmp25, tmp25, ctx);
    MUL(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, 3, ctx);
    SUB(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL_SI(tmp23, tmp23, 5, ctx);
    ADD(tmp21, tmp22, tmp23, ctx);
    SUB_SI(tmp21, tmp21, 8, ctx);
    MUL(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp20, 2, ctx);
    ADD_SI(tmp20, tmp20, 2, ctx);
    SQRT(tmp20, tmp20, ctx);
    ADD_SI(tmp20, tmp20, 2, ctx);
    MUL(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp22, 2, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    ADD_SI(tmp22, tmp22, 1, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    SUB_SI(tmp23, tmp23, 1, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp22, 2, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    ADD(tmp20, tmp21, tmp22, ctx);
    ADD_SI(tmp20, tmp20, 1, ctx);
    SQRT_UI(tmp21, 2, ctx);
    ADD_SI(tmp21, tmp21, 2, ctx);
    SQRT(tmp21, tmp21, ctx);
    SUB_SI(tmp21, tmp21, 2, ctx);
    POW_UI(tmp21, tmp21, 3, ctx);
    MUL(tmp19, tmp20, tmp21, ctx);
    DIV(tmp17, tmp18, tmp19, ctx);
    SUB(tmp15, tmp16, tmp17, ctx);
    SUB_SI(tmp15, tmp15, 1, ctx);
    MUL(tmp13, tmp14, tmp15, ctx);
    SET_SI(tmp17, 1, ctx);
    DIV_SI(tmp17, tmp17, 4, ctx);
    NEG(tmp17, tmp17, ctx);
    SQRT_UI(tmp18, 2, ctx);
    ADD_SI(tmp18, tmp18, 2, ctx);
    SQRT(tmp18, tmp18, ctx);
    MUL(tmp16, tmp17, tmp18, ctx);
    SET_SI(tmp17, 1, ctx);
    DIV_SI(tmp17, tmp17, 2, ctx);
    ADD(tmp15, tmp16, tmp17, ctx);
    SET_SI(tmp16, 3, ctx);
    DIV_SI(tmp16, tmp16, 2, ctx);
    POW(tmp14, tmp15, tmp16, ctx);
    MUL(tmp12, tmp13, tmp14, ctx);
    DIV(tmp10, tmp11, tmp12, ctx);
    ADD(tmp8, tmp9, tmp10, ctx);
    MUL(tmp6, tmp7, tmp8, ctx);
    SQRT_UI(tmp7, 2, ctx);
    ADD_SI(tmp7, tmp7, 2, ctx);
    SQRT(tmp7, tmp7, ctx);
    ADD_SI(tmp7, tmp7, 2, ctx);
    SQRT(tmp7, tmp7, ctx);
    MUL(tmp5, tmp6, tmp7, ctx);
    SET_SI(tmp8, 1, ctx);
    DIV_SI(tmp8, tmp8, 4, ctx);
    NEG(tmp8, tmp8, ctx);
    SQRT_UI(tmp9, 2, ctx);
    ADD_SI(tmp9, tmp9, 2, ctx);
    SQRT(tmp9, tmp9, ctx);
    MUL(tmp7, tmp8, tmp9, ctx);
    SET_SI(tmp8, 1, ctx);
    DIV_SI(tmp8, tmp8, 2, ctx);
    ADD(tmp6, tmp7, tmp8, ctx);
    SQRT(tmp6, tmp6, ctx);
    DIV(tmp4, tmp5, tmp6, ctx);
    SQRT_UI(tmp11, 2, ctx);
    ADD_SI(tmp11, tmp11, 2, ctx);
    SQRT(tmp11, tmp11, ctx);
    SQRT_UI(tmp12, 2, ctx);
    SUB_SI(tmp12, tmp12, 1, ctx);
    MUL(tmp10, tmp11, tmp12, ctx);
    SQRT_UI(tmp11, 2, ctx);
    ADD_SI(tmp11, tmp11, 2, ctx);
    SQRT(tmp11, tmp11, ctx);
    SUB_SI(tmp11, tmp11, 1, ctx);
    SQRT(tmp11, tmp11, ctx);
    MUL(tmp9, tmp10, tmp11, ctx);
    SQRT_UI(tmp10, 2, ctx);
    SUB(tmp8, tmp9, tmp10, ctx);
    SQRT_UI(tmp9, 2, ctx);
    ADD_SI(tmp9, tmp9, 2, ctx);
    SQRT(tmp9, tmp9, ctx);
    ADD(tmp7, tmp8, tmp9, ctx);
    MUL_SI(tmp7, tmp7, 2, ctx);
    SQRT_UI(tmp18, 2, ctx);
    MUL_SI(tmp18, tmp18, 7, ctx);
    SUB_SI(tmp18, tmp18, 10, ctx);
    MUL_SI(tmp18, tmp18, 44, ctx);
    SQRT_UI(tmp19, 2, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp18, 2, ctx);
    MUL_SI(tmp18, tmp18, -17, ctx);
    ADD_SI(tmp18, tmp18, 26, ctx);
    SQRT(tmp18, tmp18, ctx);
    MUL(tmp16, tmp17, tmp18, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 7, ctx);
    SUB_SI(tmp23, tmp23, 10, ctx);
    MUL_SI(tmp23, tmp23, 11, ctx);
    SQRT_UI(tmp24, 2, ctx);
    ADD_SI(tmp24, tmp24, 2, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, -17, ctx);
    ADD_SI(tmp23, tmp23, 26, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 63, ctx);
    SUB_SI(tmp23, tmp23, 89, ctx);
    MUL_SI(tmp23, tmp23, 10, ctx);
    SQRT_UI(tmp24, 2, ctx);
    ADD_SI(tmp24, tmp24, 2, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    SUB(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, 3, ctx);
    SUB_SI(tmp25, tmp25, 4, ctx);
    MUL_SI(tmp25, tmp25, 3, ctx);
    SQRT_UI(tmp26, 2, ctx);
    ADD_SI(tmp26, tmp26, 2, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, -17, ctx);
    ADD_SI(tmp25, tmp25, 26, ctx);
    SQRT(tmp25, tmp25, ctx);
    MUL(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, 85, ctx);
    SUB_SI(tmp25, tmp25, 122, ctx);
    SQRT_UI(tmp26, 2, ctx);
    ADD_SI(tmp26, tmp26, 2, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    SUB(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp23, 2, ctx);
    NEG(tmp23, tmp23, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SUB(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, 3, ctx);
    SUB_SI(tmp26, tmp26, 4, ctx);
    MUL_SI(tmp26, tmp26, 3, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, -17, ctx);
    ADD_SI(tmp27, tmp27, 26, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL(tmp25, tmp26, tmp27, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, 85, ctx);
    SUB(tmp24, tmp25, tmp26, ctx);
    ADD_SI(tmp24, tmp24, 122, ctx);
    SQRT_UI(tmp25, 2, ctx);
    NEG(tmp25, tmp25, ctx);
    ADD_SI(tmp25, tmp25, 2, ctx);
    SQRT(tmp25, tmp25, ctx);
    MUL(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, 7, ctx);
    SUB_SI(tmp25, tmp25, 10, ctx);
    MUL_SI(tmp25, tmp25, 11, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, -17, ctx);
    ADD_SI(tmp26, tmp26, 26, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    SUB(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 630, ctx);
    ADD(tmp21, tmp22, tmp23, ctx);
    SUB_SI(tmp21, tmp21, 890, ctx);
    MUL_SI(tmp21, tmp21, 2, ctx);
    SQRT_UI(tmp22, 2, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    SUB_SI(tmp22, tmp22, 1, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SUB(tmp18, tmp19, tmp20, ctx);
    MUL_SI(tmp18, tmp18, 2, ctx);
    SQRT_UI(tmp20, 2, ctx);
    MUL_SI(tmp20, tmp20, 3, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, -17, ctx);
    ADD_SI(tmp21, tmp21, 26, ctx);
    SQRT(tmp21, tmp21, ctx);
    ADD(tmp19, tmp20, tmp21, ctx);
    SUB_SI(tmp19, tmp19, 3, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    SUB(tmp15, tmp16, tmp17, ctx);
    SQRT_UI(tmp17, 2, ctx);
    MUL_SI(tmp17, tmp17, 63, ctx);
    SUB_SI(tmp17, tmp17, 89, ctx);
    MUL_SI(tmp17, tmp17, 40, ctx);
    SQRT_UI(tmp18, 2, ctx);
    ADD_SI(tmp18, tmp18, 2, ctx);
    SQRT(tmp18, tmp18, ctx);
    MUL(tmp16, tmp17, tmp18, ctx);
    SUB(tmp14, tmp15, tmp16, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, 3, ctx);
    SUB_SI(tmp19, tmp19, 4, ctx);
    MUL_SI(tmp19, tmp19, 3, ctx);
    SQRT_UI(tmp20, 2, ctx);
    ADD_SI(tmp20, tmp20, 2, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, -17, ctx);
    ADD_SI(tmp19, tmp19, 26, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, 85, ctx);
    SUB_SI(tmp19, tmp19, 122, ctx);
    SQRT_UI(tmp20, 2, ctx);
    ADD_SI(tmp20, tmp20, 2, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL(tmp18, tmp19, tmp20, ctx);
    SUB(tmp16, tmp17, tmp18, ctx);
    MUL_SI(tmp16, tmp16, 4, ctx);
    SQRT_UI(tmp17, 2, ctx);
    NEG(tmp17, tmp17, ctx);
    ADD_SI(tmp17, tmp17, 2, ctx);
    SQRT(tmp17, tmp17, ctx);
    MUL(tmp15, tmp16, tmp17, ctx);
    SUB(tmp13, tmp14, tmp15, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, 5, ctx);
    SUB_SI(tmp21, tmp21, 7, ctx);
    MUL_SI(tmp21, tmp21, 22, ctx);
    SQRT_UI(tmp22, 2, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, -17, ctx);
    ADD_SI(tmp21, tmp21, 26, ctx);
    SQRT(tmp21, tmp21, ctx);
    MUL(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, 5, ctx);
    SUB_SI(tmp26, tmp26, 7, ctx);
    MUL_SI(tmp26, tmp26, 11, ctx);
    SQRT_UI(tmp27, 2, ctx);
    ADD_SI(tmp27, tmp27, 2, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL(tmp25, tmp26, tmp27, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, -17, ctx);
    ADD_SI(tmp26, tmp26, 26, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, 89, ctx);
    SUB_SI(tmp26, tmp26, 126, ctx);
    MUL_SI(tmp26, tmp26, 5, ctx);
    SQRT_UI(tmp27, 2, ctx);
    ADD_SI(tmp27, tmp27, 2, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL(tmp25, tmp26, tmp27, ctx);
    SUB(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, 2, ctx);
    SUB_SI(tmp28, tmp28, 3, ctx);
    MUL_SI(tmp28, tmp28, 3, ctx);
    SQRT_UI(tmp29, 2, ctx);
    ADD_SI(tmp29, tmp29, 2, ctx);
    SQRT(tmp29, tmp29, ctx);
    MUL(tmp27, tmp28, tmp29, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, -17, ctx);
    ADD_SI(tmp28, tmp28, 26, ctx);
    SQRT(tmp28, tmp28, ctx);
    MUL(tmp26, tmp27, tmp28, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, 61, ctx);
    SUB_SI(tmp28, tmp28, 85, ctx);
    SQRT_UI(tmp29, 2, ctx);
    ADD_SI(tmp29, tmp29, 2, ctx);
    SQRT(tmp29, tmp29, ctx);
    MUL(tmp27, tmp28, tmp29, ctx);
    SUB(tmp25, tmp26, tmp27, ctx);
    SQRT_UI(tmp26, 2, ctx);
    NEG(tmp26, tmp26, ctx);
    ADD_SI(tmp26, tmp26, 2, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    SUB(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp29, 2, ctx);
    MUL_SI(tmp29, tmp29, 2, ctx);
    SUB_SI(tmp29, tmp29, 3, ctx);
    MUL_SI(tmp29, tmp29, 3, ctx);
    SQRT_UI(tmp30, 2, ctx);
    MUL_SI(tmp30, tmp30, -17, ctx);
    ADD_SI(tmp30, tmp30, 26, ctx);
    SQRT(tmp30, tmp30, ctx);
    MUL(tmp28, tmp29, tmp30, ctx);
    SQRT_UI(tmp29, 2, ctx);
    MUL_SI(tmp29, tmp29, 61, ctx);
    SUB(tmp27, tmp28, tmp29, ctx);
    ADD_SI(tmp27, tmp27, 85, ctx);
    SQRT_UI(tmp28, 2, ctx);
    NEG(tmp28, tmp28, ctx);
    ADD_SI(tmp28, tmp28, 2, ctx);
    SQRT(tmp28, tmp28, ctx);
    MUL(tmp26, tmp27, tmp28, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, 5, ctx);
    SUB_SI(tmp28, tmp28, 7, ctx);
    MUL_SI(tmp28, tmp28, 11, ctx);
    SQRT_UI(tmp29, 2, ctx);
    MUL_SI(tmp29, tmp29, -17, ctx);
    ADD_SI(tmp29, tmp29, 26, ctx);
    SQRT(tmp29, tmp29, ctx);
    MUL(tmp27, tmp28, tmp29, ctx);
    SUB(tmp25, tmp26, tmp27, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, 445, ctx);
    ADD(tmp24, tmp25, tmp26, ctx);
    SUB_SI(tmp24, tmp24, 630, ctx);
    MUL_SI(tmp24, tmp24, 2, ctx);
    SQRT_UI(tmp25, 2, ctx);
    ADD_SI(tmp25, tmp25, 2, ctx);
    SQRT(tmp25, tmp25, ctx);
    SUB_SI(tmp25, tmp25, 1, ctx);
    SQRT(tmp25, tmp25, ctx);
    MUL(tmp23, tmp24, tmp25, ctx);
    SUB(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 3, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, -17, ctx);
    ADD_SI(tmp24, tmp24, 26, ctx);
    SQRT(tmp24, tmp24, ctx);
    ADD(tmp22, tmp23, tmp24, ctx);
    SUB_SI(tmp22, tmp22, 3, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SUB(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp20, 2, ctx);
    MUL_SI(tmp20, tmp20, 89, ctx);
    SUB_SI(tmp20, tmp20, 126, ctx);
    MUL_SI(tmp20, tmp20, 10, ctx);
    SQRT_UI(tmp21, 2, ctx);
    ADD_SI(tmp21, tmp21, 2, ctx);
    SQRT(tmp21, tmp21, ctx);
    MUL(tmp19, tmp20, tmp21, ctx);
    SUB(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, 2, ctx);
    SUB_SI(tmp22, tmp22, 3, ctx);
    MUL_SI(tmp22, tmp22, 3, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, -17, ctx);
    ADD_SI(tmp22, tmp22, 26, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, 61, ctx);
    SUB_SI(tmp22, tmp22, 85, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SUB(tmp19, tmp20, tmp21, ctx);
    MUL_SI(tmp19, tmp19, 2, ctx);
    SQRT_UI(tmp20, 2, ctx);
    NEG(tmp20, tmp20, ctx);
    ADD_SI(tmp20, tmp20, 2, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL(tmp18, tmp19, tmp20, ctx);
    SUB(tmp16, tmp17, tmp18, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 2, ctx);
    SUB_SI(tmp23, tmp23, 3, ctx);
    MUL_SI(tmp23, tmp23, 3, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, -17, ctx);
    ADD_SI(tmp24, tmp24, 26, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 61, ctx);
    SUB(tmp21, tmp22, tmp23, ctx);
    ADD_SI(tmp21, tmp21, 85, ctx);
    SQRT_UI(tmp22, 2, ctx);
    NEG(tmp22, tmp22, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, 5, ctx);
    SUB_SI(tmp22, tmp22, 7, ctx);
    MUL_SI(tmp22, tmp22, 11, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, -17, ctx);
    ADD_SI(tmp23, tmp23, 26, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SUB(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp20, 2, ctx);
    MUL_SI(tmp20, tmp20, 445, ctx);
    ADD(tmp18, tmp19, tmp20, ctx);
    SUB_SI(tmp18, tmp18, 630, ctx);
    MUL_SI(tmp18, tmp18, 4, ctx);
    SQRT_UI(tmp19, 2, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    SUB_SI(tmp19, tmp19, 1, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    SUB(tmp15, tmp16, tmp17, ctx);
    SQRT_UI(tmp18, 2, ctx);
    MUL_SI(tmp18, tmp18, -12, ctx);
    SQRT_UI(tmp19, 2, ctx);
    NEG(tmp19, tmp19, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL_SI(tmp19, tmp19, 2, ctx);
    SUB(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp18, 2, ctx);
    MUL_SI(tmp18, tmp18, -17, ctx);
    ADD_SI(tmp18, tmp18, 26, ctx);
    SQRT(tmp18, tmp18, ctx);
    MUL_SI(tmp18, tmp18, 2, ctx);
    SUB(tmp16, tmp17, tmp18, ctx);
    ADD_SI(tmp16, tmp16, 24, ctx);
    SQRT(tmp16, tmp16, ctx);
    MUL(tmp14, tmp15, tmp16, ctx);
    ADD(tmp12, tmp13, tmp14, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, 3, ctx);
    SUB_SI(tmp19, tmp19, 4, ctx);
    MUL_SI(tmp19, tmp19, 3, ctx);
    SQRT_UI(tmp20, 2, ctx);
    MUL_SI(tmp20, tmp20, -17, ctx);
    ADD_SI(tmp20, tmp20, 26, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, 85, ctx);
    SUB(tmp17, tmp18, tmp19, ctx);
    ADD_SI(tmp17, tmp17, 122, ctx);
    SQRT_UI(tmp18, 2, ctx);
    NEG(tmp18, tmp18, ctx);
    ADD_SI(tmp18, tmp18, 2, ctx);
    SQRT(tmp18, tmp18, ctx);
    MUL(tmp16, tmp17, tmp18, ctx);
    SQRT_UI(tmp18, 2, ctx);
    MUL_SI(tmp18, tmp18, 7, ctx);
    SUB_SI(tmp18, tmp18, 10, ctx);
    MUL_SI(tmp18, tmp18, 11, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, -17, ctx);
    ADD_SI(tmp19, tmp19, 26, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    SUB(tmp15, tmp16, tmp17, ctx);
    SQRT_UI(tmp16, 2, ctx);
    MUL_SI(tmp16, tmp16, 630, ctx);
    ADD(tmp14, tmp15, tmp16, ctx);
    SUB_SI(tmp14, tmp14, 890, ctx);
    MUL_SI(tmp14, tmp14, 8, ctx);
    SQRT_UI(tmp15, 2, ctx);
    ADD_SI(tmp15, tmp15, 2, ctx);
    SQRT(tmp15, tmp15, ctx);
    SUB_SI(tmp15, tmp15, 1, ctx);
    SQRT(tmp15, tmp15, ctx);
    MUL(tmp13, tmp14, tmp15, ctx);
    SUB(tmp11, tmp12, tmp13, ctx);
    MUL_SI(tmp11, tmp11, 8, ctx);
    SQRT_UI(tmp15, 2, ctx);
    ADD_SI(tmp15, tmp15, 2, ctx);
    SQRT(tmp15, tmp15, ctx);
    ADD_SI(tmp15, tmp15, 1, ctx);
    SQRT_UI(tmp16, 2, ctx);
    ADD_SI(tmp16, tmp16, 2, ctx);
    SQRT(tmp16, tmp16, ctx);
    SUB_SI(tmp16, tmp16, 1, ctx);
    SQRT(tmp16, tmp16, ctx);
    MUL(tmp14, tmp15, tmp16, ctx);
    SQRT_UI(tmp15, 2, ctx);
    ADD_SI(tmp15, tmp15, 2, ctx);
    SQRT(tmp15, tmp15, ctx);
    ADD(tmp13, tmp14, tmp15, ctx);
    ADD_SI(tmp13, tmp13, 1, ctx);
    INV(tmp13, tmp13, ctx);
    SQRT_UI(tmp21, 2, ctx);
    SQRT_UI(tmp22, 2, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    ADD(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp21, 2, ctx);
    ADD_SI(tmp21, tmp21, 2, ctx);
    SQRT(tmp21, tmp21, ctx);
    SUB_SI(tmp21, tmp21, 1, ctx);
    SQRT(tmp21, tmp21, ctx);
    MUL(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp20, 2, ctx);
    MUL_SI(tmp20, tmp20, 3, ctx);
    ADD(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp19, 2, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL_SI(tmp19, tmp19, 5, ctx);
    SUB(tmp17, tmp18, tmp19, ctx);
    ADD_SI(tmp17, tmp17, 8, ctx);
    SQRT_UI(tmp22, 2, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    ADD(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp22, 2, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    SUB_SI(tmp22, tmp22, 1, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, 3, ctx);
    SUB(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp20, 2, ctx);
    ADD_SI(tmp20, tmp20, 2, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL_SI(tmp20, tmp20, 5, ctx);
    ADD(tmp18, tmp19, tmp20, ctx);
    SUB_SI(tmp18, tmp18, 8, ctx);
    MUL(tmp16, tmp17, tmp18, ctx);
    SQRT_UI(tmp17, 2, ctx);
    ADD_SI(tmp17, tmp17, 2, ctx);
    SQRT(tmp17, tmp17, ctx);
    ADD_SI(tmp17, tmp17, 2, ctx);
    MUL(tmp15, tmp16, tmp17, ctx);
    SQRT_UI(tmp20, 2, ctx);
    ADD_SI(tmp20, tmp20, 2, ctx);
    SQRT(tmp20, tmp20, ctx);
    ADD_SI(tmp20, tmp20, 1, ctx);
    SQRT_UI(tmp21, 2, ctx);
    ADD_SI(tmp21, tmp21, 2, ctx);
    SQRT(tmp21, tmp21, ctx);
    SUB_SI(tmp21, tmp21, 1, ctx);
    SQRT(tmp21, tmp21, ctx);
    MUL(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp20, 2, ctx);
    ADD_SI(tmp20, tmp20, 2, ctx);
    SQRT(tmp20, tmp20, ctx);
    ADD(tmp18, tmp19, tmp20, ctx);
    ADD_SI(tmp18, tmp18, 1, ctx);
    POW_UI(tmp18, tmp18, 2, ctx);
    SQRT_UI(tmp22, 2, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    ADD_SI(tmp22, tmp22, 1, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    SUB_SI(tmp23, tmp23, 1, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp22, 2, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    SUB(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp28, 2, ctx);
    SQRT_UI(tmp29, 2, ctx);
    ADD_SI(tmp29, tmp29, 2, ctx);
    SQRT(tmp29, tmp29, ctx);
    ADD(tmp27, tmp28, tmp29, ctx);
    SQRT_UI(tmp28, 2, ctx);
    ADD_SI(tmp28, tmp28, 2, ctx);
    SQRT(tmp28, tmp28, ctx);
    SUB_SI(tmp28, tmp28, 1, ctx);
    SQRT(tmp28, tmp28, ctx);
    MUL(tmp26, tmp27, tmp28, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, 3, ctx);
    ADD(tmp25, tmp26, tmp27, ctx);
    SQRT_UI(tmp26, 2, ctx);
    ADD_SI(tmp26, tmp26, 2, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL_SI(tmp26, tmp26, 5, ctx);
    SUB(tmp24, tmp25, tmp26, ctx);
    ADD_SI(tmp24, tmp24, 8, ctx);
    SQRT_UI(tmp29, 2, ctx);
    SQRT_UI(tmp30, 2, ctx);
    ADD_SI(tmp30, tmp30, 2, ctx);
    SQRT(tmp30, tmp30, ctx);
    ADD(tmp28, tmp29, tmp30, ctx);
    SQRT_UI(tmp29, 2, ctx);
    ADD_SI(tmp29, tmp29, 2, ctx);
    SQRT(tmp29, tmp29, ctx);
    SUB_SI(tmp29, tmp29, 1, ctx);
    SQRT(tmp29, tmp29, ctx);
    MUL(tmp27, tmp28, tmp29, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, 3, ctx);
    SUB(tmp26, tmp27, tmp28, ctx);
    SQRT_UI(tmp27, 2, ctx);
    ADD_SI(tmp27, tmp27, 2, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL_SI(tmp27, tmp27, 5, ctx);
    ADD(tmp25, tmp26, tmp27, ctx);
    SUB_SI(tmp25, tmp25, 8, ctx);
    MUL(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp24, 2, ctx);
    ADD_SI(tmp24, tmp24, 2, ctx);
    SQRT(tmp24, tmp24, ctx);
    ADD_SI(tmp24, tmp24, 2, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp26, 2, ctx);
    ADD_SI(tmp26, tmp26, 2, ctx);
    SQRT(tmp26, tmp26, ctx);
    ADD_SI(tmp26, tmp26, 1, ctx);
    SQRT_UI(tmp27, 2, ctx);
    ADD_SI(tmp27, tmp27, 2, ctx);
    SQRT(tmp27, tmp27, ctx);
    SUB_SI(tmp27, tmp27, 1, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL(tmp25, tmp26, tmp27, ctx);
    SQRT_UI(tmp26, 2, ctx);
    ADD_SI(tmp26, tmp26, 2, ctx);
    SQRT(tmp26, tmp26, ctx);
    ADD(tmp24, tmp25, tmp26, ctx);
    ADD_SI(tmp24, tmp24, 1, ctx);
    SQRT_UI(tmp25, 2, ctx);
    ADD_SI(tmp25, tmp25, 2, ctx);
    SQRT(tmp25, tmp25, ctx);
    SUB_SI(tmp25, tmp25, 2, ctx);
    POW_UI(tmp25, tmp25, 3, ctx);
    MUL(tmp23, tmp24, tmp25, ctx);
    DIV(tmp21, tmp22, tmp23, ctx);
    SUB(tmp19, tmp20, tmp21, ctx);
    SUB_SI(tmp19, tmp19, 1, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp18, 2, ctx);
    ADD_SI(tmp18, tmp18, 2, ctx);
    SQRT(tmp18, tmp18, ctx);
    SUB_SI(tmp18, tmp18, 2, ctx);
    POW_UI(tmp18, tmp18, 3, ctx);
    MUL(tmp16, tmp17, tmp18, ctx);
    DIV(tmp14, tmp15, tmp16, ctx);
    ADD(tmp12, tmp13, tmp14, ctx);
    MUL(tmp10, tmp11, tmp12, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 3, ctx);
    SUB_SI(tmp23, tmp23, 4, ctx);
    MUL_SI(tmp23, tmp23, 3, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, -17, ctx);
    ADD_SI(tmp24, tmp24, 26, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 85, ctx);
    SUB(tmp21, tmp22, tmp23, ctx);
    ADD_SI(tmp21, tmp21, 122, ctx);
    SQRT_UI(tmp22, 2, ctx);
    NEG(tmp22, tmp22, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, 7, ctx);
    SUB_SI(tmp22, tmp22, 10, ctx);
    MUL_SI(tmp22, tmp22, 11, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, -17, ctx);
    ADD_SI(tmp23, tmp23, 26, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SUB(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp20, 2, ctx);
    MUL_SI(tmp20, tmp20, 630, ctx);
    ADD(tmp18, tmp19, tmp20, ctx);
    SUB_SI(tmp18, tmp18, 890, ctx);
    MUL_SI(tmp18, tmp18, 2, ctx);
    SQRT_UI(tmp20, 2, ctx);
    MUL_SI(tmp20, tmp20, 3, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, -17, ctx);
    ADD_SI(tmp21, tmp21, 26, ctx);
    SQRT(tmp21, tmp21, ctx);
    ADD(tmp19, tmp20, tmp21, ctx);
    SUB_SI(tmp19, tmp19, 3, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp18, 2, ctx);
    ADD_SI(tmp18, tmp18, 2, ctx);
    SQRT(tmp18, tmp18, ctx);
    SUB_SI(tmp18, tmp18, 1, ctx);
    SQRT(tmp18, tmp18, ctx);
    MUL(tmp16, tmp17, tmp18, ctx);
    SQRT_UI(tmp18, 2, ctx);
    MUL_SI(tmp18, tmp18, 4896, ctx);
    SUB_SI(tmp18, tmp18, 6923, ctx);
    MUL_SI(tmp18, tmp18, 2, ctx);
    SQRT_UI(tmp19, 2, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    SUB(tmp15, tmp16, tmp17, ctx);
    SQRT_UI(tmp20, 2, ctx);
    MUL_SI(tmp20, tmp20, 79, ctx);
    SUB_SI(tmp20, tmp20, 112, ctx);
    MUL_SI(tmp20, tmp20, 20, ctx);
    SQRT_UI(tmp21, 2, ctx);
    ADD_SI(tmp21, tmp21, 2, ctx);
    SQRT(tmp21, tmp21, ctx);
    MUL(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 27, ctx);
    SUB_SI(tmp23, tmp23, 38, ctx);
    MUL_SI(tmp23, tmp23, 7, ctx);
    SQRT_UI(tmp24, 2, ctx);
    ADD_SI(tmp24, tmp24, 2, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 342, ctx);
    SUB(tmp21, tmp22, tmp23, ctx);
    ADD_SI(tmp21, tmp21, 484, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, -17, ctx);
    ADD_SI(tmp22, tmp22, 26, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SUB(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, 2820, ctx);
    SUB(tmp17, tmp18, tmp19, ctx);
    ADD_SI(tmp17, tmp17, 3992, ctx);
    SQRT_UI(tmp18, 2, ctx);
    NEG(tmp18, tmp18, ctx);
    ADD_SI(tmp18, tmp18, 2, ctx);
    SQRT(tmp18, tmp18, ctx);
    MUL(tmp16, tmp17, tmp18, ctx);
    ADD(tmp14, tmp15, tmp16, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, 2, ctx);
    SUB_SI(tmp27, tmp27, 3, ctx);
    MUL_SI(tmp27, tmp27, 3, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, -17, ctx);
    ADD_SI(tmp28, tmp28, 26, ctx);
    SQRT(tmp28, tmp28, ctx);
    MUL(tmp26, tmp27, tmp28, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, 61, ctx);
    SUB(tmp25, tmp26, tmp27, ctx);
    ADD_SI(tmp25, tmp25, 85, ctx);
    SQRT_UI(tmp26, 2, ctx);
    NEG(tmp26, tmp26, ctx);
    ADD_SI(tmp26, tmp26, 2, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, 5, ctx);
    SUB_SI(tmp26, tmp26, 7, ctx);
    MUL_SI(tmp26, tmp26, 11, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, -17, ctx);
    ADD_SI(tmp27, tmp27, 26, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL(tmp25, tmp26, tmp27, ctx);
    SUB(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, 445, ctx);
    ADD(tmp22, tmp23, tmp24, ctx);
    SUB_SI(tmp22, tmp22, 630, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, 3, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, -17, ctx);
    ADD_SI(tmp25, tmp25, 26, ctx);
    SQRT(tmp25, tmp25, ctx);
    ADD(tmp23, tmp24, tmp25, ctx);
    SUB_SI(tmp23, tmp23, 3, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp22, 2, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    SUB_SI(tmp22, tmp22, 1, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, 89, ctx);
    SUB_SI(tmp22, tmp22, 126, ctx);
    MUL_SI(tmp22, tmp22, 10, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SUB(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, 61, ctx);
    SUB_SI(tmp24, tmp24, 85, ctx);
    SQRT_UI(tmp25, 2, ctx);
    ADD_SI(tmp25, tmp25, 2, ctx);
    SQRT(tmp25, tmp25, ctx);
    MUL(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, 2, ctx);
    SUB_SI(tmp27, tmp27, 3, ctx);
    SQRT_UI(tmp28, 2, ctx);
    ADD_SI(tmp28, tmp28, 2, ctx);
    SQRT(tmp28, tmp28, ctx);
    MUL(tmp26, tmp27, tmp28, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, 2, ctx);
    SUB(tmp25, tmp26, tmp27, ctx);
    ADD_SI(tmp25, tmp25, 3, ctx);
    MUL_SI(tmp25, tmp25, 3, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, -17, ctx);
    ADD_SI(tmp26, tmp26, 26, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    SUB(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 61, ctx);
    SUB(tmp21, tmp22, tmp23, ctx);
    ADD_SI(tmp21, tmp21, 85, ctx);
    MUL_SI(tmp21, tmp21, 2, ctx);
    SQRT_UI(tmp22, 2, ctx);
    NEG(tmp22, tmp22, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    ADD(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, 5, ctx);
    SUB_SI(tmp22, tmp22, 7, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, 5, ctx);
    SUB(tmp20, tmp21, tmp22, ctx);
    ADD_SI(tmp20, tmp20, 7, ctx);
    MUL_SI(tmp20, tmp20, 22, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, -17, ctx);
    ADD_SI(tmp21, tmp21, 26, ctx);
    SQRT(tmp21, tmp21, ctx);
    MUL(tmp19, tmp20, tmp21, ctx);
    ADD(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp18, 2, ctx);
    MUL_SI(tmp18, tmp18, 890, ctx);
    ADD(tmp16, tmp17, tmp18, ctx);
    SUB_SI(tmp16, tmp16, 1260, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, -12, ctx);
    SQRT_UI(tmp20, 2, ctx);
    NEG(tmp20, tmp20, ctx);
    ADD_SI(tmp20, tmp20, 2, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL_SI(tmp20, tmp20, 2, ctx);
    SUB(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, -17, ctx);
    ADD_SI(tmp19, tmp19, 26, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL_SI(tmp19, tmp19, 2, ctx);
    SUB(tmp17, tmp18, tmp19, ctx);
    ADD_SI(tmp17, tmp17, 24, ctx);
    SQRT(tmp17, tmp17, ctx);
    MUL(tmp15, tmp16, tmp17, ctx);
    ADD(tmp13, tmp14, tmp15, ctx);
    SQRT_UI(tmp17, 2, ctx);
    MUL_SI(tmp17, tmp17, 319, ctx);
    SUB_SI(tmp17, tmp17, 452, ctx);
    SQRT_UI(tmp18, 2, ctx);
    ADD_SI(tmp18, tmp18, 2, ctx);
    SQRT(tmp18, tmp18, ctx);
    MUL(tmp16, tmp17, tmp18, ctx);
    SQRT_UI(tmp17, 2, ctx);
    MUL_SI(tmp17, tmp17, 561, ctx);
    SUB(tmp15, tmp16, tmp17, ctx);
    ADD_SI(tmp15, tmp15, 794, ctx);
    MUL_SI(tmp15, tmp15, 4, ctx);
    SQRT_UI(tmp16, 2, ctx);
    MUL_SI(tmp16, tmp16, -17, ctx);
    ADD_SI(tmp16, tmp16, 26, ctx);
    SQRT(tmp16, tmp16, ctx);
    MUL(tmp14, tmp15, tmp16, ctx);
    ADD(tmp12, tmp13, tmp14, ctx);
    SQRT_UI(tmp13, 2, ctx);
    MUL_SI(tmp13, tmp13, 17064, ctx);
    ADD(tmp11, tmp12, tmp13, ctx);
    SUB_SI(tmp11, tmp11, 24132, ctx);
    DIV(tmp9, tmp10, tmp11, ctx);
    SQRT_UI(tmp20, 2, ctx);
    MUL_SI(tmp20, tmp20, 89, ctx);
    SUB_SI(tmp20, tmp20, 126, ctx);
    MUL_SI(tmp20, tmp20, 5, ctx);
    SQRT_UI(tmp21, 2, ctx);
    ADD_SI(tmp21, tmp21, 2, ctx);
    SQRT(tmp21, tmp21, ctx);
    MUL(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, 61, ctx);
    SUB_SI(tmp24, tmp24, 85, ctx);
    SQRT_UI(tmp25, 2, ctx);
    ADD_SI(tmp25, tmp25, 2, ctx);
    SQRT(tmp25, tmp25, ctx);
    MUL(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, 2, ctx);
    SUB_SI(tmp27, tmp27, 3, ctx);
    SQRT_UI(tmp28, 2, ctx);
    ADD_SI(tmp28, tmp28, 2, ctx);
    SQRT(tmp28, tmp28, ctx);
    MUL(tmp26, tmp27, tmp28, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, 4, ctx);
    SUB(tmp25, tmp26, tmp27, ctx);
    ADD_SI(tmp25, tmp25, 6, ctx);
    MUL_SI(tmp25, tmp25, 3, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, -17, ctx);
    ADD_SI(tmp26, tmp26, 26, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    SUB(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 122, ctx);
    SUB(tmp21, tmp22, tmp23, ctx);
    ADD_SI(tmp21, tmp21, 170, ctx);
    SQRT_UI(tmp22, 2, ctx);
    NEG(tmp22, tmp22, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SUB(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, 5, ctx);
    SUB_SI(tmp22, tmp22, 7, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, 10, ctx);
    SUB(tmp20, tmp21, tmp22, ctx);
    ADD_SI(tmp20, tmp20, 14, ctx);
    MUL_SI(tmp20, tmp20, 11, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, -17, ctx);
    ADD_SI(tmp21, tmp21, 26, ctx);
    SQRT(tmp21, tmp21, ctx);
    MUL(tmp19, tmp20, tmp21, ctx);
    SUB(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp18, 2, ctx);
    MUL_SI(tmp18, tmp18, 890, ctx);
    SUB(tmp16, tmp17, tmp18, ctx);
    ADD_SI(tmp16, tmp16, 1260, ctx);
    SQRT_UI(tmp18, 2, ctx);
    MUL_SI(tmp18, tmp18, 3, ctx);
    SQRT_UI(tmp19, 2, ctx);
    NEG(tmp19, tmp19, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    ADD(tmp17, tmp18, tmp19, ctx);
    SUB_SI(tmp17, tmp17, 5, ctx);
    SQRT(tmp17, tmp17, ctx);
    MUL(tmp15, tmp16, tmp17, ctx);
    SQRT_UI(tmp18, 2, ctx);
    MUL_SI(tmp18, tmp18, -12, ctx);
    SQRT_UI(tmp19, 2, ctx);
    NEG(tmp19, tmp19, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL_SI(tmp19, tmp19, 2, ctx);
    SUB(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp18, 2, ctx);
    MUL_SI(tmp18, tmp18, -17, ctx);
    ADD_SI(tmp18, tmp18, 26, ctx);
    SQRT(tmp18, tmp18, ctx);
    MUL_SI(tmp18, tmp18, 2, ctx);
    SUB(tmp16, tmp17, tmp18, ctx);
    ADD_SI(tmp16, tmp16, 24, ctx);
    SQRT(tmp16, tmp16, ctx);
    MUL(tmp14, tmp15, tmp16, ctx);
    SQRT_UI(tmp20, 2, ctx);
    MUL_SI(tmp20, tmp20, 63, ctx);
    SUB_SI(tmp20, tmp20, 89, ctx);
    MUL_SI(tmp20, tmp20, 10, ctx);
    SQRT_UI(tmp21, 2, ctx);
    ADD_SI(tmp21, tmp21, 2, ctx);
    SQRT(tmp21, tmp21, ctx);
    MUL(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, 85, ctx);
    SUB_SI(tmp24, tmp24, 122, ctx);
    SQRT_UI(tmp25, 2, ctx);
    ADD_SI(tmp25, tmp25, 2, ctx);
    SQRT(tmp25, tmp25, ctx);
    MUL(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, 3, ctx);
    SUB_SI(tmp27, tmp27, 4, ctx);
    SQRT_UI(tmp28, 2, ctx);
    ADD_SI(tmp28, tmp28, 2, ctx);
    SQRT(tmp28, tmp28, ctx);
    MUL(tmp26, tmp27, tmp28, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, 6, ctx);
    SUB(tmp25, tmp26, tmp27, ctx);
    ADD_SI(tmp25, tmp25, 8, ctx);
    MUL_SI(tmp25, tmp25, 3, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, -17, ctx);
    ADD_SI(tmp26, tmp26, 26, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    SUB(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 170, ctx);
    SUB(tmp21, tmp22, tmp23, ctx);
    ADD_SI(tmp21, tmp21, 244, ctx);
    SQRT_UI(tmp22, 2, ctx);
    NEG(tmp22, tmp22, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SUB(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, 7, ctx);
    SUB_SI(tmp22, tmp22, 10, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, 14, ctx);
    SUB(tmp20, tmp21, tmp22, ctx);
    ADD_SI(tmp20, tmp20, 20, ctx);
    MUL_SI(tmp20, tmp20, 11, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, -17, ctx);
    ADD_SI(tmp21, tmp21, 26, ctx);
    SQRT(tmp21, tmp21, ctx);
    MUL(tmp19, tmp20, tmp21, ctx);
    SUB(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp18, 2, ctx);
    MUL_SI(tmp18, tmp18, 1260, ctx);
    SUB(tmp16, tmp17, tmp18, ctx);
    ADD_SI(tmp16, tmp16, 1780, ctx);
    MUL_SI(tmp16, tmp16, 2, ctx);
    SQRT_UI(tmp18, 2, ctx);
    MUL_SI(tmp18, tmp18, 3, ctx);
    SQRT_UI(tmp19, 2, ctx);
    NEG(tmp19, tmp19, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    ADD(tmp17, tmp18, tmp19, ctx);
    SUB_SI(tmp17, tmp17, 5, ctx);
    SQRT(tmp17, tmp17, ctx);
    MUL(tmp15, tmp16, tmp17, ctx);
    ADD(tmp13, tmp14, tmp15, ctx);
    SQRT_UI(tmp18, 2, ctx);
    SQRT_UI(tmp19, 2, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    ADD(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp18, 2, ctx);
    ADD_SI(tmp18, tmp18, 2, ctx);
    SQRT(tmp18, tmp18, ctx);
    SUB_SI(tmp18, tmp18, 1, ctx);
    SQRT(tmp18, tmp18, ctx);
    MUL(tmp16, tmp17, tmp18, ctx);
    SQRT_UI(tmp17, 2, ctx);
    MUL_SI(tmp17, tmp17, 3, ctx);
    ADD(tmp15, tmp16, tmp17, ctx);
    SQRT_UI(tmp16, 2, ctx);
    ADD_SI(tmp16, tmp16, 2, ctx);
    SQRT(tmp16, tmp16, ctx);
    MUL_SI(tmp16, tmp16, 5, ctx);
    SUB(tmp14, tmp15, tmp16, ctx);
    ADD_SI(tmp14, tmp14, 8, ctx);
    MUL(tmp12, tmp13, tmp14, ctx);
    SQRT_UI(tmp13, 2, ctx);
    ADD_SI(tmp13, tmp13, 2, ctx);
    SQRT(tmp13, tmp13, ctx);
    ADD_SI(tmp13, tmp13, 2, ctx);
    SQRT(tmp13, tmp13, ctx);
    MUL(tmp11, tmp12, tmp13, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, 3, ctx);
    SUB_SI(tmp27, tmp27, 4, ctx);
    MUL_SI(tmp27, tmp27, 3, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, -17, ctx);
    ADD_SI(tmp28, tmp28, 26, ctx);
    SQRT(tmp28, tmp28, ctx);
    MUL(tmp26, tmp27, tmp28, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, 85, ctx);
    SUB(tmp25, tmp26, tmp27, ctx);
    ADD_SI(tmp25, tmp25, 122, ctx);
    SQRT_UI(tmp26, 2, ctx);
    NEG(tmp26, tmp26, ctx);
    ADD_SI(tmp26, tmp26, 2, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, 7, ctx);
    SUB_SI(tmp26, tmp26, 10, ctx);
    MUL_SI(tmp26, tmp26, 11, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, -17, ctx);
    ADD_SI(tmp27, tmp27, 26, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL(tmp25, tmp26, tmp27, ctx);
    SUB(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, 630, ctx);
    ADD(tmp22, tmp23, tmp24, ctx);
    SUB_SI(tmp22, tmp22, 890, ctx);
    MUL_SI(tmp22, tmp22, 2, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, 3, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, -17, ctx);
    ADD_SI(tmp25, tmp25, 26, ctx);
    SQRT(tmp25, tmp25, ctx);
    ADD(tmp23, tmp24, tmp25, ctx);
    SUB_SI(tmp23, tmp23, 3, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp22, 2, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    SUB_SI(tmp22, tmp22, 1, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, 4896, ctx);
    SUB_SI(tmp22, tmp22, 6923, ctx);
    MUL_SI(tmp22, tmp22, 2, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SUB(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, 79, ctx);
    SUB_SI(tmp24, tmp24, 112, ctx);
    MUL_SI(tmp24, tmp24, 20, ctx);
    SQRT_UI(tmp25, 2, ctx);
    ADD_SI(tmp25, tmp25, 2, ctx);
    SQRT(tmp25, tmp25, ctx);
    MUL(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, 27, ctx);
    SUB_SI(tmp27, tmp27, 38, ctx);
    MUL_SI(tmp27, tmp27, 7, ctx);
    SQRT_UI(tmp28, 2, ctx);
    ADD_SI(tmp28, tmp28, 2, ctx);
    SQRT(tmp28, tmp28, ctx);
    MUL(tmp26, tmp27, tmp28, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, 342, ctx);
    SUB(tmp25, tmp26, tmp27, ctx);
    ADD_SI(tmp25, tmp25, 484, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, -17, ctx);
    ADD_SI(tmp26, tmp26, 26, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    SUB(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 2820, ctx);
    SUB(tmp21, tmp22, tmp23, ctx);
    ADD_SI(tmp21, tmp21, 3992, ctx);
    SQRT_UI(tmp22, 2, ctx);
    NEG(tmp22, tmp22, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    ADD(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp31, 2, ctx);
    MUL_SI(tmp31, tmp31, 2, ctx);
    SUB_SI(tmp31, tmp31, 3, ctx);
    MUL_SI(tmp31, tmp31, 3, ctx);
    SQRT_UI(tmp32, 2, ctx);
    MUL_SI(tmp32, tmp32, -17, ctx);
    ADD_SI(tmp32, tmp32, 26, ctx);
    SQRT(tmp32, tmp32, ctx);
    MUL(tmp30, tmp31, tmp32, ctx);
    SQRT_UI(tmp31, 2, ctx);
    MUL_SI(tmp31, tmp31, 61, ctx);
    SUB(tmp29, tmp30, tmp31, ctx);
    ADD_SI(tmp29, tmp29, 85, ctx);
    SQRT_UI(tmp30, 2, ctx);
    NEG(tmp30, tmp30, ctx);
    ADD_SI(tmp30, tmp30, 2, ctx);
    SQRT(tmp30, tmp30, ctx);
    MUL(tmp28, tmp29, tmp30, ctx);
    SQRT_UI(tmp30, 2, ctx);
    MUL_SI(tmp30, tmp30, 5, ctx);
    SUB_SI(tmp30, tmp30, 7, ctx);
    MUL_SI(tmp30, tmp30, 11, ctx);
    SQRT_UI(tmp31, 2, ctx);
    MUL_SI(tmp31, tmp31, -17, ctx);
    ADD_SI(tmp31, tmp31, 26, ctx);
    SQRT(tmp31, tmp31, ctx);
    MUL(tmp29, tmp30, tmp31, ctx);
    SUB(tmp27, tmp28, tmp29, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, 445, ctx);
    ADD(tmp26, tmp27, tmp28, ctx);
    SUB_SI(tmp26, tmp26, 630, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, 3, ctx);
    SQRT_UI(tmp29, 2, ctx);
    MUL_SI(tmp29, tmp29, -17, ctx);
    ADD_SI(tmp29, tmp29, 26, ctx);
    SQRT(tmp29, tmp29, ctx);
    ADD(tmp27, tmp28, tmp29, ctx);
    SUB_SI(tmp27, tmp27, 3, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL(tmp25, tmp26, tmp27, ctx);
    SQRT_UI(tmp26, 2, ctx);
    ADD_SI(tmp26, tmp26, 2, ctx);
    SQRT(tmp26, tmp26, ctx);
    SUB_SI(tmp26, tmp26, 1, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, 89, ctx);
    SUB_SI(tmp26, tmp26, 126, ctx);
    MUL_SI(tmp26, tmp26, 10, ctx);
    SQRT_UI(tmp27, 2, ctx);
    ADD_SI(tmp27, tmp27, 2, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL(tmp25, tmp26, tmp27, ctx);
    SUB(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, 61, ctx);
    SUB_SI(tmp28, tmp28, 85, ctx);
    SQRT_UI(tmp29, 2, ctx);
    ADD_SI(tmp29, tmp29, 2, ctx);
    SQRT(tmp29, tmp29, ctx);
    MUL(tmp27, tmp28, tmp29, ctx);
    SQRT_UI(tmp31, 2, ctx);
    MUL_SI(tmp31, tmp31, 2, ctx);
    SUB_SI(tmp31, tmp31, 3, ctx);
    SQRT_UI(tmp32, 2, ctx);
    ADD_SI(tmp32, tmp32, 2, ctx);
    SQRT(tmp32, tmp32, ctx);
    MUL(tmp30, tmp31, tmp32, ctx);
    SQRT_UI(tmp31, 2, ctx);
    MUL_SI(tmp31, tmp31, 2, ctx);
    SUB(tmp29, tmp30, tmp31, ctx);
    ADD_SI(tmp29, tmp29, 3, ctx);
    MUL_SI(tmp29, tmp29, 3, ctx);
    SQRT_UI(tmp30, 2, ctx);
    MUL_SI(tmp30, tmp30, -17, ctx);
    ADD_SI(tmp30, tmp30, 26, ctx);
    SQRT(tmp30, tmp30, ctx);
    MUL(tmp28, tmp29, tmp30, ctx);
    SUB(tmp26, tmp27, tmp28, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, 61, ctx);
    SUB(tmp25, tmp26, tmp27, ctx);
    ADD_SI(tmp25, tmp25, 85, ctx);
    MUL_SI(tmp25, tmp25, 2, ctx);
    SQRT_UI(tmp26, 2, ctx);
    NEG(tmp26, tmp26, ctx);
    ADD_SI(tmp26, tmp26, 2, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    ADD(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, 5, ctx);
    SUB_SI(tmp26, tmp26, 7, ctx);
    SQRT_UI(tmp27, 2, ctx);
    ADD_SI(tmp27, tmp27, 2, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL(tmp25, tmp26, tmp27, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, 5, ctx);
    SUB(tmp24, tmp25, tmp26, ctx);
    ADD_SI(tmp24, tmp24, 7, ctx);
    MUL_SI(tmp24, tmp24, 22, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, -17, ctx);
    ADD_SI(tmp25, tmp25, 26, ctx);
    SQRT(tmp25, tmp25, ctx);
    MUL(tmp23, tmp24, tmp25, ctx);
    ADD(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, 890, ctx);
    ADD(tmp20, tmp21, tmp22, ctx);
    SUB_SI(tmp20, tmp20, 1260, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, -12, ctx);
    SQRT_UI(tmp24, 2, ctx);
    NEG(tmp24, tmp24, ctx);
    ADD_SI(tmp24, tmp24, 2, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL_SI(tmp24, tmp24, 2, ctx);
    SUB(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, -17, ctx);
    ADD_SI(tmp23, tmp23, 26, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL_SI(tmp23, tmp23, 2, ctx);
    SUB(tmp21, tmp22, tmp23, ctx);
    ADD_SI(tmp21, tmp21, 24, ctx);
    SQRT(tmp21, tmp21, ctx);
    MUL(tmp19, tmp20, tmp21, ctx);
    ADD(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, 319, ctx);
    SUB_SI(tmp21, tmp21, 452, ctx);
    SQRT_UI(tmp22, 2, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, 561, ctx);
    SUB(tmp19, tmp20, tmp21, ctx);
    ADD_SI(tmp19, tmp19, 794, ctx);
    MUL_SI(tmp19, tmp19, 4, ctx);
    SQRT_UI(tmp20, 2, ctx);
    MUL_SI(tmp20, tmp20, -17, ctx);
    ADD_SI(tmp20, tmp20, 26, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL(tmp18, tmp19, tmp20, ctx);
    ADD(tmp16, tmp17, tmp18, ctx);
    SQRT_UI(tmp17, 2, ctx);
    MUL_SI(tmp17, tmp17, 17064, ctx);
    ADD(tmp15, tmp16, tmp17, ctx);
    SUB_SI(tmp15, tmp15, 24132, ctx);
    SQRT_UI(tmp18, 2, ctx);
    ADD_SI(tmp18, tmp18, 2, ctx);
    SQRT(tmp18, tmp18, ctx);
    ADD_SI(tmp18, tmp18, 1, ctx);
    SQRT_UI(tmp19, 2, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    SUB_SI(tmp19, tmp19, 1, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp18, 2, ctx);
    ADD_SI(tmp18, tmp18, 2, ctx);
    SQRT(tmp18, tmp18, ctx);
    ADD(tmp16, tmp17, tmp18, ctx);
    ADD_SI(tmp16, tmp16, 1, ctx);
    MUL(tmp14, tmp15, tmp16, ctx);
    SQRT_UI(tmp18, 2, ctx);
    ADD_SI(tmp18, tmp18, 2, ctx);
    SQRT(tmp18, tmp18, ctx);
    ADD_SI(tmp18, tmp18, 1, ctx);
    SQRT_UI(tmp19, 2, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    SUB_SI(tmp19, tmp19, 1, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp18, 2, ctx);
    ADD_SI(tmp18, tmp18, 2, ctx);
    SQRT(tmp18, tmp18, ctx);
    SUB(tmp16, tmp17, tmp18, ctx);
    SQRT_UI(tmp24, 2, ctx);
    SQRT_UI(tmp25, 2, ctx);
    ADD_SI(tmp25, tmp25, 2, ctx);
    SQRT(tmp25, tmp25, ctx);
    ADD(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp24, 2, ctx);
    ADD_SI(tmp24, tmp24, 2, ctx);
    SQRT(tmp24, tmp24, ctx);
    SUB_SI(tmp24, tmp24, 1, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 3, ctx);
    ADD(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp22, 2, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL_SI(tmp22, tmp22, 5, ctx);
    SUB(tmp20, tmp21, tmp22, ctx);
    ADD_SI(tmp20, tmp20, 8, ctx);
    SQRT_UI(tmp25, 2, ctx);
    SQRT_UI(tmp26, 2, ctx);
    ADD_SI(tmp26, tmp26, 2, ctx);
    SQRT(tmp26, tmp26, ctx);
    ADD(tmp24, tmp25, tmp26, ctx);
    SQRT_UI(tmp25, 2, ctx);
    ADD_SI(tmp25, tmp25, 2, ctx);
    SQRT(tmp25, tmp25, ctx);
    SUB_SI(tmp25, tmp25, 1, ctx);
    SQRT(tmp25, tmp25, ctx);
    MUL(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, 3, ctx);
    SUB(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL_SI(tmp23, tmp23, 5, ctx);
    ADD(tmp21, tmp22, tmp23, ctx);
    SUB_SI(tmp21, tmp21, 8, ctx);
    MUL(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp20, 2, ctx);
    ADD_SI(tmp20, tmp20, 2, ctx);
    SQRT(tmp20, tmp20, ctx);
    ADD_SI(tmp20, tmp20, 2, ctx);
    MUL(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp22, 2, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    ADD_SI(tmp22, tmp22, 1, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    SUB_SI(tmp23, tmp23, 1, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp22, 2, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    ADD(tmp20, tmp21, tmp22, ctx);
    ADD_SI(tmp20, tmp20, 1, ctx);
    SQRT_UI(tmp21, 2, ctx);
    ADD_SI(tmp21, tmp21, 2, ctx);
    SQRT(tmp21, tmp21, ctx);
    SUB_SI(tmp21, tmp21, 2, ctx);
    POW_UI(tmp21, tmp21, 3, ctx);
    MUL(tmp19, tmp20, tmp21, ctx);
    DIV(tmp17, tmp18, tmp19, ctx);
    SUB(tmp15, tmp16, tmp17, ctx);
    SUB_SI(tmp15, tmp15, 1, ctx);
    MUL(tmp13, tmp14, tmp15, ctx);
    SET_SI(tmp17, 1, ctx);
    DIV_SI(tmp17, tmp17, 4, ctx);
    NEG(tmp17, tmp17, ctx);
    SQRT_UI(tmp18, 2, ctx);
    ADD_SI(tmp18, tmp18, 2, ctx);
    SQRT(tmp18, tmp18, ctx);
    MUL(tmp16, tmp17, tmp18, ctx);
    SET_SI(tmp17, 1, ctx);
    DIV_SI(tmp17, tmp17, 2, ctx);
    ADD(tmp15, tmp16, tmp17, ctx);
    SET_SI(tmp16, 3, ctx);
    DIV_SI(tmp16, tmp16, 2, ctx);
    POW(tmp14, tmp15, tmp16, ctx);
    MUL(tmp12, tmp13, tmp14, ctx);
    DIV(tmp10, tmp11, tmp12, ctx);
    ADD(tmp8, tmp9, tmp10, ctx);
    MUL(tmp6, tmp7, tmp8, ctx);
    SQRT_UI(tmp7, 2, ctx);
    ADD_SI(tmp7, tmp7, 2, ctx);
    SQRT(tmp7, tmp7, ctx);
    SUB_SI(tmp7, tmp7, 2, ctx);
    DIV(tmp5, tmp6, tmp7, ctx);
    ADD(tmp3, tmp4, tmp5, ctx);
    MUL(tmp1, tmp2, tmp3, ctx);
    SQRT_UI(tmp14, 2, ctx);
    MUL_SI(tmp14, tmp14, 3, ctx);
    SUB_SI(tmp14, tmp14, 4, ctx);
    MUL_SI(tmp14, tmp14, 3, ctx);
    SQRT_UI(tmp15, 2, ctx);
    MUL_SI(tmp15, tmp15, -17, ctx);
    ADD_SI(tmp15, tmp15, 26, ctx);
    SQRT(tmp15, tmp15, ctx);
    MUL(tmp13, tmp14, tmp15, ctx);
    SQRT_UI(tmp14, 2, ctx);
    MUL_SI(tmp14, tmp14, 85, ctx);
    SUB(tmp12, tmp13, tmp14, ctx);
    ADD_SI(tmp12, tmp12, 122, ctx);
    SQRT_UI(tmp13, 2, ctx);
    NEG(tmp13, tmp13, ctx);
    ADD_SI(tmp13, tmp13, 2, ctx);
    SQRT(tmp13, tmp13, ctx);
    MUL(tmp11, tmp12, tmp13, ctx);
    SQRT_UI(tmp13, 2, ctx);
    MUL_SI(tmp13, tmp13, 7, ctx);
    SUB_SI(tmp13, tmp13, 10, ctx);
    MUL_SI(tmp13, tmp13, 11, ctx);
    SQRT_UI(tmp14, 2, ctx);
    MUL_SI(tmp14, tmp14, -17, ctx);
    ADD_SI(tmp14, tmp14, 26, ctx);
    SQRT(tmp14, tmp14, ctx);
    MUL(tmp12, tmp13, tmp14, ctx);
    SUB(tmp10, tmp11, tmp12, ctx);
    SQRT_UI(tmp11, 2, ctx);
    MUL_SI(tmp11, tmp11, 630, ctx);
    ADD(tmp9, tmp10, tmp11, ctx);
    SUB_SI(tmp9, tmp9, 890, ctx);
    MUL_SI(tmp9, tmp9, 2, ctx);
    SQRT_UI(tmp11, 2, ctx);
    MUL_SI(tmp11, tmp11, 3, ctx);
    SQRT_UI(tmp12, 2, ctx);
    MUL_SI(tmp12, tmp12, -17, ctx);
    ADD_SI(tmp12, tmp12, 26, ctx);
    SQRT(tmp12, tmp12, ctx);
    ADD(tmp10, tmp11, tmp12, ctx);
    SUB_SI(tmp10, tmp10, 3, ctx);
    SQRT(tmp10, tmp10, ctx);
    MUL(tmp8, tmp9, tmp10, ctx);
    SQRT_UI(tmp9, 2, ctx);
    ADD_SI(tmp9, tmp9, 2, ctx);
    SQRT(tmp9, tmp9, ctx);
    SUB_SI(tmp9, tmp9, 1, ctx);
    SQRT(tmp9, tmp9, ctx);
    MUL(tmp7, tmp8, tmp9, ctx);
    SQRT_UI(tmp9, 2, ctx);
    MUL_SI(tmp9, tmp9, 4896, ctx);
    SUB_SI(tmp9, tmp9, 6923, ctx);
    MUL_SI(tmp9, tmp9, 2, ctx);
    SQRT_UI(tmp10, 2, ctx);
    ADD_SI(tmp10, tmp10, 2, ctx);
    SQRT(tmp10, tmp10, ctx);
    MUL(tmp8, tmp9, tmp10, ctx);
    SUB(tmp6, tmp7, tmp8, ctx);
    SQRT_UI(tmp11, 2, ctx);
    MUL_SI(tmp11, tmp11, 79, ctx);
    SUB_SI(tmp11, tmp11, 112, ctx);
    MUL_SI(tmp11, tmp11, 20, ctx);
    SQRT_UI(tmp12, 2, ctx);
    ADD_SI(tmp12, tmp12, 2, ctx);
    SQRT(tmp12, tmp12, ctx);
    MUL(tmp10, tmp11, tmp12, ctx);
    SQRT_UI(tmp14, 2, ctx);
    MUL_SI(tmp14, tmp14, 27, ctx);
    SUB_SI(tmp14, tmp14, 38, ctx);
    MUL_SI(tmp14, tmp14, 7, ctx);
    SQRT_UI(tmp15, 2, ctx);
    ADD_SI(tmp15, tmp15, 2, ctx);
    SQRT(tmp15, tmp15, ctx);
    MUL(tmp13, tmp14, tmp15, ctx);
    SQRT_UI(tmp14, 2, ctx);
    MUL_SI(tmp14, tmp14, 342, ctx);
    SUB(tmp12, tmp13, tmp14, ctx);
    ADD_SI(tmp12, tmp12, 484, ctx);
    SQRT_UI(tmp13, 2, ctx);
    MUL_SI(tmp13, tmp13, -17, ctx);
    ADD_SI(tmp13, tmp13, 26, ctx);
    SQRT(tmp13, tmp13, ctx);
    MUL(tmp11, tmp12, tmp13, ctx);
    SUB(tmp9, tmp10, tmp11, ctx);
    SQRT_UI(tmp10, 2, ctx);
    MUL_SI(tmp10, tmp10, 2820, ctx);
    SUB(tmp8, tmp9, tmp10, ctx);
    ADD_SI(tmp8, tmp8, 3992, ctx);
    SQRT_UI(tmp9, 2, ctx);
    NEG(tmp9, tmp9, ctx);
    ADD_SI(tmp9, tmp9, 2, ctx);
    SQRT(tmp9, tmp9, ctx);
    MUL(tmp7, tmp8, tmp9, ctx);
    ADD(tmp5, tmp6, tmp7, ctx);
    SQRT_UI(tmp18, 2, ctx);
    MUL_SI(tmp18, tmp18, 2, ctx);
    SUB_SI(tmp18, tmp18, 3, ctx);
    MUL_SI(tmp18, tmp18, 3, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, -17, ctx);
    ADD_SI(tmp19, tmp19, 26, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp18, 2, ctx);
    MUL_SI(tmp18, tmp18, 61, ctx);
    SUB(tmp16, tmp17, tmp18, ctx);
    ADD_SI(tmp16, tmp16, 85, ctx);
    SQRT_UI(tmp17, 2, ctx);
    NEG(tmp17, tmp17, ctx);
    ADD_SI(tmp17, tmp17, 2, ctx);
    SQRT(tmp17, tmp17, ctx);
    MUL(tmp15, tmp16, tmp17, ctx);
    SQRT_UI(tmp17, 2, ctx);
    MUL_SI(tmp17, tmp17, 5, ctx);
    SUB_SI(tmp17, tmp17, 7, ctx);
    MUL_SI(tmp17, tmp17, 11, ctx);
    SQRT_UI(tmp18, 2, ctx);
    MUL_SI(tmp18, tmp18, -17, ctx);
    ADD_SI(tmp18, tmp18, 26, ctx);
    SQRT(tmp18, tmp18, ctx);
    MUL(tmp16, tmp17, tmp18, ctx);
    SUB(tmp14, tmp15, tmp16, ctx);
    SQRT_UI(tmp15, 2, ctx);
    MUL_SI(tmp15, tmp15, 445, ctx);
    ADD(tmp13, tmp14, tmp15, ctx);
    SUB_SI(tmp13, tmp13, 630, ctx);
    SQRT_UI(tmp15, 2, ctx);
    MUL_SI(tmp15, tmp15, 3, ctx);
    SQRT_UI(tmp16, 2, ctx);
    MUL_SI(tmp16, tmp16, -17, ctx);
    ADD_SI(tmp16, tmp16, 26, ctx);
    SQRT(tmp16, tmp16, ctx);
    ADD(tmp14, tmp15, tmp16, ctx);
    SUB_SI(tmp14, tmp14, 3, ctx);
    SQRT(tmp14, tmp14, ctx);
    MUL(tmp12, tmp13, tmp14, ctx);
    SQRT_UI(tmp13, 2, ctx);
    ADD_SI(tmp13, tmp13, 2, ctx);
    SQRT(tmp13, tmp13, ctx);
    SUB_SI(tmp13, tmp13, 1, ctx);
    SQRT(tmp13, tmp13, ctx);
    MUL(tmp11, tmp12, tmp13, ctx);
    SQRT_UI(tmp13, 2, ctx);
    MUL_SI(tmp13, tmp13, 89, ctx);
    SUB_SI(tmp13, tmp13, 126, ctx);
    MUL_SI(tmp13, tmp13, 10, ctx);
    SQRT_UI(tmp14, 2, ctx);
    ADD_SI(tmp14, tmp14, 2, ctx);
    SQRT(tmp14, tmp14, ctx);
    MUL(tmp12, tmp13, tmp14, ctx);
    SUB(tmp10, tmp11, tmp12, ctx);
    SQRT_UI(tmp15, 2, ctx);
    MUL_SI(tmp15, tmp15, 61, ctx);
    SUB_SI(tmp15, tmp15, 85, ctx);
    SQRT_UI(tmp16, 2, ctx);
    ADD_SI(tmp16, tmp16, 2, ctx);
    SQRT(tmp16, tmp16, ctx);
    MUL(tmp14, tmp15, tmp16, ctx);
    SQRT_UI(tmp18, 2, ctx);
    MUL_SI(tmp18, tmp18, 2, ctx);
    SUB_SI(tmp18, tmp18, 3, ctx);
    SQRT_UI(tmp19, 2, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp18, 2, ctx);
    MUL_SI(tmp18, tmp18, 2, ctx);
    SUB(tmp16, tmp17, tmp18, ctx);
    ADD_SI(tmp16, tmp16, 3, ctx);
    MUL_SI(tmp16, tmp16, 3, ctx);
    SQRT_UI(tmp17, 2, ctx);
    MUL_SI(tmp17, tmp17, -17, ctx);
    ADD_SI(tmp17, tmp17, 26, ctx);
    SQRT(tmp17, tmp17, ctx);
    MUL(tmp15, tmp16, tmp17, ctx);
    SUB(tmp13, tmp14, tmp15, ctx);
    SQRT_UI(tmp14, 2, ctx);
    MUL_SI(tmp14, tmp14, 61, ctx);
    SUB(tmp12, tmp13, tmp14, ctx);
    ADD_SI(tmp12, tmp12, 85, ctx);
    MUL_SI(tmp12, tmp12, 2, ctx);
    SQRT_UI(tmp13, 2, ctx);
    NEG(tmp13, tmp13, ctx);
    ADD_SI(tmp13, tmp13, 2, ctx);
    SQRT(tmp13, tmp13, ctx);
    MUL(tmp11, tmp12, tmp13, ctx);
    ADD(tmp9, tmp10, tmp11, ctx);
    SQRT_UI(tmp13, 2, ctx);
    MUL_SI(tmp13, tmp13, 5, ctx);
    SUB_SI(tmp13, tmp13, 7, ctx);
    SQRT_UI(tmp14, 2, ctx);
    ADD_SI(tmp14, tmp14, 2, ctx);
    SQRT(tmp14, tmp14, ctx);
    MUL(tmp12, tmp13, tmp14, ctx);
    SQRT_UI(tmp13, 2, ctx);
    MUL_SI(tmp13, tmp13, 5, ctx);
    SUB(tmp11, tmp12, tmp13, ctx);
    ADD_SI(tmp11, tmp11, 7, ctx);
    MUL_SI(tmp11, tmp11, 22, ctx);
    SQRT_UI(tmp12, 2, ctx);
    MUL_SI(tmp12, tmp12, -17, ctx);
    ADD_SI(tmp12, tmp12, 26, ctx);
    SQRT(tmp12, tmp12, ctx);
    MUL(tmp10, tmp11, tmp12, ctx);
    ADD(tmp8, tmp9, tmp10, ctx);
    SQRT_UI(tmp9, 2, ctx);
    MUL_SI(tmp9, tmp9, 890, ctx);
    ADD(tmp7, tmp8, tmp9, ctx);
    SUB_SI(tmp7, tmp7, 1260, ctx);
    SQRT_UI(tmp10, 2, ctx);
    MUL_SI(tmp10, tmp10, -12, ctx);
    SQRT_UI(tmp11, 2, ctx);
    NEG(tmp11, tmp11, ctx);
    ADD_SI(tmp11, tmp11, 2, ctx);
    SQRT(tmp11, tmp11, ctx);
    MUL_SI(tmp11, tmp11, 2, ctx);
    SUB(tmp9, tmp10, tmp11, ctx);
    SQRT_UI(tmp10, 2, ctx);
    MUL_SI(tmp10, tmp10, -17, ctx);
    ADD_SI(tmp10, tmp10, 26, ctx);
    SQRT(tmp10, tmp10, ctx);
    MUL_SI(tmp10, tmp10, 2, ctx);
    SUB(tmp8, tmp9, tmp10, ctx);
    ADD_SI(tmp8, tmp8, 24, ctx);
    SQRT(tmp8, tmp8, ctx);
    MUL(tmp6, tmp7, tmp8, ctx);
    ADD(tmp4, tmp5, tmp6, ctx);
    SQRT_UI(tmp8, 2, ctx);
    MUL_SI(tmp8, tmp8, 319, ctx);
    SUB_SI(tmp8, tmp8, 452, ctx);
    SQRT_UI(tmp9, 2, ctx);
    ADD_SI(tmp9, tmp9, 2, ctx);
    SQRT(tmp9, tmp9, ctx);
    MUL(tmp7, tmp8, tmp9, ctx);
    SQRT_UI(tmp8, 2, ctx);
    MUL_SI(tmp8, tmp8, 561, ctx);
    SUB(tmp6, tmp7, tmp8, ctx);
    ADD_SI(tmp6, tmp6, 794, ctx);
    MUL_SI(tmp6, tmp6, 4, ctx);
    SQRT_UI(tmp7, 2, ctx);
    MUL_SI(tmp7, tmp7, -17, ctx);
    ADD_SI(tmp7, tmp7, 26, ctx);
    SQRT(tmp7, tmp7, ctx);
    MUL(tmp5, tmp6, tmp7, ctx);
    ADD(tmp3, tmp4, tmp5, ctx);
    SQRT_UI(tmp4, 2, ctx);
    MUL_SI(tmp4, tmp4, 17064, ctx);
    ADD(tmp2, tmp3, tmp4, ctx);
    SUB_SI(tmp2, tmp2, 24132, ctx);
    DIV(tmp0, tmp1, tmp2, ctx);
    SET_SI(tmp4, 1, ctx);
    DIV_SI(tmp4, tmp4, 16, ctx);
    SQRT_UI(tmp12, 2, ctx);
    MUL_SI(tmp12, tmp12, 89, ctx);
    SUB_SI(tmp12, tmp12, 126, ctx);
    MUL_SI(tmp12, tmp12, 5, ctx);
    SQRT_UI(tmp13, 2, ctx);
    ADD_SI(tmp13, tmp13, 2, ctx);
    SQRT(tmp13, tmp13, ctx);
    MUL(tmp11, tmp12, tmp13, ctx);
    SQRT_UI(tmp16, 2, ctx);
    MUL_SI(tmp16, tmp16, 61, ctx);
    SUB_SI(tmp16, tmp16, 85, ctx);
    SQRT_UI(tmp17, 2, ctx);
    ADD_SI(tmp17, tmp17, 2, ctx);
    SQRT(tmp17, tmp17, ctx);
    MUL(tmp15, tmp16, tmp17, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, 2, ctx);
    SUB_SI(tmp19, tmp19, 3, ctx);
    SQRT_UI(tmp20, 2, ctx);
    ADD_SI(tmp20, tmp20, 2, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, 4, ctx);
    SUB(tmp17, tmp18, tmp19, ctx);
    ADD_SI(tmp17, tmp17, 6, ctx);
    MUL_SI(tmp17, tmp17, 3, ctx);
    SQRT_UI(tmp18, 2, ctx);
    MUL_SI(tmp18, tmp18, -17, ctx);
    ADD_SI(tmp18, tmp18, 26, ctx);
    SQRT(tmp18, tmp18, ctx);
    MUL(tmp16, tmp17, tmp18, ctx);
    SUB(tmp14, tmp15, tmp16, ctx);
    SQRT_UI(tmp15, 2, ctx);
    MUL_SI(tmp15, tmp15, 122, ctx);
    SUB(tmp13, tmp14, tmp15, ctx);
    ADD_SI(tmp13, tmp13, 170, ctx);
    SQRT_UI(tmp14, 2, ctx);
    NEG(tmp14, tmp14, ctx);
    ADD_SI(tmp14, tmp14, 2, ctx);
    SQRT(tmp14, tmp14, ctx);
    MUL(tmp12, tmp13, tmp14, ctx);
    SUB(tmp10, tmp11, tmp12, ctx);
    SQRT_UI(tmp14, 2, ctx);
    MUL_SI(tmp14, tmp14, 5, ctx);
    SUB_SI(tmp14, tmp14, 7, ctx);
    SQRT_UI(tmp15, 2, ctx);
    ADD_SI(tmp15, tmp15, 2, ctx);
    SQRT(tmp15, tmp15, ctx);
    MUL(tmp13, tmp14, tmp15, ctx);
    SQRT_UI(tmp14, 2, ctx);
    MUL_SI(tmp14, tmp14, 10, ctx);
    SUB(tmp12, tmp13, tmp14, ctx);
    ADD_SI(tmp12, tmp12, 14, ctx);
    MUL_SI(tmp12, tmp12, 11, ctx);
    SQRT_UI(tmp13, 2, ctx);
    MUL_SI(tmp13, tmp13, -17, ctx);
    ADD_SI(tmp13, tmp13, 26, ctx);
    SQRT(tmp13, tmp13, ctx);
    MUL(tmp11, tmp12, tmp13, ctx);
    SUB(tmp9, tmp10, tmp11, ctx);
    SQRT_UI(tmp10, 2, ctx);
    MUL_SI(tmp10, tmp10, 890, ctx);
    SUB(tmp8, tmp9, tmp10, ctx);
    ADD_SI(tmp8, tmp8, 1260, ctx);
    SQRT_UI(tmp10, 2, ctx);
    MUL_SI(tmp10, tmp10, 3, ctx);
    SQRT_UI(tmp11, 2, ctx);
    NEG(tmp11, tmp11, ctx);
    ADD_SI(tmp11, tmp11, 2, ctx);
    SQRT(tmp11, tmp11, ctx);
    ADD(tmp9, tmp10, tmp11, ctx);
    SUB_SI(tmp9, tmp9, 5, ctx);
    SQRT(tmp9, tmp9, ctx);
    MUL(tmp7, tmp8, tmp9, ctx);
    SQRT_UI(tmp10, 2, ctx);
    MUL_SI(tmp10, tmp10, -12, ctx);
    SQRT_UI(tmp11, 2, ctx);
    NEG(tmp11, tmp11, ctx);
    ADD_SI(tmp11, tmp11, 2, ctx);
    SQRT(tmp11, tmp11, ctx);
    MUL_SI(tmp11, tmp11, 2, ctx);
    SUB(tmp9, tmp10, tmp11, ctx);
    SQRT_UI(tmp10, 2, ctx);
    MUL_SI(tmp10, tmp10, -17, ctx);
    ADD_SI(tmp10, tmp10, 26, ctx);
    SQRT(tmp10, tmp10, ctx);
    MUL_SI(tmp10, tmp10, 2, ctx);
    SUB(tmp8, tmp9, tmp10, ctx);
    ADD_SI(tmp8, tmp8, 24, ctx);
    SQRT(tmp8, tmp8, ctx);
    MUL(tmp6, tmp7, tmp8, ctx);
    SQRT_UI(tmp12, 2, ctx);
    MUL_SI(tmp12, tmp12, 63, ctx);
    SUB_SI(tmp12, tmp12, 89, ctx);
    MUL_SI(tmp12, tmp12, 10, ctx);
    SQRT_UI(tmp13, 2, ctx);
    ADD_SI(tmp13, tmp13, 2, ctx);
    SQRT(tmp13, tmp13, ctx);
    MUL(tmp11, tmp12, tmp13, ctx);
    SQRT_UI(tmp16, 2, ctx);
    MUL_SI(tmp16, tmp16, 85, ctx);
    SUB_SI(tmp16, tmp16, 122, ctx);
    SQRT_UI(tmp17, 2, ctx);
    ADD_SI(tmp17, tmp17, 2, ctx);
    SQRT(tmp17, tmp17, ctx);
    MUL(tmp15, tmp16, tmp17, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, 3, ctx);
    SUB_SI(tmp19, tmp19, 4, ctx);
    SQRT_UI(tmp20, 2, ctx);
    ADD_SI(tmp20, tmp20, 2, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, 6, ctx);
    SUB(tmp17, tmp18, tmp19, ctx);
    ADD_SI(tmp17, tmp17, 8, ctx);
    MUL_SI(tmp17, tmp17, 3, ctx);
    SQRT_UI(tmp18, 2, ctx);
    MUL_SI(tmp18, tmp18, -17, ctx);
    ADD_SI(tmp18, tmp18, 26, ctx);
    SQRT(tmp18, tmp18, ctx);
    MUL(tmp16, tmp17, tmp18, ctx);
    SUB(tmp14, tmp15, tmp16, ctx);
    SQRT_UI(tmp15, 2, ctx);
    MUL_SI(tmp15, tmp15, 170, ctx);
    SUB(tmp13, tmp14, tmp15, ctx);
    ADD_SI(tmp13, tmp13, 244, ctx);
    SQRT_UI(tmp14, 2, ctx);
    NEG(tmp14, tmp14, ctx);
    ADD_SI(tmp14, tmp14, 2, ctx);
    SQRT(tmp14, tmp14, ctx);
    MUL(tmp12, tmp13, tmp14, ctx);
    SUB(tmp10, tmp11, tmp12, ctx);
    SQRT_UI(tmp14, 2, ctx);
    MUL_SI(tmp14, tmp14, 7, ctx);
    SUB_SI(tmp14, tmp14, 10, ctx);
    SQRT_UI(tmp15, 2, ctx);
    ADD_SI(tmp15, tmp15, 2, ctx);
    SQRT(tmp15, tmp15, ctx);
    MUL(tmp13, tmp14, tmp15, ctx);
    SQRT_UI(tmp14, 2, ctx);
    MUL_SI(tmp14, tmp14, 14, ctx);
    SUB(tmp12, tmp13, tmp14, ctx);
    ADD_SI(tmp12, tmp12, 20, ctx);
    MUL_SI(tmp12, tmp12, 11, ctx);
    SQRT_UI(tmp13, 2, ctx);
    MUL_SI(tmp13, tmp13, -17, ctx);
    ADD_SI(tmp13, tmp13, 26, ctx);
    SQRT(tmp13, tmp13, ctx);
    MUL(tmp11, tmp12, tmp13, ctx);
    SUB(tmp9, tmp10, tmp11, ctx);
    SQRT_UI(tmp10, 2, ctx);
    MUL_SI(tmp10, tmp10, 1260, ctx);
    SUB(tmp8, tmp9, tmp10, ctx);
    ADD_SI(tmp8, tmp8, 1780, ctx);
    MUL_SI(tmp8, tmp8, 2, ctx);
    SQRT_UI(tmp10, 2, ctx);
    MUL_SI(tmp10, tmp10, 3, ctx);
    SQRT_UI(tmp11, 2, ctx);
    NEG(tmp11, tmp11, ctx);
    ADD_SI(tmp11, tmp11, 2, ctx);
    SQRT(tmp11, tmp11, ctx);
    ADD(tmp9, tmp10, tmp11, ctx);
    SUB_SI(tmp9, tmp9, 5, ctx);
    SQRT(tmp9, tmp9, ctx);
    MUL(tmp7, tmp8, tmp9, ctx);
    ADD(tmp5, tmp6, tmp7, ctx);
    MUL(tmp3, tmp4, tmp5, ctx);
    SQRT_UI(tmp12, 2, ctx);
    SQRT_UI(tmp13, 2, ctx);
    ADD_SI(tmp13, tmp13, 2, ctx);
    SQRT(tmp13, tmp13, ctx);
    MUL(tmp11, tmp12, tmp13, ctx);
    SQRT_UI(tmp12, 2, ctx);
    SUB(tmp10, tmp11, tmp12, ctx);
    SUB_SI(tmp10, tmp10, 1, ctx);
    SQRT_UI(tmp11, 2, ctx);
    ADD_SI(tmp11, tmp11, 2, ctx);
    SQRT(tmp11, tmp11, ctx);
    SUB_SI(tmp11, tmp11, 1, ctx);
    SQRT(tmp11, tmp11, ctx);
    MUL(tmp9, tmp10, tmp11, ctx);
    SQRT_UI(tmp10, 2, ctx);
    ADD_SI(tmp10, tmp10, 2, ctx);
    SQRT(tmp10, tmp10, ctx);
    SUB(tmp8, tmp9, tmp10, ctx);
    ADD_SI(tmp8, tmp8, 1, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, 7, ctx);
    SUB_SI(tmp19, tmp19, 10, ctx);
    MUL_SI(tmp19, tmp19, 44, ctx);
    SQRT_UI(tmp20, 2, ctx);
    ADD_SI(tmp20, tmp20, 2, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, -17, ctx);
    ADD_SI(tmp19, tmp19, 26, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, 7, ctx);
    SUB_SI(tmp24, tmp24, 10, ctx);
    MUL_SI(tmp24, tmp24, 11, ctx);
    SQRT_UI(tmp25, 2, ctx);
    ADD_SI(tmp25, tmp25, 2, ctx);
    SQRT(tmp25, tmp25, ctx);
    MUL(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, -17, ctx);
    ADD_SI(tmp24, tmp24, 26, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, 63, ctx);
    SUB_SI(tmp24, tmp24, 89, ctx);
    MUL_SI(tmp24, tmp24, 10, ctx);
    SQRT_UI(tmp25, 2, ctx);
    ADD_SI(tmp25, tmp25, 2, ctx);
    SQRT(tmp25, tmp25, ctx);
    MUL(tmp23, tmp24, tmp25, ctx);
    SUB(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, 3, ctx);
    SUB_SI(tmp26, tmp26, 4, ctx);
    MUL_SI(tmp26, tmp26, 3, ctx);
    SQRT_UI(tmp27, 2, ctx);
    ADD_SI(tmp27, tmp27, 2, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL(tmp25, tmp26, tmp27, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, -17, ctx);
    ADD_SI(tmp26, tmp26, 26, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, 85, ctx);
    SUB_SI(tmp26, tmp26, 122, ctx);
    SQRT_UI(tmp27, 2, ctx);
    ADD_SI(tmp27, tmp27, 2, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL(tmp25, tmp26, tmp27, ctx);
    SUB(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp24, 2, ctx);
    NEG(tmp24, tmp24, ctx);
    ADD_SI(tmp24, tmp24, 2, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    SUB(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, 3, ctx);
    SUB_SI(tmp27, tmp27, 4, ctx);
    MUL_SI(tmp27, tmp27, 3, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, -17, ctx);
    ADD_SI(tmp28, tmp28, 26, ctx);
    SQRT(tmp28, tmp28, ctx);
    MUL(tmp26, tmp27, tmp28, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, 85, ctx);
    SUB(tmp25, tmp26, tmp27, ctx);
    ADD_SI(tmp25, tmp25, 122, ctx);
    SQRT_UI(tmp26, 2, ctx);
    NEG(tmp26, tmp26, ctx);
    ADD_SI(tmp26, tmp26, 2, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, 7, ctx);
    SUB_SI(tmp26, tmp26, 10, ctx);
    MUL_SI(tmp26, tmp26, 11, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, -17, ctx);
    ADD_SI(tmp27, tmp27, 26, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL(tmp25, tmp26, tmp27, ctx);
    SUB(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, 630, ctx);
    ADD(tmp22, tmp23, tmp24, ctx);
    SUB_SI(tmp22, tmp22, 890, ctx);
    MUL_SI(tmp22, tmp22, 2, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    SUB_SI(tmp23, tmp23, 1, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SUB(tmp19, tmp20, tmp21, ctx);
    MUL_SI(tmp19, tmp19, 2, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, 3, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, -17, ctx);
    ADD_SI(tmp22, tmp22, 26, ctx);
    SQRT(tmp22, tmp22, ctx);
    ADD(tmp20, tmp21, tmp22, ctx);
    SUB_SI(tmp20, tmp20, 3, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL(tmp18, tmp19, tmp20, ctx);
    SUB(tmp16, tmp17, tmp18, ctx);
    SQRT_UI(tmp18, 2, ctx);
    MUL_SI(tmp18, tmp18, 63, ctx);
    SUB_SI(tmp18, tmp18, 89, ctx);
    MUL_SI(tmp18, tmp18, 40, ctx);
    SQRT_UI(tmp19, 2, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    SUB(tmp15, tmp16, tmp17, ctx);
    SQRT_UI(tmp20, 2, ctx);
    MUL_SI(tmp20, tmp20, 3, ctx);
    SUB_SI(tmp20, tmp20, 4, ctx);
    MUL_SI(tmp20, tmp20, 3, ctx);
    SQRT_UI(tmp21, 2, ctx);
    ADD_SI(tmp21, tmp21, 2, ctx);
    SQRT(tmp21, tmp21, ctx);
    MUL(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp20, 2, ctx);
    MUL_SI(tmp20, tmp20, -17, ctx);
    ADD_SI(tmp20, tmp20, 26, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp20, 2, ctx);
    MUL_SI(tmp20, tmp20, 85, ctx);
    SUB_SI(tmp20, tmp20, 122, ctx);
    SQRT_UI(tmp21, 2, ctx);
    ADD_SI(tmp21, tmp21, 2, ctx);
    SQRT(tmp21, tmp21, ctx);
    MUL(tmp19, tmp20, tmp21, ctx);
    SUB(tmp17, tmp18, tmp19, ctx);
    MUL_SI(tmp17, tmp17, 4, ctx);
    SQRT_UI(tmp18, 2, ctx);
    NEG(tmp18, tmp18, ctx);
    ADD_SI(tmp18, tmp18, 2, ctx);
    SQRT(tmp18, tmp18, ctx);
    MUL(tmp16, tmp17, tmp18, ctx);
    SUB(tmp14, tmp15, tmp16, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, 5, ctx);
    SUB_SI(tmp22, tmp22, 7, ctx);
    MUL_SI(tmp22, tmp22, 22, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, -17, ctx);
    ADD_SI(tmp22, tmp22, 26, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, 5, ctx);
    SUB_SI(tmp27, tmp27, 7, ctx);
    MUL_SI(tmp27, tmp27, 11, ctx);
    SQRT_UI(tmp28, 2, ctx);
    ADD_SI(tmp28, tmp28, 2, ctx);
    SQRT(tmp28, tmp28, ctx);
    MUL(tmp26, tmp27, tmp28, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, -17, ctx);
    ADD_SI(tmp27, tmp27, 26, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL(tmp25, tmp26, tmp27, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, 89, ctx);
    SUB_SI(tmp27, tmp27, 126, ctx);
    MUL_SI(tmp27, tmp27, 5, ctx);
    SQRT_UI(tmp28, 2, ctx);
    ADD_SI(tmp28, tmp28, 2, ctx);
    SQRT(tmp28, tmp28, ctx);
    MUL(tmp26, tmp27, tmp28, ctx);
    SUB(tmp24, tmp25, tmp26, ctx);
    SQRT_UI(tmp29, 2, ctx);
    MUL_SI(tmp29, tmp29, 2, ctx);
    SUB_SI(tmp29, tmp29, 3, ctx);
    MUL_SI(tmp29, tmp29, 3, ctx);
    SQRT_UI(tmp30, 2, ctx);
    ADD_SI(tmp30, tmp30, 2, ctx);
    SQRT(tmp30, tmp30, ctx);
    MUL(tmp28, tmp29, tmp30, ctx);
    SQRT_UI(tmp29, 2, ctx);
    MUL_SI(tmp29, tmp29, -17, ctx);
    ADD_SI(tmp29, tmp29, 26, ctx);
    SQRT(tmp29, tmp29, ctx);
    MUL(tmp27, tmp28, tmp29, ctx);
    SQRT_UI(tmp29, 2, ctx);
    MUL_SI(tmp29, tmp29, 61, ctx);
    SUB_SI(tmp29, tmp29, 85, ctx);
    SQRT_UI(tmp30, 2, ctx);
    ADD_SI(tmp30, tmp30, 2, ctx);
    SQRT(tmp30, tmp30, ctx);
    MUL(tmp28, tmp29, tmp30, ctx);
    SUB(tmp26, tmp27, tmp28, ctx);
    SQRT_UI(tmp27, 2, ctx);
    NEG(tmp27, tmp27, ctx);
    ADD_SI(tmp27, tmp27, 2, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL(tmp25, tmp26, tmp27, ctx);
    SUB(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp30, 2, ctx);
    MUL_SI(tmp30, tmp30, 2, ctx);
    SUB_SI(tmp30, tmp30, 3, ctx);
    MUL_SI(tmp30, tmp30, 3, ctx);
    SQRT_UI(tmp31, 2, ctx);
    MUL_SI(tmp31, tmp31, -17, ctx);
    ADD_SI(tmp31, tmp31, 26, ctx);
    SQRT(tmp31, tmp31, ctx);
    MUL(tmp29, tmp30, tmp31, ctx);
    SQRT_UI(tmp30, 2, ctx);
    MUL_SI(tmp30, tmp30, 61, ctx);
    SUB(tmp28, tmp29, tmp30, ctx);
    ADD_SI(tmp28, tmp28, 85, ctx);
    SQRT_UI(tmp29, 2, ctx);
    NEG(tmp29, tmp29, ctx);
    ADD_SI(tmp29, tmp29, 2, ctx);
    SQRT(tmp29, tmp29, ctx);
    MUL(tmp27, tmp28, tmp29, ctx);
    SQRT_UI(tmp29, 2, ctx);
    MUL_SI(tmp29, tmp29, 5, ctx);
    SUB_SI(tmp29, tmp29, 7, ctx);
    MUL_SI(tmp29, tmp29, 11, ctx);
    SQRT_UI(tmp30, 2, ctx);
    MUL_SI(tmp30, tmp30, -17, ctx);
    ADD_SI(tmp30, tmp30, 26, ctx);
    SQRT(tmp30, tmp30, ctx);
    MUL(tmp28, tmp29, tmp30, ctx);
    SUB(tmp26, tmp27, tmp28, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, 445, ctx);
    ADD(tmp25, tmp26, tmp27, ctx);
    SUB_SI(tmp25, tmp25, 630, ctx);
    MUL_SI(tmp25, tmp25, 2, ctx);
    SQRT_UI(tmp26, 2, ctx);
    ADD_SI(tmp26, tmp26, 2, ctx);
    SQRT(tmp26, tmp26, ctx);
    SUB_SI(tmp26, tmp26, 1, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    SUB(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, 3, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, -17, ctx);
    ADD_SI(tmp25, tmp25, 26, ctx);
    SQRT(tmp25, tmp25, ctx);
    ADD(tmp23, tmp24, tmp25, ctx);
    SUB_SI(tmp23, tmp23, 3, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SUB(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, 89, ctx);
    SUB_SI(tmp21, tmp21, 126, ctx);
    MUL_SI(tmp21, tmp21, 10, ctx);
    SQRT_UI(tmp22, 2, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SUB(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 2, ctx);
    SUB_SI(tmp23, tmp23, 3, ctx);
    MUL_SI(tmp23, tmp23, 3, ctx);
    SQRT_UI(tmp24, 2, ctx);
    ADD_SI(tmp24, tmp24, 2, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, -17, ctx);
    ADD_SI(tmp23, tmp23, 26, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 61, ctx);
    SUB_SI(tmp23, tmp23, 85, ctx);
    SQRT_UI(tmp24, 2, ctx);
    ADD_SI(tmp24, tmp24, 2, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    SUB(tmp20, tmp21, tmp22, ctx);
    MUL_SI(tmp20, tmp20, 2, ctx);
    SQRT_UI(tmp21, 2, ctx);
    NEG(tmp21, tmp21, ctx);
    ADD_SI(tmp21, tmp21, 2, ctx);
    SQRT(tmp21, tmp21, ctx);
    MUL(tmp19, tmp20, tmp21, ctx);
    SUB(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, 2, ctx);
    SUB_SI(tmp24, tmp24, 3, ctx);
    MUL_SI(tmp24, tmp24, 3, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, -17, ctx);
    ADD_SI(tmp25, tmp25, 26, ctx);
    SQRT(tmp25, tmp25, ctx);
    MUL(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, 61, ctx);
    SUB(tmp22, tmp23, tmp24, ctx);
    ADD_SI(tmp22, tmp22, 85, ctx);
    SQRT_UI(tmp23, 2, ctx);
    NEG(tmp23, tmp23, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 5, ctx);
    SUB_SI(tmp23, tmp23, 7, ctx);
    MUL_SI(tmp23, tmp23, 11, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, -17, ctx);
    ADD_SI(tmp24, tmp24, 26, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    SUB(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, 445, ctx);
    ADD(tmp19, tmp20, tmp21, ctx);
    SUB_SI(tmp19, tmp19, 630, ctx);
    MUL_SI(tmp19, tmp19, 4, ctx);
    SQRT_UI(tmp20, 2, ctx);
    ADD_SI(tmp20, tmp20, 2, ctx);
    SQRT(tmp20, tmp20, ctx);
    SUB_SI(tmp20, tmp20, 1, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL(tmp18, tmp19, tmp20, ctx);
    SUB(tmp16, tmp17, tmp18, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, -12, ctx);
    SQRT_UI(tmp20, 2, ctx);
    NEG(tmp20, tmp20, ctx);
    ADD_SI(tmp20, tmp20, 2, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL_SI(tmp20, tmp20, 2, ctx);
    SUB(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, -17, ctx);
    ADD_SI(tmp19, tmp19, 26, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL_SI(tmp19, tmp19, 2, ctx);
    SUB(tmp17, tmp18, tmp19, ctx);
    ADD_SI(tmp17, tmp17, 24, ctx);
    SQRT(tmp17, tmp17, ctx);
    MUL(tmp15, tmp16, tmp17, ctx);
    ADD(tmp13, tmp14, tmp15, ctx);
    SQRT_UI(tmp20, 2, ctx);
    MUL_SI(tmp20, tmp20, 3, ctx);
    SUB_SI(tmp20, tmp20, 4, ctx);
    MUL_SI(tmp20, tmp20, 3, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, -17, ctx);
    ADD_SI(tmp21, tmp21, 26, ctx);
    SQRT(tmp21, tmp21, ctx);
    MUL(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp20, 2, ctx);
    MUL_SI(tmp20, tmp20, 85, ctx);
    SUB(tmp18, tmp19, tmp20, ctx);
    ADD_SI(tmp18, tmp18, 122, ctx);
    SQRT_UI(tmp19, 2, ctx);
    NEG(tmp19, tmp19, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, 7, ctx);
    SUB_SI(tmp19, tmp19, 10, ctx);
    MUL_SI(tmp19, tmp19, 11, ctx);
    SQRT_UI(tmp20, 2, ctx);
    MUL_SI(tmp20, tmp20, -17, ctx);
    ADD_SI(tmp20, tmp20, 26, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL(tmp18, tmp19, tmp20, ctx);
    SUB(tmp16, tmp17, tmp18, ctx);
    SQRT_UI(tmp17, 2, ctx);
    MUL_SI(tmp17, tmp17, 630, ctx);
    ADD(tmp15, tmp16, tmp17, ctx);
    SUB_SI(tmp15, tmp15, 890, ctx);
    MUL_SI(tmp15, tmp15, 8, ctx);
    SQRT_UI(tmp16, 2, ctx);
    ADD_SI(tmp16, tmp16, 2, ctx);
    SQRT(tmp16, tmp16, ctx);
    SUB_SI(tmp16, tmp16, 1, ctx);
    SQRT(tmp16, tmp16, ctx);
    MUL(tmp14, tmp15, tmp16, ctx);
    SUB(tmp12, tmp13, tmp14, ctx);
    MUL_SI(tmp12, tmp12, 8, ctx);
    SQRT_UI(tmp16, 2, ctx);
    ADD_SI(tmp16, tmp16, 2, ctx);
    SQRT(tmp16, tmp16, ctx);
    ADD_SI(tmp16, tmp16, 1, ctx);
    SQRT_UI(tmp17, 2, ctx);
    ADD_SI(tmp17, tmp17, 2, ctx);
    SQRT(tmp17, tmp17, ctx);
    SUB_SI(tmp17, tmp17, 1, ctx);
    SQRT(tmp17, tmp17, ctx);
    MUL(tmp15, tmp16, tmp17, ctx);
    SQRT_UI(tmp16, 2, ctx);
    ADD_SI(tmp16, tmp16, 2, ctx);
    SQRT(tmp16, tmp16, ctx);
    ADD(tmp14, tmp15, tmp16, ctx);
    ADD_SI(tmp14, tmp14, 1, ctx);
    INV(tmp14, tmp14, ctx);
    SQRT_UI(tmp22, 2, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    ADD(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp22, 2, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    SUB_SI(tmp22, tmp22, 1, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, 3, ctx);
    ADD(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp20, 2, ctx);
    ADD_SI(tmp20, tmp20, 2, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL_SI(tmp20, tmp20, 5, ctx);
    SUB(tmp18, tmp19, tmp20, ctx);
    ADD_SI(tmp18, tmp18, 8, ctx);
    SQRT_UI(tmp23, 2, ctx);
    SQRT_UI(tmp24, 2, ctx);
    ADD_SI(tmp24, tmp24, 2, ctx);
    SQRT(tmp24, tmp24, ctx);
    ADD(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    SUB_SI(tmp23, tmp23, 1, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, 3, ctx);
    SUB(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp21, 2, ctx);
    ADD_SI(tmp21, tmp21, 2, ctx);
    SQRT(tmp21, tmp21, ctx);
    MUL_SI(tmp21, tmp21, 5, ctx);
    ADD(tmp19, tmp20, tmp21, ctx);
    SUB_SI(tmp19, tmp19, 8, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp18, 2, ctx);
    ADD_SI(tmp18, tmp18, 2, ctx);
    SQRT(tmp18, tmp18, ctx);
    ADD_SI(tmp18, tmp18, 2, ctx);
    MUL(tmp16, tmp17, tmp18, ctx);
    SQRT_UI(tmp21, 2, ctx);
    ADD_SI(tmp21, tmp21, 2, ctx);
    SQRT(tmp21, tmp21, ctx);
    ADD_SI(tmp21, tmp21, 1, ctx);
    SQRT_UI(tmp22, 2, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    SUB_SI(tmp22, tmp22, 1, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp21, 2, ctx);
    ADD_SI(tmp21, tmp21, 2, ctx);
    SQRT(tmp21, tmp21, ctx);
    ADD(tmp19, tmp20, tmp21, ctx);
    ADD_SI(tmp19, tmp19, 1, ctx);
    POW_UI(tmp19, tmp19, 2, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    ADD_SI(tmp23, tmp23, 1, ctx);
    SQRT_UI(tmp24, 2, ctx);
    ADD_SI(tmp24, tmp24, 2, ctx);
    SQRT(tmp24, tmp24, ctx);
    SUB_SI(tmp24, tmp24, 1, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    SUB(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp29, 2, ctx);
    SQRT_UI(tmp30, 2, ctx);
    ADD_SI(tmp30, tmp30, 2, ctx);
    SQRT(tmp30, tmp30, ctx);
    ADD(tmp28, tmp29, tmp30, ctx);
    SQRT_UI(tmp29, 2, ctx);
    ADD_SI(tmp29, tmp29, 2, ctx);
    SQRT(tmp29, tmp29, ctx);
    SUB_SI(tmp29, tmp29, 1, ctx);
    SQRT(tmp29, tmp29, ctx);
    MUL(tmp27, tmp28, tmp29, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, 3, ctx);
    ADD(tmp26, tmp27, tmp28, ctx);
    SQRT_UI(tmp27, 2, ctx);
    ADD_SI(tmp27, tmp27, 2, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL_SI(tmp27, tmp27, 5, ctx);
    SUB(tmp25, tmp26, tmp27, ctx);
    ADD_SI(tmp25, tmp25, 8, ctx);
    SQRT_UI(tmp30, 2, ctx);
    SQRT_UI(tmp31, 2, ctx);
    ADD_SI(tmp31, tmp31, 2, ctx);
    SQRT(tmp31, tmp31, ctx);
    ADD(tmp29, tmp30, tmp31, ctx);
    SQRT_UI(tmp30, 2, ctx);
    ADD_SI(tmp30, tmp30, 2, ctx);
    SQRT(tmp30, tmp30, ctx);
    SUB_SI(tmp30, tmp30, 1, ctx);
    SQRT(tmp30, tmp30, ctx);
    MUL(tmp28, tmp29, tmp30, ctx);
    SQRT_UI(tmp29, 2, ctx);
    MUL_SI(tmp29, tmp29, 3, ctx);
    SUB(tmp27, tmp28, tmp29, ctx);
    SQRT_UI(tmp28, 2, ctx);
    ADD_SI(tmp28, tmp28, 2, ctx);
    SQRT(tmp28, tmp28, ctx);
    MUL_SI(tmp28, tmp28, 5, ctx);
    ADD(tmp26, tmp27, tmp28, ctx);
    SUB_SI(tmp26, tmp26, 8, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    SQRT_UI(tmp25, 2, ctx);
    ADD_SI(tmp25, tmp25, 2, ctx);
    SQRT(tmp25, tmp25, ctx);
    ADD_SI(tmp25, tmp25, 2, ctx);
    MUL(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp27, 2, ctx);
    ADD_SI(tmp27, tmp27, 2, ctx);
    SQRT(tmp27, tmp27, ctx);
    ADD_SI(tmp27, tmp27, 1, ctx);
    SQRT_UI(tmp28, 2, ctx);
    ADD_SI(tmp28, tmp28, 2, ctx);
    SQRT(tmp28, tmp28, ctx);
    SUB_SI(tmp28, tmp28, 1, ctx);
    SQRT(tmp28, tmp28, ctx);
    MUL(tmp26, tmp27, tmp28, ctx);
    SQRT_UI(tmp27, 2, ctx);
    ADD_SI(tmp27, tmp27, 2, ctx);
    SQRT(tmp27, tmp27, ctx);
    ADD(tmp25, tmp26, tmp27, ctx);
    ADD_SI(tmp25, tmp25, 1, ctx);
    SQRT_UI(tmp26, 2, ctx);
    ADD_SI(tmp26, tmp26, 2, ctx);
    SQRT(tmp26, tmp26, ctx);
    SUB_SI(tmp26, tmp26, 2, ctx);
    POW_UI(tmp26, tmp26, 3, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    DIV(tmp22, tmp23, tmp24, ctx);
    SUB(tmp20, tmp21, tmp22, ctx);
    SUB_SI(tmp20, tmp20, 1, ctx);
    MUL(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp19, 2, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    SUB_SI(tmp19, tmp19, 2, ctx);
    POW_UI(tmp19, tmp19, 3, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    DIV(tmp15, tmp16, tmp17, ctx);
    ADD(tmp13, tmp14, tmp15, ctx);
    MUL(tmp11, tmp12, tmp13, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, 3, ctx);
    SUB_SI(tmp24, tmp24, 4, ctx);
    MUL_SI(tmp24, tmp24, 3, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, -17, ctx);
    ADD_SI(tmp25, tmp25, 26, ctx);
    SQRT(tmp25, tmp25, ctx);
    MUL(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, 85, ctx);
    SUB(tmp22, tmp23, tmp24, ctx);
    ADD_SI(tmp22, tmp22, 122, ctx);
    SQRT_UI(tmp23, 2, ctx);
    NEG(tmp23, tmp23, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 7, ctx);
    SUB_SI(tmp23, tmp23, 10, ctx);
    MUL_SI(tmp23, tmp23, 11, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, -17, ctx);
    ADD_SI(tmp24, tmp24, 26, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    SUB(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, 630, ctx);
    ADD(tmp19, tmp20, tmp21, ctx);
    SUB_SI(tmp19, tmp19, 890, ctx);
    MUL_SI(tmp19, tmp19, 2, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, 3, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, -17, ctx);
    ADD_SI(tmp22, tmp22, 26, ctx);
    SQRT(tmp22, tmp22, ctx);
    ADD(tmp20, tmp21, tmp22, ctx);
    SUB_SI(tmp20, tmp20, 3, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp19, 2, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    SUB_SI(tmp19, tmp19, 1, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, 4896, ctx);
    SUB_SI(tmp19, tmp19, 6923, ctx);
    MUL_SI(tmp19, tmp19, 2, ctx);
    SQRT_UI(tmp20, 2, ctx);
    ADD_SI(tmp20, tmp20, 2, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL(tmp18, tmp19, tmp20, ctx);
    SUB(tmp16, tmp17, tmp18, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, 79, ctx);
    SUB_SI(tmp21, tmp21, 112, ctx);
    MUL_SI(tmp21, tmp21, 20, ctx);
    SQRT_UI(tmp22, 2, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, 27, ctx);
    SUB_SI(tmp24, tmp24, 38, ctx);
    MUL_SI(tmp24, tmp24, 7, ctx);
    SQRT_UI(tmp25, 2, ctx);
    ADD_SI(tmp25, tmp25, 2, ctx);
    SQRT(tmp25, tmp25, ctx);
    MUL(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, 342, ctx);
    SUB(tmp22, tmp23, tmp24, ctx);
    ADD_SI(tmp22, tmp22, 484, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, -17, ctx);
    ADD_SI(tmp23, tmp23, 26, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SUB(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp20, 2, ctx);
    MUL_SI(tmp20, tmp20, 2820, ctx);
    SUB(tmp18, tmp19, tmp20, ctx);
    ADD_SI(tmp18, tmp18, 3992, ctx);
    SQRT_UI(tmp19, 2, ctx);
    NEG(tmp19, tmp19, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    ADD(tmp15, tmp16, tmp17, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, 2, ctx);
    SUB_SI(tmp28, tmp28, 3, ctx);
    MUL_SI(tmp28, tmp28, 3, ctx);
    SQRT_UI(tmp29, 2, ctx);
    MUL_SI(tmp29, tmp29, -17, ctx);
    ADD_SI(tmp29, tmp29, 26, ctx);
    SQRT(tmp29, tmp29, ctx);
    MUL(tmp27, tmp28, tmp29, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, 61, ctx);
    SUB(tmp26, tmp27, tmp28, ctx);
    ADD_SI(tmp26, tmp26, 85, ctx);
    SQRT_UI(tmp27, 2, ctx);
    NEG(tmp27, tmp27, ctx);
    ADD_SI(tmp27, tmp27, 2, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL(tmp25, tmp26, tmp27, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, 5, ctx);
    SUB_SI(tmp27, tmp27, 7, ctx);
    MUL_SI(tmp27, tmp27, 11, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, -17, ctx);
    ADD_SI(tmp28, tmp28, 26, ctx);
    SQRT(tmp28, tmp28, ctx);
    MUL(tmp26, tmp27, tmp28, ctx);
    SUB(tmp24, tmp25, tmp26, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, 445, ctx);
    ADD(tmp23, tmp24, tmp25, ctx);
    SUB_SI(tmp23, tmp23, 630, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, 3, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, -17, ctx);
    ADD_SI(tmp26, tmp26, 26, ctx);
    SQRT(tmp26, tmp26, ctx);
    ADD(tmp24, tmp25, tmp26, ctx);
    SUB_SI(tmp24, tmp24, 3, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    SUB_SI(tmp23, tmp23, 1, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 89, ctx);
    SUB_SI(tmp23, tmp23, 126, ctx);
    MUL_SI(tmp23, tmp23, 10, ctx);
    SQRT_UI(tmp24, 2, ctx);
    ADD_SI(tmp24, tmp24, 2, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    SUB(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, 61, ctx);
    SUB_SI(tmp25, tmp25, 85, ctx);
    SQRT_UI(tmp26, 2, ctx);
    ADD_SI(tmp26, tmp26, 2, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, 2, ctx);
    SUB_SI(tmp28, tmp28, 3, ctx);
    SQRT_UI(tmp29, 2, ctx);
    ADD_SI(tmp29, tmp29, 2, ctx);
    SQRT(tmp29, tmp29, ctx);
    MUL(tmp27, tmp28, tmp29, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, 2, ctx);
    SUB(tmp26, tmp27, tmp28, ctx);
    ADD_SI(tmp26, tmp26, 3, ctx);
    MUL_SI(tmp26, tmp26, 3, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, -17, ctx);
    ADD_SI(tmp27, tmp27, 26, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL(tmp25, tmp26, tmp27, ctx);
    SUB(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, 61, ctx);
    SUB(tmp22, tmp23, tmp24, ctx);
    ADD_SI(tmp22, tmp22, 85, ctx);
    MUL_SI(tmp22, tmp22, 2, ctx);
    SQRT_UI(tmp23, 2, ctx);
    NEG(tmp23, tmp23, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    ADD(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 5, ctx);
    SUB_SI(tmp23, tmp23, 7, ctx);
    SQRT_UI(tmp24, 2, ctx);
    ADD_SI(tmp24, tmp24, 2, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 5, ctx);
    SUB(tmp21, tmp22, tmp23, ctx);
    ADD_SI(tmp21, tmp21, 7, ctx);
    MUL_SI(tmp21, tmp21, 22, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, -17, ctx);
    ADD_SI(tmp22, tmp22, 26, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    ADD(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, 890, ctx);
    ADD(tmp17, tmp18, tmp19, ctx);
    SUB_SI(tmp17, tmp17, 1260, ctx);
    SQRT_UI(tmp20, 2, ctx);
    MUL_SI(tmp20, tmp20, -12, ctx);
    SQRT_UI(tmp21, 2, ctx);
    NEG(tmp21, tmp21, ctx);
    ADD_SI(tmp21, tmp21, 2, ctx);
    SQRT(tmp21, tmp21, ctx);
    MUL_SI(tmp21, tmp21, 2, ctx);
    SUB(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp20, 2, ctx);
    MUL_SI(tmp20, tmp20, -17, ctx);
    ADD_SI(tmp20, tmp20, 26, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL_SI(tmp20, tmp20, 2, ctx);
    SUB(tmp18, tmp19, tmp20, ctx);
    ADD_SI(tmp18, tmp18, 24, ctx);
    SQRT(tmp18, tmp18, ctx);
    MUL(tmp16, tmp17, tmp18, ctx);
    ADD(tmp14, tmp15, tmp16, ctx);
    SQRT_UI(tmp18, 2, ctx);
    MUL_SI(tmp18, tmp18, 319, ctx);
    SUB_SI(tmp18, tmp18, 452, ctx);
    SQRT_UI(tmp19, 2, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp18, 2, ctx);
    MUL_SI(tmp18, tmp18, 561, ctx);
    SUB(tmp16, tmp17, tmp18, ctx);
    ADD_SI(tmp16, tmp16, 794, ctx);
    MUL_SI(tmp16, tmp16, 4, ctx);
    SQRT_UI(tmp17, 2, ctx);
    MUL_SI(tmp17, tmp17, -17, ctx);
    ADD_SI(tmp17, tmp17, 26, ctx);
    SQRT(tmp17, tmp17, ctx);
    MUL(tmp15, tmp16, tmp17, ctx);
    ADD(tmp13, tmp14, tmp15, ctx);
    SQRT_UI(tmp14, 2, ctx);
    MUL_SI(tmp14, tmp14, 17064, ctx);
    ADD(tmp12, tmp13, tmp14, ctx);
    SUB_SI(tmp12, tmp12, 24132, ctx);
    DIV(tmp10, tmp11, tmp12, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, 89, ctx);
    SUB_SI(tmp21, tmp21, 126, ctx);
    MUL_SI(tmp21, tmp21, 5, ctx);
    SQRT_UI(tmp22, 2, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, 61, ctx);
    SUB_SI(tmp25, tmp25, 85, ctx);
    SQRT_UI(tmp26, 2, ctx);
    ADD_SI(tmp26, tmp26, 2, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, 2, ctx);
    SUB_SI(tmp28, tmp28, 3, ctx);
    SQRT_UI(tmp29, 2, ctx);
    ADD_SI(tmp29, tmp29, 2, ctx);
    SQRT(tmp29, tmp29, ctx);
    MUL(tmp27, tmp28, tmp29, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, 4, ctx);
    SUB(tmp26, tmp27, tmp28, ctx);
    ADD_SI(tmp26, tmp26, 6, ctx);
    MUL_SI(tmp26, tmp26, 3, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, -17, ctx);
    ADD_SI(tmp27, tmp27, 26, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL(tmp25, tmp26, tmp27, ctx);
    SUB(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, 122, ctx);
    SUB(tmp22, tmp23, tmp24, ctx);
    ADD_SI(tmp22, tmp22, 170, ctx);
    SQRT_UI(tmp23, 2, ctx);
    NEG(tmp23, tmp23, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SUB(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 5, ctx);
    SUB_SI(tmp23, tmp23, 7, ctx);
    SQRT_UI(tmp24, 2, ctx);
    ADD_SI(tmp24, tmp24, 2, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 10, ctx);
    SUB(tmp21, tmp22, tmp23, ctx);
    ADD_SI(tmp21, tmp21, 14, ctx);
    MUL_SI(tmp21, tmp21, 11, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, -17, ctx);
    ADD_SI(tmp22, tmp22, 26, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SUB(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, 890, ctx);
    SUB(tmp17, tmp18, tmp19, ctx);
    ADD_SI(tmp17, tmp17, 1260, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, 3, ctx);
    SQRT_UI(tmp20, 2, ctx);
    NEG(tmp20, tmp20, ctx);
    ADD_SI(tmp20, tmp20, 2, ctx);
    SQRT(tmp20, tmp20, ctx);
    ADD(tmp18, tmp19, tmp20, ctx);
    SUB_SI(tmp18, tmp18, 5, ctx);
    SQRT(tmp18, tmp18, ctx);
    MUL(tmp16, tmp17, tmp18, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, -12, ctx);
    SQRT_UI(tmp20, 2, ctx);
    NEG(tmp20, tmp20, ctx);
    ADD_SI(tmp20, tmp20, 2, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL_SI(tmp20, tmp20, 2, ctx);
    SUB(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, -17, ctx);
    ADD_SI(tmp19, tmp19, 26, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL_SI(tmp19, tmp19, 2, ctx);
    SUB(tmp17, tmp18, tmp19, ctx);
    ADD_SI(tmp17, tmp17, 24, ctx);
    SQRT(tmp17, tmp17, ctx);
    MUL(tmp15, tmp16, tmp17, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, 63, ctx);
    SUB_SI(tmp21, tmp21, 89, ctx);
    MUL_SI(tmp21, tmp21, 10, ctx);
    SQRT_UI(tmp22, 2, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, 85, ctx);
    SUB_SI(tmp25, tmp25, 122, ctx);
    SQRT_UI(tmp26, 2, ctx);
    ADD_SI(tmp26, tmp26, 2, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, 3, ctx);
    SUB_SI(tmp28, tmp28, 4, ctx);
    SQRT_UI(tmp29, 2, ctx);
    ADD_SI(tmp29, tmp29, 2, ctx);
    SQRT(tmp29, tmp29, ctx);
    MUL(tmp27, tmp28, tmp29, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, 6, ctx);
    SUB(tmp26, tmp27, tmp28, ctx);
    ADD_SI(tmp26, tmp26, 8, ctx);
    MUL_SI(tmp26, tmp26, 3, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, -17, ctx);
    ADD_SI(tmp27, tmp27, 26, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL(tmp25, tmp26, tmp27, ctx);
    SUB(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, 170, ctx);
    SUB(tmp22, tmp23, tmp24, ctx);
    ADD_SI(tmp22, tmp22, 244, ctx);
    SQRT_UI(tmp23, 2, ctx);
    NEG(tmp23, tmp23, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SUB(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 7, ctx);
    SUB_SI(tmp23, tmp23, 10, ctx);
    SQRT_UI(tmp24, 2, ctx);
    ADD_SI(tmp24, tmp24, 2, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 14, ctx);
    SUB(tmp21, tmp22, tmp23, ctx);
    ADD_SI(tmp21, tmp21, 20, ctx);
    MUL_SI(tmp21, tmp21, 11, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, -17, ctx);
    ADD_SI(tmp22, tmp22, 26, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SUB(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, 1260, ctx);
    SUB(tmp17, tmp18, tmp19, ctx);
    ADD_SI(tmp17, tmp17, 1780, ctx);
    MUL_SI(tmp17, tmp17, 2, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, 3, ctx);
    SQRT_UI(tmp20, 2, ctx);
    NEG(tmp20, tmp20, ctx);
    ADD_SI(tmp20, tmp20, 2, ctx);
    SQRT(tmp20, tmp20, ctx);
    ADD(tmp18, tmp19, tmp20, ctx);
    SUB_SI(tmp18, tmp18, 5, ctx);
    SQRT(tmp18, tmp18, ctx);
    MUL(tmp16, tmp17, tmp18, ctx);
    ADD(tmp14, tmp15, tmp16, ctx);
    SQRT_UI(tmp19, 2, ctx);
    SQRT_UI(tmp20, 2, ctx);
    ADD_SI(tmp20, tmp20, 2, ctx);
    SQRT(tmp20, tmp20, ctx);
    ADD(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp19, 2, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    SUB_SI(tmp19, tmp19, 1, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp18, 2, ctx);
    MUL_SI(tmp18, tmp18, 3, ctx);
    ADD(tmp16, tmp17, tmp18, ctx);
    SQRT_UI(tmp17, 2, ctx);
    ADD_SI(tmp17, tmp17, 2, ctx);
    SQRT(tmp17, tmp17, ctx);
    MUL_SI(tmp17, tmp17, 5, ctx);
    SUB(tmp15, tmp16, tmp17, ctx);
    ADD_SI(tmp15, tmp15, 8, ctx);
    MUL(tmp13, tmp14, tmp15, ctx);
    SQRT_UI(tmp14, 2, ctx);
    ADD_SI(tmp14, tmp14, 2, ctx);
    SQRT(tmp14, tmp14, ctx);
    ADD_SI(tmp14, tmp14, 2, ctx);
    SQRT(tmp14, tmp14, ctx);
    MUL(tmp12, tmp13, tmp14, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, 3, ctx);
    SUB_SI(tmp28, tmp28, 4, ctx);
    MUL_SI(tmp28, tmp28, 3, ctx);
    SQRT_UI(tmp29, 2, ctx);
    MUL_SI(tmp29, tmp29, -17, ctx);
    ADD_SI(tmp29, tmp29, 26, ctx);
    SQRT(tmp29, tmp29, ctx);
    MUL(tmp27, tmp28, tmp29, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, 85, ctx);
    SUB(tmp26, tmp27, tmp28, ctx);
    ADD_SI(tmp26, tmp26, 122, ctx);
    SQRT_UI(tmp27, 2, ctx);
    NEG(tmp27, tmp27, ctx);
    ADD_SI(tmp27, tmp27, 2, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL(tmp25, tmp26, tmp27, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, 7, ctx);
    SUB_SI(tmp27, tmp27, 10, ctx);
    MUL_SI(tmp27, tmp27, 11, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, -17, ctx);
    ADD_SI(tmp28, tmp28, 26, ctx);
    SQRT(tmp28, tmp28, ctx);
    MUL(tmp26, tmp27, tmp28, ctx);
    SUB(tmp24, tmp25, tmp26, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, 630, ctx);
    ADD(tmp23, tmp24, tmp25, ctx);
    SUB_SI(tmp23, tmp23, 890, ctx);
    MUL_SI(tmp23, tmp23, 2, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, 3, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, -17, ctx);
    ADD_SI(tmp26, tmp26, 26, ctx);
    SQRT(tmp26, tmp26, ctx);
    ADD(tmp24, tmp25, tmp26, ctx);
    SUB_SI(tmp24, tmp24, 3, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    SUB_SI(tmp23, tmp23, 1, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 4896, ctx);
    SUB_SI(tmp23, tmp23, 6923, ctx);
    MUL_SI(tmp23, tmp23, 2, ctx);
    SQRT_UI(tmp24, 2, ctx);
    ADD_SI(tmp24, tmp24, 2, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    SUB(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, 79, ctx);
    SUB_SI(tmp25, tmp25, 112, ctx);
    MUL_SI(tmp25, tmp25, 20, ctx);
    SQRT_UI(tmp26, 2, ctx);
    ADD_SI(tmp26, tmp26, 2, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, 27, ctx);
    SUB_SI(tmp28, tmp28, 38, ctx);
    MUL_SI(tmp28, tmp28, 7, ctx);
    SQRT_UI(tmp29, 2, ctx);
    ADD_SI(tmp29, tmp29, 2, ctx);
    SQRT(tmp29, tmp29, ctx);
    MUL(tmp27, tmp28, tmp29, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, 342, ctx);
    SUB(tmp26, tmp27, tmp28, ctx);
    ADD_SI(tmp26, tmp26, 484, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, -17, ctx);
    ADD_SI(tmp27, tmp27, 26, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL(tmp25, tmp26, tmp27, ctx);
    SUB(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, 2820, ctx);
    SUB(tmp22, tmp23, tmp24, ctx);
    ADD_SI(tmp22, tmp22, 3992, ctx);
    SQRT_UI(tmp23, 2, ctx);
    NEG(tmp23, tmp23, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    ADD(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp32, 2, ctx);
    MUL_SI(tmp32, tmp32, 2, ctx);
    SUB_SI(tmp32, tmp32, 3, ctx);
    MUL_SI(tmp32, tmp32, 3, ctx);
    SQRT_UI(tmp33, 2, ctx);
    MUL_SI(tmp33, tmp33, -17, ctx);
    ADD_SI(tmp33, tmp33, 26, ctx);
    SQRT(tmp33, tmp33, ctx);
    MUL(tmp31, tmp32, tmp33, ctx);
    SQRT_UI(tmp32, 2, ctx);
    MUL_SI(tmp32, tmp32, 61, ctx);
    SUB(tmp30, tmp31, tmp32, ctx);
    ADD_SI(tmp30, tmp30, 85, ctx);
    SQRT_UI(tmp31, 2, ctx);
    NEG(tmp31, tmp31, ctx);
    ADD_SI(tmp31, tmp31, 2, ctx);
    SQRT(tmp31, tmp31, ctx);
    MUL(tmp29, tmp30, tmp31, ctx);
    SQRT_UI(tmp31, 2, ctx);
    MUL_SI(tmp31, tmp31, 5, ctx);
    SUB_SI(tmp31, tmp31, 7, ctx);
    MUL_SI(tmp31, tmp31, 11, ctx);
    SQRT_UI(tmp32, 2, ctx);
    MUL_SI(tmp32, tmp32, -17, ctx);
    ADD_SI(tmp32, tmp32, 26, ctx);
    SQRT(tmp32, tmp32, ctx);
    MUL(tmp30, tmp31, tmp32, ctx);
    SUB(tmp28, tmp29, tmp30, ctx);
    SQRT_UI(tmp29, 2, ctx);
    MUL_SI(tmp29, tmp29, 445, ctx);
    ADD(tmp27, tmp28, tmp29, ctx);
    SUB_SI(tmp27, tmp27, 630, ctx);
    SQRT_UI(tmp29, 2, ctx);
    MUL_SI(tmp29, tmp29, 3, ctx);
    SQRT_UI(tmp30, 2, ctx);
    MUL_SI(tmp30, tmp30, -17, ctx);
    ADD_SI(tmp30, tmp30, 26, ctx);
    SQRT(tmp30, tmp30, ctx);
    ADD(tmp28, tmp29, tmp30, ctx);
    SUB_SI(tmp28, tmp28, 3, ctx);
    SQRT(tmp28, tmp28, ctx);
    MUL(tmp26, tmp27, tmp28, ctx);
    SQRT_UI(tmp27, 2, ctx);
    ADD_SI(tmp27, tmp27, 2, ctx);
    SQRT(tmp27, tmp27, ctx);
    SUB_SI(tmp27, tmp27, 1, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL(tmp25, tmp26, tmp27, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, 89, ctx);
    SUB_SI(tmp27, tmp27, 126, ctx);
    MUL_SI(tmp27, tmp27, 10, ctx);
    SQRT_UI(tmp28, 2, ctx);
    ADD_SI(tmp28, tmp28, 2, ctx);
    SQRT(tmp28, tmp28, ctx);
    MUL(tmp26, tmp27, tmp28, ctx);
    SUB(tmp24, tmp25, tmp26, ctx);
    SQRT_UI(tmp29, 2, ctx);
    MUL_SI(tmp29, tmp29, 61, ctx);
    SUB_SI(tmp29, tmp29, 85, ctx);
    SQRT_UI(tmp30, 2, ctx);
    ADD_SI(tmp30, tmp30, 2, ctx);
    SQRT(tmp30, tmp30, ctx);
    MUL(tmp28, tmp29, tmp30, ctx);
    SQRT_UI(tmp32, 2, ctx);
    MUL_SI(tmp32, tmp32, 2, ctx);
    SUB_SI(tmp32, tmp32, 3, ctx);
    SQRT_UI(tmp33, 2, ctx);
    ADD_SI(tmp33, tmp33, 2, ctx);
    SQRT(tmp33, tmp33, ctx);
    MUL(tmp31, tmp32, tmp33, ctx);
    SQRT_UI(tmp32, 2, ctx);
    MUL_SI(tmp32, tmp32, 2, ctx);
    SUB(tmp30, tmp31, tmp32, ctx);
    ADD_SI(tmp30, tmp30, 3, ctx);
    MUL_SI(tmp30, tmp30, 3, ctx);
    SQRT_UI(tmp31, 2, ctx);
    MUL_SI(tmp31, tmp31, -17, ctx);
    ADD_SI(tmp31, tmp31, 26, ctx);
    SQRT(tmp31, tmp31, ctx);
    MUL(tmp29, tmp30, tmp31, ctx);
    SUB(tmp27, tmp28, tmp29, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, 61, ctx);
    SUB(tmp26, tmp27, tmp28, ctx);
    ADD_SI(tmp26, tmp26, 85, ctx);
    MUL_SI(tmp26, tmp26, 2, ctx);
    SQRT_UI(tmp27, 2, ctx);
    NEG(tmp27, tmp27, ctx);
    ADD_SI(tmp27, tmp27, 2, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL(tmp25, tmp26, tmp27, ctx);
    ADD(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, 5, ctx);
    SUB_SI(tmp27, tmp27, 7, ctx);
    SQRT_UI(tmp28, 2, ctx);
    ADD_SI(tmp28, tmp28, 2, ctx);
    SQRT(tmp28, tmp28, ctx);
    MUL(tmp26, tmp27, tmp28, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, 5, ctx);
    SUB(tmp25, tmp26, tmp27, ctx);
    ADD_SI(tmp25, tmp25, 7, ctx);
    MUL_SI(tmp25, tmp25, 22, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, -17, ctx);
    ADD_SI(tmp26, tmp26, 26, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    ADD(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 890, ctx);
    ADD(tmp21, tmp22, tmp23, ctx);
    SUB_SI(tmp21, tmp21, 1260, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, -12, ctx);
    SQRT_UI(tmp25, 2, ctx);
    NEG(tmp25, tmp25, ctx);
    ADD_SI(tmp25, tmp25, 2, ctx);
    SQRT(tmp25, tmp25, ctx);
    MUL_SI(tmp25, tmp25, 2, ctx);
    SUB(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, -17, ctx);
    ADD_SI(tmp24, tmp24, 26, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL_SI(tmp24, tmp24, 2, ctx);
    SUB(tmp22, tmp23, tmp24, ctx);
    ADD_SI(tmp22, tmp22, 24, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    ADD(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, 319, ctx);
    SUB_SI(tmp22, tmp22, 452, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, 561, ctx);
    SUB(tmp20, tmp21, tmp22, ctx);
    ADD_SI(tmp20, tmp20, 794, ctx);
    MUL_SI(tmp20, tmp20, 4, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, -17, ctx);
    ADD_SI(tmp21, tmp21, 26, ctx);
    SQRT(tmp21, tmp21, ctx);
    MUL(tmp19, tmp20, tmp21, ctx);
    ADD(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp18, 2, ctx);
    MUL_SI(tmp18, tmp18, 17064, ctx);
    ADD(tmp16, tmp17, tmp18, ctx);
    SUB_SI(tmp16, tmp16, 24132, ctx);
    SQRT_UI(tmp19, 2, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    ADD_SI(tmp19, tmp19, 1, ctx);
    SQRT_UI(tmp20, 2, ctx);
    ADD_SI(tmp20, tmp20, 2, ctx);
    SQRT(tmp20, tmp20, ctx);
    SUB_SI(tmp20, tmp20, 1, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp19, 2, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    ADD(tmp17, tmp18, tmp19, ctx);
    ADD_SI(tmp17, tmp17, 1, ctx);
    MUL(tmp15, tmp16, tmp17, ctx);
    SQRT_UI(tmp19, 2, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    ADD_SI(tmp19, tmp19, 1, ctx);
    SQRT_UI(tmp20, 2, ctx);
    ADD_SI(tmp20, tmp20, 2, ctx);
    SQRT(tmp20, tmp20, ctx);
    SUB_SI(tmp20, tmp20, 1, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp19, 2, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    SUB(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp25, 2, ctx);
    SQRT_UI(tmp26, 2, ctx);
    ADD_SI(tmp26, tmp26, 2, ctx);
    SQRT(tmp26, tmp26, ctx);
    ADD(tmp24, tmp25, tmp26, ctx);
    SQRT_UI(tmp25, 2, ctx);
    ADD_SI(tmp25, tmp25, 2, ctx);
    SQRT(tmp25, tmp25, ctx);
    SUB_SI(tmp25, tmp25, 1, ctx);
    SQRT(tmp25, tmp25, ctx);
    MUL(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, 3, ctx);
    ADD(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL_SI(tmp23, tmp23, 5, ctx);
    SUB(tmp21, tmp22, tmp23, ctx);
    ADD_SI(tmp21, tmp21, 8, ctx);
    SQRT_UI(tmp26, 2, ctx);
    SQRT_UI(tmp27, 2, ctx);
    ADD_SI(tmp27, tmp27, 2, ctx);
    SQRT(tmp27, tmp27, ctx);
    ADD(tmp25, tmp26, tmp27, ctx);
    SQRT_UI(tmp26, 2, ctx);
    ADD_SI(tmp26, tmp26, 2, ctx);
    SQRT(tmp26, tmp26, ctx);
    SUB_SI(tmp26, tmp26, 1, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, 3, ctx);
    SUB(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp24, 2, ctx);
    ADD_SI(tmp24, tmp24, 2, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL_SI(tmp24, tmp24, 5, ctx);
    ADD(tmp22, tmp23, tmp24, ctx);
    SUB_SI(tmp22, tmp22, 8, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp21, 2, ctx);
    ADD_SI(tmp21, tmp21, 2, ctx);
    SQRT(tmp21, tmp21, ctx);
    ADD_SI(tmp21, tmp21, 2, ctx);
    MUL(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    ADD_SI(tmp23, tmp23, 1, ctx);
    SQRT_UI(tmp24, 2, ctx);
    ADD_SI(tmp24, tmp24, 2, ctx);
    SQRT(tmp24, tmp24, ctx);
    SUB_SI(tmp24, tmp24, 1, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    ADD(tmp21, tmp22, tmp23, ctx);
    ADD_SI(tmp21, tmp21, 1, ctx);
    SQRT_UI(tmp22, 2, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    SUB_SI(tmp22, tmp22, 2, ctx);
    POW_UI(tmp22, tmp22, 3, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    DIV(tmp18, tmp19, tmp20, ctx);
    SUB(tmp16, tmp17, tmp18, ctx);
    SUB_SI(tmp16, tmp16, 1, ctx);
    MUL(tmp14, tmp15, tmp16, ctx);
    SET_SI(tmp18, 1, ctx);
    DIV_SI(tmp18, tmp18, 4, ctx);
    NEG(tmp18, tmp18, ctx);
    SQRT_UI(tmp19, 2, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    SET_SI(tmp18, 1, ctx);
    DIV_SI(tmp18, tmp18, 2, ctx);
    ADD(tmp16, tmp17, tmp18, ctx);
    SET_SI(tmp17, 3, ctx);
    DIV_SI(tmp17, tmp17, 2, ctx);
    POW(tmp15, tmp16, tmp17, ctx);
    MUL(tmp13, tmp14, tmp15, ctx);
    DIV(tmp11, tmp12, tmp13, ctx);
    ADD(tmp9, tmp10, tmp11, ctx);
    MUL(tmp7, tmp8, tmp9, ctx);
    SQRT_UI(tmp8, 2, ctx);
    ADD_SI(tmp8, tmp8, 2, ctx);
    SQRT(tmp8, tmp8, ctx);
    ADD_SI(tmp8, tmp8, 2, ctx);
    SQRT(tmp8, tmp8, ctx);
    MUL(tmp6, tmp7, tmp8, ctx);
    SET_SI(tmp9, 1, ctx);
    DIV_SI(tmp9, tmp9, 4, ctx);
    NEG(tmp9, tmp9, ctx);
    SQRT_UI(tmp10, 2, ctx);
    ADD_SI(tmp10, tmp10, 2, ctx);
    SQRT(tmp10, tmp10, ctx);
    MUL(tmp8, tmp9, tmp10, ctx);
    SET_SI(tmp9, 1, ctx);
    DIV_SI(tmp9, tmp9, 2, ctx);
    ADD(tmp7, tmp8, tmp9, ctx);
    SQRT(tmp7, tmp7, ctx);
    DIV(tmp5, tmp6, tmp7, ctx);
    SQRT_UI(tmp12, 2, ctx);
    ADD_SI(tmp12, tmp12, 2, ctx);
    SQRT(tmp12, tmp12, ctx);
    SQRT_UI(tmp13, 2, ctx);
    SUB_SI(tmp13, tmp13, 1, ctx);
    MUL(tmp11, tmp12, tmp13, ctx);
    SQRT_UI(tmp12, 2, ctx);
    ADD_SI(tmp12, tmp12, 2, ctx);
    SQRT(tmp12, tmp12, ctx);
    SUB_SI(tmp12, tmp12, 1, ctx);
    SQRT(tmp12, tmp12, ctx);
    MUL(tmp10, tmp11, tmp12, ctx);
    SQRT_UI(tmp11, 2, ctx);
    ADD(tmp9, tmp10, tmp11, ctx);
    SQRT_UI(tmp10, 2, ctx);
    ADD_SI(tmp10, tmp10, 2, ctx);
    SQRT(tmp10, tmp10, ctx);
    SUB(tmp8, tmp9, tmp10, ctx);
    MUL_SI(tmp8, tmp8, 2, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, 89, ctx);
    SUB_SI(tmp19, tmp19, 126, ctx);
    MUL_SI(tmp19, tmp19, 5, ctx);
    SQRT_UI(tmp20, 2, ctx);
    ADD_SI(tmp20, tmp20, 2, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 61, ctx);
    SUB_SI(tmp23, tmp23, 85, ctx);
    SQRT_UI(tmp24, 2, ctx);
    ADD_SI(tmp24, tmp24, 2, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, 2, ctx);
    SUB_SI(tmp26, tmp26, 3, ctx);
    SQRT_UI(tmp27, 2, ctx);
    ADD_SI(tmp27, tmp27, 2, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL(tmp25, tmp26, tmp27, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, 4, ctx);
    SUB(tmp24, tmp25, tmp26, ctx);
    ADD_SI(tmp24, tmp24, 6, ctx);
    MUL_SI(tmp24, tmp24, 3, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, -17, ctx);
    ADD_SI(tmp25, tmp25, 26, ctx);
    SQRT(tmp25, tmp25, ctx);
    MUL(tmp23, tmp24, tmp25, ctx);
    SUB(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, 122, ctx);
    SUB(tmp20, tmp21, tmp22, ctx);
    ADD_SI(tmp20, tmp20, 170, ctx);
    SQRT_UI(tmp21, 2, ctx);
    NEG(tmp21, tmp21, ctx);
    ADD_SI(tmp21, tmp21, 2, ctx);
    SQRT(tmp21, tmp21, ctx);
    MUL(tmp19, tmp20, tmp21, ctx);
    SUB(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, 5, ctx);
    SUB_SI(tmp21, tmp21, 7, ctx);
    SQRT_UI(tmp22, 2, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, 10, ctx);
    SUB(tmp19, tmp20, tmp21, ctx);
    ADD_SI(tmp19, tmp19, 14, ctx);
    MUL_SI(tmp19, tmp19, 11, ctx);
    SQRT_UI(tmp20, 2, ctx);
    MUL_SI(tmp20, tmp20, -17, ctx);
    ADD_SI(tmp20, tmp20, 26, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL(tmp18, tmp19, tmp20, ctx);
    SUB(tmp16, tmp17, tmp18, ctx);
    SQRT_UI(tmp17, 2, ctx);
    MUL_SI(tmp17, tmp17, 890, ctx);
    SUB(tmp15, tmp16, tmp17, ctx);
    ADD_SI(tmp15, tmp15, 1260, ctx);
    SQRT_UI(tmp17, 2, ctx);
    MUL_SI(tmp17, tmp17, 3, ctx);
    SQRT_UI(tmp18, 2, ctx);
    NEG(tmp18, tmp18, ctx);
    ADD_SI(tmp18, tmp18, 2, ctx);
    SQRT(tmp18, tmp18, ctx);
    ADD(tmp16, tmp17, tmp18, ctx);
    SUB_SI(tmp16, tmp16, 5, ctx);
    SQRT(tmp16, tmp16, ctx);
    MUL(tmp14, tmp15, tmp16, ctx);
    SQRT_UI(tmp17, 2, ctx);
    MUL_SI(tmp17, tmp17, -12, ctx);
    SQRT_UI(tmp18, 2, ctx);
    NEG(tmp18, tmp18, ctx);
    ADD_SI(tmp18, tmp18, 2, ctx);
    SQRT(tmp18, tmp18, ctx);
    MUL_SI(tmp18, tmp18, 2, ctx);
    SUB(tmp16, tmp17, tmp18, ctx);
    SQRT_UI(tmp17, 2, ctx);
    MUL_SI(tmp17, tmp17, -17, ctx);
    ADD_SI(tmp17, tmp17, 26, ctx);
    SQRT(tmp17, tmp17, ctx);
    MUL_SI(tmp17, tmp17, 2, ctx);
    SUB(tmp15, tmp16, tmp17, ctx);
    ADD_SI(tmp15, tmp15, 24, ctx);
    SQRT(tmp15, tmp15, ctx);
    MUL(tmp13, tmp14, tmp15, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, 63, ctx);
    SUB_SI(tmp19, tmp19, 89, ctx);
    MUL_SI(tmp19, tmp19, 10, ctx);
    SQRT_UI(tmp20, 2, ctx);
    ADD_SI(tmp20, tmp20, 2, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 85, ctx);
    SUB_SI(tmp23, tmp23, 122, ctx);
    SQRT_UI(tmp24, 2, ctx);
    ADD_SI(tmp24, tmp24, 2, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, 3, ctx);
    SUB_SI(tmp26, tmp26, 4, ctx);
    SQRT_UI(tmp27, 2, ctx);
    ADD_SI(tmp27, tmp27, 2, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL(tmp25, tmp26, tmp27, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, 6, ctx);
    SUB(tmp24, tmp25, tmp26, ctx);
    ADD_SI(tmp24, tmp24, 8, ctx);
    MUL_SI(tmp24, tmp24, 3, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, -17, ctx);
    ADD_SI(tmp25, tmp25, 26, ctx);
    SQRT(tmp25, tmp25, ctx);
    MUL(tmp23, tmp24, tmp25, ctx);
    SUB(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, 170, ctx);
    SUB(tmp20, tmp21, tmp22, ctx);
    ADD_SI(tmp20, tmp20, 244, ctx);
    SQRT_UI(tmp21, 2, ctx);
    NEG(tmp21, tmp21, ctx);
    ADD_SI(tmp21, tmp21, 2, ctx);
    SQRT(tmp21, tmp21, ctx);
    MUL(tmp19, tmp20, tmp21, ctx);
    SUB(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, 7, ctx);
    SUB_SI(tmp21, tmp21, 10, ctx);
    SQRT_UI(tmp22, 2, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, 14, ctx);
    SUB(tmp19, tmp20, tmp21, ctx);
    ADD_SI(tmp19, tmp19, 20, ctx);
    MUL_SI(tmp19, tmp19, 11, ctx);
    SQRT_UI(tmp20, 2, ctx);
    MUL_SI(tmp20, tmp20, -17, ctx);
    ADD_SI(tmp20, tmp20, 26, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL(tmp18, tmp19, tmp20, ctx);
    SUB(tmp16, tmp17, tmp18, ctx);
    SQRT_UI(tmp17, 2, ctx);
    MUL_SI(tmp17, tmp17, 1260, ctx);
    SUB(tmp15, tmp16, tmp17, ctx);
    ADD_SI(tmp15, tmp15, 1780, ctx);
    MUL_SI(tmp15, tmp15, 2, ctx);
    SQRT_UI(tmp17, 2, ctx);
    MUL_SI(tmp17, tmp17, 3, ctx);
    SQRT_UI(tmp18, 2, ctx);
    NEG(tmp18, tmp18, ctx);
    ADD_SI(tmp18, tmp18, 2, ctx);
    SQRT(tmp18, tmp18, ctx);
    ADD(tmp16, tmp17, tmp18, ctx);
    SUB_SI(tmp16, tmp16, 5, ctx);
    SQRT(tmp16, tmp16, ctx);
    MUL(tmp14, tmp15, tmp16, ctx);
    ADD(tmp12, tmp13, tmp14, ctx);
    MUL_SI(tmp12, tmp12, 8, ctx);
    SQRT_UI(tmp16, 2, ctx);
    ADD_SI(tmp16, tmp16, 2, ctx);
    SQRT(tmp16, tmp16, ctx);
    ADD_SI(tmp16, tmp16, 1, ctx);
    SQRT_UI(tmp17, 2, ctx);
    ADD_SI(tmp17, tmp17, 2, ctx);
    SQRT(tmp17, tmp17, ctx);
    SUB_SI(tmp17, tmp17, 1, ctx);
    SQRT(tmp17, tmp17, ctx);
    MUL(tmp15, tmp16, tmp17, ctx);
    SQRT_UI(tmp16, 2, ctx);
    ADD_SI(tmp16, tmp16, 2, ctx);
    SQRT(tmp16, tmp16, ctx);
    ADD(tmp14, tmp15, tmp16, ctx);
    ADD_SI(tmp14, tmp14, 1, ctx);
    INV(tmp14, tmp14, ctx);
    SQRT_UI(tmp22, 2, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    ADD(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp22, 2, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    SUB_SI(tmp22, tmp22, 1, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, 3, ctx);
    ADD(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp20, 2, ctx);
    ADD_SI(tmp20, tmp20, 2, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL_SI(tmp20, tmp20, 5, ctx);
    SUB(tmp18, tmp19, tmp20, ctx);
    ADD_SI(tmp18, tmp18, 8, ctx);
    SQRT_UI(tmp23, 2, ctx);
    SQRT_UI(tmp24, 2, ctx);
    ADD_SI(tmp24, tmp24, 2, ctx);
    SQRT(tmp24, tmp24, ctx);
    ADD(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    SUB_SI(tmp23, tmp23, 1, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, 3, ctx);
    SUB(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp21, 2, ctx);
    ADD_SI(tmp21, tmp21, 2, ctx);
    SQRT(tmp21, tmp21, ctx);
    MUL_SI(tmp21, tmp21, 5, ctx);
    ADD(tmp19, tmp20, tmp21, ctx);
    SUB_SI(tmp19, tmp19, 8, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp18, 2, ctx);
    ADD_SI(tmp18, tmp18, 2, ctx);
    SQRT(tmp18, tmp18, ctx);
    ADD_SI(tmp18, tmp18, 2, ctx);
    MUL(tmp16, tmp17, tmp18, ctx);
    SQRT_UI(tmp21, 2, ctx);
    ADD_SI(tmp21, tmp21, 2, ctx);
    SQRT(tmp21, tmp21, ctx);
    ADD_SI(tmp21, tmp21, 1, ctx);
    SQRT_UI(tmp22, 2, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    SUB_SI(tmp22, tmp22, 1, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp21, 2, ctx);
    ADD_SI(tmp21, tmp21, 2, ctx);
    SQRT(tmp21, tmp21, ctx);
    ADD(tmp19, tmp20, tmp21, ctx);
    ADD_SI(tmp19, tmp19, 1, ctx);
    POW_UI(tmp19, tmp19, 2, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    ADD_SI(tmp23, tmp23, 1, ctx);
    SQRT_UI(tmp24, 2, ctx);
    ADD_SI(tmp24, tmp24, 2, ctx);
    SQRT(tmp24, tmp24, ctx);
    SUB_SI(tmp24, tmp24, 1, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    SUB(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp29, 2, ctx);
    SQRT_UI(tmp30, 2, ctx);
    ADD_SI(tmp30, tmp30, 2, ctx);
    SQRT(tmp30, tmp30, ctx);
    ADD(tmp28, tmp29, tmp30, ctx);
    SQRT_UI(tmp29, 2, ctx);
    ADD_SI(tmp29, tmp29, 2, ctx);
    SQRT(tmp29, tmp29, ctx);
    SUB_SI(tmp29, tmp29, 1, ctx);
    SQRT(tmp29, tmp29, ctx);
    MUL(tmp27, tmp28, tmp29, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, 3, ctx);
    ADD(tmp26, tmp27, tmp28, ctx);
    SQRT_UI(tmp27, 2, ctx);
    ADD_SI(tmp27, tmp27, 2, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL_SI(tmp27, tmp27, 5, ctx);
    SUB(tmp25, tmp26, tmp27, ctx);
    ADD_SI(tmp25, tmp25, 8, ctx);
    SQRT_UI(tmp30, 2, ctx);
    SQRT_UI(tmp31, 2, ctx);
    ADD_SI(tmp31, tmp31, 2, ctx);
    SQRT(tmp31, tmp31, ctx);
    ADD(tmp29, tmp30, tmp31, ctx);
    SQRT_UI(tmp30, 2, ctx);
    ADD_SI(tmp30, tmp30, 2, ctx);
    SQRT(tmp30, tmp30, ctx);
    SUB_SI(tmp30, tmp30, 1, ctx);
    SQRT(tmp30, tmp30, ctx);
    MUL(tmp28, tmp29, tmp30, ctx);
    SQRT_UI(tmp29, 2, ctx);
    MUL_SI(tmp29, tmp29, 3, ctx);
    SUB(tmp27, tmp28, tmp29, ctx);
    SQRT_UI(tmp28, 2, ctx);
    ADD_SI(tmp28, tmp28, 2, ctx);
    SQRT(tmp28, tmp28, ctx);
    MUL_SI(tmp28, tmp28, 5, ctx);
    ADD(tmp26, tmp27, tmp28, ctx);
    SUB_SI(tmp26, tmp26, 8, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    SQRT_UI(tmp25, 2, ctx);
    ADD_SI(tmp25, tmp25, 2, ctx);
    SQRT(tmp25, tmp25, ctx);
    ADD_SI(tmp25, tmp25, 2, ctx);
    MUL(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp27, 2, ctx);
    ADD_SI(tmp27, tmp27, 2, ctx);
    SQRT(tmp27, tmp27, ctx);
    ADD_SI(tmp27, tmp27, 1, ctx);
    SQRT_UI(tmp28, 2, ctx);
    ADD_SI(tmp28, tmp28, 2, ctx);
    SQRT(tmp28, tmp28, ctx);
    SUB_SI(tmp28, tmp28, 1, ctx);
    SQRT(tmp28, tmp28, ctx);
    MUL(tmp26, tmp27, tmp28, ctx);
    SQRT_UI(tmp27, 2, ctx);
    ADD_SI(tmp27, tmp27, 2, ctx);
    SQRT(tmp27, tmp27, ctx);
    ADD(tmp25, tmp26, tmp27, ctx);
    ADD_SI(tmp25, tmp25, 1, ctx);
    SQRT_UI(tmp26, 2, ctx);
    ADD_SI(tmp26, tmp26, 2, ctx);
    SQRT(tmp26, tmp26, ctx);
    SUB_SI(tmp26, tmp26, 2, ctx);
    POW_UI(tmp26, tmp26, 3, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    DIV(tmp22, tmp23, tmp24, ctx);
    SUB(tmp20, tmp21, tmp22, ctx);
    SUB_SI(tmp20, tmp20, 1, ctx);
    MUL(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp19, 2, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    SUB_SI(tmp19, tmp19, 2, ctx);
    POW_UI(tmp19, tmp19, 3, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    DIV(tmp15, tmp16, tmp17, ctx);
    ADD(tmp13, tmp14, tmp15, ctx);
    MUL(tmp11, tmp12, tmp13, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, 3, ctx);
    SUB_SI(tmp24, tmp24, 4, ctx);
    MUL_SI(tmp24, tmp24, 3, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, -17, ctx);
    ADD_SI(tmp25, tmp25, 26, ctx);
    SQRT(tmp25, tmp25, ctx);
    MUL(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, 85, ctx);
    SUB(tmp22, tmp23, tmp24, ctx);
    ADD_SI(tmp22, tmp22, 122, ctx);
    SQRT_UI(tmp23, 2, ctx);
    NEG(tmp23, tmp23, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 7, ctx);
    SUB_SI(tmp23, tmp23, 10, ctx);
    MUL_SI(tmp23, tmp23, 11, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, -17, ctx);
    ADD_SI(tmp24, tmp24, 26, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    SUB(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, 630, ctx);
    ADD(tmp19, tmp20, tmp21, ctx);
    SUB_SI(tmp19, tmp19, 890, ctx);
    MUL_SI(tmp19, tmp19, 2, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, 3, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, -17, ctx);
    ADD_SI(tmp22, tmp22, 26, ctx);
    SQRT(tmp22, tmp22, ctx);
    ADD(tmp20, tmp21, tmp22, ctx);
    SUB_SI(tmp20, tmp20, 3, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp19, 2, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    SUB_SI(tmp19, tmp19, 1, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, 4896, ctx);
    SUB_SI(tmp19, tmp19, 6923, ctx);
    MUL_SI(tmp19, tmp19, 2, ctx);
    SQRT_UI(tmp20, 2, ctx);
    ADD_SI(tmp20, tmp20, 2, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL(tmp18, tmp19, tmp20, ctx);
    SUB(tmp16, tmp17, tmp18, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, 79, ctx);
    SUB_SI(tmp21, tmp21, 112, ctx);
    MUL_SI(tmp21, tmp21, 20, ctx);
    SQRT_UI(tmp22, 2, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, 27, ctx);
    SUB_SI(tmp24, tmp24, 38, ctx);
    MUL_SI(tmp24, tmp24, 7, ctx);
    SQRT_UI(tmp25, 2, ctx);
    ADD_SI(tmp25, tmp25, 2, ctx);
    SQRT(tmp25, tmp25, ctx);
    MUL(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, 342, ctx);
    SUB(tmp22, tmp23, tmp24, ctx);
    ADD_SI(tmp22, tmp22, 484, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, -17, ctx);
    ADD_SI(tmp23, tmp23, 26, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SUB(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp20, 2, ctx);
    MUL_SI(tmp20, tmp20, 2820, ctx);
    SUB(tmp18, tmp19, tmp20, ctx);
    ADD_SI(tmp18, tmp18, 3992, ctx);
    SQRT_UI(tmp19, 2, ctx);
    NEG(tmp19, tmp19, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    ADD(tmp15, tmp16, tmp17, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, 2, ctx);
    SUB_SI(tmp28, tmp28, 3, ctx);
    MUL_SI(tmp28, tmp28, 3, ctx);
    SQRT_UI(tmp29, 2, ctx);
    MUL_SI(tmp29, tmp29, -17, ctx);
    ADD_SI(tmp29, tmp29, 26, ctx);
    SQRT(tmp29, tmp29, ctx);
    MUL(tmp27, tmp28, tmp29, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, 61, ctx);
    SUB(tmp26, tmp27, tmp28, ctx);
    ADD_SI(tmp26, tmp26, 85, ctx);
    SQRT_UI(tmp27, 2, ctx);
    NEG(tmp27, tmp27, ctx);
    ADD_SI(tmp27, tmp27, 2, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL(tmp25, tmp26, tmp27, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, 5, ctx);
    SUB_SI(tmp27, tmp27, 7, ctx);
    MUL_SI(tmp27, tmp27, 11, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, -17, ctx);
    ADD_SI(tmp28, tmp28, 26, ctx);
    SQRT(tmp28, tmp28, ctx);
    MUL(tmp26, tmp27, tmp28, ctx);
    SUB(tmp24, tmp25, tmp26, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, 445, ctx);
    ADD(tmp23, tmp24, tmp25, ctx);
    SUB_SI(tmp23, tmp23, 630, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, 3, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, -17, ctx);
    ADD_SI(tmp26, tmp26, 26, ctx);
    SQRT(tmp26, tmp26, ctx);
    ADD(tmp24, tmp25, tmp26, ctx);
    SUB_SI(tmp24, tmp24, 3, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    SUB_SI(tmp23, tmp23, 1, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 89, ctx);
    SUB_SI(tmp23, tmp23, 126, ctx);
    MUL_SI(tmp23, tmp23, 10, ctx);
    SQRT_UI(tmp24, 2, ctx);
    ADD_SI(tmp24, tmp24, 2, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    SUB(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, 61, ctx);
    SUB_SI(tmp25, tmp25, 85, ctx);
    SQRT_UI(tmp26, 2, ctx);
    ADD_SI(tmp26, tmp26, 2, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, 2, ctx);
    SUB_SI(tmp28, tmp28, 3, ctx);
    SQRT_UI(tmp29, 2, ctx);
    ADD_SI(tmp29, tmp29, 2, ctx);
    SQRT(tmp29, tmp29, ctx);
    MUL(tmp27, tmp28, tmp29, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, 2, ctx);
    SUB(tmp26, tmp27, tmp28, ctx);
    ADD_SI(tmp26, tmp26, 3, ctx);
    MUL_SI(tmp26, tmp26, 3, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, -17, ctx);
    ADD_SI(tmp27, tmp27, 26, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL(tmp25, tmp26, tmp27, ctx);
    SUB(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, 61, ctx);
    SUB(tmp22, tmp23, tmp24, ctx);
    ADD_SI(tmp22, tmp22, 85, ctx);
    MUL_SI(tmp22, tmp22, 2, ctx);
    SQRT_UI(tmp23, 2, ctx);
    NEG(tmp23, tmp23, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    ADD(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 5, ctx);
    SUB_SI(tmp23, tmp23, 7, ctx);
    SQRT_UI(tmp24, 2, ctx);
    ADD_SI(tmp24, tmp24, 2, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 5, ctx);
    SUB(tmp21, tmp22, tmp23, ctx);
    ADD_SI(tmp21, tmp21, 7, ctx);
    MUL_SI(tmp21, tmp21, 22, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, -17, ctx);
    ADD_SI(tmp22, tmp22, 26, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    ADD(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, 890, ctx);
    ADD(tmp17, tmp18, tmp19, ctx);
    SUB_SI(tmp17, tmp17, 1260, ctx);
    SQRT_UI(tmp20, 2, ctx);
    MUL_SI(tmp20, tmp20, -12, ctx);
    SQRT_UI(tmp21, 2, ctx);
    NEG(tmp21, tmp21, ctx);
    ADD_SI(tmp21, tmp21, 2, ctx);
    SQRT(tmp21, tmp21, ctx);
    MUL_SI(tmp21, tmp21, 2, ctx);
    SUB(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp20, 2, ctx);
    MUL_SI(tmp20, tmp20, -17, ctx);
    ADD_SI(tmp20, tmp20, 26, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL_SI(tmp20, tmp20, 2, ctx);
    SUB(tmp18, tmp19, tmp20, ctx);
    ADD_SI(tmp18, tmp18, 24, ctx);
    SQRT(tmp18, tmp18, ctx);
    MUL(tmp16, tmp17, tmp18, ctx);
    ADD(tmp14, tmp15, tmp16, ctx);
    SQRT_UI(tmp18, 2, ctx);
    MUL_SI(tmp18, tmp18, 319, ctx);
    SUB_SI(tmp18, tmp18, 452, ctx);
    SQRT_UI(tmp19, 2, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp18, 2, ctx);
    MUL_SI(tmp18, tmp18, 561, ctx);
    SUB(tmp16, tmp17, tmp18, ctx);
    ADD_SI(tmp16, tmp16, 794, ctx);
    MUL_SI(tmp16, tmp16, 4, ctx);
    SQRT_UI(tmp17, 2, ctx);
    MUL_SI(tmp17, tmp17, -17, ctx);
    ADD_SI(tmp17, tmp17, 26, ctx);
    SQRT(tmp17, tmp17, ctx);
    MUL(tmp15, tmp16, tmp17, ctx);
    ADD(tmp13, tmp14, tmp15, ctx);
    SQRT_UI(tmp14, 2, ctx);
    MUL_SI(tmp14, tmp14, 17064, ctx);
    ADD(tmp12, tmp13, tmp14, ctx);
    SUB_SI(tmp12, tmp12, 24132, ctx);
    DIV(tmp10, tmp11, tmp12, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, 7, ctx);
    SUB_SI(tmp21, tmp21, 10, ctx);
    MUL_SI(tmp21, tmp21, 44, ctx);
    SQRT_UI(tmp22, 2, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, -17, ctx);
    ADD_SI(tmp21, tmp21, 26, ctx);
    SQRT(tmp21, tmp21, ctx);
    MUL(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, 7, ctx);
    SUB_SI(tmp26, tmp26, 10, ctx);
    MUL_SI(tmp26, tmp26, 11, ctx);
    SQRT_UI(tmp27, 2, ctx);
    ADD_SI(tmp27, tmp27, 2, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL(tmp25, tmp26, tmp27, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, -17, ctx);
    ADD_SI(tmp26, tmp26, 26, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, 63, ctx);
    SUB_SI(tmp26, tmp26, 89, ctx);
    MUL_SI(tmp26, tmp26, 10, ctx);
    SQRT_UI(tmp27, 2, ctx);
    ADD_SI(tmp27, tmp27, 2, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL(tmp25, tmp26, tmp27, ctx);
    SUB(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, 3, ctx);
    SUB_SI(tmp28, tmp28, 4, ctx);
    MUL_SI(tmp28, tmp28, 3, ctx);
    SQRT_UI(tmp29, 2, ctx);
    ADD_SI(tmp29, tmp29, 2, ctx);
    SQRT(tmp29, tmp29, ctx);
    MUL(tmp27, tmp28, tmp29, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, -17, ctx);
    ADD_SI(tmp28, tmp28, 26, ctx);
    SQRT(tmp28, tmp28, ctx);
    MUL(tmp26, tmp27, tmp28, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, 85, ctx);
    SUB_SI(tmp28, tmp28, 122, ctx);
    SQRT_UI(tmp29, 2, ctx);
    ADD_SI(tmp29, tmp29, 2, ctx);
    SQRT(tmp29, tmp29, ctx);
    MUL(tmp27, tmp28, tmp29, ctx);
    SUB(tmp25, tmp26, tmp27, ctx);
    SQRT_UI(tmp26, 2, ctx);
    NEG(tmp26, tmp26, ctx);
    ADD_SI(tmp26, tmp26, 2, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    SUB(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp29, 2, ctx);
    MUL_SI(tmp29, tmp29, 3, ctx);
    SUB_SI(tmp29, tmp29, 4, ctx);
    MUL_SI(tmp29, tmp29, 3, ctx);
    SQRT_UI(tmp30, 2, ctx);
    MUL_SI(tmp30, tmp30, -17, ctx);
    ADD_SI(tmp30, tmp30, 26, ctx);
    SQRT(tmp30, tmp30, ctx);
    MUL(tmp28, tmp29, tmp30, ctx);
    SQRT_UI(tmp29, 2, ctx);
    MUL_SI(tmp29, tmp29, 85, ctx);
    SUB(tmp27, tmp28, tmp29, ctx);
    ADD_SI(tmp27, tmp27, 122, ctx);
    SQRT_UI(tmp28, 2, ctx);
    NEG(tmp28, tmp28, ctx);
    ADD_SI(tmp28, tmp28, 2, ctx);
    SQRT(tmp28, tmp28, ctx);
    MUL(tmp26, tmp27, tmp28, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, 7, ctx);
    SUB_SI(tmp28, tmp28, 10, ctx);
    MUL_SI(tmp28, tmp28, 11, ctx);
    SQRT_UI(tmp29, 2, ctx);
    MUL_SI(tmp29, tmp29, -17, ctx);
    ADD_SI(tmp29, tmp29, 26, ctx);
    SQRT(tmp29, tmp29, ctx);
    MUL(tmp27, tmp28, tmp29, ctx);
    SUB(tmp25, tmp26, tmp27, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, 630, ctx);
    ADD(tmp24, tmp25, tmp26, ctx);
    SUB_SI(tmp24, tmp24, 890, ctx);
    MUL_SI(tmp24, tmp24, 2, ctx);
    SQRT_UI(tmp25, 2, ctx);
    ADD_SI(tmp25, tmp25, 2, ctx);
    SQRT(tmp25, tmp25, ctx);
    SUB_SI(tmp25, tmp25, 1, ctx);
    SQRT(tmp25, tmp25, ctx);
    MUL(tmp23, tmp24, tmp25, ctx);
    ADD(tmp21, tmp22, tmp23, ctx);
    MUL_SI(tmp21, tmp21, 2, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 3, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, -17, ctx);
    ADD_SI(tmp24, tmp24, 26, ctx);
    SQRT(tmp24, tmp24, ctx);
    ADD(tmp22, tmp23, tmp24, ctx);
    SUB_SI(tmp22, tmp22, 3, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    ADD(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp20, 2, ctx);
    MUL_SI(tmp20, tmp20, 63, ctx);
    SUB_SI(tmp20, tmp20, 89, ctx);
    MUL_SI(tmp20, tmp20, 40, ctx);
    SQRT_UI(tmp21, 2, ctx);
    ADD_SI(tmp21, tmp21, 2, ctx);
    SQRT(tmp21, tmp21, ctx);
    MUL(tmp19, tmp20, tmp21, ctx);
    SUB(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, 3, ctx);
    SUB_SI(tmp22, tmp22, 4, ctx);
    MUL_SI(tmp22, tmp22, 3, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, -17, ctx);
    ADD_SI(tmp22, tmp22, 26, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, 85, ctx);
    SUB_SI(tmp22, tmp22, 122, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SUB(tmp19, tmp20, tmp21, ctx);
    MUL_SI(tmp19, tmp19, 4, ctx);
    SQRT_UI(tmp20, 2, ctx);
    NEG(tmp20, tmp20, ctx);
    ADD_SI(tmp20, tmp20, 2, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL(tmp18, tmp19, tmp20, ctx);
    SUB(tmp16, tmp17, tmp18, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, 5, ctx);
    SUB_SI(tmp24, tmp24, 7, ctx);
    MUL_SI(tmp24, tmp24, 22, ctx);
    SQRT_UI(tmp25, 2, ctx);
    ADD_SI(tmp25, tmp25, 2, ctx);
    SQRT(tmp25, tmp25, ctx);
    MUL(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, -17, ctx);
    ADD_SI(tmp24, tmp24, 26, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp29, 2, ctx);
    MUL_SI(tmp29, tmp29, 5, ctx);
    SUB_SI(tmp29, tmp29, 7, ctx);
    MUL_SI(tmp29, tmp29, 11, ctx);
    SQRT_UI(tmp30, 2, ctx);
    ADD_SI(tmp30, tmp30, 2, ctx);
    SQRT(tmp30, tmp30, ctx);
    MUL(tmp28, tmp29, tmp30, ctx);
    SQRT_UI(tmp29, 2, ctx);
    MUL_SI(tmp29, tmp29, -17, ctx);
    ADD_SI(tmp29, tmp29, 26, ctx);
    SQRT(tmp29, tmp29, ctx);
    MUL(tmp27, tmp28, tmp29, ctx);
    SQRT_UI(tmp29, 2, ctx);
    MUL_SI(tmp29, tmp29, 89, ctx);
    SUB_SI(tmp29, tmp29, 126, ctx);
    MUL_SI(tmp29, tmp29, 5, ctx);
    SQRT_UI(tmp30, 2, ctx);
    ADD_SI(tmp30, tmp30, 2, ctx);
    SQRT(tmp30, tmp30, ctx);
    MUL(tmp28, tmp29, tmp30, ctx);
    SUB(tmp26, tmp27, tmp28, ctx);
    SQRT_UI(tmp31, 2, ctx);
    MUL_SI(tmp31, tmp31, 2, ctx);
    SUB_SI(tmp31, tmp31, 3, ctx);
    MUL_SI(tmp31, tmp31, 3, ctx);
    SQRT_UI(tmp32, 2, ctx);
    ADD_SI(tmp32, tmp32, 2, ctx);
    SQRT(tmp32, tmp32, ctx);
    MUL(tmp30, tmp31, tmp32, ctx);
    SQRT_UI(tmp31, 2, ctx);
    MUL_SI(tmp31, tmp31, -17, ctx);
    ADD_SI(tmp31, tmp31, 26, ctx);
    SQRT(tmp31, tmp31, ctx);
    MUL(tmp29, tmp30, tmp31, ctx);
    SQRT_UI(tmp31, 2, ctx);
    MUL_SI(tmp31, tmp31, 61, ctx);
    SUB_SI(tmp31, tmp31, 85, ctx);
    SQRT_UI(tmp32, 2, ctx);
    ADD_SI(tmp32, tmp32, 2, ctx);
    SQRT(tmp32, tmp32, ctx);
    MUL(tmp30, tmp31, tmp32, ctx);
    SUB(tmp28, tmp29, tmp30, ctx);
    SQRT_UI(tmp29, 2, ctx);
    NEG(tmp29, tmp29, ctx);
    ADD_SI(tmp29, tmp29, 2, ctx);
    SQRT(tmp29, tmp29, ctx);
    MUL(tmp27, tmp28, tmp29, ctx);
    SUB(tmp25, tmp26, tmp27, ctx);
    SQRT_UI(tmp32, 2, ctx);
    MUL_SI(tmp32, tmp32, 2, ctx);
    SUB_SI(tmp32, tmp32, 3, ctx);
    MUL_SI(tmp32, tmp32, 3, ctx);
    SQRT_UI(tmp33, 2, ctx);
    MUL_SI(tmp33, tmp33, -17, ctx);
    ADD_SI(tmp33, tmp33, 26, ctx);
    SQRT(tmp33, tmp33, ctx);
    MUL(tmp31, tmp32, tmp33, ctx);
    SQRT_UI(tmp32, 2, ctx);
    MUL_SI(tmp32, tmp32, 61, ctx);
    SUB(tmp30, tmp31, tmp32, ctx);
    ADD_SI(tmp30, tmp30, 85, ctx);
    SQRT_UI(tmp31, 2, ctx);
    NEG(tmp31, tmp31, ctx);
    ADD_SI(tmp31, tmp31, 2, ctx);
    SQRT(tmp31, tmp31, ctx);
    MUL(tmp29, tmp30, tmp31, ctx);
    SQRT_UI(tmp31, 2, ctx);
    MUL_SI(tmp31, tmp31, 5, ctx);
    SUB_SI(tmp31, tmp31, 7, ctx);
    MUL_SI(tmp31, tmp31, 11, ctx);
    SQRT_UI(tmp32, 2, ctx);
    MUL_SI(tmp32, tmp32, -17, ctx);
    ADD_SI(tmp32, tmp32, 26, ctx);
    SQRT(tmp32, tmp32, ctx);
    MUL(tmp30, tmp31, tmp32, ctx);
    SUB(tmp28, tmp29, tmp30, ctx);
    SQRT_UI(tmp29, 2, ctx);
    MUL_SI(tmp29, tmp29, 445, ctx);
    ADD(tmp27, tmp28, tmp29, ctx);
    SUB_SI(tmp27, tmp27, 630, ctx);
    MUL_SI(tmp27, tmp27, 2, ctx);
    SQRT_UI(tmp28, 2, ctx);
    ADD_SI(tmp28, tmp28, 2, ctx);
    SQRT(tmp28, tmp28, ctx);
    SUB_SI(tmp28, tmp28, 1, ctx);
    SQRT(tmp28, tmp28, ctx);
    MUL(tmp26, tmp27, tmp28, ctx);
    ADD(tmp24, tmp25, tmp26, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, 3, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, -17, ctx);
    ADD_SI(tmp27, tmp27, 26, ctx);
    SQRT(tmp27, tmp27, ctx);
    ADD(tmp25, tmp26, tmp27, ctx);
    SUB_SI(tmp25, tmp25, 3, ctx);
    SQRT(tmp25, tmp25, ctx);
    MUL(tmp23, tmp24, tmp25, ctx);
    ADD(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 89, ctx);
    SUB_SI(tmp23, tmp23, 126, ctx);
    MUL_SI(tmp23, tmp23, 10, ctx);
    SQRT_UI(tmp24, 2, ctx);
    ADD_SI(tmp24, tmp24, 2, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    SUB(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, 2, ctx);
    SUB_SI(tmp25, tmp25, 3, ctx);
    MUL_SI(tmp25, tmp25, 3, ctx);
    SQRT_UI(tmp26, 2, ctx);
    ADD_SI(tmp26, tmp26, 2, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, -17, ctx);
    ADD_SI(tmp25, tmp25, 26, ctx);
    SQRT(tmp25, tmp25, ctx);
    MUL(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, 61, ctx);
    SUB_SI(tmp25, tmp25, 85, ctx);
    SQRT_UI(tmp26, 2, ctx);
    ADD_SI(tmp26, tmp26, 2, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    SUB(tmp22, tmp23, tmp24, ctx);
    MUL_SI(tmp22, tmp22, 2, ctx);
    SQRT_UI(tmp23, 2, ctx);
    NEG(tmp23, tmp23, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SUB(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, 2, ctx);
    SUB_SI(tmp26, tmp26, 3, ctx);
    MUL_SI(tmp26, tmp26, 3, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, -17, ctx);
    ADD_SI(tmp27, tmp27, 26, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL(tmp25, tmp26, tmp27, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, 61, ctx);
    SUB(tmp24, tmp25, tmp26, ctx);
    ADD_SI(tmp24, tmp24, 85, ctx);
    SQRT_UI(tmp25, 2, ctx);
    NEG(tmp25, tmp25, ctx);
    ADD_SI(tmp25, tmp25, 2, ctx);
    SQRT(tmp25, tmp25, ctx);
    MUL(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, 5, ctx);
    SUB_SI(tmp25, tmp25, 7, ctx);
    MUL_SI(tmp25, tmp25, 11, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, -17, ctx);
    ADD_SI(tmp26, tmp26, 26, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    SUB(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 445, ctx);
    ADD(tmp21, tmp22, tmp23, ctx);
    SUB_SI(tmp21, tmp21, 630, ctx);
    MUL_SI(tmp21, tmp21, 4, ctx);
    SQRT_UI(tmp22, 2, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    SUB_SI(tmp22, tmp22, 1, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    ADD(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, -12, ctx);
    SQRT_UI(tmp22, 2, ctx);
    NEG(tmp22, tmp22, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL_SI(tmp22, tmp22, 2, ctx);
    SUB(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, -17, ctx);
    ADD_SI(tmp21, tmp21, 26, ctx);
    SQRT(tmp21, tmp21, ctx);
    MUL_SI(tmp21, tmp21, 2, ctx);
    SUB(tmp19, tmp20, tmp21, ctx);
    ADD_SI(tmp19, tmp19, 24, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    ADD(tmp15, tmp16, tmp17, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, 3, ctx);
    SUB_SI(tmp22, tmp22, 4, ctx);
    MUL_SI(tmp22, tmp22, 3, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, -17, ctx);
    ADD_SI(tmp23, tmp23, 26, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, 85, ctx);
    SUB(tmp20, tmp21, tmp22, ctx);
    ADD_SI(tmp20, tmp20, 122, ctx);
    SQRT_UI(tmp21, 2, ctx);
    NEG(tmp21, tmp21, ctx);
    ADD_SI(tmp21, tmp21, 2, ctx);
    SQRT(tmp21, tmp21, ctx);
    MUL(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, 7, ctx);
    SUB_SI(tmp21, tmp21, 10, ctx);
    MUL_SI(tmp21, tmp21, 11, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, -17, ctx);
    ADD_SI(tmp22, tmp22, 26, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SUB(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, 630, ctx);
    ADD(tmp17, tmp18, tmp19, ctx);
    SUB_SI(tmp17, tmp17, 890, ctx);
    MUL_SI(tmp17, tmp17, 8, ctx);
    SQRT_UI(tmp18, 2, ctx);
    ADD_SI(tmp18, tmp18, 2, ctx);
    SQRT(tmp18, tmp18, ctx);
    SUB_SI(tmp18, tmp18, 1, ctx);
    SQRT(tmp18, tmp18, ctx);
    MUL(tmp16, tmp17, tmp18, ctx);
    ADD(tmp14, tmp15, tmp16, ctx);
    SQRT_UI(tmp19, 2, ctx);
    SQRT_UI(tmp20, 2, ctx);
    ADD_SI(tmp20, tmp20, 2, ctx);
    SQRT(tmp20, tmp20, ctx);
    ADD(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp19, 2, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    SUB_SI(tmp19, tmp19, 1, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp18, 2, ctx);
    MUL_SI(tmp18, tmp18, 3, ctx);
    ADD(tmp16, tmp17, tmp18, ctx);
    SQRT_UI(tmp17, 2, ctx);
    ADD_SI(tmp17, tmp17, 2, ctx);
    SQRT(tmp17, tmp17, ctx);
    MUL_SI(tmp17, tmp17, 5, ctx);
    SUB(tmp15, tmp16, tmp17, ctx);
    ADD_SI(tmp15, tmp15, 8, ctx);
    MUL(tmp13, tmp14, tmp15, ctx);
    SQRT_UI(tmp14, 2, ctx);
    ADD_SI(tmp14, tmp14, 2, ctx);
    SQRT(tmp14, tmp14, ctx);
    ADD_SI(tmp14, tmp14, 2, ctx);
    SQRT(tmp14, tmp14, ctx);
    MUL(tmp12, tmp13, tmp14, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, 3, ctx);
    SUB_SI(tmp28, tmp28, 4, ctx);
    MUL_SI(tmp28, tmp28, 3, ctx);
    SQRT_UI(tmp29, 2, ctx);
    MUL_SI(tmp29, tmp29, -17, ctx);
    ADD_SI(tmp29, tmp29, 26, ctx);
    SQRT(tmp29, tmp29, ctx);
    MUL(tmp27, tmp28, tmp29, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, 85, ctx);
    SUB(tmp26, tmp27, tmp28, ctx);
    ADD_SI(tmp26, tmp26, 122, ctx);
    SQRT_UI(tmp27, 2, ctx);
    NEG(tmp27, tmp27, ctx);
    ADD_SI(tmp27, tmp27, 2, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL(tmp25, tmp26, tmp27, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, 7, ctx);
    SUB_SI(tmp27, tmp27, 10, ctx);
    MUL_SI(tmp27, tmp27, 11, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, -17, ctx);
    ADD_SI(tmp28, tmp28, 26, ctx);
    SQRT(tmp28, tmp28, ctx);
    MUL(tmp26, tmp27, tmp28, ctx);
    SUB(tmp24, tmp25, tmp26, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, 630, ctx);
    ADD(tmp23, tmp24, tmp25, ctx);
    SUB_SI(tmp23, tmp23, 890, ctx);
    MUL_SI(tmp23, tmp23, 2, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, 3, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, -17, ctx);
    ADD_SI(tmp26, tmp26, 26, ctx);
    SQRT(tmp26, tmp26, ctx);
    ADD(tmp24, tmp25, tmp26, ctx);
    SUB_SI(tmp24, tmp24, 3, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    SUB_SI(tmp23, tmp23, 1, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 4896, ctx);
    SUB_SI(tmp23, tmp23, 6923, ctx);
    MUL_SI(tmp23, tmp23, 2, ctx);
    SQRT_UI(tmp24, 2, ctx);
    ADD_SI(tmp24, tmp24, 2, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    SUB(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, 79, ctx);
    SUB_SI(tmp25, tmp25, 112, ctx);
    MUL_SI(tmp25, tmp25, 20, ctx);
    SQRT_UI(tmp26, 2, ctx);
    ADD_SI(tmp26, tmp26, 2, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, 27, ctx);
    SUB_SI(tmp28, tmp28, 38, ctx);
    MUL_SI(tmp28, tmp28, 7, ctx);
    SQRT_UI(tmp29, 2, ctx);
    ADD_SI(tmp29, tmp29, 2, ctx);
    SQRT(tmp29, tmp29, ctx);
    MUL(tmp27, tmp28, tmp29, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, 342, ctx);
    SUB(tmp26, tmp27, tmp28, ctx);
    ADD_SI(tmp26, tmp26, 484, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, -17, ctx);
    ADD_SI(tmp27, tmp27, 26, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL(tmp25, tmp26, tmp27, ctx);
    SUB(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, 2820, ctx);
    SUB(tmp22, tmp23, tmp24, ctx);
    ADD_SI(tmp22, tmp22, 3992, ctx);
    SQRT_UI(tmp23, 2, ctx);
    NEG(tmp23, tmp23, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    ADD(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp32, 2, ctx);
    MUL_SI(tmp32, tmp32, 2, ctx);
    SUB_SI(tmp32, tmp32, 3, ctx);
    MUL_SI(tmp32, tmp32, 3, ctx);
    SQRT_UI(tmp33, 2, ctx);
    MUL_SI(tmp33, tmp33, -17, ctx);
    ADD_SI(tmp33, tmp33, 26, ctx);
    SQRT(tmp33, tmp33, ctx);
    MUL(tmp31, tmp32, tmp33, ctx);
    SQRT_UI(tmp32, 2, ctx);
    MUL_SI(tmp32, tmp32, 61, ctx);
    SUB(tmp30, tmp31, tmp32, ctx);
    ADD_SI(tmp30, tmp30, 85, ctx);
    SQRT_UI(tmp31, 2, ctx);
    NEG(tmp31, tmp31, ctx);
    ADD_SI(tmp31, tmp31, 2, ctx);
    SQRT(tmp31, tmp31, ctx);
    MUL(tmp29, tmp30, tmp31, ctx);
    SQRT_UI(tmp31, 2, ctx);
    MUL_SI(tmp31, tmp31, 5, ctx);
    SUB_SI(tmp31, tmp31, 7, ctx);
    MUL_SI(tmp31, tmp31, 11, ctx);
    SQRT_UI(tmp32, 2, ctx);
    MUL_SI(tmp32, tmp32, -17, ctx);
    ADD_SI(tmp32, tmp32, 26, ctx);
    SQRT(tmp32, tmp32, ctx);
    MUL(tmp30, tmp31, tmp32, ctx);
    SUB(tmp28, tmp29, tmp30, ctx);
    SQRT_UI(tmp29, 2, ctx);
    MUL_SI(tmp29, tmp29, 445, ctx);
    ADD(tmp27, tmp28, tmp29, ctx);
    SUB_SI(tmp27, tmp27, 630, ctx);
    SQRT_UI(tmp29, 2, ctx);
    MUL_SI(tmp29, tmp29, 3, ctx);
    SQRT_UI(tmp30, 2, ctx);
    MUL_SI(tmp30, tmp30, -17, ctx);
    ADD_SI(tmp30, tmp30, 26, ctx);
    SQRT(tmp30, tmp30, ctx);
    ADD(tmp28, tmp29, tmp30, ctx);
    SUB_SI(tmp28, tmp28, 3, ctx);
    SQRT(tmp28, tmp28, ctx);
    MUL(tmp26, tmp27, tmp28, ctx);
    SQRT_UI(tmp27, 2, ctx);
    ADD_SI(tmp27, tmp27, 2, ctx);
    SQRT(tmp27, tmp27, ctx);
    SUB_SI(tmp27, tmp27, 1, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL(tmp25, tmp26, tmp27, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, 89, ctx);
    SUB_SI(tmp27, tmp27, 126, ctx);
    MUL_SI(tmp27, tmp27, 10, ctx);
    SQRT_UI(tmp28, 2, ctx);
    ADD_SI(tmp28, tmp28, 2, ctx);
    SQRT(tmp28, tmp28, ctx);
    MUL(tmp26, tmp27, tmp28, ctx);
    SUB(tmp24, tmp25, tmp26, ctx);
    SQRT_UI(tmp29, 2, ctx);
    MUL_SI(tmp29, tmp29, 61, ctx);
    SUB_SI(tmp29, tmp29, 85, ctx);
    SQRT_UI(tmp30, 2, ctx);
    ADD_SI(tmp30, tmp30, 2, ctx);
    SQRT(tmp30, tmp30, ctx);
    MUL(tmp28, tmp29, tmp30, ctx);
    SQRT_UI(tmp32, 2, ctx);
    MUL_SI(tmp32, tmp32, 2, ctx);
    SUB_SI(tmp32, tmp32, 3, ctx);
    SQRT_UI(tmp33, 2, ctx);
    ADD_SI(tmp33, tmp33, 2, ctx);
    SQRT(tmp33, tmp33, ctx);
    MUL(tmp31, tmp32, tmp33, ctx);
    SQRT_UI(tmp32, 2, ctx);
    MUL_SI(tmp32, tmp32, 2, ctx);
    SUB(tmp30, tmp31, tmp32, ctx);
    ADD_SI(tmp30, tmp30, 3, ctx);
    MUL_SI(tmp30, tmp30, 3, ctx);
    SQRT_UI(tmp31, 2, ctx);
    MUL_SI(tmp31, tmp31, -17, ctx);
    ADD_SI(tmp31, tmp31, 26, ctx);
    SQRT(tmp31, tmp31, ctx);
    MUL(tmp29, tmp30, tmp31, ctx);
    SUB(tmp27, tmp28, tmp29, ctx);
    SQRT_UI(tmp28, 2, ctx);
    MUL_SI(tmp28, tmp28, 61, ctx);
    SUB(tmp26, tmp27, tmp28, ctx);
    ADD_SI(tmp26, tmp26, 85, ctx);
    MUL_SI(tmp26, tmp26, 2, ctx);
    SQRT_UI(tmp27, 2, ctx);
    NEG(tmp27, tmp27, ctx);
    ADD_SI(tmp27, tmp27, 2, ctx);
    SQRT(tmp27, tmp27, ctx);
    MUL(tmp25, tmp26, tmp27, ctx);
    ADD(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, 5, ctx);
    SUB_SI(tmp27, tmp27, 7, ctx);
    SQRT_UI(tmp28, 2, ctx);
    ADD_SI(tmp28, tmp28, 2, ctx);
    SQRT(tmp28, tmp28, ctx);
    MUL(tmp26, tmp27, tmp28, ctx);
    SQRT_UI(tmp27, 2, ctx);
    MUL_SI(tmp27, tmp27, 5, ctx);
    SUB(tmp25, tmp26, tmp27, ctx);
    ADD_SI(tmp25, tmp25, 7, ctx);
    MUL_SI(tmp25, tmp25, 22, ctx);
    SQRT_UI(tmp26, 2, ctx);
    MUL_SI(tmp26, tmp26, -17, ctx);
    ADD_SI(tmp26, tmp26, 26, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    ADD(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp23, 2, ctx);
    MUL_SI(tmp23, tmp23, 890, ctx);
    ADD(tmp21, tmp22, tmp23, ctx);
    SUB_SI(tmp21, tmp21, 1260, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, -12, ctx);
    SQRT_UI(tmp25, 2, ctx);
    NEG(tmp25, tmp25, ctx);
    ADD_SI(tmp25, tmp25, 2, ctx);
    SQRT(tmp25, tmp25, ctx);
    MUL_SI(tmp25, tmp25, 2, ctx);
    SUB(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, -17, ctx);
    ADD_SI(tmp24, tmp24, 26, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL_SI(tmp24, tmp24, 2, ctx);
    SUB(tmp22, tmp23, tmp24, ctx);
    ADD_SI(tmp22, tmp22, 24, ctx);
    SQRT(tmp22, tmp22, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    ADD(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, 319, ctx);
    SUB_SI(tmp22, tmp22, 452, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL(tmp21, tmp22, tmp23, ctx);
    SQRT_UI(tmp22, 2, ctx);
    MUL_SI(tmp22, tmp22, 561, ctx);
    SUB(tmp20, tmp21, tmp22, ctx);
    ADD_SI(tmp20, tmp20, 794, ctx);
    MUL_SI(tmp20, tmp20, 4, ctx);
    SQRT_UI(tmp21, 2, ctx);
    MUL_SI(tmp21, tmp21, -17, ctx);
    ADD_SI(tmp21, tmp21, 26, ctx);
    SQRT(tmp21, tmp21, ctx);
    MUL(tmp19, tmp20, tmp21, ctx);
    ADD(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp18, 2, ctx);
    MUL_SI(tmp18, tmp18, 17064, ctx);
    ADD(tmp16, tmp17, tmp18, ctx);
    SUB_SI(tmp16, tmp16, 24132, ctx);
    SQRT_UI(tmp19, 2, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    ADD_SI(tmp19, tmp19, 1, ctx);
    SQRT_UI(tmp20, 2, ctx);
    ADD_SI(tmp20, tmp20, 2, ctx);
    SQRT(tmp20, tmp20, ctx);
    SUB_SI(tmp20, tmp20, 1, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp19, 2, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    ADD(tmp17, tmp18, tmp19, ctx);
    ADD_SI(tmp17, tmp17, 1, ctx);
    MUL(tmp15, tmp16, tmp17, ctx);
    SQRT_UI(tmp19, 2, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    ADD_SI(tmp19, tmp19, 1, ctx);
    SQRT_UI(tmp20, 2, ctx);
    ADD_SI(tmp20, tmp20, 2, ctx);
    SQRT(tmp20, tmp20, ctx);
    SUB_SI(tmp20, tmp20, 1, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp19, 2, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    SUB(tmp17, tmp18, tmp19, ctx);
    SQRT_UI(tmp25, 2, ctx);
    SQRT_UI(tmp26, 2, ctx);
    ADD_SI(tmp26, tmp26, 2, ctx);
    SQRT(tmp26, tmp26, ctx);
    ADD(tmp24, tmp25, tmp26, ctx);
    SQRT_UI(tmp25, 2, ctx);
    ADD_SI(tmp25, tmp25, 2, ctx);
    SQRT(tmp25, tmp25, ctx);
    SUB_SI(tmp25, tmp25, 1, ctx);
    SQRT(tmp25, tmp25, ctx);
    MUL(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp24, 2, ctx);
    MUL_SI(tmp24, tmp24, 3, ctx);
    ADD(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    MUL_SI(tmp23, tmp23, 5, ctx);
    SUB(tmp21, tmp22, tmp23, ctx);
    ADD_SI(tmp21, tmp21, 8, ctx);
    SQRT_UI(tmp26, 2, ctx);
    SQRT_UI(tmp27, 2, ctx);
    ADD_SI(tmp27, tmp27, 2, ctx);
    SQRT(tmp27, tmp27, ctx);
    ADD(tmp25, tmp26, tmp27, ctx);
    SQRT_UI(tmp26, 2, ctx);
    ADD_SI(tmp26, tmp26, 2, ctx);
    SQRT(tmp26, tmp26, ctx);
    SUB_SI(tmp26, tmp26, 1, ctx);
    SQRT(tmp26, tmp26, ctx);
    MUL(tmp24, tmp25, tmp26, ctx);
    SQRT_UI(tmp25, 2, ctx);
    MUL_SI(tmp25, tmp25, 3, ctx);
    SUB(tmp23, tmp24, tmp25, ctx);
    SQRT_UI(tmp24, 2, ctx);
    ADD_SI(tmp24, tmp24, 2, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL_SI(tmp24, tmp24, 5, ctx);
    ADD(tmp22, tmp23, tmp24, ctx);
    SUB_SI(tmp22, tmp22, 8, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    SQRT_UI(tmp21, 2, ctx);
    ADD_SI(tmp21, tmp21, 2, ctx);
    SQRT(tmp21, tmp21, ctx);
    ADD_SI(tmp21, tmp21, 2, ctx);
    MUL(tmp19, tmp20, tmp21, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    ADD_SI(tmp23, tmp23, 1, ctx);
    SQRT_UI(tmp24, 2, ctx);
    ADD_SI(tmp24, tmp24, 2, ctx);
    SQRT(tmp24, tmp24, ctx);
    SUB_SI(tmp24, tmp24, 1, ctx);
    SQRT(tmp24, tmp24, ctx);
    MUL(tmp22, tmp23, tmp24, ctx);
    SQRT_UI(tmp23, 2, ctx);
    ADD_SI(tmp23, tmp23, 2, ctx);
    SQRT(tmp23, tmp23, ctx);
    ADD(tmp21, tmp22, tmp23, ctx);
    ADD_SI(tmp21, tmp21, 1, ctx);
    SQRT_UI(tmp22, 2, ctx);
    ADD_SI(tmp22, tmp22, 2, ctx);
    SQRT(tmp22, tmp22, ctx);
    SUB_SI(tmp22, tmp22, 2, ctx);
    POW_UI(tmp22, tmp22, 3, ctx);
    MUL(tmp20, tmp21, tmp22, ctx);
    DIV(tmp18, tmp19, tmp20, ctx);
    SUB(tmp16, tmp17, tmp18, ctx);
    SUB_SI(tmp16, tmp16, 1, ctx);
    MUL(tmp14, tmp15, tmp16, ctx);
    SET_SI(tmp18, 1, ctx);
    DIV_SI(tmp18, tmp18, 4, ctx);
    NEG(tmp18, tmp18, ctx);
    SQRT_UI(tmp19, 2, ctx);
    ADD_SI(tmp19, tmp19, 2, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    SET_SI(tmp18, 1, ctx);
    DIV_SI(tmp18, tmp18, 2, ctx);
    ADD(tmp16, tmp17, tmp18, ctx);
    SET_SI(tmp17, 3, ctx);
    DIV_SI(tmp17, tmp17, 2, ctx);
    POW(tmp15, tmp16, tmp17, ctx);
    MUL(tmp13, tmp14, tmp15, ctx);
    DIV(tmp11, tmp12, tmp13, ctx);
    ADD(tmp9, tmp10, tmp11, ctx);
    MUL(tmp7, tmp8, tmp9, ctx);
    SQRT_UI(tmp8, 2, ctx);
    ADD_SI(tmp8, tmp8, 2, ctx);
    SQRT(tmp8, tmp8, ctx);
    SUB_SI(tmp8, tmp8, 2, ctx);
    DIV(tmp6, tmp7, tmp8, ctx);
    SUB(tmp4, tmp5, tmp6, ctx);
    MUL(tmp2, tmp3, tmp4, ctx);
    SQRT_UI(tmp15, 2, ctx);
    MUL_SI(tmp15, tmp15, 3, ctx);
    SUB_SI(tmp15, tmp15, 4, ctx);
    MUL_SI(tmp15, tmp15, 3, ctx);
    SQRT_UI(tmp16, 2, ctx);
    MUL_SI(tmp16, tmp16, -17, ctx);
    ADD_SI(tmp16, tmp16, 26, ctx);
    SQRT(tmp16, tmp16, ctx);
    MUL(tmp14, tmp15, tmp16, ctx);
    SQRT_UI(tmp15, 2, ctx);
    MUL_SI(tmp15, tmp15, 85, ctx);
    SUB(tmp13, tmp14, tmp15, ctx);
    ADD_SI(tmp13, tmp13, 122, ctx);
    SQRT_UI(tmp14, 2, ctx);
    NEG(tmp14, tmp14, ctx);
    ADD_SI(tmp14, tmp14, 2, ctx);
    SQRT(tmp14, tmp14, ctx);
    MUL(tmp12, tmp13, tmp14, ctx);
    SQRT_UI(tmp14, 2, ctx);
    MUL_SI(tmp14, tmp14, 7, ctx);
    SUB_SI(tmp14, tmp14, 10, ctx);
    MUL_SI(tmp14, tmp14, 11, ctx);
    SQRT_UI(tmp15, 2, ctx);
    MUL_SI(tmp15, tmp15, -17, ctx);
    ADD_SI(tmp15, tmp15, 26, ctx);
    SQRT(tmp15, tmp15, ctx);
    MUL(tmp13, tmp14, tmp15, ctx);
    SUB(tmp11, tmp12, tmp13, ctx);
    SQRT_UI(tmp12, 2, ctx);
    MUL_SI(tmp12, tmp12, 630, ctx);
    ADD(tmp10, tmp11, tmp12, ctx);
    SUB_SI(tmp10, tmp10, 890, ctx);
    MUL_SI(tmp10, tmp10, 2, ctx);
    SQRT_UI(tmp12, 2, ctx);
    MUL_SI(tmp12, tmp12, 3, ctx);
    SQRT_UI(tmp13, 2, ctx);
    MUL_SI(tmp13, tmp13, -17, ctx);
    ADD_SI(tmp13, tmp13, 26, ctx);
    SQRT(tmp13, tmp13, ctx);
    ADD(tmp11, tmp12, tmp13, ctx);
    SUB_SI(tmp11, tmp11, 3, ctx);
    SQRT(tmp11, tmp11, ctx);
    MUL(tmp9, tmp10, tmp11, ctx);
    SQRT_UI(tmp10, 2, ctx);
    ADD_SI(tmp10, tmp10, 2, ctx);
    SQRT(tmp10, tmp10, ctx);
    SUB_SI(tmp10, tmp10, 1, ctx);
    SQRT(tmp10, tmp10, ctx);
    MUL(tmp8, tmp9, tmp10, ctx);
    SQRT_UI(tmp10, 2, ctx);
    MUL_SI(tmp10, tmp10, 4896, ctx);
    SUB_SI(tmp10, tmp10, 6923, ctx);
    MUL_SI(tmp10, tmp10, 2, ctx);
    SQRT_UI(tmp11, 2, ctx);
    ADD_SI(tmp11, tmp11, 2, ctx);
    SQRT(tmp11, tmp11, ctx);
    MUL(tmp9, tmp10, tmp11, ctx);
    SUB(tmp7, tmp8, tmp9, ctx);
    SQRT_UI(tmp12, 2, ctx);
    MUL_SI(tmp12, tmp12, 79, ctx);
    SUB_SI(tmp12, tmp12, 112, ctx);
    MUL_SI(tmp12, tmp12, 20, ctx);
    SQRT_UI(tmp13, 2, ctx);
    ADD_SI(tmp13, tmp13, 2, ctx);
    SQRT(tmp13, tmp13, ctx);
    MUL(tmp11, tmp12, tmp13, ctx);
    SQRT_UI(tmp15, 2, ctx);
    MUL_SI(tmp15, tmp15, 27, ctx);
    SUB_SI(tmp15, tmp15, 38, ctx);
    MUL_SI(tmp15, tmp15, 7, ctx);
    SQRT_UI(tmp16, 2, ctx);
    ADD_SI(tmp16, tmp16, 2, ctx);
    SQRT(tmp16, tmp16, ctx);
    MUL(tmp14, tmp15, tmp16, ctx);
    SQRT_UI(tmp15, 2, ctx);
    MUL_SI(tmp15, tmp15, 342, ctx);
    SUB(tmp13, tmp14, tmp15, ctx);
    ADD_SI(tmp13, tmp13, 484, ctx);
    SQRT_UI(tmp14, 2, ctx);
    MUL_SI(tmp14, tmp14, -17, ctx);
    ADD_SI(tmp14, tmp14, 26, ctx);
    SQRT(tmp14, tmp14, ctx);
    MUL(tmp12, tmp13, tmp14, ctx);
    SUB(tmp10, tmp11, tmp12, ctx);
    SQRT_UI(tmp11, 2, ctx);
    MUL_SI(tmp11, tmp11, 2820, ctx);
    SUB(tmp9, tmp10, tmp11, ctx);
    ADD_SI(tmp9, tmp9, 3992, ctx);
    SQRT_UI(tmp10, 2, ctx);
    NEG(tmp10, tmp10, ctx);
    ADD_SI(tmp10, tmp10, 2, ctx);
    SQRT(tmp10, tmp10, ctx);
    MUL(tmp8, tmp9, tmp10, ctx);
    ADD(tmp6, tmp7, tmp8, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, 2, ctx);
    SUB_SI(tmp19, tmp19, 3, ctx);
    MUL_SI(tmp19, tmp19, 3, ctx);
    SQRT_UI(tmp20, 2, ctx);
    MUL_SI(tmp20, tmp20, -17, ctx);
    ADD_SI(tmp20, tmp20, 26, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, 61, ctx);
    SUB(tmp17, tmp18, tmp19, ctx);
    ADD_SI(tmp17, tmp17, 85, ctx);
    SQRT_UI(tmp18, 2, ctx);
    NEG(tmp18, tmp18, ctx);
    ADD_SI(tmp18, tmp18, 2, ctx);
    SQRT(tmp18, tmp18, ctx);
    MUL(tmp16, tmp17, tmp18, ctx);
    SQRT_UI(tmp18, 2, ctx);
    MUL_SI(tmp18, tmp18, 5, ctx);
    SUB_SI(tmp18, tmp18, 7, ctx);
    MUL_SI(tmp18, tmp18, 11, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, -17, ctx);
    ADD_SI(tmp19, tmp19, 26, ctx);
    SQRT(tmp19, tmp19, ctx);
    MUL(tmp17, tmp18, tmp19, ctx);
    SUB(tmp15, tmp16, tmp17, ctx);
    SQRT_UI(tmp16, 2, ctx);
    MUL_SI(tmp16, tmp16, 445, ctx);
    ADD(tmp14, tmp15, tmp16, ctx);
    SUB_SI(tmp14, tmp14, 630, ctx);
    SQRT_UI(tmp16, 2, ctx);
    MUL_SI(tmp16, tmp16, 3, ctx);
    SQRT_UI(tmp17, 2, ctx);
    MUL_SI(tmp17, tmp17, -17, ctx);
    ADD_SI(tmp17, tmp17, 26, ctx);
    SQRT(tmp17, tmp17, ctx);
    ADD(tmp15, tmp16, tmp17, ctx);
    SUB_SI(tmp15, tmp15, 3, ctx);
    SQRT(tmp15, tmp15, ctx);
    MUL(tmp13, tmp14, tmp15, ctx);
    SQRT_UI(tmp14, 2, ctx);
    ADD_SI(tmp14, tmp14, 2, ctx);
    SQRT(tmp14, tmp14, ctx);
    SUB_SI(tmp14, tmp14, 1, ctx);
    SQRT(tmp14, tmp14, ctx);
    MUL(tmp12, tmp13, tmp14, ctx);
    SQRT_UI(tmp14, 2, ctx);
    MUL_SI(tmp14, tmp14, 89, ctx);
    SUB_SI(tmp14, tmp14, 126, ctx);
    MUL_SI(tmp14, tmp14, 10, ctx);
    SQRT_UI(tmp15, 2, ctx);
    ADD_SI(tmp15, tmp15, 2, ctx);
    SQRT(tmp15, tmp15, ctx);
    MUL(tmp13, tmp14, tmp15, ctx);
    SUB(tmp11, tmp12, tmp13, ctx);
    SQRT_UI(tmp16, 2, ctx);
    MUL_SI(tmp16, tmp16, 61, ctx);
    SUB_SI(tmp16, tmp16, 85, ctx);
    SQRT_UI(tmp17, 2, ctx);
    ADD_SI(tmp17, tmp17, 2, ctx);
    SQRT(tmp17, tmp17, ctx);
    MUL(tmp15, tmp16, tmp17, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, 2, ctx);
    SUB_SI(tmp19, tmp19, 3, ctx);
    SQRT_UI(tmp20, 2, ctx);
    ADD_SI(tmp20, tmp20, 2, ctx);
    SQRT(tmp20, tmp20, ctx);
    MUL(tmp18, tmp19, tmp20, ctx);
    SQRT_UI(tmp19, 2, ctx);
    MUL_SI(tmp19, tmp19, 2, ctx);
    SUB(tmp17, tmp18, tmp19, ctx);
    ADD_SI(tmp17, tmp17, 3, ctx);
    MUL_SI(tmp17, tmp17, 3, ctx);
    SQRT_UI(tmp18, 2, ctx);
    MUL_SI(tmp18, tmp18, -17, ctx);
    ADD_SI(tmp18, tmp18, 26, ctx);
    SQRT(tmp18, tmp18, ctx);
    MUL(tmp16, tmp17, tmp18, ctx);
    SUB(tmp14, tmp15, tmp16, ctx);
    SQRT_UI(tmp15, 2, ctx);
    MUL_SI(tmp15, tmp15, 61, ctx);
    SUB(tmp13, tmp14, tmp15, ctx);
    ADD_SI(tmp13, tmp13, 85, ctx);
    MUL_SI(tmp13, tmp13, 2, ctx);
    SQRT_UI(tmp14, 2, ctx);
    NEG(tmp14, tmp14, ctx);
    ADD_SI(tmp14, tmp14, 2, ctx);
    SQRT(tmp14, tmp14, ctx);
    MUL(tmp12, tmp13, tmp14, ctx);
    ADD(tmp10, tmp11, tmp12, ctx);
    SQRT_UI(tmp14, 2, ctx);
    MUL_SI(tmp14, tmp14, 5, ctx);
    SUB_SI(tmp14, tmp14, 7, ctx);
    SQRT_UI(tmp15, 2, ctx);
    ADD_SI(tmp15, tmp15, 2, ctx);
    SQRT(tmp15, tmp15, ctx);
    MUL(tmp13, tmp14, tmp15, ctx);
    SQRT_UI(tmp14, 2, ctx);
    MUL_SI(tmp14, tmp14, 5, ctx);
    SUB(tmp12, tmp13, tmp14, ctx);
    ADD_SI(tmp12, tmp12, 7, ctx);
    MUL_SI(tmp12, tmp12, 22, ctx);
    SQRT_UI(tmp13, 2, ctx);
    MUL_SI(tmp13, tmp13, -17, ctx);
    ADD_SI(tmp13, tmp13, 26, ctx);
    SQRT(tmp13, tmp13, ctx);
    MUL(tmp11, tmp12, tmp13, ctx);
    ADD(tmp9, tmp10, tmp11, ctx);
    SQRT_UI(tmp10, 2, ctx);
    MUL_SI(tmp10, tmp10, 890, ctx);
    ADD(tmp8, tmp9, tmp10, ctx);
    SUB_SI(tmp8, tmp8, 1260, ctx);
    SQRT_UI(tmp11, 2, ctx);
    MUL_SI(tmp11, tmp11, -12, ctx);
    SQRT_UI(tmp12, 2, ctx);
    NEG(tmp12, tmp12, ctx);
    ADD_SI(tmp12, tmp12, 2, ctx);
    SQRT(tmp12, tmp12, ctx);
    MUL_SI(tmp12, tmp12, 2, ctx);
    SUB(tmp10, tmp11, tmp12, ctx);
    SQRT_UI(tmp11, 2, ctx);
    MUL_SI(tmp11, tmp11, -17, ctx);
    ADD_SI(tmp11, tmp11, 26, ctx);
    SQRT(tmp11, tmp11, ctx);
    MUL_SI(tmp11, tmp11, 2, ctx);
    SUB(tmp9, tmp10, tmp11, ctx);
    ADD_SI(tmp9, tmp9, 24, ctx);
    SQRT(tmp9, tmp9, ctx);
    MUL(tmp7, tmp8, tmp9, ctx);
    ADD(tmp5, tmp6, tmp7, ctx);
    SQRT_UI(tmp9, 2, ctx);
    MUL_SI(tmp9, tmp9, 319, ctx);
    SUB_SI(tmp9, tmp9, 452, ctx);
    SQRT_UI(tmp10, 2, ctx);
    ADD_SI(tmp10, tmp10, 2, ctx);
    SQRT(tmp10, tmp10, ctx);
    MUL(tmp8, tmp9, tmp10, ctx);
    SQRT_UI(tmp9, 2, ctx);
    MUL_SI(tmp9, tmp9, 561, ctx);
    SUB(tmp7, tmp8, tmp9, ctx);
    ADD_SI(tmp7, tmp7, 794, ctx);
    MUL_SI(tmp7, tmp7, 4, ctx);
    SQRT_UI(tmp8, 2, ctx);
    MUL_SI(tmp8, tmp8, -17, ctx);
    ADD_SI(tmp8, tmp8, 26, ctx);
    SQRT(tmp8, tmp8, ctx);
    MUL(tmp6, tmp7, tmp8, ctx);
    ADD(tmp4, tmp5, tmp6, ctx);
    SQRT_UI(tmp5, 2, ctx);
    MUL_SI(tmp5, tmp5, 17064, ctx);
    ADD(tmp3, tmp4, tmp5, ctx);
    SUB_SI(tmp3, tmp3, 24132, ctx);
    DIV(tmp1, tmp2, tmp3, ctx);
    SUB(N, tmp0, tmp1, ctx);
    TIMEIT_ONCE_STOP

    flint_printf("Evaluating M...\n");
    TIMEIT_ONCE_START
    SQRT_UI(tmp6, 2, ctx);
    MUL_SI(tmp6, tmp6, 6, ctx);
    SQRT_UI(tmp7, 2, ctx);
    NEG(tmp7, tmp7, ctx);
    ADD_SI(tmp7, tmp7, 2, ctx);
    SQRT(tmp7, tmp7, ctx);
    ADD(tmp5, tmp6, tmp7, ctx);
    SQRT_UI(tmp6, 2, ctx);
    MUL_SI(tmp6, tmp6, -17, ctx);
    ADD_SI(tmp6, tmp6, 26, ctx);
    SQRT(tmp6, tmp6, ctx);
    ADD(tmp4, tmp5, tmp6, ctx);
    SUB_SI(tmp4, tmp4, 8, ctx);
    MUL_SI(tmp4, tmp4, 4, ctx);
    SQRT_UI(tmp6, 2, ctx);
    MUL_SI(tmp6, tmp6, 3, ctx);
    SQRT_UI(tmp7, 2, ctx);
    NEG(tmp7, tmp7, ctx);
    ADD_SI(tmp7, tmp7, 2, ctx);
    SQRT(tmp7, tmp7, ctx);
    ADD(tmp5, tmp6, tmp7, ctx);
    SUB_SI(tmp5, tmp5, 5, ctx);
    SQRT(tmp5, tmp5, ctx);
    MUL(tmp3, tmp4, tmp5, ctx);
    SQRT_UI(tmp6, 2, ctx);
    MUL_SI(tmp6, tmp6, 3, ctx);
    SQRT_UI(tmp7, 2, ctx);
    MUL_SI(tmp7, tmp7, -17, ctx);
    ADD_SI(tmp7, tmp7, 26, ctx);
    SQRT(tmp7, tmp7, ctx);
    ADD(tmp5, tmp6, tmp7, ctx);
    SUB_SI(tmp5, tmp5, 3, ctx);
    SQRT(tmp5, tmp5, ctx);
    CONST_I(tmp10, ctx);
    MUL_SI(tmp10, tmp10, -24, ctx);
    SQRT_UI(tmp11, 2, ctx);
    MUL(tmp9, tmp10, tmp11, ctx);
    CONST_I(tmp11, ctx);
    MUL_SI(tmp11, tmp11, 4, ctx);
    SQRT_UI(tmp12, 2, ctx);
    NEG(tmp12, tmp12, ctx);
    ADD_SI(tmp12, tmp12, 2, ctx);
    SQRT(tmp12, tmp12, ctx);
    MUL(tmp10, tmp11, tmp12, ctx);
    SUB(tmp8, tmp9, tmp10, ctx);
    CONST_I(tmp10, ctx);
    MUL_SI(tmp10, tmp10, 4, ctx);
    SQRT_UI(tmp11, 2, ctx);
    MUL_SI(tmp11, tmp11, -17, ctx);
    ADD_SI(tmp11, tmp11, 26, ctx);
    SQRT(tmp11, tmp11, ctx);
    MUL(tmp9, tmp10, tmp11, ctx);
    SUB(tmp7, tmp8, tmp9, ctx);
    CONST_I(tmp8, ctx);
    MUL_SI(tmp8, tmp8, 32, ctx);
    ADD(tmp6, tmp7, tmp8, ctx);
    MUL(tmp4, tmp5, tmp6, ctx);
    SUB(tmp2, tmp3, tmp4, ctx);
    SQRT_UI(tmp9, 2, ctx);
    SQRT_UI(tmp10, 2, ctx);
    NEG(tmp10, tmp10, ctx);
    ADD_SI(tmp10, tmp10, 2, ctx);
    SQRT(tmp10, tmp10, ctx);
    MUL(tmp8, tmp9, tmp10, ctx);
    SQRT_UI(tmp10, 2, ctx);
    SQRT_UI(tmp11, 2, ctx);
    MUL_SI(tmp11, tmp11, -17, ctx);
    ADD_SI(tmp11, tmp11, 26, ctx);
    SQRT(tmp11, tmp11, ctx);
    MUL(tmp9, tmp10, tmp11, ctx);
    ADD(tmp7, tmp8, tmp9, ctx);
    SQRT_UI(tmp8, 2, ctx);
    MUL_SI(tmp8, tmp8, 8, ctx);
    SUB(tmp6, tmp7, tmp8, ctx);
    ADD_SI(tmp6, tmp6, 12, ctx);
    SQRT_UI(tmp8, 2, ctx);
    MUL_SI(tmp8, tmp8, 3, ctx);
    SQRT_UI(tmp9, 2, ctx);
    NEG(tmp9, tmp9, ctx);
    ADD_SI(tmp9, tmp9, 2, ctx);
    SQRT(tmp9, tmp9, ctx);
    ADD(tmp7, tmp8, tmp9, ctx);
    SUB_SI(tmp7, tmp7, 5, ctx);
    SQRT(tmp7, tmp7, ctx);
    MUL(tmp5, tmp6, tmp7, ctx);
    CONST_I(tmp12, ctx);
    SQRT_UI(tmp13, 2, ctx);
    MUL(tmp11, tmp12, tmp13, ctx);
    SQRT_UI(tmp12, 2, ctx);
    NEG(tmp12, tmp12, ctx);
    ADD_SI(tmp12, tmp12, 2, ctx);
    SQRT(tmp12, tmp12, ctx);
    MUL(tmp10, tmp11, tmp12, ctx);
    CONST_I(tmp13, ctx);
    SQRT_UI(tmp14, 2, ctx);
    MUL(tmp12, tmp13, tmp14, ctx);
    SQRT_UI(tmp13, 2, ctx);
    MUL_SI(tmp13, tmp13, -17, ctx);
    ADD_SI(tmp13, tmp13, 26, ctx);
    SQRT(tmp13, tmp13, ctx);
    MUL(tmp11, tmp12, tmp13, ctx);
    ADD(tmp9, tmp10, tmp11, ctx);
    CONST_I(tmp11, ctx);
    MUL_SI(tmp11, tmp11, 8, ctx);
    SQRT_UI(tmp12, 2, ctx);
    MUL(tmp10, tmp11, tmp12, ctx);
    SUB(tmp8, tmp9, tmp10, ctx);
    CONST_I(tmp9, ctx);
    MUL_SI(tmp9, tmp9, 12, ctx);
    ADD(tmp7, tmp8, tmp9, ctx);
    SQRT_UI(tmp9, 2, ctx);
    MUL_SI(tmp9, tmp9, 3, ctx);
    SQRT_UI(tmp10, 2, ctx);
    MUL_SI(tmp10, tmp10, -17, ctx);
    ADD_SI(tmp10, tmp10, 26, ctx);
    SQRT(tmp10, tmp10, ctx);
    ADD(tmp8, tmp9, tmp10, ctx);
    SUB_SI(tmp8, tmp8, 3, ctx);
    SQRT(tmp8, tmp8, ctx);
    MUL(tmp6, tmp7, tmp8, ctx);
    ADD(tmp4, tmp5, tmp6, ctx);
    SQRT_UI(tmp7, 2, ctx);
    MUL_SI(tmp7, tmp7, -12, ctx);
    SQRT_UI(tmp8, 2, ctx);
    NEG(tmp8, tmp8, ctx);
    ADD_SI(tmp8, tmp8, 2, ctx);
    SQRT(tmp8, tmp8, ctx);
    MUL_SI(tmp8, tmp8, 2, ctx);
    SUB(tmp6, tmp7, tmp8, ctx);
    SQRT_UI(tmp7, 2, ctx);
    MUL_SI(tmp7, tmp7, -17, ctx);
    ADD_SI(tmp7, tmp7, 26, ctx);
    SQRT(tmp7, tmp7, ctx);
    MUL_SI(tmp7, tmp7, 2, ctx);
    SUB(tmp5, tmp6, tmp7, ctx);
    ADD_SI(tmp5, tmp5, 24, ctx);
    SQRT(tmp5, tmp5, ctx);
    MUL(tmp3, tmp4, tmp5, ctx);
    SUB(tmp1, tmp2, tmp3, ctx);
    CONST_I(tmp10, ctx);
    MUL_SI(tmp10, tmp10, 24, ctx);
    SQRT_UI(tmp11, 2, ctx);
    MUL(tmp9, tmp10, tmp11, ctx);
    CONST_I(tmp11, ctx);
    MUL_SI(tmp11, tmp11, 4, ctx);
    SQRT_UI(tmp12, 2, ctx);
    MUL_SI(tmp12, tmp12, -17, ctx);
    ADD_SI(tmp12, tmp12, 26, ctx);
    SQRT(tmp12, tmp12, ctx);
    MUL(tmp10, tmp11, tmp12, ctx);
    ADD(tmp8, tmp9, tmp10, ctx);
    CONST_I(tmp9, ctx);
    MUL_SI(tmp9, tmp9, 32, ctx);
    SUB(tmp7, tmp8, tmp9, ctx);
    SQRT_UI(tmp8, 2, ctx);
    NEG(tmp8, tmp8, ctx);
    ADD_SI(tmp8, tmp8, 2, ctx);
    SQRT(tmp8, tmp8, ctx);
    MUL(tmp6, tmp7, tmp8, ctx);
    CONST_I(tmp9, ctx);
    MUL_SI(tmp9, tmp9, 8, ctx);
    SQRT_UI(tmp10, 2, ctx);
    MUL_SI(tmp10, tmp10, 3, ctx);
    SUB_SI(tmp10, tmp10, 4, ctx);
    MUL(tmp8, tmp9, tmp10, ctx);
    SQRT_UI(tmp9, 2, ctx);
    MUL_SI(tmp9, tmp9, -17, ctx);
    ADD_SI(tmp9, tmp9, 26, ctx);
    SQRT(tmp9, tmp9, ctx);
    MUL(tmp7, tmp8, tmp9, ctx);
    ADD(tmp5, tmp6, tmp7, ctx);
    CONST_I(tmp7, ctx);
    MUL_SI(tmp7, tmp7, 228, ctx);
    SQRT_UI(tmp8, 2, ctx);
    MUL(tmp6, tmp7, tmp8, ctx);
    SUB(tmp4, tmp5, tmp6, ctx);
    CONST_I(tmp5, ctx);
    MUL_SI(tmp5, tmp5, 328, ctx);
    ADD(tmp3, tmp4, tmp5, ctx);
    SQRT_UI(tmp4, 2, ctx);
    ADD_SI(tmp4, tmp4, 2, ctx);
    SQRT(tmp4, tmp4, ctx);
    SUB_SI(tmp4, tmp4, 1, ctx);
    SQRT(tmp4, tmp4, ctx);
    MUL(tmp2, tmp3, tmp4, ctx);
    SUB(tmp0, tmp1, tmp2, ctx);
    NEG(tmp0, tmp0, ctx);
    SQRT_UI(tmp10, 2, ctx);
    MUL_SI(tmp10, tmp10, 6, ctx);
    SQRT_UI(tmp11, 2, ctx);
    NEG(tmp11, tmp11, ctx);
    ADD_SI(tmp11, tmp11, 2, ctx);
    SQRT(tmp11, tmp11, ctx);
    ADD(tmp9, tmp10, tmp11, ctx);
    SQRT_UI(tmp10, 2, ctx);
    MUL_SI(tmp10, tmp10, -17, ctx);
    ADD_SI(tmp10, tmp10, 26, ctx);
    SQRT(tmp10, tmp10, ctx);
    ADD(tmp8, tmp9, tmp10, ctx);
    SUB_SI(tmp8, tmp8, 8, ctx);
    MUL_SI(tmp8, tmp8, 4, ctx);
    SQRT_UI(tmp10, 2, ctx);
    MUL_SI(tmp10, tmp10, 3, ctx);
    SQRT_UI(tmp11, 2, ctx);
    MUL_SI(tmp11, tmp11, -17, ctx);
    ADD_SI(tmp11, tmp11, 26, ctx);
    SQRT(tmp11, tmp11, ctx);
    ADD(tmp9, tmp10, tmp11, ctx);
    SUB_SI(tmp9, tmp9, 3, ctx);
    SQRT(tmp9, tmp9, ctx);
    MUL(tmp7, tmp8, tmp9, ctx);
    SQRT_UI(tmp8, 2, ctx);
    ADD_SI(tmp8, tmp8, 2, ctx);
    SQRT(tmp8, tmp8, ctx);
    SUB_SI(tmp8, tmp8, 1, ctx);
    SQRT(tmp8, tmp8, ctx);
    MUL(tmp6, tmp7, tmp8, ctx);
    SQRT_UI(tmp10, 2, ctx);
    MUL_SI(tmp10, tmp10, 3, ctx);
    SQRT_UI(tmp11, 2, ctx);
    NEG(tmp11, tmp11, ctx);
    ADD_SI(tmp11, tmp11, 2, ctx);
    SQRT(tmp11, tmp11, ctx);
    ADD(tmp9, tmp10, tmp11, ctx);
    SUB_SI(tmp9, tmp9, 5, ctx);
    SQRT(tmp9, tmp9, ctx);
    CONST_I(tmp14, ctx);
    MUL_SI(tmp14, tmp14, -24, ctx);
    SQRT_UI(tmp15, 2, ctx);
    MUL(tmp13, tmp14, tmp15, ctx);
    CONST_I(tmp15, ctx);
    MUL_SI(tmp15, tmp15, 4, ctx);
    SQRT_UI(tmp16, 2, ctx);
    NEG(tmp16, tmp16, ctx);
    ADD_SI(tmp16, tmp16, 2, ctx);
    SQRT(tmp16, tmp16, ctx);
    MUL(tmp14, tmp15, tmp16, ctx);
    SUB(tmp12, tmp13, tmp14, ctx);
    CONST_I(tmp14, ctx);
    MUL_SI(tmp14, tmp14, 4, ctx);
    SQRT_UI(tmp15, 2, ctx);
    MUL_SI(tmp15, tmp15, -17, ctx);
    ADD_SI(tmp15, tmp15, 26, ctx);
    SQRT(tmp15, tmp15, ctx);
    MUL(tmp13, tmp14, tmp15, ctx);
    SUB(tmp11, tmp12, tmp13, ctx);
    CONST_I(tmp12, ctx);
    MUL_SI(tmp12, tmp12, 32, ctx);
    ADD(tmp10, tmp11, tmp12, ctx);
    MUL(tmp8, tmp9, tmp10, ctx);
    SQRT_UI(tmp9, 2, ctx);
    ADD_SI(tmp9, tmp9, 2, ctx);
    SQRT(tmp9, tmp9, ctx);
    SUB_SI(tmp9, tmp9, 1, ctx);
    SQRT(tmp9, tmp9, ctx);
    MUL(tmp7, tmp8, tmp9, ctx);
    ADD(tmp5, tmp6, tmp7, ctx);
    SQRT_UI(tmp8, 2, ctx);
    MUL_SI(tmp8, tmp8, 6, ctx);
    SQRT_UI(tmp9, 2, ctx);
    MUL_SI(tmp9, tmp9, -17, ctx);
    ADD_SI(tmp9, tmp9, 26, ctx);
    SQRT(tmp9, tmp9, ctx);
    ADD(tmp7, tmp8, tmp9, ctx);
    SUB_SI(tmp7, tmp7, 8, ctx);
    MUL_SI(tmp7, tmp7, 4, ctx);
    SQRT_UI(tmp8, 2, ctx);
    NEG(tmp8, tmp8, ctx);
    ADD_SI(tmp8, tmp8, 2, ctx);
    SQRT(tmp8, tmp8, ctx);
    MUL(tmp6, tmp7, tmp8, ctx);
    SUB(tmp4, tmp5, tmp6, ctx);
    CONST_I(tmp14, ctx);
    SQRT_UI(tmp15, 2, ctx);
    MUL(tmp13, tmp14, tmp15, ctx);
    SQRT_UI(tmp14, 2, ctx);
    NEG(tmp14, tmp14, ctx);
    ADD_SI(tmp14, tmp14, 2, ctx);
    SQRT(tmp14, tmp14, ctx);
    MUL(tmp12, tmp13, tmp14, ctx);
    CONST_I(tmp15, ctx);
    SQRT_UI(tmp16, 2, ctx);
    MUL(tmp14, tmp15, tmp16, ctx);
    SQRT_UI(tmp15, 2, ctx);
    MUL_SI(tmp15, tmp15, -17, ctx);
    ADD_SI(tmp15, tmp15, 26, ctx);
    SQRT(tmp15, tmp15, ctx);
    MUL(tmp13, tmp14, tmp15, ctx);
    ADD(tmp11, tmp12, tmp13, ctx);
    CONST_I(tmp13, ctx);
    MUL_SI(tmp13, tmp13, 8, ctx);
    SQRT_UI(tmp14, 2, ctx);
    MUL(tmp12, tmp13, tmp14, ctx);
    SUB(tmp10, tmp11, tmp12, ctx);
    CONST_I(tmp11, ctx);
    MUL_SI(tmp11, tmp11, 12, ctx);
    ADD(tmp9, tmp10, tmp11, ctx);
    SQRT_UI(tmp11, 2, ctx);
    MUL_SI(tmp11, tmp11, 3, ctx);
    SQRT_UI(tmp12, 2, ctx);
    NEG(tmp12, tmp12, ctx);
    ADD_SI(tmp12, tmp12, 2, ctx);
    SQRT(tmp12, tmp12, ctx);
    ADD(tmp10, tmp11, tmp12, ctx);
    SUB_SI(tmp10, tmp10, 5, ctx);
    SQRT(tmp10, tmp10, ctx);
    MUL(tmp8, tmp9, tmp10, ctx);
    SQRT_UI(tmp9, 2, ctx);
    ADD_SI(tmp9, tmp9, 2, ctx);
    SQRT(tmp9, tmp9, ctx);
    SUB_SI(tmp9, tmp9, 1, ctx);
    SQRT(tmp9, tmp9, ctx);
    MUL(tmp7, tmp8, tmp9, ctx);
    SQRT_UI(tmp13, 2, ctx);
    SQRT_UI(tmp14, 2, ctx);
    NEG(tmp14, tmp14, ctx);
    ADD_SI(tmp14, tmp14, 2, ctx);
    SQRT(tmp14, tmp14, ctx);
    MUL(tmp12, tmp13, tmp14, ctx);
    SQRT_UI(tmp14, 2, ctx);
    SQRT_UI(tmp15, 2, ctx);
    MUL_SI(tmp15, tmp15, -17, ctx);
    ADD_SI(tmp15, tmp15, 26, ctx);
    SQRT(tmp15, tmp15, ctx);
    MUL(tmp13, tmp14, tmp15, ctx);
    ADD(tmp11, tmp12, tmp13, ctx);
    SQRT_UI(tmp12, 2, ctx);
    MUL_SI(tmp12, tmp12, 8, ctx);
    SUB(tmp10, tmp11, tmp12, ctx);
    ADD_SI(tmp10, tmp10, 12, ctx);
    SQRT_UI(tmp12, 2, ctx);
    MUL_SI(tmp12, tmp12, 3, ctx);
    SQRT_UI(tmp13, 2, ctx);
    MUL_SI(tmp13, tmp13, -17, ctx);
    ADD_SI(tmp13, tmp13, 26, ctx);
    SQRT(tmp13, tmp13, ctx);
    ADD(tmp11, tmp12, tmp13, ctx);
    SUB_SI(tmp11, tmp11, 3, ctx);
    SQRT(tmp11, tmp11, ctx);
    MUL(tmp9, tmp10, tmp11, ctx);
    SQRT_UI(tmp10, 2, ctx);
    ADD_SI(tmp10, tmp10, 2, ctx);
    SQRT(tmp10, tmp10, ctx);
    SUB_SI(tmp10, tmp10, 1, ctx);
    SQRT(tmp10, tmp10, ctx);
    MUL(tmp8, tmp9, tmp10, ctx);
    SUB(tmp6, tmp7, tmp8, ctx);
    SQRT_UI(tmp9, 2, ctx);
    MUL_SI(tmp9, tmp9, -12, ctx);
    SQRT_UI(tmp10, 2, ctx);
    NEG(tmp10, tmp10, ctx);
    ADD_SI(tmp10, tmp10, 2, ctx);
    SQRT(tmp10, tmp10, ctx);
    MUL_SI(tmp10, tmp10, 2, ctx);
    SUB(tmp8, tmp9, tmp10, ctx);
    SQRT_UI(tmp9, 2, ctx);
    MUL_SI(tmp9, tmp9, -17, ctx);
    ADD_SI(tmp9, tmp9, 26, ctx);
    SQRT(tmp9, tmp9, ctx);
    MUL_SI(tmp9, tmp9, 2, ctx);
    SUB(tmp7, tmp8, tmp9, ctx);
    ADD_SI(tmp7, tmp7, 24, ctx);
    SQRT(tmp7, tmp7, ctx);
    MUL(tmp5, tmp6, tmp7, ctx);
    ADD(tmp3, tmp4, tmp5, ctx);
    SQRT_UI(tmp5, 2, ctx);
    MUL_SI(tmp5, tmp5, 3, ctx);
    SUB_SI(tmp5, tmp5, 4, ctx);
    MUL_SI(tmp5, tmp5, 8, ctx);
    SQRT_UI(tmp6, 2, ctx);
    MUL_SI(tmp6, tmp6, -17, ctx);
    ADD_SI(tmp6, tmp6, 26, ctx);
    SQRT(tmp6, tmp6, ctx);
    MUL(tmp4, tmp5, tmp6, ctx);
    SUB(tmp2, tmp3, tmp4, ctx);
    SQRT_UI(tmp3, 2, ctx);
    MUL_SI(tmp3, tmp3, 228, ctx);
    ADD(tmp1, tmp2, tmp3, ctx);
    SUB_SI(tmp1, tmp1, 328, ctx);
    DIV(M, tmp0, tmp1, ctx);
    TIMEIT_ONCE_STOP

    flint_printf("Evaluating E = -(1-|M|^2)^2...\n");
    TIMEIT_ONCE_START
    ABS(E, M, ctx);
    POW_UI(E, E, 2, ctx);
    SUB_SI(E, E, 1, ctx);
    NEG(E, E, ctx);
    POW_UI(E, E, 2, ctx);
    NEG(E, E, ctx);
    TIMEIT_ONCE_STOP

    if (status != GR_SUCCESS)
    {
        flint_printf("evaluation failed\n");
        flint_abort();
    }

    flint_printf("N ~ "); gr_println(N, ctx);
    flint_printf("E ~ "); gr_println(E, ctx);

    flint_printf("Testing E = N...\n");
    TIMEIT_ONCE_START
    equal = gr_equal(E, N, ctx);
    TIMEIT_ONCE_STOP

    flint_printf("\nEqual = ");
    truth_print(equal);
    flint_printf("\n");

    GR_TMP_CLEAR3(N, M, E, ctx);
    GR_TMP_CLEAR5(tmp0, tmp1, tmp2, tmp3, tmp4, ctx);
    GR_TMP_CLEAR5(tmp5, tmp6, tmp7, tmp8, tmp9, ctx);
    GR_TMP_CLEAR5(tmp10, tmp11, tmp12, tmp13, tmp14, ctx);
    GR_TMP_CLEAR5(tmp15, tmp16, tmp17, tmp18, tmp19, ctx);
    GR_TMP_CLEAR5(tmp20, tmp21, tmp22, tmp23, tmp24, ctx);
    GR_TMP_CLEAR5(tmp25, tmp26, tmp27, tmp28, tmp29, ctx);
    GR_TMP_CLEAR5(tmp30, tmp31, tmp32, tmp33, tmp34, ctx);
}

int main(int argc, char *argv[])
{
    TIMEIT_ONCE_START

    if (argc >= 2 && strcmp(argv[1], "-ca") == 0)
    {
        gr_ctx_t ctx;
        gr_ctx_init_complex_algebraic_ca(ctx);
        gr_ctx_ca_set_option(ctx, CA_OPT_QQBAR_DEG_LIMIT, 10000);
        doit(ctx);
        gr_ctx_clear(ctx);
    }
    else
    {
        gr_ctx_t ctx;
        gr_ctx_init_complex_qqbar(ctx);
        doit(ctx);
        gr_ctx_clear(ctx);
    }

    flint_printf("\n");
    flint_printf("Total: ");
    TIMEIT_ONCE_STOP
    SHOW_MEMORY_USAGE

    flint_cleanup_master();
    return 0;
}

