/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.critic;

import ca.sqlpower.architect.swingui.dbtree.DBTreeCellRenderer;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.sql.JDBCDataSourceType;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLIndex;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.sqlobject.SQLTable;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class CriticismObjectRenderer
extends DefaultTableCellRenderer {
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String visibleText = CriticismObjectRenderer.getVisibleText(value);
        Component originalComponent = super.getTableCellRendererComponent(table, visibleText, isSelected, hasFocus, row, column);
        JLabel label = new JLabel();
        label.setFont(originalComponent.getFont());
        label.setText(visibleText);
        if (value instanceof SQLTable) {
            label.setIcon(DBTreeCellRenderer.TABLE_ICON);
            return label;
        }
        if (value instanceof SQLIndex) {
            SQLIndex index = (SQLIndex)value;
            if (index.isPrimaryKeyIndex()) {
                label.setIcon(DBTreeCellRenderer.PK_ICON);
            } else {
                label.setIcon(DBTreeCellRenderer.INDEX_ICON);
            }
            label.setText(visibleText);
            return label;
        }
        if (value instanceof SQLColumn) {
            label.setIcon(DBTreeCellRenderer.COLUMN_ICON);
            return label;
        }
        if (value instanceof SQLRelationship) {
            label.setIcon(DBTreeCellRenderer.EXPORTED_KEY_ICON);
            return label;
        }
        if (value instanceof SQLRelationship.SQLImportedKey) {
            label.setIcon(DBTreeCellRenderer.IMPORTED_KEY_ICON);
            return label;
        }
        return originalComponent;
    }

    public static String getVisibleText(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof SQLTable) {
            return "<html><b>" + ((SQLTable)value).getName() + "</b></html>";
        }
        if (value instanceof SQLIndex) {
            SQLIndex index = (SQLIndex)value;
            StringBuffer text = new StringBuffer();
            text.append("<html>");
            if (index.getParent() != null) {
                text.append(index.getParent().getName() + ".");
            } else {
                text.append("(no parent).");
            }
            text.append("<b>");
            text.append(index.getName());
            text.append("</b></html>");
            return text.toString();
        }
        if (value instanceof SQLColumn) {
            SQLColumn sqlColumn = (SQLColumn)value;
            StringBuffer text = new StringBuffer();
            text.append("<html>");
            if (sqlColumn.getParent() != null) {
                text.append(sqlColumn.getParent().getName() + ".");
            } else {
                text.append("(no parent).");
            }
            text.append("<b>");
            text.append(sqlColumn.getName());
            text.append("</b></html>");
            return text.toString();
        }
        if (value instanceof SQLRelationship) {
            SQLRelationship relation = (SQLRelationship)value;
            StringBuffer text = new StringBuffer();
            text.append("<html>");
            if (relation.getParent() != null) {
                text.append(relation.getParent().getName() + ".");
            } else {
                text.append("(no parent).");
            }
            text.append("<b>");
            text.append(relation.getName());
            text.append("</b></html>");
            return text.toString();
        }
        if (value instanceof SQLRelationship.SQLImportedKey) {
            SQLRelationship relation = (SQLRelationship)value;
            StringBuffer text = new StringBuffer();
            text.append("<html>");
            if (relation.getParent() != null) {
                text.append(relation.getParent().getName() + ".");
            } else {
                text.append("(no parent).");
            }
            text.append("<b>");
            text.append(relation.getName());
            text.append("</b></html>");
            return text.toString();
        }
        if (value instanceof SQLObject) {
            String name = ((SQLObject)value).getShortDisplayName();
            if (name == null || name.trim().length() == 0) {
                ((SQLObject)value).getName();
            }
            return name;
        }
        if (value instanceof SPObject) {
            return ((SPObject)value).getName();
        }
        if (value instanceof JDBCDataSourceType) {
            return ((JDBCDataSourceType)value).getName();
        }
        return value.toString();
    }
}

