/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaMembers;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.MemberBox;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaArray;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeJavaMethod
extends BaseFunction {
    static final long serialVersionUID = -3440381785576412928L;
    private static final int PREFERENCE_EQUAL = 0;
    private static final int PREFERENCE_FIRST_ARG = 1;
    private static final int PREFERENCE_SECOND_ARG = 2;
    private static final int PREFERENCE_AMBIGUOUS = 3;
    private static final boolean debug = false;
    MemberBox[] methods;
    private String functionName;

    NativeJavaMethod(MemberBox[] memberBoxArray) {
        this.functionName = memberBoxArray[0].getName();
        this.methods = memberBoxArray;
    }

    NativeJavaMethod(MemberBox memberBox, String string) {
        this.functionName = string;
        this.methods = new MemberBox[]{memberBox};
    }

    public NativeJavaMethod(Method method, String string) {
        this(new MemberBox(method), string);
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    static String scriptSignature(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n != objectArray.length) {
            String string;
            Object object = objectArray[n];
            if (object == null) {
                string = "null";
            } else if (object instanceof Boolean) {
                string = "boolean";
            } else if (object instanceof String) {
                string = "string";
            } else if (object instanceof Number) {
                string = "number";
            } else if (object instanceof Scriptable) {
                if (object instanceof Undefined) {
                    string = "undefined";
                } else if (object instanceof Wrapper) {
                    Object object2 = ((Wrapper)object).unwrap();
                    string = object2.getClass().getName();
                } else {
                    string = object instanceof Function ? "function" : "object";
                }
            } else {
                string = JavaMembers.javaSignature(object.getClass());
            }
            if (n != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(string);
            ++n;
        }
        return stringBuffer.toString();
    }

    @Override
    String decompile(int n, int n2) {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = bl = (n2 & 1) != 0;
        if (!bl) {
            stringBuffer.append("function ");
            stringBuffer.append(this.getFunctionName());
            stringBuffer.append("() {");
        }
        stringBuffer.append("/*\n");
        stringBuffer.append(this.toString());
        stringBuffer.append(bl ? "*/\n" : "*/}\n");
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = this.methods.length;
        while (n != n2) {
            Method method = this.methods[n].method();
            stringBuffer.append(JavaMembers.javaSignature(method.getReturnType()));
            stringBuffer.append(' ');
            stringBuffer.append(method.getName());
            stringBuffer.append(JavaMembers.liveConnectSignature(this.methods[n].argTypes));
            stringBuffer.append('\n');
            ++n;
        }
        return stringBuffer.toString();
    }

    @Override
    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Class<?> clazz;
        Object object;
        if (this.methods.length == 0) {
            throw new RuntimeException("No methods defined for call");
        }
        int n = NativeJavaMethod.findFunction(context, this.methods, objectArray);
        if (n < 0) {
            Class<?> clazz2 = this.methods[0].method().getDeclaringClass();
            String string = String.valueOf(clazz2.getName()) + '.' + this.getFunctionName() + '(' + NativeJavaMethod.scriptSignature(objectArray) + ')';
            throw Context.reportRuntimeError1("msg.java.no_such_method", string);
        }
        MemberBox memberBox = this.methods[n];
        Class<?>[] classArray = memberBox.argTypes;
        if (memberBox.vararg) {
            Object object2;
            object = new Object[classArray.length];
            int n2 = 0;
            while (n2 < classArray.length - 1) {
                object[n2] = Context.jsToJava(objectArray[n2], classArray[n2]);
                ++n2;
            }
            if (objectArray.length == classArray.length && (objectArray[objectArray.length - 1] == null || objectArray[objectArray.length - 1] instanceof NativeArray || objectArray[objectArray.length - 1] instanceof NativeJavaArray)) {
                object2 = Context.jsToJava(objectArray[objectArray.length - 1], classArray[classArray.length - 1]);
            } else {
                clazz = classArray[classArray.length - 1].getComponentType();
                object2 = Array.newInstance(clazz, objectArray.length - classArray.length + 1);
                int n3 = 0;
                while (n3 < Array.getLength(object2)) {
                    Object object3 = Context.jsToJava(objectArray[classArray.length - 1 + n3], clazz);
                    Array.set(object2, n3, object3);
                    ++n3;
                }
            }
            object[classArray.length - 1] = object2;
            objectArray = object;
        } else {
            object = objectArray;
            int n4 = 0;
            while (n4 < objectArray.length) {
                clazz = objectArray[n4];
                Object object4 = Context.jsToJava(clazz, classArray[n4]);
                if (object4 != clazz) {
                    if (object == objectArray) {
                        objectArray = (Object[])objectArray.clone();
                    }
                    objectArray[n4] = object4;
                }
                ++n4;
            }
        }
        if (memberBox.isStatic()) {
            object = null;
        } else {
            Scriptable scriptable3 = scriptable2;
            clazz = memberBox.getDeclaringClass();
            while (true) {
                if (scriptable3 == null) {
                    throw Context.reportRuntimeError3("msg.nonjava.method", this.getFunctionName(), ScriptRuntime.toString(scriptable2), clazz.getName());
                }
                if (scriptable3 instanceof Wrapper && clazz.isInstance(object = ((Wrapper)((Object)scriptable3)).unwrap())) break;
                scriptable3 = scriptable3.getPrototype();
            }
        }
        Object object5 = memberBox.invoke(object, objectArray);
        clazz = memberBox.method().getReturnType();
        Object object6 = context.getWrapFactory().wrap(context, scriptable, object5, clazz);
        if (object6 == null && clazz == Void.TYPE) {
            object6 = Undefined.instance;
        }
        return object6;
    }

    static int findFunction(Context context, MemberBox[] memberBoxArray, Object[] objectArray) {
        Object object;
        if (memberBoxArray.length == 0) {
            return -1;
        }
        if (memberBoxArray.length == 1) {
            MemberBox memberBox = memberBoxArray[0];
            Class<?>[] classArray = memberBox.argTypes;
            int n = classArray.length;
            if (memberBox.vararg ? --n > objectArray.length : n != objectArray.length) {
                return -1;
            }
            int n2 = 0;
            while (n2 != n) {
                if (!NativeJavaObject.canConvert(objectArray[n2], classArray[n2])) {
                    return -1;
                }
                ++n2;
            }
            return 0;
        }
        int n = -1;
        int[] nArray = null;
        int n3 = 0;
        int n4 = 0;
        while (n4 < memberBoxArray.length) {
            block31: {
                MemberBox memberBox = memberBoxArray[n4];
                object = memberBox.argTypes;
                int n5 = ((Class<?>[])object).length;
                if (!(memberBox.vararg ? --n5 > objectArray.length : n5 != objectArray.length)) {
                    int n6 = 0;
                    while (n6 < n5) {
                        if (NativeJavaObject.canConvert(objectArray[n6], object[n6])) {
                            ++n6;
                            continue;
                        }
                        break block31;
                    }
                    if (n < 0) {
                        n = n4;
                    } else {
                        n6 = 0;
                        int n7 = 0;
                        int n8 = -1;
                        while (n8 != n3) {
                            int n9 = n8 == -1 ? n : nArray[n8];
                            MemberBox memberBox2 = memberBoxArray[n9];
                            if (context.hasFeature(13) && (memberBox2.member().getModifiers() & 1) != (memberBox.member().getModifiers() & 1)) {
                                if ((memberBox2.member().getModifiers() & 1) == 0) {
                                    ++n6;
                                } else {
                                    ++n7;
                                }
                            } else {
                                int n10 = NativeJavaMethod.preferSignature(objectArray, object, memberBox.vararg, memberBox2.argTypes, memberBox2.vararg);
                                if (n10 == 3) break;
                                if (n10 == 1) {
                                    ++n6;
                                } else {
                                    if (n10 != 2) {
                                        if (n10 != 0) {
                                            Kit.codeBug();
                                        }
                                        if (memberBox2.isStatic() && memberBox2.getDeclaringClass().isAssignableFrom(memberBox.getDeclaringClass())) {
                                            if (n8 == -1) {
                                                n = n4;
                                            } else {
                                                nArray[n8] = n4;
                                            }
                                        }
                                        break block31;
                                    }
                                    ++n7;
                                }
                            }
                            ++n8;
                        }
                        if (n6 == 1 + n3) {
                            n = n4;
                            n3 = 0;
                        } else if (n7 != 1 + n3) {
                            if (nArray == null) {
                                nArray = new int[memberBoxArray.length - 1];
                            }
                            nArray[n3] = n4;
                            ++n3;
                        }
                    }
                }
            }
            ++n4;
        }
        if (n < 0) {
            return -1;
        }
        if (n3 == 0) {
            return n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n11 = -1;
        while (n11 != n3) {
            int n12 = n11 == -1 ? n : nArray[n11];
            stringBuffer.append("\n    ");
            stringBuffer.append(memberBoxArray[n12].toJavaDeclaration());
            ++n11;
        }
        MemberBox memberBox = memberBoxArray[n];
        object = memberBox.getName();
        String string = memberBox.getDeclaringClass().getName();
        if (memberBoxArray[0].isMethod()) {
            throw Context.reportRuntimeError3("msg.constructor.ambiguous", object, NativeJavaMethod.scriptSignature(objectArray), stringBuffer.toString());
        }
        throw Context.reportRuntimeError4("msg.method.ambiguous", string, object, NativeJavaMethod.scriptSignature(objectArray), stringBuffer.toString());
    }

    private static int preferSignature(Object[] objectArray, Class<?>[] classArray, boolean bl, Class<?>[] classArray2, boolean bl2) {
        int n = objectArray.length;
        if (!bl && bl2) {
            return 1;
        }
        if (bl && !bl2) {
            return 2;
        }
        if (bl && bl2) {
            if (classArray.length < classArray2.length) {
                return 2;
            }
            if (classArray.length > classArray2.length) {
                return 1;
            }
            n = Math.min(objectArray.length, classArray.length - 1);
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            Class<?> clazz = classArray[n3];
            Class<?> clazz2 = classArray2[n3];
            if (clazz != clazz2) {
                int n4;
                Object object = objectArray[n3];
                int n5 = NativeJavaObject.getConversionWeight(object, clazz);
                int n6 = n5 < (n4 = NativeJavaObject.getConversionWeight(object, clazz2)) ? 1 : (n5 > n4 ? 2 : (n5 == 0 ? (clazz.isAssignableFrom(clazz2) ? 2 : (clazz2.isAssignableFrom(clazz) ? 1 : 3)) : 3));
                if ((n2 |= n6) == 3) break;
            }
            ++n3;
        }
        return n2;
    }

    private static void printDebug(String string, MemberBox memberBox, Object[] objectArray) {
    }
}

