/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.instrumentation.api.jvmbytecode;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.internal.instrumentation.api.jvmbytecode.BridgeMethodBuilder;
import org.gradle.internal.instrumentation.api.types.BytecodeInterceptorFilter;
import org.gradle.model.internal.asm.MethodVisitorScope;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public abstract class DefaultBridgeMethodBuilder
implements BridgeMethodBuilder {
    private static final Type VISITOR_CONTEXT_TYPE = Type.getType(BytecodeInterceptorFilter.class);
    private final String bridgeDesc;
    private final String interceptorOwner;
    private final String interceptorName;
    private final String interceptorDesc;
    private final boolean hasKotlinDefaultMask;
    @Nullable
    private final String binaryClassName;
    @Nullable
    private final BytecodeInterceptorFilter context;

    public static DefaultBridgeMethodBuilder create(int originalTag, String originalOwner, String originalDesc, String interceptorOwner, String interceptorName, String interceptorDesc) {
        switch (originalTag) {
            case 6: {
                return new StaticBridgeMethodBuilder(originalDesc, interceptorOwner, interceptorName, interceptorDesc);
            }
            case 8: {
                if (Type.getMethodType((String)interceptorDesc).getReturnType().getSort() != 0) {
                    throw new IllegalArgumentException(String.format("Cannot intercept constructor %s of %s with a non-void returning method %s.%s(%s)!", originalDesc, originalOwner, interceptorOwner, interceptorName, interceptorDesc));
                }
                return new ConstructorBridgeMethodBuilder(originalOwner, originalDesc, interceptorOwner, interceptorName, interceptorDesc);
            }
            case 5: 
            case 9: {
                return new InstanceBridgeMethodBuilder(originalTag, originalOwner, originalDesc, interceptorOwner, interceptorName, interceptorDesc);
            }
        }
        throw new IllegalArgumentException("Unsupported tag " + originalTag);
    }

    private DefaultBridgeMethodBuilder(String bridgeDesc, String interceptorOwner, String interceptorName, String interceptorDesc) {
        this(bridgeDesc, interceptorOwner, interceptorName, interceptorDesc, false, null, null);
    }

    protected DefaultBridgeMethodBuilder(DefaultBridgeMethodBuilder builder, String bridgeDesc) {
        this(bridgeDesc, builder.interceptorOwner, builder.interceptorName, builder.interceptorDesc, builder.hasKotlinDefaultMask, builder.binaryClassName, builder.context);
    }

    protected DefaultBridgeMethodBuilder(DefaultBridgeMethodBuilder builder, boolean hasKotlinDefaultMask, @Nullable String binaryClassName, @Nullable BytecodeInterceptorFilter context) {
        this(builder.bridgeDesc, builder.interceptorOwner, builder.interceptorName, builder.interceptorDesc, hasKotlinDefaultMask, binaryClassName, context);
    }

    private DefaultBridgeMethodBuilder(String bridgeDesc, String interceptorOwner, String interceptorName, String interceptorDesc, boolean hasKotlinDefaultMask, @Nullable String binaryClassName, @Nullable BytecodeInterceptorFilter context) {
        this.bridgeDesc = bridgeDesc;
        this.interceptorOwner = interceptorOwner;
        this.interceptorName = interceptorName;
        this.interceptorDesc = interceptorDesc;
        this.hasKotlinDefaultMask = hasKotlinDefaultMask;
        this.binaryClassName = binaryClassName;
        this.context = context;
    }

    @Override
    public BridgeMethodBuilder withReceiverType(String targetType) {
        throw new UnsupportedOperationException("Receiver type refinement isn't supported for " + this.getClass().getSimpleName());
    }

    @CheckReturnValue
    public final DefaultBridgeMethodBuilder withKotlinDefaultMask() {
        return this.copy(true, this.binaryClassName, this.context);
    }

    @CheckReturnValue
    public final DefaultBridgeMethodBuilder withClassName(String className) {
        return this.copy(this.hasKotlinDefaultMask, Type.getObjectType((String)className).getClassName(), this.context);
    }

    @CheckReturnValue
    public final DefaultBridgeMethodBuilder withVisitorContext(BytecodeInterceptorFilter context) {
        return this.copy(this.hasKotlinDefaultMask, this.binaryClassName, context);
    }

    protected abstract DefaultBridgeMethodBuilder copy(boolean var1, @Nullable String var2, @Nullable BytecodeInterceptorFilter var3);

    @Override
    public final String getBridgeMethodDescriptor() {
        return this.bridgeDesc;
    }

    @Override
    public final void buildBridgeMethod(MethodVisitor methodVisitor) {
        MethodVisitorScope mv = new MethodVisitorScope(methodVisitor);
        this.buildBridgeMethodImpl(mv);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void buildBridgeMethodImpl(MethodVisitorScope mv) {
        this.copyBridgeMethodArgsOnStack(mv);
        if (this.hasKotlinDefaultMask) {
            mv._LDC((Object)0);
        }
        if (this.binaryClassName != null) {
            mv._LDC((Object)this.binaryClassName);
        }
        if (this.context != null) {
            mv._GETSTATIC(VISITOR_CONTEXT_TYPE, this.context.name(), VISITOR_CONTEXT_TYPE.getDescriptor());
        }
        mv._INVOKESTATIC(this.interceptorOwner, this.interceptorName, this.interceptorDesc);
        mv._IRETURN_OF(this.getBridgeMethod().getReturnType());
    }

    protected final void copyBridgeMethodArgsOnStack(MethodVisitorScope mv) {
        Type[] args = this.getBridgeMethod().getArgumentTypes();
        for (int i = 0; i < args.length; ++i) {
            mv._ILOAD_OF(args[i], i);
        }
    }

    @Nonnull
    private Type getBridgeMethod() {
        return Type.getMethodType((String)this.bridgeDesc);
    }

    private static class StaticBridgeMethodBuilder
    extends DefaultBridgeMethodBuilder {
        private StaticBridgeMethodBuilder(String bridgeDesc, String interceptorOwner, String interceptorName, String interceptorDesc) {
            super(bridgeDesc, interceptorOwner, interceptorName, interceptorDesc);
        }

        private StaticBridgeMethodBuilder(StaticBridgeMethodBuilder builder, boolean hasKotlinDefaultMask, @Nullable String binaryClassName, @Nullable BytecodeInterceptorFilter context) {
            super(builder, hasKotlinDefaultMask, binaryClassName, context);
        }

        @Override
        protected StaticBridgeMethodBuilder copy(boolean hasKotlinDefaultMask, @Nullable String binaryClassName, @Nullable BytecodeInterceptorFilter context) {
            return new StaticBridgeMethodBuilder(this, hasKotlinDefaultMask, binaryClassName, context);
        }
    }

    private static class ConstructorBridgeMethodBuilder
    extends DefaultBridgeMethodBuilder {
        private final String originalOwner;
        private final String originalConstructorDesc;

        ConstructorBridgeMethodBuilder(String originalOwner, String originalConstructorDesc, String interceptorOwner, String interceptorName, String interceptorDesc) {
            super(ConstructorBridgeMethodBuilder.buildConstructorBridgeDesc(originalOwner, originalConstructorDesc), interceptorOwner, interceptorName, interceptorDesc);
            this.originalOwner = originalOwner;
            this.originalConstructorDesc = originalConstructorDesc;
        }

        private ConstructorBridgeMethodBuilder(ConstructorBridgeMethodBuilder builder, boolean hasKotlinDefaultMask, @Nullable String binaryClassName, @Nullable BytecodeInterceptorFilter context) {
            super(builder, hasKotlinDefaultMask, binaryClassName, context);
            this.originalOwner = builder.originalOwner;
            this.originalConstructorDesc = builder.originalConstructorDesc;
        }

        @Override
        protected ConstructorBridgeMethodBuilder copy(boolean hasKotlinDefaultMask, @Nullable String binaryClassName, @Nullable BytecodeInterceptorFilter context) {
            return new ConstructorBridgeMethodBuilder(this, hasKotlinDefaultMask, binaryClassName, context);
        }

        @Override
        protected void buildBridgeMethodImpl(MethodVisitorScope mv) {
            Type ownerType = Type.getObjectType((String)this.originalOwner);
            mv._NEW(ownerType);
            mv._DUP();
            this.copyBridgeMethodArgsOnStack(mv);
            mv._INVOKESPECIAL(ownerType, "<init>", this.originalConstructorDesc);
            mv._DUP();
            super.buildBridgeMethodImpl(mv);
        }

        private static String buildConstructorBridgeDesc(String owner, String desc) {
            Type originalOwner = Type.getObjectType((String)owner);
            Type originalMethodType = Type.getMethodType((String)desc);
            return Type.getMethodDescriptor((Type)originalOwner, (Type[])originalMethodType.getArgumentTypes());
        }
    }

    private static class InstanceBridgeMethodBuilder
    extends DefaultBridgeMethodBuilder {
        private final int tag;
        private final String originalDesc;

        InstanceBridgeMethodBuilder(int tag, String originalOwner, String originalDesc, String interceptorOwner, String interceptorName, String interceptorDesc) {
            super(InstanceBridgeMethodBuilder.buildInstanceBridgeDesc(tag, originalOwner, originalDesc), interceptorOwner, interceptorName, interceptorDesc);
            this.tag = tag;
            this.originalDesc = originalDesc;
        }

        private InstanceBridgeMethodBuilder(String refinedOwner, InstanceBridgeMethodBuilder builder) {
            super(builder, InstanceBridgeMethodBuilder.buildInstanceBridgeDesc(builder.tag, refinedOwner, builder.originalDesc));
            this.tag = builder.tag;
            this.originalDesc = builder.originalDesc;
        }

        private InstanceBridgeMethodBuilder(InstanceBridgeMethodBuilder builder, boolean hasKotlinDefaultMask, @Nullable String binaryClassName, @Nullable BytecodeInterceptorFilter context) {
            super(builder, hasKotlinDefaultMask, binaryClassName, context);
            this.tag = builder.tag;
            this.originalDesc = builder.originalDesc;
        }

        @Override
        protected InstanceBridgeMethodBuilder copy(boolean hasKotlinDefaultMask, @Nullable String binaryClassName, @Nullable BytecodeInterceptorFilter context) {
            return new InstanceBridgeMethodBuilder(this, hasKotlinDefaultMask, binaryClassName, context);
        }

        @Override
        public BridgeMethodBuilder withReceiverType(String targetType) {
            return new InstanceBridgeMethodBuilder(targetType, this);
        }

        private static String buildInstanceBridgeDesc(int tag, String owner, String desc) {
            assert (tag == 9 || tag == 5);
            Type originalOwner = Type.getObjectType((String)owner);
            Type originalMethodType = Type.getMethodType((String)desc);
            ArrayList<Type> interceptorArguments = new ArrayList<Type>(originalMethodType.getArgumentCount() + 1);
            interceptorArguments.add(originalOwner);
            interceptorArguments.addAll(Arrays.asList(originalMethodType.getArgumentTypes()));
            return Type.getMethodDescriptor((Type)originalMethodType.getReturnType(), (Type[])interceptorArguments.toArray(new Type[0]));
        }
    }
}

