%% Generated by lilypond-book
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************

#(ly:set-option 'eps-box-padding 3.000000)



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}




% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "snippets/clip-systems.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it was automatically
%% generated from the LilyPond Snippet Repository
%% (http://lsr.di.unimi.it).
%%
%% Make any changes in the LSR itself, or in
%% `Documentation/snippets/new/`, then run
%% `scripts/auxiliar/makelsr.pl`.
%%
%% This file is in the public domain.

\version "2.23.13"

\header {
%% Translation of GIT committish: f11513f36c131dab18338d6a3a729e24a927150d
  texidocja = "
このコードは、フルスコアから部分をクリップ (抽出) する方法を示しています。@c

このファイルは @code{-dclip-systems} を付加して個別に実行する必要があり、@c
スニペットのページに示されている出力は結果を示しているものではありません。

出力されるファイルの名前は
@samp{base-from-start-to-end[-count].eps} の形になります。

システムの始端や終端が含まれている場合は、System Grob の領域も@c
出力に含まれます (例: 楽器名)。

クリップ領域の終端にある装飾音符は出力に含まれません。

クリップ領域は複数のシステムを含むことができます。この場合には、複数の
EPS ファイルが出力されます。
"
  doctitleja = "システムをクリップする"

%% Translation of GIT committish: a3fd5364fc4f247579da0ed2bfea887ab37285c6
  texidocfr = "
Le code ci-dessous permet de réaliser des découpes à l'emporte pièce,
autrement dit d'extraire des fragments, au sein d'une partition.

Dans la mesure où le rendu inclus dans ce manuel pourrait ne pas être
des plus évidents, nous vous conseillons de traiter ce fichier
individuellement, avec l'option @code{-dclip-systems}.

Les fichiers résultants sont de la forme
@samp{@emph{base}-from-@emph{début}-to-@emph{fin}[-@emph{compteur}].eps}.

Lorsque sont inclus le début ou la fin d'un système, l'extraction
comportera les objets rattachés au système, comme le nom d'instrument.

Les notes d'ornement qui se trouveraient en fin de fragment ne sont pas
incluses.

La découpe peut couvrir plusieurs systèmes, auquel cas seront générés
plusieurs fichiers EPS.
"

  doctitlefr = "Découpe de systèmes"

%% Translation of GIT committish: 0c00cd98e81b27325bed5891b950fe7f0f0ebe5d
  texidoces = "
Este código muestra cómo recortar (extraer) fragmentos a partir de una
partitura completa.

Este archivo tiene que procesarse de forma separada con la opción
@option{-dclip-systems}; la página de fragmentos de código podría no
mostrar el resultado adecuadamente.

La salida consiste en archivos con los nombres
@samp{base-from-inicio-to-final[-número].eps}.


Si se incluyen los comienzos y finales de los sistemas, incluyen las
dimensiones del grob del sistema, por ejemplo los nombres de
instrumento.


Las notas de adorno en el punto final de la región no se incluyen.


Las regiones pueden abarcar varios sistemas.  En este caso, se generan
varios archivos EPS.

"
  doctitlees = "Recorte de sistemas"

%% Translation of GIT committish: 3f57efa0cde39bf0642fb6fb3672a19262ceda83
  texidoca = "
Aquest codi mostra com retallar (extraure) fragments a partir d'una
partitura completa.

Aquest fitxer s'ha de processar de forma separada amb l'opció
@option{-dclip-systems}; la pàgina de fragments de codi podria no
mostrar el resultat adequadament.

La sortida consisteix en fitxers amb els noms
@samp{base-from-inici-to-final[-número].eps}.

Si s'inclouen els començament i finals dels sistemes, inclouen les
dimensions del grob del sistema, per exemple els noms d'instrument.

Les notes d'adorn en el punt final de la regió no s'inclouen.

Les regions poden abastar diversos sistemes.  En aquest cas, es
generen diversos fitxers EPS.

"
  doctitleca = "Retallada de sistemes"

  lsrtags = "paper-and-layout"

  texidoc = "
This code shows how to clip (extract) snippets from a full score.

This file needs to be run separately with @code{-dclip-systems}; the
snippets page may not adequately show the results. The result will be
files named
@samp{@emph{base}-from-@emph{start}-to-@emph{end}[-@emph{count}].eps}.

If system starts and ends are included, they include extents of the
System grob, e.g., instrument names.

Grace notes at the end point of the region are not included.

Regions can span multiple systems.  In this case, multiple EPS files
are generated.
"

  doctitle = "Clip systems"
} % begin verbatim


#(ly:set-option 'clip-systems)
#(define output-suffix "1")

origScore = \score {
  \relative c' {
    \new Staff \with { instrumentName = "Instrument" }
    c1
    d1
    \grace c16 e1
    \key d \major
    f1 \break
    \clef bass
    g,1
    fis1
  }
}

\book {
  \score {
    \origScore
    \layout {
      % Each clip-region is a (START . END) pair
      % where both are rhythmic-locations.

      % (make-rhythmic-locations BAR-NUMBER NUM DEN)
      % means NUM/DEN whole-notes into bar numbered BAR-NUMBER

      clip-regions = #(list
      (cons
       (make-rhythmic-location 2 0 1)
       (make-rhythmic-location 4 0 1))

      (cons
       (make-rhythmic-location 0 0 1)
       (make-rhythmic-location 4 0 1))

      (cons
       (make-rhythmic-location 0 0 1)
       (make-rhythmic-location 6 0 1))
      )
    }
  }
}

#(ly:set-option 'clip-systems #f)
#(define output-suffix #f)

\book {
  \score { \origScore }
  \markup { \bold \fontsize #6 clips }
  \score {
    \lyrics {
      \markup { from-2.0.1-to-4.0.1-clip.eps }
      \markup {
        \epsfile #X #30.0 #(format #f "~a-1-from-2.0.1-to-4.0.1-clip.eps"
                            (ly:parser-output-name)) }
    }
  }
}



% ****************************************************************
% end ly snippet
% ****************************************************************
