untrusted comment: signature from openbsd 5.8 base secret key
RWQNNZXtC/MqP9TLWC5XKIaHfavS/OUkP5BW1bQcK0wEjrNW+P+uY12NqkvhYzh7RdTY0UxAub2PpbvTxuCwNZDIq7YQs7d4gg0=

OpenBSD 5.8 errata 26, Aug 02, 2016:

Missing overflow checks in uvm may result in panics.

Apply by doing:
    signify -Vep /etc/signify/openbsd-58-base.pub -x 026_uvmisavail.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install a kernel:
    cd /usr/src/sys/arch/`machine`/conf
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    config $KK
    cd ../compile/$KK
    make
    make install

Index: sys/uvm/uvm_map.c
===================================================================
RCS file: /cvs/src/sys/uvm/uvm_map.c,v
retrieving revision 1.192
diff -u -p -r1.192 uvm_map.c
--- sys/uvm/uvm_map.c	17 Jul 2015 21:56:14 -0000	1.192
+++ sys/uvm/uvm_map.c	1 Aug 2016 19:17:47 -0000
@@ -781,6 +781,9 @@ uvm_map_isavail(struct vm_map *map, stru
 	struct uvm_map_addr *atree;
 	struct vm_map_entry *i, *i_end;
 
+	if (addr + sz < addr)
+		return 0;
+
 	/*
 	 * Kernel memory above uvm_maxkaddr is considered unavailable.
 	 */
@@ -1041,6 +1044,12 @@ uvm_mapanon(struct vm_map *map, vaddr_t 
 			goto unlock;
 	}
 
+	/* Check if selected address doesn't cause overflow. */
+	if (*addr + sz < *addr) {
+		error = ENOMEM;
+		goto unlock;
+	}
+
 	/* If we only want a query, return now. */
 	if (flags & UVM_FLAG_QUERY) {
 		error = 0;
@@ -1280,6 +1289,12 @@ uvm_map(struct vm_map *map, vaddr_t *add
 
 		if (error != 0)
 			goto unlock;
+	}
+
+	/* Check if selected address doesn't cause overflow. */
+	if (*addr + sz < *addr) {
+		error = ENOMEM;
+		goto unlock;
 	}
 
 	KASSERT((map->flags & VM_MAP_ISVMSPACE) == VM_MAP_ISVMSPACE ||
