/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter;

import com.fasterxml.jackson.core.type.TypeReference;
import com.webauthn4j.converter.exception.DataConversionException;
import com.webauthn4j.converter.util.JsonConverter;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.data.extension.client.ExtensionClientOutput;
import com.webauthn4j.util.AssertUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AuthenticationExtensionsClientOutputsConverter {
    private final JsonConverter jsonConverter;

    public AuthenticationExtensionsClientOutputsConverter(@NotNull ObjectConverter objectConverter) {
        AssertUtil.notNull(objectConverter, "objectConverter must not be null");
        this.jsonConverter = objectConverter.getJsonConverter();
    }

    @Nullable
    public <T extends ExtensionClientOutput> AuthenticationExtensionsClientOutputs<T> convert(@NotNull String value) {
        try {
            AssertUtil.notNull(value, "value must not be null");
            return (AuthenticationExtensionsClientOutputs)this.jsonConverter.readValue(value, new TypeReference<AuthenticationExtensionsClientOutputs<T>>(){});
        }
        catch (IllegalArgumentException e) {
            throw new DataConversionException(e);
        }
    }

    @NotNull
    public <T extends ExtensionClientOutput> String convertToString(@NotNull AuthenticationExtensionsClientOutputs<T> value) {
        try {
            AssertUtil.notNull(value, "value must not be null");
            return this.jsonConverter.writeValueAsString(value);
        }
        catch (IllegalArgumentException e) {
            throw new DataConversionException(e);
        }
    }
}

