/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.math;

import java.math.BigDecimal;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;
import org.pentaho.reporting.libraries.formula.util.NumberUtil;

public class ModFunction
implements Function {
    private static final long serialVersionUID = -2492279311353854670L;

    @Override
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        Object value2;
        Object value1;
        Type type1;
        int parameterCount = parameters.getParameterCount();
        if (parameterCount != 2) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = context.getTypeRegistry();
        Number number1 = typeRegistry.convertToNumber(type1 = parameters.getType(0), value1 = parameters.getValue(0));
        if (number1 == null) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        BigDecimal divided = NumberUtil.getAsBigDecimal(number1);
        Type type2 = parameters.getType(1);
        Number number2 = typeRegistry.convertToNumber(type2, value2 = parameters.getValue(1));
        if (number2 == null) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        BigDecimal divisor = NumberUtil.getAsBigDecimal(number2);
        if (divisor.signum() == 0) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARITHMETIC_VALUE);
        }
        BigDecimal divide = new BigDecimal(divided.divide(divisor, 0, 3).toString());
        BigDecimal reminder = divided.subtract(divisor.multiply(divide));
        if (divide.signum() == 0 && (divided.signum() == -1 && divisor.signum() != -1 || divisor.signum() == -1 && divided.signum() != -1)) {
            reminder = divided.add(divisor);
        }
        return new TypeValuePair(NumberType.GENERIC_NUMBER, reminder);
    }

    @Override
    public String getCanonicalName() {
        return "MOD";
    }
}

