/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions;

import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.ui.actions.Command;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.actions.support.Displayable;
import org.netbeans.modules.php.project.ui.actions.tests.GoToTest;
import org.netbeans.spi.gototest.TestLocator;
import org.netbeans.spi.project.ActionProvider;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class RunTestCommand
extends Command
implements Displayable {
    public static final String ID = "test.single";
    public static final String DISPLAY_NAME = NbBundle.getMessage(RunTestCommand.class, (String)"LBL_TestFile");

    public RunTestCommand(PhpProject project) {
        super(project);
    }

    @Override
    public void invokeActionInternal(Lookup context) {
        FileObject testClass = this.findTest(context);
        if (testClass == null) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(RunTestCommand.class, (String)"MSG_TestNotFound"));
            return;
        }
        ((ActionProvider)this.getProject().getLookup().lookup(ActionProvider.class)).invokeAction("run.single", Lookups.fixed((Object[])new Object[]{testClass}));
    }

    @Override
    public boolean isActionEnabledInternal(Lookup context) {
        return true;
    }

    @Override
    public String getCommandId() {
        return ID;
    }

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    private FileObject findTest(Lookup context) {
        FileObject fo = CommandUtils.fileForContextOrSelectedNodes(context, ProjectPropertiesSupport.getSourcesDirectory(this.getProject()));
        if (fo == null) {
            return null;
        }
        TestLocator.LocationResult locationResult = GoToTest.findTest(this.getProject(), fo);
        if (locationResult == null) {
            return null;
        }
        return locationResult.getFileObject();
    }
}

