/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.ui.api;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.gsf.testrunner.api.CommonUtils;
import org.netbeans.modules.gsf.testrunner.ui.annotation.TestMethodAnnotation;
import org.netbeans.modules.gsf.testrunner.ui.api.Bundle;
import org.netbeans.modules.gsf.testrunner.ui.api.TestMethodController;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SingleMethod;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;
import org.openide.text.NbDocument;
import org.openide.util.Cancellable;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.lookup.Lookups;

public abstract class TestMethodRunnerProvider {
    private final String command = "run.single.method";
    private RequestProcessor.Task singleMethodTask;
    private SingleMethod singleMethod;

    public abstract boolean canHandle(Node var1);

    public abstract SingleMethod getTestMethod(Document var1, int var2);

    public boolean isTestClass(Node activatedNode) {
        return true;
    }

    public final void runTestMethod(Node activatedNode) {
        int caret;
        Document doc;
        Node activeNode = activatedNode;
        final EditorCookie ec = (EditorCookie)activeNode.getLookup().lookup(EditorCookie.class);
        if (ec != null) {
            JEditorPane pane = (JEditorPane)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<JEditorPane>(){

                public JEditorPane run() {
                    return NbDocument.findRecentEditorPane((EditorCookie)ec);
                }
            });
            if (pane != null) {
                doc = pane.getDocument();
                caret = pane.getCaret().getDot();
            } else {
                doc = null;
                caret = -1;
            }
        } else {
            doc = null;
            caret = -1;
        }
        this.singleMethod = (SingleMethod)activeNode.getLookup().lookup(SingleMethod.class);
        if (this.singleMethod == null) {
            RequestProcessor RP = new RequestProcessor("TestMethodRunnerProvider", 1, true);
            this.singleMethodTask = RP.create(new Runnable(){

                @Override
                public void run() {
                    TestMethodRunnerProvider.this.singleMethod = TestMethodRunnerProvider.findTestMethod(doc, caret, TestMethodRunnerProvider.this::getTestMethod);
                }
            });
            final ProgressHandle ph = ProgressHandleFactory.createHandle((String)Bundle.Search_For_Test_Method(), (Cancellable)this.singleMethodTask);
            this.singleMethodTask.addTaskListener(new TaskListener(){

                public void taskFinished(Task task) {
                    ph.finish();
                    if (TestMethodRunnerProvider.this.singleMethod == null) {
                        StatusDisplayer.getDefault().setStatusText(Bundle.No_Test_Method_Found());
                    } else {
                        Mutex.EVENT.readAccess(new Runnable(){

                            @Override
                            public void run() {
                                ActionProvider ap = CommonUtils.getInstance().getActionProvider(TestMethodRunnerProvider.this.singleMethod.getFile());
                                if (ap != null && Arrays.asList(ap.getSupportedActions()).contains("run.single.method") && ap.isActionEnabled("run.single.method", Lookups.singleton((Object)TestMethodRunnerProvider.this.singleMethod))) {
                                    ap.invokeAction("run.single.method", Lookups.singleton((Object)TestMethodRunnerProvider.this.singleMethod));
                                }
                            }
                        });
                    }
                }
            });
            ph.start();
            this.singleMethodTask.schedule(0);
        }
    }

    static SingleMethod findTestMethod(Document doc, int cursor, BiFunction<Document, Integer, SingleMethod> fallback) {
        List methods = (List)doc.getProperty(TestMethodAnnotation.DOCUMENT_METHODS_KEY);
        if (methods != null) {
            int s = 0;
            int e = methods.size();
            while (e > s) {
                int m = s + (e - s) / 2;
                TestMethodController.TestMethod cand = (TestMethodController.TestMethod)methods.get(m);
                if (cand.start().getOffset() <= cursor && cursor <= cand.end().getOffset()) {
                    return cand.method();
                }
                if (cursor < cand.start().getOffset()) {
                    e = m - 1;
                    continue;
                }
                s = m + 1;
            }
        }
        return fallback.apply(doc, cursor);
    }
}

