/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui;

import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.project.ui.ProjectUISupport;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.FileSystemAction;
import org.openide.actions.FindAction;
import org.openide.actions.PasteAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;

public final class DocBaseNodeFactory
implements NodeFactory {
    private static RequestProcessor RP = new RequestProcessor();

    public NodeList createNodes(Project p) {
        WebProject project = (WebProject)p.getLookup().lookup(WebProject.class);
        assert (project != null);
        return new DocBaseNodeList(project);
    }

    private static class DocBaseNodeList
    implements NodeList<String>,
    PropertyChangeListener {
        private static final String DOC_BASE = "docBase";
        private static final String WEB_INF = "webInf";
        private final WebProject project;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private final PropertyEvaluator evaluator;
        private final UpdateHelper helper;
        private SourceGroup webDocRoot;

        DocBaseNodeList(WebProject proj) {
            this.project = proj;
            this.evaluator = this.project.evaluator();
            this.helper = this.project.getUpdateHelper();
            Sources s = (Sources)this.project.getLookup().lookup(Sources.class);
            assert (s != null);
            if (s.getSourceGroups("doc_root").length > 0) {
                this.webDocRoot = s.getSourceGroups("doc_root")[0];
            } else {
                String name = ProjectUtils.getInformation((Project)proj).getDisplayName();
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(DocBaseNodeList.class, (String)"LBL_No_Source_Groups_Found", (Object)name), 1);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            }
        }

        public List<String> keys() {
            FolderHolder nodeFolders = this.getNodeFolders();
            ArrayList<String> result = new ArrayList<String>();
            result.add(DOC_BASE + this.getFolderPath(nodeFolders.getWebDocBaseDir()));
            if (!nodeFolders.hasCorrectStructure()) {
                result.add(WEB_INF + this.getFolderPath(nodeFolders.getWebInfDir()));
            }
            return result;
        }

        public void addChangeListener(ChangeListener l) {
            this.changeSupport.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.changeSupport.removeChangeListener(l);
        }

        public Node node(String key) {
            FolderHolder nodeFolders = this.getNodeFolders();
            if (key.startsWith(DOC_BASE)) {
                FileObject webDocBaseDir = nodeFolders.getWebDocBaseDir();
                DataFolder webFolder = this.getFolder(webDocBaseDir);
                if (webFolder != null) {
                    return new DocBaseNode(webFolder, this.project, new VisibilityQueryDataFilter(this.webDocRoot));
                }
                return null;
            }
            if (key.startsWith(WEB_INF)) {
                if (nodeFolders.hasCorrectStructure()) {
                    return null;
                }
                FileObject webInfDir = nodeFolders.getWebInfDir();
                DataFolder webInfFolder = this.getFolder(webInfDir);
                if (webInfFolder != null) {
                    return new WebInfNode(webInfFolder, this.project, new VisibilityQueryDataFilter(null));
                }
                return null;
            }
            assert (false) : "No node for key: " + key;
            return null;
        }

        public void addNotify() {
            this.evaluator.addPropertyChangeListener((PropertyChangeListener)this);
        }

        public void removeNotify() {
            this.evaluator.removePropertyChangeListener((PropertyChangeListener)this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    changeSupport.fireChange();
                }
            });
        }

        private DataFolder getFolder(FileObject folder) {
            if (folder != null) {
                return DataFolder.findFolder((FileObject)folder);
            }
            return null;
        }

        private String getFolderPath(FileObject folder) {
            if (folder == null) {
                return "";
            }
            return folder.getPath();
        }

        private FileObject getFileObject(String propName) {
            String foName = this.evaluator.getProperty(propName);
            if (foName == null) {
                return null;
            }
            FileObject fo = this.helper.getAntProjectHelper().resolveFileObject(foName);
            return fo != null && fo.isValid() ? fo : null;
        }

        private FolderHolder getNodeFolders() {
            return (FolderHolder)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<FolderHolder>(){

                public FolderHolder run() {
                    FileObject webDocBaseDir = this.getFileObject("web.docbase.dir");
                    FileObject webInf = this.getFileObject("webinf.dir");
                    return new FolderHolder(webDocBaseDir, webInf);
                }
            });
        }

        private static final class FolderHolder {
            private final FileObject webDocBaseDir;
            private final FileObject webInfDir;

            public FolderHolder(FileObject webDocBaseDir, FileObject webInfDir) {
                this.webDocBaseDir = webDocBaseDir;
                this.webInfDir = webInfDir;
            }

            public FileObject getWebDocBaseDir() {
                return this.webDocBaseDir;
            }

            public FileObject getWebInfDir() {
                return this.webInfDir;
            }

            public boolean hasCorrectStructure() {
                if (this.webDocBaseDir == null || this.webInfDir == null) {
                    return false;
                }
                return FileUtil.isParentOf((FileObject)this.webDocBaseDir, (FileObject)this.webInfDir);
            }
        }
    }

    static final class VisibilityQueryDataFilter
    implements ChangeListener,
    ChangeableDataFilter,
    PropertyChangeListener {
        private static final long serialVersionUID = 1L;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private final SourceGroup sourceGroup;

        public VisibilityQueryDataFilter(SourceGroup sourceGroup) {
            this.sourceGroup = sourceGroup;
            if (this.sourceGroup != null) {
                this.sourceGroup.addPropertyChangeListener((PropertyChangeListener)this);
            }
            VisibilityQuery defaultQuery = VisibilityQuery.getDefault();
            defaultQuery.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)defaultQuery));
        }

        public boolean acceptDataObject(DataObject obj) {
            FileObject fo = obj.getPrimaryFile();
            return (this.sourceGroup == null || this.sourceGroup.contains(fo)) && VisibilityQuery.getDefault().isVisible(fo);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.changeSupport.fireChange();
        }

        public void addChangeListener(ChangeListener listener) {
            this.changeSupport.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.changeSupport.removeChangeListener(listener);
        }

        @Override
        public void propertyChange(PropertyChangeEvent arg0) {
            this.changeSupport.fireChange();
        }
    }

    private static abstract class BaseNode
    extends FilterNode {
        private static Image WEB_PAGES_BADGE = ImageUtilities.loadImage((String)"org/netbeans/modules/web/project/ui/resources/webPagesBadge.gif");
        private static final String JAVA_MIME_TYPE = "text/x-java";
        private Action[] actions;
        protected final WebProject project;

        BaseNode(DataFolder folder, WebProject project, VisibilityQueryDataFilter filter) {
            super(folder.getNodeDelegate(), folder.createNodeChildren((DataFilter)filter));
            this.project = project;
        }

        public Image getIcon(int type) {
            return this.computeIcon(false, type);
        }

        public Image getOpenedIcon(int type) {
            return this.computeIcon(true, type);
        }

        private Node getDataFolderNodeDelegate() {
            return ((DataFolder)this.getLookup().lookup(DataFolder.class)).getNodeDelegate();
        }

        private Image computeIcon(boolean opened, int type) {
            Image image = opened ? this.getDataFolderNodeDelegate().getOpenedIcon(type) : this.getDataFolderNodeDelegate().getIcon(type);
            image = ImageUtilities.mergeImages((Image)image, (Image)WEB_PAGES_BADGE, (int)7, (int)7);
            return image;
        }

        public boolean canRename() {
            return false;
        }

        public Action[] getActions(boolean context) {
            if (this.actions == null) {
                this.actions = new Action[9];
                this.actions[0] = CommonProjectActions.newFileAction();
                this.actions[1] = null;
                this.actions[2] = SystemAction.get(FindAction.class);
                this.actions[3] = null;
                this.actions[4] = SystemAction.get(PasteAction.class);
                this.actions[5] = null;
                this.actions[6] = SystemAction.get(FileSystemAction.class);
                this.actions[7] = null;
                this.actions[8] = ProjectUISupport.createPreselectPropertiesAction((Project)this.project, (String)"Sources", null);
            }
            return this.actions;
        }

        public PasteType getDropType(Transferable t, int action, int index) {
            try {
                Object data;
                if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor) && (data = t.getTransferData(DataFlavor.javaFileListFlavor)) != null) {
                    List list = (List)data;
                    for (Object each : list) {
                        File f = FileUtil.normalizeFile((File)((File)each));
                        FileObject file = FileUtil.toFileObject((File)f);
                        if (file == null || !JAVA_MIME_TYPE.equals(file.getMIMEType())) continue;
                        return null;
                    }
                }
            }
            catch (UnsupportedFlavorException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return super.getDropType(t, action, index);
        }
    }

    private static final class WebInfNode
    extends BaseNode {
        WebInfNode(DataFolder folder, WebProject project, VisibilityQueryDataFilter filter) {
            super(folder, project, filter);
        }

        public String getDisplayName() {
            return NbBundle.getMessage(DocBaseNodeFactory.class, (String)"LBL_Node_WebInf");
        }
    }

    private static final class DocBaseNode
    extends BaseNode {
        DocBaseNode(DataFolder folder, WebProject project, VisibilityQueryDataFilter filter) {
            super(folder, project, filter);
        }

        public String getDisplayName() {
            return NbBundle.getMessage(DocBaseNodeFactory.class, (String)"LBL_Node_DocBase");
        }
    }
}

