/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.graph;

import java.util.Stack;
import org.netbeans.modules.java.graph.DependencyGraphScene;
import org.netbeans.modules.java.graph.GraphNode;
import org.netbeans.modules.java.graph.GraphNodeImplementation;
import org.netbeans.modules.java.graph.GraphNodeVisitor;
import org.netbeans.modules.java.graph.NodeWidget;

class SearchVisitor
implements GraphNodeVisitor {
    private final DependencyGraphScene scene;
    private final Stack<GraphNodeImplementation> path;
    private GraphNodeImplementation root;
    private String searchTerm;

    SearchVisitor(DependencyGraphScene scene) {
        this.scene = scene;
        this.path = new Stack();
    }

    public void setSearchString(String search) {
        this.searchTerm = search;
    }

    public boolean visit(GraphNodeImplementation node) {
        if (this.root == null) {
            this.root = node;
        }
        if (!this.path.contains(node) && this.scene.isIncluded(node)) {
            GraphNode grNode = this.scene.getGraphNodeRepresentant(node);
            if (grNode == null) {
                return false;
            }
            NodeWidget aw = (NodeWidget)this.scene.findWidget(grNode);
            aw.highlightText(this.searchTerm);
            this.path.push(node);
            return true;
        }
        return false;
    }

    public boolean endVisit(GraphNodeImplementation node) {
        if (this.path.peek() == node) {
            this.path.pop();
        }
        return true;
    }
}

