/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetVolumeBackupPolicyRequest
extends BmcRequest<Void> {
    private String policyId;

    public String getPolicyId() {
        return this.policyId;
    }

    public Builder toBuilder() {
        return new Builder().policyId(this.policyId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",policyId=").append(String.valueOf(this.policyId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetVolumeBackupPolicyRequest)) {
            return false;
        }
        GetVolumeBackupPolicyRequest other = (GetVolumeBackupPolicyRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.policyId, other.policyId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.policyId == null ? 43 : this.policyId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetVolumeBackupPolicyRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String policyId = null;

        public Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetVolumeBackupPolicyRequest o) {
            this.policyId(o.getPolicyId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetVolumeBackupPolicyRequest build() {
            GetVolumeBackupPolicyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetVolumeBackupPolicyRequest buildWithoutInvocationCallback() {
            GetVolumeBackupPolicyRequest request = new GetVolumeBackupPolicyRequest();
            request.policyId = this.policyId;
            return request;
        }
    }
}

