/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.fife.ui.rsyntaxtextarea.CodeTemplate;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class CodeTemplateManager {
    private int maxTemplateIDLength;
    private List templates;
    private KeyStroke insertTrigger;
    private String insertTriggerString;
    private Segment s;
    private TemplateComparator comparator;
    private File directory;
    private static final String AFTER_CARET = "afterCaret";
    private static final String BEFORE_CARET = "beforeCaret";
    private static final String CODE_TEMPLATE = "codeTemplate";
    private static final String ENCODING = "UTF-8";
    private static final String ID = "id";
    private static final String _VALUE = "value";

    public CodeTemplateManager() {
        this.setInsertTrigger(KeyStroke.getKeyStroke(' '));
        this.s = new Segment();
        this.comparator = new TemplateComparator();
        this.templates = new ArrayList();
    }

    public void addTemplate(CodeTemplate codeTemplate) {
        if (codeTemplate != null) {
            this.templates.add(codeTemplate);
            this.sortTemplates();
        }
    }

    public KeyStroke getInsertTrigger() {
        return this.insertTrigger;
    }

    public String getInsertTriggerString() {
        return this.insertTriggerString;
    }

    public CodeTemplate getTemplate(RSyntaxTextArea rSyntaxTextArea) {
        int n = rSyntaxTextArea.getCaretPosition();
        int n2 = Math.min(n, this.maxTemplateIDLength);
        try {
            Document document = rSyntaxTextArea.getDocument();
            document.getText(n - n2, n2, this.s);
            int n3 = Collections.binarySearch(this.templates, this.s, this.comparator);
            return n3 >= 0 ? (CodeTemplate)this.templates.get(n3) : null;
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            throw new InternalError("Error in CodeTemplateManager");
        }
    }

    public int getTemplateCount() {
        return this.templates.size();
    }

    CodeTemplate[] getTemplates() {
        CodeTemplate[] codeTemplateArray = new CodeTemplate[this.templates.size()];
        return this.templates.toArray(codeTemplateArray);
    }

    void replaceTemplates(CodeTemplate[] codeTemplateArray) {
        this.templates.clear();
        if (codeTemplateArray != null) {
            for (int i = 0; i < codeTemplateArray.length; ++i) {
                this.templates.add(codeTemplateArray[i]);
            }
        }
        this.sortTemplates();
    }

    public boolean saveTemplates() {
        if (this.templates == null) {
            return true;
        }
        if (this.directory == null || !this.directory.isDirectory()) {
            return false;
        }
        File[] fileArray = this.directory.listFiles(new XMLFileFilter());
        if (fileArray == null) {
            return false;
        }
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            fileArray[i].delete();
        }
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception exception) {
            return false;
        }
        DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
        boolean bl = true;
        Iterator iterator = this.templates.iterator();
        while (iterator.hasNext()) {
            CodeTemplate codeTemplate = (CodeTemplate)iterator.next();
            File file = new File(this.directory, new String(codeTemplate.getID()) + ".xml");
            try {
                org.w3c.dom.Document document = dOMImplementation.createDocument(null, CODE_TEMPLATE, null);
                this.saveToFile(codeTemplate, document, file);
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    private void saveToFile(CodeTemplate codeTemplate, org.w3c.dom.Document document, File file) throws Exception {
        Element element = document.getDocumentElement();
        Element element2 = document.createElement(ID);
        element2.setAttribute(_VALUE, new String(codeTemplate.getID()));
        element.appendChild(element2);
        element2 = document.createElement(BEFORE_CARET);
        String string = codeTemplate.getBeforeCaretText();
        if (string != null) {
            element2.appendChild(document.createCDATASection(string));
        }
        element.appendChild(element2);
        element2 = document.createElement(AFTER_CARET);
        string = codeTemplate.getAfterCaretText();
        if (string != null) {
            element2.appendChild(document.createCDATASection(string));
        }
        element.appendChild(element2);
        StreamResult streamResult = new StreamResult(file);
        DOMSource dOMSource = new DOMSource(document);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", ENCODING);
        transformer.transform(dOMSource, streamResult);
    }

    public void setInsertTrigger(KeyStroke keyStroke) {
        if (keyStroke != null) {
            this.insertTrigger = keyStroke;
            this.insertTriggerString = keyStroke.getKeyChar() + "";
        }
    }

    public int setTemplateDirectory(File file) {
        if (file != null && file.isDirectory()) {
            this.directory = file;
            File[] fileArray = file.listFiles(new XMLFileFilter());
            int n = fileArray == null ? 0 : fileArray.length;
            int n2 = this.templates.size();
            if (n > 0) {
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                SAXParser sAXParser = null;
                try {
                    sAXParser = sAXParserFactory.newSAXParser();
                }
                catch (Exception exception) {
                    return -1;
                }
                Handler handler = new Handler();
                ArrayList<CodeTemplate> arrayList = new ArrayList<CodeTemplate>(n2 + n);
                arrayList.addAll(this.templates);
                for (int i = 0; i < n; ++i) {
                    try {
                        sAXParser.parse(fileArray[i], (DefaultHandler)handler);
                        CodeTemplate codeTemplate = handler.getCodeTemplate();
                        if (codeTemplate == null) continue;
                        arrayList.add(codeTemplate);
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                this.templates = arrayList;
                this.sortTemplates();
            }
            return this.getTemplateCount();
        }
        return -1;
    }

    private final void sortTemplates() {
        this.maxTemplateIDLength = 0;
        Iterator iterator = this.templates.iterator();
        while (iterator.hasNext()) {
            CodeTemplate codeTemplate = (CodeTemplate)iterator.next();
            if (codeTemplate == null) {
                iterator.remove();
                continue;
            }
            this.maxTemplateIDLength = Math.max(this.maxTemplateIDLength, codeTemplate.getID().length);
        }
        Collections.sort(this.templates);
    }

    private static class XMLFileFilter
    implements FileFilter {
        private XMLFileFilter() {
        }

        public boolean accept(File file) {
            return file.getName().toLowerCase().endsWith(".xml");
        }
    }

    private static class TemplateComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            int n;
            CodeTemplate codeTemplate = (CodeTemplate)object;
            char[] cArray = codeTemplate.getID();
            int n2 = 0;
            int n3 = cArray.length;
            Segment segment = (Segment)object2;
            char[] cArray2 = segment.array;
            int n4 = segment.count;
            for (n = segment.offset + n4 - 1; n >= segment.offset && CodeTemplate.isValidChar(cArray2[n]); --n) {
            }
            int n5 = ++n - segment.offset;
            int n6 = Math.min(n3, n4 -= n5);
            while (n6-- != 0) {
                char c;
                char c2;
                if ((c2 = cArray[n2++]) == (c = cArray2[n++])) continue;
                return c2 - c;
            }
            return n3 - n4;
        }
    }

    private static class Handler
    extends DefaultHandler {
        private CodeTemplate template;
        private String id;
        private String beforeCaret;
        private String afterCaret;
        private StringBuffer sb = new StringBuffer();
        private boolean storeChars;

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.storeChars) {
                this.sb.append(cArray, n, n2);
            }
        }

        public void endDocument() throws SAXException {
            this.template = new CodeTemplate(this.id, this.beforeCaret, this.afterCaret);
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (!CodeTemplateManager.ID.equals(string3)) {
                if (CodeTemplateManager.BEFORE_CARET.equals(string3)) {
                    this.beforeCaret = this.sb.toString();
                } else if (CodeTemplateManager.AFTER_CARET.equals(string3)) {
                    this.afterCaret = this.sb.toString();
                }
            }
        }

        public CodeTemplate getCodeTemplate() {
            return this.template;
        }

        public void startDocument() throws SAXException {
            this.sb.setLength(0);
            this.storeChars = false;
            this.template = null;
            this.afterCaret = null;
            this.beforeCaret = null;
            this.id = null;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (CodeTemplateManager.ID.equals(string3)) {
                this.id = attributes.getValue(CodeTemplateManager._VALUE);
            } else if (CodeTemplateManager.BEFORE_CARET.equals(string3)) {
                this.sb.setLength(0);
                this.storeChars = true;
            } else if (CodeTemplateManager.AFTER_CARET.equals(string3)) {
                this.sb.setLength(0);
                this.storeChars = true;
            }
        }
    }
}

