/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest;

import java.io.Closeable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.ws.rs.sse.OutboundSseEvent;
import javax.ws.rs.sse.SseEventSink;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class SseBroadcaster<@NonNull I>
implements Closeable {
    private final Logger logger = LoggerFactory.getLogger(SseBroadcaster.class);
    private final List<Listener<I>> listeners = new CopyOnWriteArrayList<Listener<I>>();
    private final Map<SseEventSink, I> sinks = new ConcurrentHashMap<SseEventSink, I>();

    public void addListener(Listener<I> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener<I> listener) {
        this.listeners.remove(listener);
    }

    public @Nullable I add(SseEventSink sink, I info) {
        return this.sinks.put(sink, info);
    }

    public @Nullable I remove(SseEventSink sink) {
        return this.sinks.remove(sink);
    }

    public @Nullable I getInfo(SseEventSink sink) {
        return this.sinks.get(sink);
    }

    public Stream<I> getInfoIf(Predicate<I> predicate) {
        return this.sinks.values().stream().filter(predicate);
    }

    @Override
    public void close() {
        Iterator<Map.Entry<SseEventSink, I>> it = this.sinks.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<SseEventSink, I> entry = it.next();
            it.remove();
            this.close(entry.getKey());
            this.notifyAboutRemoval(entry.getKey(), entry.getValue());
        }
    }

    public void send(OutboundSseEvent event) {
        this.sendIf(event, info -> true);
    }

    public void sendIf(OutboundSseEvent event, Predicate<I> predicate) {
        this.logger.trace("broadcast to potential {} sinks", (Object)this.sinks.size());
        this.sinks.forEach((sink, info) -> {
            if (!predicate.test(info)) {
                return;
            }
            if (sink.isClosed()) {
                this.handleRemoval((SseEventSink)sink);
                return;
            }
            sink.send(event).exceptionally(throwable -> {
                this.logger.debug("Sending event to sink failed", throwable);
                this.close((SseEventSink)sink);
                this.handleRemoval((SseEventSink)sink);
                return null;
            });
        });
    }

    public void closeAndRemoveIf(Predicate<I> predicate) {
        this.sinks.forEach((sink, info) -> {
            if (predicate.test(info)) {
                this.close((SseEventSink)sink);
                this.handleRemoval((SseEventSink)sink);
            }
        });
    }

    private void close(SseEventSink sink) {
        if (sink.isClosed()) {
            this.logger.debug("SSE event sink is already closed");
            return;
        }
        try {
            this.logger.debug("Closing SSE event sink");
            sink.close();
        }
        catch (RuntimeException ex) {
            this.logger.debug("Closing SSE event sink failed. Nothing we can do here...", (Throwable)ex);
        }
    }

    private void handleRemoval(SseEventSink sink) {
        @Nullable I info = this.sinks.remove(sink);
        if (info != null) {
            this.notifyAboutRemoval(sink, info);
        }
    }

    private void notifyAboutRemoval(SseEventSink sink, I info) {
        this.listeners.forEach(listener -> listener.sseEventSinkRemoved(sink, info));
    }

    public static interface Listener<I> {
        public void sseEventSinkRemoved(SseEventSink var1, I var2);
    }
}

