/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (uvec4(16u, 24u, 23u, 25u) >> uvec4(16u, 24u, 23u, 25u)) => uvec4(0u, 0u, 0u, 0u)
 * (uvec4(16u, 24u, 23u, 25u) >> uvec4(23u, 12u, 14u, 19u)) => uvec4(0u, 0u, 0u, 0u)
 * (uvec4(23u, 12u, 14u, 19u) >> uvec4(16u, 24u, 23u, 25u)) => uvec4(0u, 0u, 0u, 0u)
 * (uvec4(23u, 12u, 14u, 19u) >> uvec4(23u, 12u, 14u, 19u)) => uvec4(0u, 0u, 0u, 0u)
 */
#version 150

void main()
{
  float[all(equal((uvec4(16u, 24u, 23u, 25u) >> uvec4(16u, 24u, 23u, 25u)), uvec4(0u, 0u, 0u, 0u))) ? 1 : -1] array0;
  float[all(equal((uvec4(16u, 24u, 23u, 25u) >> uvec4(23u, 12u, 14u, 19u)), uvec4(0u, 0u, 0u, 0u))) ? 1 : -1] array1;
  float[all(equal((uvec4(23u, 12u, 14u, 19u) >> uvec4(16u, 24u, 23u, 25u)), uvec4(0u, 0u, 0u, 0u))) ? 1 : -1] array2;
  float[all(equal((uvec4(23u, 12u, 14u, 19u) >> uvec4(23u, 12u, 14u, 19u)), uvec4(0u, 0u, 0u, 0u))) ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
