/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;

public class ChangeStateMessage
extends AttributeMessage {
    public static final String TAG = "changeState";
    private static final String STATE_TAG = "state";
    private static final String UNIT_TAG = "unit";

    public ChangeStateMessage(Unit unit, Unit.UnitState state) {
        super(TAG, UNIT_TAG, unit.getId(), STATE_TAG, String.valueOf((Object)state));
    }

    public ChangeStateMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, UNIT_TAG, STATE_TAG);
    }

    @Override
    public boolean currentPlayerMessage() {
        return true;
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        Unit.UnitState state;
        Unit unit;
        String unitId = this.getStringAttribute(UNIT_TAG);
        String stateString = this.getStringAttribute(STATE_TAG);
        try {
            unit = serverPlayer.getOurFreeColGameObject(unitId, Unit.class);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        try {
            state = Enum.valueOf(Unit.UnitState.class, stateString);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        if (!unit.checkSetState(state)) {
            return serverPlayer.clientError("Unit " + unitId + " can not change state: " + unit.getState() + " -> " + stateString);
        }
        return this.igc(freeColServer).changeState(serverPlayer, unit, state);
    }
}

