/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.undo.AbstractUndoableEdit;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.action.AbstractDrawingViewAction;
import org.jhotdraw.util.ResourceBundleUtil;

public class DrawingAttributeAction
extends AbstractDrawingViewAction {
    protected Map<AttributeKey, Object> attributes;

    public DrawingAttributeAction(DrawingEditor drawingEditor, AttributeKey attributeKey, Object object) {
        this(drawingEditor, attributeKey, object, null, null);
    }

    public DrawingAttributeAction(DrawingEditor drawingEditor, AttributeKey attributeKey, Object object, Icon icon) {
        this(drawingEditor, attributeKey, object, null, icon);
    }

    public DrawingAttributeAction(DrawingEditor drawingEditor, AttributeKey attributeKey, Object object, String string) {
        this(drawingEditor, attributeKey, object, string, null);
    }

    public DrawingAttributeAction(DrawingEditor drawingEditor, AttributeKey attributeKey, Object object, String string, Icon icon) {
        this(drawingEditor, attributeKey, object, string, icon, null);
    }

    public DrawingAttributeAction(DrawingEditor drawingEditor, AttributeKey attributeKey, Object object, String string, Icon icon, Action action) {
        super(drawingEditor);
        this.attributes = new HashMap<AttributeKey, Object>();
        this.attributes.put(attributeKey, object);
        this.putValue("Name", string);
        this.putValue("SmallIcon", icon);
        this.setEnabled(true);
    }

    public DrawingAttributeAction(DrawingEditor drawingEditor, Map<AttributeKey, Object> map, String string, Icon icon) {
        super(drawingEditor);
        this.attributes = map;
        this.putValue("Name", string);
        this.putValue("SmallIcon", icon);
        this.updateEnabledState();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        final ArrayList<Object> arrayList = new ArrayList<Object>();
        final Drawing drawing = this.getView().getDrawing();
        arrayList.add(drawing.getAttributesRestoreData());
        drawing.willChange();
        for (Map.Entry<AttributeKey, Object> entry : this.attributes.entrySet()) {
            drawing.set(entry.getKey(), entry.getValue());
        }
        drawing.changed();
        AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

            @Override
            public String getPresentationName() {
                String string = (String)DrawingAttributeAction.this.getValue("undoPresentationName");
                if (string == null) {
                    string = (String)DrawingAttributeAction.this.getValue("Name");
                }
                if (string == null) {
                    ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
                    string = resourceBundleUtil.getString("attribute.text");
                }
                return string;
            }

            @Override
            public void undo() {
                super.undo();
                Iterator iterator = arrayList.iterator();
                drawing.willChange();
                drawing.restoreAttributesTo(iterator.next());
                drawing.changed();
            }

            @Override
            public void redo() {
                super.redo();
                arrayList.add(drawing.getAttributesRestoreData());
                drawing.willChange();
                for (Map.Entry<AttributeKey, Object> entry : DrawingAttributeAction.this.attributes.entrySet()) {
                    drawing.set(entry.getKey(), entry.getValue());
                }
                drawing.changed();
            }
        };
        this.fireUndoableEditHappened(abstractUndoableEdit);
    }
}

