untrusted comment: verify with openbsd-71-base.pub
RWR2eHwZTOEiTYIFdYu6YTGGTUu3YAdFjHwtpl0yMI1jjI7nGPdXoukM5cuFWzZZZMqbYv56rsu+rCQvSQ9RFFGDsa3XQ11Pnw4=

OpenBSD 7.1 errata 018, January 13, 2023:

A TCP packet with destination port 0 that matches a pf divert-to
rule could crash the kernel.

Apply by doing:
    signify -Vep /etc/signify/openbsd-71-base.pub -x 018_tcp.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/net/pf.c
===================================================================
RCS file: /cvs/src/sys/net/pf.c,v
diff -u -p -r1.1126 pf.c
--- sys/net/pf.c	17 Mar 2022 18:27:55 -0000	1.1126
+++ sys/net/pf.c	10 Jan 2023 11:08:21 -0000
@@ -6729,7 +6729,8 @@ pf_setup_pdesc(struct pf_pdesc *pd, sa_f
 		    NULL, reason, pd->af))
 			return (PF_DROP);
 		pd->hdrlen = sizeof(*th);
-		if (pd->off + (th->th_off << 2) > pd->tot_len ||
+		if (th->th_dport == 0 ||
+		    pd->off + (th->th_off << 2) > pd->tot_len ||
 		    (th->th_off << 2) < sizeof(struct tcphdr)) {
 			REASON_SET(reason, PFRES_SHORT);
 			return (PF_DROP);
Index: sys/netinet/tcp_input.c
===================================================================
RCS file: /cvs/src/sys/netinet/tcp_input.c,v
diff -u -p -r1.375 tcp_input.c
--- sys/netinet/tcp_input.c	4 Jan 2022 06:32:39 -0000	1.375
+++ sys/netinet/tcp_input.c	10 Jan 2023 11:08:22 -0000
@@ -519,6 +519,11 @@ tcp_input(struct mbuf **mp, int *offp, i
 	th->th_win = ntohs(th->th_win);
 	th->th_urp = ntohs(th->th_urp);
 
+	if (th->th_dport == 0) {
+		tcpstat_inc(tcps_noport);
+		goto dropwithreset_ratelim;
+	}
+
 	/*
 	 * Locate pcb for segment.
 	 */
