/*
 *    certificate.c
 *    "AuthenticationFramework" ASN.1 module encode/decode/extracting/matching/free C src.
 *    This file was generated by modified eSMACC compiler Sat Dec 11 11:22:49 2004
 *    The generated files are supposed to be compiled as a module for OpenLDAP Software
 */

#include "certificate.h"

BDecComponentCertificateTop( void* mem_op, GenBuf* b, void **v, AsnLen* bytesDecoded,int mode) {
	AsnTag tag;
	AsnLen elmtLen;

	tag = BDecTag ( b, bytesDecoded );
	elmtLen = BDecLen ( b, bytesDecoded );
	if ( elmtLen <= 0 ) return (-1);
	if ( tag != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE) ) {
		return (-1);
	}
		
	return BDecComponentCertificate( mem_op, b, tag, elmtLen, (ComponentCertificate**)v,(AsnLen*)bytesDecoded, mode );
}

void init_module_AuthenticationFramework() {
	/* Register Certificate OID and its decoder */
	InstallOidDecoderMapping( "2.5.4.36", NULL,
				GDecComponentCertificate,
				BDecComponentCertificateTop,
				ExtractingComponentCertificate,
				MatchingComponentCertificate );
	InitAnyAuthenticationFramework();
}


void InitAnyAuthenticationFramework()
{
    AsnOid oid0 ={ 9, "\52\206\110\206\367\15\1\1\4" };
    AsnOid oid1 ={ 9, "\52\206\110\206\367\15\1\1\1" };
    AsnOid oid2 ={ 3, "\125\4\3" };
    AsnOid oid3 ={ 3, "\125\4\6" };
    AsnOid oid4 ={ 3, "\125\4\7" };
    AsnOid oid5 ={ 3, "\125\4\10" };
    AsnOid oid6 ={ 3, "\125\4\12" };
    AsnOid oid7 ={ 3, "\125\4\13" };
    AsnOid oid8 ={ 9, "\52\206\110\206\367\15\1\11\1" };
    AsnOid oid9 ={ 3, "\125\35\23" };
    AsnOid oid10 ={ 9, "\140\206\110\1\206\370\102\1\15" };
    AsnOid oid11 ={ 3, "\125\35\16" };


    InstallAnyByComponentOid (nullOid_ANY_ID, &oid0, sizeof (ComponentNull), (EncodeFcn)BEncAsnNull, (gser_decoder_func*)GDecComponentNull, (ber_tag_decoder_func*)BDecComponentNullTag, (ExtractFcn)NULL,(MatchFcn)MatchingComponentNull,(FreeFcn)FreeComponentNull, (PrintFcn)NULL);

    InstallAnyByComponentOid (nullOid2_ANY_ID, &oid1, sizeof (ComponentNull), (EncodeFcn)BEncAsnNull, (gser_decoder_func*)GDecComponentNull, (ber_tag_decoder_func*)BDecComponentNullTag, (ExtractFcn)NULL,(MatchFcn)MatchingComponentNull,(FreeFcn)FreeComponentNull, (PrintFcn)NULL);

    InstallAnyByComponentOid (printableStringOid_ANY_ID, &oid2, sizeof (ComponentPrintableString), (EncodeFcn)BEncPrintableString, (gser_decoder_func*)GDecComponentPrintableString, (ber_tag_decoder_func*)BDecComponentPrintableStringTag, (ExtractFcn)NULL,(MatchFcn)MatchingComponentPrintableString,(FreeFcn)FreeComponentPrintableString, (PrintFcn)NULL);

    InstallAnyByComponentOid (printableStringOid2_ANY_ID, &oid3, sizeof (ComponentPrintableString), (EncodeFcn)BEncPrintableString, (gser_decoder_func*)GDecComponentPrintableString, (ber_tag_decoder_func*)BDecComponentPrintableStringTag, (ExtractFcn)NULL,(MatchFcn)MatchingComponentPrintableString,(FreeFcn)FreeComponentPrintableString, (PrintFcn)NULL);

    InstallAnyByComponentOid (printableStringOid3_ANY_ID, &oid4, sizeof (ComponentPrintableString), (EncodeFcn)BEncPrintableString, (gser_decoder_func*)GDecComponentPrintableString, (ber_tag_decoder_func*)BDecComponentPrintableStringTag, (ExtractFcn)NULL,(MatchFcn)MatchingComponentPrintableString,(FreeFcn)FreeComponentPrintableString, (PrintFcn)NULL);

    InstallAnyByComponentOid (printableStringOid4_ANY_ID, &oid5, sizeof (ComponentPrintableString), (EncodeFcn)BEncPrintableString, (gser_decoder_func*)GDecComponentPrintableString, (ber_tag_decoder_func*)BDecComponentPrintableStringTag, (ExtractFcn)NULL,(MatchFcn)MatchingComponentPrintableString,(FreeFcn)FreeComponentPrintableString, (PrintFcn)NULL);

    InstallAnyByComponentOid (printableStringOid5_ANY_ID, &oid6, sizeof (ComponentPrintableString), (EncodeFcn)BEncPrintableString, (gser_decoder_func*)GDecComponentPrintableString, (ber_tag_decoder_func*)BDecComponentPrintableStringTag, (ExtractFcn)NULL,(MatchFcn)MatchingComponentPrintableString,(FreeFcn)FreeComponentPrintableString, (PrintFcn)NULL);

    InstallAnyByComponentOid (printableStringOid6_ANY_ID, &oid7, sizeof (ComponentPrintableString), (EncodeFcn)BEncPrintableString, (gser_decoder_func*)GDecComponentPrintableString, (ber_tag_decoder_func*)BDecComponentPrintableStringTag, (ExtractFcn)NULL,(MatchFcn)MatchingComponentPrintableString,(FreeFcn)FreeComponentPrintableString, (PrintFcn)NULL);

    InstallAnyByComponentOid (iA5StringOid_ANY_ID, &oid8, sizeof (ComponentIA5String), (EncodeFcn)BEncIA5String, (gser_decoder_func*)GDecComponentIA5String, (ber_tag_decoder_func*)BDecComponentIA5StringTag, (ExtractFcn)NULL,(MatchFcn)MatchingComponentIA5String,(FreeFcn)FreeComponentIA5String, (PrintFcn)NULL);

    InstallAnyByComponentOid (octetStringOid_ANY_ID, &oid9, sizeof (ComponentOcts), (EncodeFcn)BEncAsnOcts, (gser_decoder_func*)GDecComponentOcts, (ber_tag_decoder_func*)BDecComponentOctsTag, (ExtractFcn)NULL,(MatchFcn)MatchingComponentOcts,(FreeFcn)FreeComponentOcts, (PrintFcn)NULL);

    InstallAnyByComponentOid (octetStringOid2_ANY_ID, &oid10, sizeof (ComponentOcts), (EncodeFcn)BEncAsnOcts, (gser_decoder_func*)GDecComponentOcts, (ber_tag_decoder_func*)BDecComponentOctsTag, (ExtractFcn)NULL,(MatchFcn)MatchingComponentOcts,(FreeFcn)FreeComponentOcts, (PrintFcn)NULL);

    InstallAnyByComponentOid (octetStringOid3_ANY_ID, &oid11, sizeof (ComponentOcts), (EncodeFcn)BEncAsnOcts, (gser_decoder_func*)GDecComponentOcts, (ber_tag_decoder_func*)BDecComponentOctsTag, (ExtractFcn)NULL,(MatchFcn)MatchingComponentOcts,(FreeFcn)FreeComponentOcts, (PrintFcn)NULL);

}  /* InitAnyAuthenticationFramework */


int
MatchingComponentAlgorithmIdentifier ( char* oid, ComponentSyntaxInfo* csi_attr, ComponentSyntaxInfo* csi_assert ) {
	int rc;
	MatchingRule* mr;

	if ( oid ) {
		mr = retrieve_matching_rule( oid, csi_attr->csi_comp_desc->cd_type_id);
		if ( mr ) return component_value_match( mr, csi_attr, csi_assert );
	}

	rc = 1;
	rc =	MatchingComponentOid ( oid, (ComponentSyntaxInfo*)&((ComponentAlgorithmIdentifier*)csi_attr)->algorithm, (ComponentSyntaxInfo*)&((ComponentAlgorithmIdentifier*)csi_assert)->algorithm );
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	rc =	SetAnyTypeByComponentOid ((ComponentSyntaxInfo*)&((ComponentAlgorithmIdentifier*)csi_attr)->parameters, (&((ComponentAlgorithmIdentifier*)csi_attr)->algorithm));
	rc = MatchingComponentAnyDefinedBy ( oid, (ComponentAny*)&((ComponentAlgorithmIdentifier*)csi_attr)->parameters, (ComponentAny*)&((ComponentAlgorithmIdentifier*)csi_assert)->parameters);
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	return LDAP_COMPARE_TRUE;
}  /* BMatchingComponentAlgorithmIdentifier */

void*
ExtractingComponentAlgorithmIdentifier ( void* mem_op, ComponentReference* cr, ComponentAlgorithmIdentifier *comp )
{

	if ( ( comp->algorithm.identifier.bv_val && strncmp(comp->algorithm.identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->algorithm.id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
		return &comp->algorithm;
		else
		return NULL;
	}
	if ( ( comp->parameters.identifier.bv_val && strncmp(comp->parameters.identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->parameters.id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
		return &comp->parameters;
	else if ( cr->cr_curr->ci_next->ci_type == LDAP_COMPREF_CONTENT) {
			cr->cr_curr = cr->cr_curr->ci_next;
		return &comp->parameters;
	 } else {
		return NULL;
		}
	}
	return NULL;
}  /* ExtractingComponentAlgorithmIdentifier */

int
BDecComponentAlgorithmIdentifier PARAMS ((b, tagId0, elmtLen0, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
AsnTag tagId0 _AND_
AsnLen elmtLen0 _AND_
ComponentAlgorithmIdentifier **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	int seqDone = FALSE;
	AsnLen totalElmtsLen1 = 0;
	AsnLen elmtLen1;
	AsnTag tagId1;
	int mandatoryElmtCount1 = 0;
	int old_mode = mode;
	int rc;
	ComponentAlgorithmIdentifier *k, *t, c_temp;


	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
    tagId1 = BDecTag (b, &totalElmtsLen1 );

    if (((tagId1 == MAKE_TAG_ID (UNIV, PRIM, OID_TAG_CODE))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
	rc = BDecComponentOid (mem_op, b, tagId1, elmtLen1, (&k->algorithm), &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(&k->algorithm)->identifier.bv_val = (&k->algorithm)->id_buf;
		(&k->algorithm)->identifier.bv_len = strlen("algorithm");
		strcpy( (&k->algorithm)->identifier.bv_val, "algorithm");
    if ((elmtLen0 != INDEFINITE_LEN) && (totalElmtsLen1 == elmtLen0))
        seqDone = TRUE;
    else
    {
         tagId1 = BufPeekByte (b);
         if ((elmtLen0 == INDEFINITE_LEN) && (tagId1 == EOC_TAG_ID))
        {
            BDecEoc (b, &totalElmtsLen1 );
            seqDone = TRUE;
        }
    }
    }
    else
        return -1;



    if (!seqDone)    {
	rc = SetAnyTypeByComponentOid ((&k->parameters), (&k->algorithm));
 	rc = BDecComponentAnyDefinedBy (mem_op,b, (&k->parameters), &totalElmtsLen1, mode );
		if ( rc != LDAP_SUCCESS ) return rc;
		(&k->parameters)->identifier.bv_val = (&k->parameters)->id_buf;
		(&k->parameters)->identifier.bv_len = strlen("parameters");
		strcpy( (&k->parameters)->identifier.bv_val, "parameters");
        seqDone = TRUE;
        if (elmtLen0 == INDEFINITE_LEN)
            BDecEoc (b, &totalElmtsLen1 );
        else if (totalElmtsLen1 != elmtLen0)
        return -1;

    }


    if (!seqDone)
        return -1;

	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentAlgorithmIdentifier*) CompAlloc( mem_op, sizeof(ComponentAlgorithmIdentifier) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentAlgorithmIdentifier ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentAlgorithmIdentifier ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentAlgorithmIdentifier;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = COMPOSITE_ASN1_TYPE;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentAlgorithmIdentifier;
    (*bytesDecoded) += totalElmtsLen1;
	return LDAP_SUCCESS;
}  /* BDecAlgorithmIdentifier*/

int
GDecComponentAlgorithmIdentifier PARAMS (( mem_op,b, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
ComponentAlgorithmIdentifier **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	char* peek_head,*peek_head2;
	int i, strLen,strLen2, rc, old_mode = mode;
	ComponentAlgorithmIdentifier *k,*t, c_temp;


	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
	*bytesDecoded = 0;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading { in encoded data");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != '{'){
		Asn1Error("Missing { in encoded data");
		return LDAP_PROTOCOL_ERROR;
	}

	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	if ( strncmp( peek_head, "algorithm", strlen("algorithm") ) == 0 ) {
		rc = 	GDecComponentOid (mem_op, b, (&k->algorithm), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	(&k->algorithm)->identifier.bv_val = peek_head;
	(&k->algorithm)->identifier.bv_len = strLen;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading , ");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != ','){
		Asn1Error("Missing , in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
	  Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	}
	if ( strncmp( peek_head, "parameters", strlen("parameters") ) == 0 ) {
		rc = 	rc = SetAnyTypeByComponentOid ((&k->parameters), (&k->algorithm));
	rc = GDecComponentAnyDefinedBy (mem_op, b, (&k->parameters), bytesDecoded, mode );
		if ( rc != LDAP_SUCCESS ) return rc;
	(&k->parameters)->identifier.bv_val = peek_head;
	(&k->parameters)->identifier.bv_len = strLen;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ) {
		Asn1Error("Error during Reading } in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != '}'){
		Asn1Error("Missing } in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentAlgorithmIdentifier*) CompAlloc( mem_op, sizeof(ComponentAlgorithmIdentifier) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentAlgorithmIdentifier ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentAlgorithmIdentifier ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentAlgorithmIdentifier;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = COMPOSITE_ASN1_TYPE;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentAlgorithmIdentifier;
	return LDAP_SUCCESS;
}  /* GDecAlgorithmIdentifier*/


int
MatchingComponentTime ( char* oid, ComponentSyntaxInfo* csi_attr, ComponentSyntaxInfo* csi_assert ) {
	int rc;
	MatchingRule* mr;
	ComponentTime *v1, *v2;


	v1 = (ComponentTime*)csi_attr;
	v2 = (ComponentTime*)csi_assert;
	if ( oid ) {
		mr = retrieve_matching_rule( oid, csi_attr->csi_comp_desc->cd_type_id);
		if ( mr ) return component_value_match( mr, csi_attr, csi_assert );
	}

	if( (v1->choiceId != v2->choiceId ) )
		return LDAP_COMPARE_FALSE;
	switch( v1->choiceId )
	{
	   case TIME_UTCTIME :
		rc = 	MatchingComponentUTCTime ( oid, (ComponentSyntaxInfo*)(v1->a.utcTime), (ComponentSyntaxInfo*)(v2->a.utcTime) );
		break;
	   case TIME_GENERALIZEDTIME :
		rc = 	MatchingComponentGeneralizedTime ( oid, (ComponentSyntaxInfo*)(v1->a.generalizedTime), (ComponentSyntaxInfo*)(v2->a.generalizedTime) );
		break;
	default : 
		 return LDAP_PROTOCOL_ERROR;
	}
	return rc;
}  /* BMatchingComponentTimeContent */

void*
ExtractingComponentTime ( void* mem_op, ComponentReference* cr, ComponentTime *comp )
{


	if( (comp->choiceId) ==  TIME_UTCTIME &&
		 (( comp->a.utcTime->identifier.bv_val && strncmp(comp->a.utcTime->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0) ||
		 ( strncmp(comp->a.utcTime->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0))) {
		if ( cr->cr_curr->ci_next == NULL )
			return (comp->a.utcTime);
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentUTCTime ( mem_op, cr, (comp->a.utcTime) );
		};
	}
	if( (comp->choiceId) ==  TIME_GENERALIZEDTIME &&
		 (( comp->a.generalizedTime->identifier.bv_val && strncmp(comp->a.generalizedTime->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0) ||
		 ( strncmp(comp->a.generalizedTime->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0))) {
		if ( cr->cr_curr->ci_next == NULL )
			return (comp->a.generalizedTime);
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentGeneralizedTime ( mem_op, cr, (comp->a.generalizedTime) );
		};
	}
	return NULL;
}  /* ExtractingComponentTime */

int
BDecComponentTime PARAMS ((b, tagId0, elmtLen0, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
AsnTag tagId0 _AND_
AsnLen elmtLen0 _AND_
ComponentTime **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	int seqDone = FALSE;
	AsnLen totalElmtsLen1 = 0;
	AsnLen elmtLen1;
	AsnTag tagId1;
	int mandatoryElmtCount1 = 0;
	int old_mode = mode;
	int rc;
	ComponentTime *k, *t, c_temp;


	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
    switch (tagId0)
    {
       case MAKE_TAG_ID (UNIV, PRIM, UTCTIME_TAG_CODE):
       case MAKE_TAG_ID (UNIV, CONS, UTCTIME_TAG_CODE):
        (k->choiceId) = TIME_UTCTIME;
	rc = BDecComponentUTCTime (mem_op, b, tagId0, elmtLen0, (&k->a.utcTime), &totalElmtsLen1, DEC_ALLOC_MODE_0 );
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->a.utcTime)->identifier.bv_val = (k->a.utcTime)->id_buf;
		(k->a.utcTime)->identifier.bv_len = strlen("utcTime");
		strcpy( (k->a.utcTime)->identifier.bv_val, "utcTime");
    break;

       case MAKE_TAG_ID (UNIV, PRIM, GENERALIZEDTIME_TAG_CODE):
       case MAKE_TAG_ID (UNIV, CONS, GENERALIZEDTIME_TAG_CODE):
        (k->choiceId) = TIME_GENERALIZEDTIME;
	rc = BDecComponentGeneralizedTime (mem_op, b, tagId0, elmtLen0, (&k->a.generalizedTime), &totalElmtsLen1, DEC_ALLOC_MODE_0 );
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->a.generalizedTime)->identifier.bv_val = (k->a.generalizedTime)->id_buf;
		(k->a.generalizedTime)->identifier.bv_len = strlen("generalizedTime");
		strcpy( (k->a.generalizedTime)->identifier.bv_val, "generalizedTime");
    break;

    default:
        Asn1Error ("ERROR - unexpected tag in CHOICE\n");
        return -1;
        break;
    } /* end switch */
	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentTime*) CompAlloc( mem_op, sizeof(ComponentTime) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentTime ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentTime ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentTime;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = COMPOSITE_ASN1_TYPE;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentTime;
    (*bytesDecoded) += totalElmtsLen1;
	return LDAP_SUCCESS;
}  /* BDecTimeContent */

int
GDecComponentTime PARAMS (( mem_op,b, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
ComponentTime **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	char* peek_head,*peek_head2;
	int i, strLen,strLen2, rc, old_mode = mode;
	ComponentTime *k,*t, c_temp;


	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(strLen2 = LocateNextGSERToken(mem_op,b,&peek_head2,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head2 != ':'){
		Asn1Error("Missing : in encoded data");
		return LDAP_PROTOCOL_ERROR;
	}
	if( strncmp("utcTime",peek_head, strlen("utcTime")) == 0){
		(k->choiceId) = TIME_UTCTIME;
		rc = 	GDecComponentUTCTime (mem_op, b, (&k->a.utcTime), bytesDecoded, DEC_ALLOC_MODE_0 );
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->a.utcTime)->identifier.bv_val = peek_head;
		(k->a.utcTime)->identifier.bv_len = strLen;
	}
	else if( strncmp("generalizedTime",peek_head,strlen("generalizedTime")) == 0){
		(k->choiceId) = TIME_GENERALIZEDTIME;
		rc = 	GDecComponentGeneralizedTime (mem_op, b, (&k->a.generalizedTime), bytesDecoded, DEC_ALLOC_MODE_0 );
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->a.generalizedTime)->identifier.bv_val = peek_head;
		(k->a.generalizedTime)->identifier.bv_len = strLen;
	}
	else {
		Asn1Error("Undefined Identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentTime*) CompAlloc( mem_op, sizeof(ComponentTime) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentTime ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentTime ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentTime;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = COMPOSITE_ASN1_TYPE;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentTime;
	return LDAP_SUCCESS;
}  /* GDecTimeContent */


int
MatchingComponentExtension ( char* oid, ComponentSyntaxInfo* csi_attr, ComponentSyntaxInfo* csi_assert ) {
	int rc;
	MatchingRule* mr;

	if ( oid ) {
		mr = retrieve_matching_rule( oid, csi_attr->csi_comp_desc->cd_type_id);
		if ( mr ) return component_value_match( mr, csi_attr, csi_assert );
	}

	rc = 1;
	rc =	MatchingComponentOid ( oid, (ComponentSyntaxInfo*)&((ComponentExtension*)csi_attr)->extnID, (ComponentSyntaxInfo*)&((ComponentExtension*)csi_assert)->extnID );
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	rc =	MatchingComponentBool ( oid, (ComponentSyntaxInfo*)((ComponentExtension*)csi_attr)->critical, (ComponentSyntaxInfo*)((ComponentExtension*)csi_assert)->critical );
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	rc =	MatchingComponentOcts ( oid, (ComponentSyntaxInfo*)&((ComponentExtension*)csi_attr)->extnValue, (ComponentSyntaxInfo*)&((ComponentExtension*)csi_assert)->extnValue );
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	return LDAP_COMPARE_TRUE;
}  /* BMatchingComponentExtension */

void*
ExtractingComponentExtension ( void* mem_op, ComponentReference* cr, ComponentExtension *comp )
{

	if ( ( comp->extnID.identifier.bv_val && strncmp(comp->extnID.identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->extnID.id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
		return &comp->extnID;
		else
		return NULL;
	}
	if ( ( comp->critical->identifier.bv_val && strncmp(comp->critical->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->critical->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
			return comp->critical;
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentBool ( mem_op, cr, comp->critical );
		}
	}
	if ( ( comp->extnValue.identifier.bv_val && strncmp(comp->extnValue.identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->extnValue.id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
		return &comp->extnValue;
	else if ( cr->cr_curr->ci_next->ci_type == LDAP_COMPREF_CONTENT) {
			cr->cr_curr = cr->cr_curr->ci_next;
		return &comp->extnValue;
	 } else {
		return NULL;
		}
	}
	return NULL;
}  /* ExtractingComponentExtension */

int
BDecComponentExtension PARAMS ((b, tagId0, elmtLen0, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
AsnTag tagId0 _AND_
AsnLen elmtLen0 _AND_
ComponentExtension **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	int seqDone = FALSE;
	AsnLen totalElmtsLen1 = 0;
	AsnLen elmtLen1;
	AsnTag tagId1;
	int mandatoryElmtCount1 = 0;
	int old_mode = mode;
	int rc;
	ComponentExtension *k, *t, c_temp;


	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
    tagId1 = BDecTag (b, &totalElmtsLen1 );

    if (((tagId1 == MAKE_TAG_ID (UNIV, PRIM, OID_TAG_CODE))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
	rc = BDecComponentOid (mem_op, b, tagId1, elmtLen1, (&k->extnID), &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(&k->extnID)->identifier.bv_val = (&k->extnID)->id_buf;
		(&k->extnID)->identifier.bv_len = strlen("extnID");
		strcpy( (&k->extnID)->identifier.bv_val, "extnID");
    tagId1 = BDecTag (b, &totalElmtsLen1);
    }
    else
        return -1;



    if (((tagId1 == MAKE_TAG_ID (UNIV, PRIM, BOOLEAN_TAG_CODE))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
	rc = BDecComponentBool (mem_op, b, tagId1, elmtLen1, (&k->critical), &totalElmtsLen1, DEC_ALLOC_MODE_0 );
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->critical)->identifier.bv_val = (k->critical)->id_buf;
		(k->critical)->identifier.bv_len = strlen("critical");
		strcpy( (k->critical)->identifier.bv_val, "critical");
    tagId1 = BDecTag (b, &totalElmtsLen1);
    }


    if (((tagId1 == MAKE_TAG_ID (UNIV, PRIM, OCTETSTRING_TAG_CODE)) ||
(tagId1 == MAKE_TAG_ID (UNIV, CONS, OCTETSTRING_TAG_CODE))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
	rc = BDecComponentOcts (mem_op, b, tagId1, elmtLen1, (&k->extnValue), &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(&k->extnValue)->identifier.bv_val = (&k->extnValue)->id_buf;
		(&k->extnValue)->identifier.bv_len = strlen("extnValue");
		strcpy( (&k->extnValue)->identifier.bv_val, "extnValue");
        seqDone = TRUE;
        if (elmtLen0 == INDEFINITE_LEN)
            BDecEoc (b, &totalElmtsLen1 );
        else if (totalElmtsLen1 != elmtLen0)
        return -1;

    }
    else
        return -1;



    if (!seqDone)
        return -1;

	if(!COMPONENTNOT_NULL ((k->critical)))
	{
(k->critical) = CompAlloc( mem_op, sizeof(ComponentBool));
		(k->critical)->identifier.bv_val = (k->critical)->id_buf;
		(k->critical)->identifier.bv_len = strlen("critical");
		strcpy( (k->critical)->identifier.bv_val, "critical");
	(k->critical)->value = 0;
	}
	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentExtension*) CompAlloc( mem_op, sizeof(ComponentExtension) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentExtension ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentExtension ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentExtension;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = COMPOSITE_ASN1_TYPE;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentExtension;
    (*bytesDecoded) += totalElmtsLen1;
	return LDAP_SUCCESS;
}  /* BDecExtension*/

int
GDecComponentExtension PARAMS (( mem_op,b, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
ComponentExtension **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	char* peek_head,*peek_head2;
	int i, strLen,strLen2, rc, old_mode = mode;
	ComponentExtension *k,*t, c_temp;


	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
	*bytesDecoded = 0;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading { in encoded data");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != '{'){
		Asn1Error("Missing { in encoded data");
		return LDAP_PROTOCOL_ERROR;
	}

	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	if ( strncmp( peek_head, "extnID", strlen("extnID") ) == 0 ) {
		rc = 	GDecComponentOid (mem_op, b, (&k->extnID), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	(&k->extnID)->identifier.bv_val = peek_head;
	(&k->extnID)->identifier.bv_len = strLen;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading , ");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != ','){
		Asn1Error("Missing , in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
	  Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	}
	if ( strncmp( peek_head, "critical", strlen("critical") ) == 0 ) {
		rc = 	GDecComponentBool (mem_op, b, (&k->critical), bytesDecoded, DEC_ALLOC_MODE_0 );
		if ( rc != LDAP_SUCCESS ) return rc;
	( k->critical)->identifier.bv_val = peek_head;
	( k->critical)->identifier.bv_len = strLen;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading , ");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != ','){
		Asn1Error("Missing , in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
	  Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	}
	else {
(k->critical) = CompAlloc( mem_op, sizeof(ComponentBool));
			(k->critical)->value = 0;
	}
	if ( strncmp( peek_head, "extnValue", strlen("extnValue") ) == 0 ) {
		rc = 	GDecComponentOcts (mem_op, b, (&k->extnValue), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	(&k->extnValue)->identifier.bv_val = peek_head;
	(&k->extnValue)->identifier.bv_len = strLen;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ) {
		Asn1Error("Error during Reading } in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != '}'){
		Asn1Error("Missing } in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentExtension*) CompAlloc( mem_op, sizeof(ComponentExtension) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentExtension ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentExtension ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentExtension;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = COMPOSITE_ASN1_TYPE;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentExtension;
	return LDAP_SUCCESS;
}  /* GDecExtension*/


int
MatchingComponentAttributeTypeAndValue ( char* oid, ComponentSyntaxInfo* csi_attr, ComponentSyntaxInfo* csi_assert ) {
	int rc;
	MatchingRule* mr;

	if ( oid ) {
		mr = retrieve_matching_rule( oid, csi_attr->csi_comp_desc->cd_type_id);
		if ( mr ) return component_value_match( mr, csi_attr, csi_assert );
	}

	rc = 1;
	rc =	MatchingComponentAttributeType ( oid, (ComponentSyntaxInfo*)&((ComponentAttributeTypeAndValue*)csi_attr)->type, (ComponentSyntaxInfo*)&((ComponentAttributeTypeAndValue*)csi_assert)->type );
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	rc =	SetAnyTypeByComponentOid ((ComponentSyntaxInfo*)&((ComponentAttributeTypeAndValue*)csi_attr)->value, (&((ComponentAttributeTypeAndValue*)csi_attr)->type));
	rc = MatchingComponentAnyDefinedBy ( oid, (ComponentAny*)&((ComponentAttributeTypeAndValue*)csi_attr)->value, (ComponentAny*)&((ComponentAttributeTypeAndValue*)csi_assert)->value);
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	return LDAP_COMPARE_TRUE;
}  /* BMatchingComponentAttributeTypeAndValue */

void*
ExtractingComponentAttributeTypeAndValue ( void* mem_op, ComponentReference* cr, ComponentAttributeTypeAndValue *comp )
{

	if ( ( comp->type.identifier.bv_val && strncmp(comp->type.identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->type.id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
		return &comp->type;
		else
		return NULL;
	}
	if ( ( comp->value.identifier.bv_val && strncmp(comp->value.identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->value.id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
		return &comp->value;
		else if ( cr->cr_curr->ci_next->ci_type == LDAP_COMPREF_SELECT ) {
			cr->cr_curr = cr->cr_curr->ci_next;
			return &comp->value;
	 } else {
		return NULL;
		}
	}
	return NULL;
}  /* ExtractingComponentAttributeTypeAndValue */

int
BDecComponentAttributeTypeAndValue PARAMS ((b, tagId0, elmtLen0, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
AsnTag tagId0 _AND_
AsnLen elmtLen0 _AND_
ComponentAttributeTypeAndValue **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	int seqDone = FALSE;
	AsnLen totalElmtsLen1 = 0;
	AsnLen elmtLen1;
	AsnTag tagId1;
	int mandatoryElmtCount1 = 0;
	int old_mode = mode;
	int rc;
	ComponentAttributeTypeAndValue *k, *t, c_temp;


	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
    tagId1 = BDecTag (b, &totalElmtsLen1 );

    if (((tagId1 == MAKE_TAG_ID (UNIV, PRIM, OID_TAG_CODE))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
	rc = BDecComponentAttributeType (mem_op, b, tagId1, elmtLen1, (&k->type), &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(&k->type)->identifier.bv_val = (&k->type)->id_buf;
		(&k->type)->identifier.bv_len = strlen("type");
		strcpy( (&k->type)->identifier.bv_val, "type");
    }
    else
        return -1;



    {
	rc = SetAnyTypeByComponentOid ((&k->value), (&k->type));
 	rc = BDecComponentAnyDefinedBy (mem_op,b, (&k->value), &totalElmtsLen1, mode );
		if ( rc != LDAP_SUCCESS ) return rc;
		(&k->value)->identifier.bv_val = (&k->value)->id_buf;
		(&k->value)->identifier.bv_len = strlen("value");
		strcpy( (&k->value)->identifier.bv_val, "value");
        seqDone = TRUE;
        if (elmtLen0 == INDEFINITE_LEN)
            BDecEoc (b, &totalElmtsLen1 );
        else if (totalElmtsLen1 != elmtLen0)
        return -1;

    }


    if (!seqDone)
        return -1;

	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentAttributeTypeAndValue*) CompAlloc( mem_op, sizeof(ComponentAttributeTypeAndValue) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentAttributeTypeAndValue ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentAttributeTypeAndValue ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentAttributeTypeAndValue;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = COMPOSITE_ASN1_TYPE;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentAttributeTypeAndValue;
    (*bytesDecoded) += totalElmtsLen1;
	return LDAP_SUCCESS;
}  /* BDecAttributeTypeAndValue*/

int
GDecComponentAttributeTypeAndValue PARAMS (( mem_op,b, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
ComponentAttributeTypeAndValue **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	char* peek_head,*peek_head2;
	int i, strLen,strLen2, rc, old_mode = mode;
	ComponentAttributeTypeAndValue *k,*t, c_temp;


	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
	*bytesDecoded = 0;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading { in encoded data");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != '{'){
		Asn1Error("Missing { in encoded data");
		return LDAP_PROTOCOL_ERROR;
	}

	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	if ( strncmp( peek_head, "type", strlen("type") ) == 0 ) {
		rc = 	GDecComponentAttributeType (mem_op, b, (&k->type), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	(&k->type)->identifier.bv_val = peek_head;
	(&k->type)->identifier.bv_len = strLen;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading , ");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != ','){
		Asn1Error("Missing , in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
	  Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	}
	if ( strncmp( peek_head, "value", strlen("value") ) == 0 ) {
		rc = 	rc = SetAnyTypeByComponentOid ((&k->value), (&k->type));
	rc = GDecComponentAnyDefinedBy (mem_op, b, (&k->value), bytesDecoded, mode );
		if ( rc != LDAP_SUCCESS ) return rc;
	(&k->value)->identifier.bv_val = peek_head;
	(&k->value)->identifier.bv_len = strLen;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ) {
		Asn1Error("Error during Reading } in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != '}'){
		Asn1Error("Missing } in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentAttributeTypeAndValue*) CompAlloc( mem_op, sizeof(ComponentAttributeTypeAndValue) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentAttributeTypeAndValue ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentAttributeTypeAndValue ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentAttributeTypeAndValue;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = COMPOSITE_ASN1_TYPE;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentAttributeTypeAndValue;
	return LDAP_SUCCESS;
}  /* GDecAttributeTypeAndValue*/


int
MatchingComponentValidity ( char* oid, ComponentSyntaxInfo* csi_attr, ComponentSyntaxInfo* csi_assert ) {
	int rc;
	MatchingRule* mr;

	if ( oid ) {
		mr = retrieve_matching_rule( oid, csi_attr->csi_comp_desc->cd_type_id);
		if ( mr ) return component_value_match( mr, csi_attr, csi_assert );
	}

	rc = 1;
	rc =	MatchingComponentTime ( oid, (ComponentSyntaxInfo*)((ComponentValidity*)csi_attr)->notBefore, (ComponentSyntaxInfo*)((ComponentValidity*)csi_assert)->notBefore );
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	rc =	MatchingComponentTime ( oid, (ComponentSyntaxInfo*)((ComponentValidity*)csi_attr)->notAfter, (ComponentSyntaxInfo*)((ComponentValidity*)csi_assert)->notAfter );
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	return LDAP_COMPARE_TRUE;
}  /* BMatchingComponentValidity */

void*
ExtractingComponentValidity ( void* mem_op, ComponentReference* cr, ComponentValidity *comp )
{

	if ( ( comp->notBefore->identifier.bv_val && strncmp(comp->notBefore->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->notBefore->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
			return comp->notBefore;
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentTime ( mem_op, cr, comp->notBefore );
		}
	}
	if ( ( comp->notAfter->identifier.bv_val && strncmp(comp->notAfter->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->notAfter->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
			return comp->notAfter;
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentTime ( mem_op, cr, comp->notAfter );
		}
	}
	return NULL;
}  /* ExtractingComponentValidity */

int
BDecComponentValidity PARAMS ((b, tagId0, elmtLen0, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
AsnTag tagId0 _AND_
AsnLen elmtLen0 _AND_
ComponentValidity **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	int seqDone = FALSE;
	AsnLen totalElmtsLen1 = 0;
	AsnLen elmtLen1;
	AsnTag tagId1;
	int mandatoryElmtCount1 = 0;
	AsnLen totalElmtsLen2 = 0;
	AsnLen elmtLen2;
	AsnTag tagId2;
	int old_mode = mode;
	int rc;
	ComponentValidity *k, *t, c_temp;


	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
    tagId1 = BDecTag (b, &totalElmtsLen1 );

    if (((tagId1 == MAKE_TAG_ID (UNIV, PRIM, UTCTIME_TAG_CODE)) ||
(tagId1 == MAKE_TAG_ID (UNIV, CONS, UTCTIME_TAG_CODE)) ||
     (tagId1 ==MAKE_TAG_ID (UNIV, PRIM, GENERALIZEDTIME_TAG_CODE))||
    (tagId1 == MAKE_TAG_ID (UNIV, CONS, GENERALIZEDTIME_TAG_CODE))))
    {
        elmtLen1 = BDecLen (b, &totalElmtsLen1 );
	rc = BDecComponentTime (mem_op, b, tagId1, elmtLen1, (&k->notBefore), &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->notBefore)->identifier.bv_val = (k->notBefore)->id_buf;
		(k->notBefore)->identifier.bv_len = strlen("notBefore");
		strcpy( (k->notBefore)->identifier.bv_val, "notBefore");
    tagId1 = BDecTag (b, &totalElmtsLen1);
    }
    else
        return -1;



    if (((tagId1 == MAKE_TAG_ID (UNIV, PRIM, UTCTIME_TAG_CODE)) ||
(tagId1 == MAKE_TAG_ID (UNIV, CONS, UTCTIME_TAG_CODE)) ||
     (tagId1 ==MAKE_TAG_ID (UNIV, PRIM, GENERALIZEDTIME_TAG_CODE))||
    (tagId1 == MAKE_TAG_ID (UNIV, CONS, GENERALIZEDTIME_TAG_CODE))))
    {
        elmtLen1 = BDecLen (b, &totalElmtsLen1 );
	rc = BDecComponentTime (mem_op, b, tagId1, elmtLen1, (&k->notAfter), &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->notAfter)->identifier.bv_val = (k->notAfter)->id_buf;
		(k->notAfter)->identifier.bv_len = strlen("notAfter");
		strcpy( (k->notAfter)->identifier.bv_val, "notAfter");
        seqDone = TRUE;
        if (elmtLen0 == INDEFINITE_LEN)
            BDecEoc (b, &totalElmtsLen1 );
        else if (totalElmtsLen1 != elmtLen0)
        return -1;

    }
    else
        return -1;



    if (!seqDone)
        return -1;

	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentValidity*) CompAlloc( mem_op, sizeof(ComponentValidity) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentValidity ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentValidity ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentValidity;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = COMPOSITE_ASN1_TYPE;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentValidity;
    (*bytesDecoded) += totalElmtsLen1;
	return LDAP_SUCCESS;
}  /* BDecValidity*/

int
GDecComponentValidity PARAMS (( mem_op,b, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
ComponentValidity **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	char* peek_head,*peek_head2;
	int i, strLen,strLen2, rc, old_mode = mode;
	ComponentValidity *k,*t, c_temp;


	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
	*bytesDecoded = 0;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading { in encoded data");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != '{'){
		Asn1Error("Missing { in encoded data");
		return LDAP_PROTOCOL_ERROR;
	}

	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	if ( strncmp( peek_head, "notBefore", strlen("notBefore") ) == 0 ) {
		rc = 	GDecComponentTime (mem_op, b, (&k->notBefore), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	( k->notBefore)->identifier.bv_val = peek_head;
	( k->notBefore)->identifier.bv_len = strLen;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading , ");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != ','){
		Asn1Error("Missing , in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
	  Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	}
	if ( strncmp( peek_head, "notAfter", strlen("notAfter") ) == 0 ) {
		rc = 	GDecComponentTime (mem_op, b, (&k->notAfter), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	( k->notAfter)->identifier.bv_val = peek_head;
	( k->notAfter)->identifier.bv_len = strLen;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ) {
		Asn1Error("Error during Reading } in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != '}'){
		Asn1Error("Missing } in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentValidity*) CompAlloc( mem_op, sizeof(ComponentValidity) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentValidity ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentValidity ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentValidity;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = COMPOSITE_ASN1_TYPE;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentValidity;
	return LDAP_SUCCESS;
}  /* GDecValidity*/


int
MatchingComponentSubjectPublicKeyInfo ( char* oid, ComponentSyntaxInfo* csi_attr, ComponentSyntaxInfo* csi_assert ) {
	int rc;
	MatchingRule* mr;

	if ( oid ) {
		mr = retrieve_matching_rule( oid, csi_attr->csi_comp_desc->cd_type_id);
		if ( mr ) return component_value_match( mr, csi_attr, csi_assert );
	}

	rc = 1;
	rc =	MatchingComponentAlgorithmIdentifier ( oid, (ComponentSyntaxInfo*)((ComponentSubjectPublicKeyInfo*)csi_attr)->algorithm, (ComponentSyntaxInfo*)((ComponentSubjectPublicKeyInfo*)csi_assert)->algorithm );
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	rc =	MatchingComponentBits ( oid, (ComponentSyntaxInfo*)&((ComponentSubjectPublicKeyInfo*)csi_attr)->subjectPublicKey, (ComponentSyntaxInfo*)&((ComponentSubjectPublicKeyInfo*)csi_assert)->subjectPublicKey );
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	return LDAP_COMPARE_TRUE;
}  /* BMatchingComponentSubjectPublicKeyInfo */

void*
ExtractingComponentSubjectPublicKeyInfo ( void* mem_op, ComponentReference* cr, ComponentSubjectPublicKeyInfo *comp )
{

	if ( ( comp->algorithm->identifier.bv_val && strncmp(comp->algorithm->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->algorithm->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
			return comp->algorithm;
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentAlgorithmIdentifier ( mem_op, cr, comp->algorithm );
		}
	}
	if ( ( comp->subjectPublicKey.identifier.bv_val && strncmp(comp->subjectPublicKey.identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->subjectPublicKey.id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
		return &comp->subjectPublicKey;
	else if ( cr->cr_curr->ci_next->ci_type == LDAP_COMPREF_CONTENT) {
			cr->cr_curr = cr->cr_curr->ci_next;
		return &comp->subjectPublicKey;
	 } else {
		return NULL;
		}
	}
	return NULL;
}  /* ExtractingComponentSubjectPublicKeyInfo */

int
BDecComponentSubjectPublicKeyInfo PARAMS ((b, tagId0, elmtLen0, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
AsnTag tagId0 _AND_
AsnLen elmtLen0 _AND_
ComponentSubjectPublicKeyInfo **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	int seqDone = FALSE;
	AsnLen totalElmtsLen1 = 0;
	AsnLen elmtLen1;
	AsnTag tagId1;
	int mandatoryElmtCount1 = 0;
	int old_mode = mode;
	int rc;
	ComponentSubjectPublicKeyInfo *k, *t, c_temp;


	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
    tagId1 = BDecTag (b, &totalElmtsLen1 );

    if (((tagId1 == MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
	rc = BDecComponentAlgorithmIdentifier (mem_op, b, tagId1, elmtLen1, (&k->algorithm), &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->algorithm)->identifier.bv_val = (k->algorithm)->id_buf;
		(k->algorithm)->identifier.bv_len = strlen("algorithm");
		strcpy( (k->algorithm)->identifier.bv_val, "algorithm");
    tagId1 = BDecTag (b, &totalElmtsLen1);
    }
    else
        return -1;



    if (((tagId1 == MAKE_TAG_ID (UNIV, PRIM, BITSTRING_TAG_CODE)) ||
(tagId1 == MAKE_TAG_ID (UNIV, CONS, BITSTRING_TAG_CODE))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
	rc = BDecComponentBits (mem_op, b, tagId1, elmtLen1, (&k->subjectPublicKey), &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(&k->subjectPublicKey)->identifier.bv_val = (&k->subjectPublicKey)->id_buf;
		(&k->subjectPublicKey)->identifier.bv_len = strlen("subjectPublicKey");
		strcpy( (&k->subjectPublicKey)->identifier.bv_val, "subjectPublicKey");
        seqDone = TRUE;
        if (elmtLen0 == INDEFINITE_LEN)
            BDecEoc (b, &totalElmtsLen1 );
        else if (totalElmtsLen1 != elmtLen0)
        return -1;

    }
    else
        return -1;



    if (!seqDone)
        return -1;

	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentSubjectPublicKeyInfo*) CompAlloc( mem_op, sizeof(ComponentSubjectPublicKeyInfo) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentSubjectPublicKeyInfo ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentSubjectPublicKeyInfo ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentSubjectPublicKeyInfo;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = COMPOSITE_ASN1_TYPE;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentSubjectPublicKeyInfo;
    (*bytesDecoded) += totalElmtsLen1;
	return LDAP_SUCCESS;
}  /* BDecSubjectPublicKeyInfo*/

int
GDecComponentSubjectPublicKeyInfo PARAMS (( mem_op,b, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
ComponentSubjectPublicKeyInfo **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	char* peek_head,*peek_head2;
	int i, strLen,strLen2, rc, old_mode = mode;
	ComponentSubjectPublicKeyInfo *k,*t, c_temp;


	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
	*bytesDecoded = 0;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading { in encoded data");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != '{'){
		Asn1Error("Missing { in encoded data");
		return LDAP_PROTOCOL_ERROR;
	}

	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	if ( strncmp( peek_head, "algorithm", strlen("algorithm") ) == 0 ) {
		rc = 	GDecComponentAlgorithmIdentifier (mem_op, b, (&k->algorithm), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	( k->algorithm)->identifier.bv_val = peek_head;
	( k->algorithm)->identifier.bv_len = strLen;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading , ");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != ','){
		Asn1Error("Missing , in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
	  Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	}
	if ( strncmp( peek_head, "subjectPublicKey", strlen("subjectPublicKey") ) == 0 ) {
		rc = 	GDecComponentBits (mem_op, b, (&k->subjectPublicKey), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	(&k->subjectPublicKey)->identifier.bv_val = peek_head;
	(&k->subjectPublicKey)->identifier.bv_len = strLen;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ) {
		Asn1Error("Error during Reading } in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != '}'){
		Asn1Error("Missing } in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentSubjectPublicKeyInfo*) CompAlloc( mem_op, sizeof(ComponentSubjectPublicKeyInfo) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentSubjectPublicKeyInfo ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentSubjectPublicKeyInfo ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentSubjectPublicKeyInfo;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = COMPOSITE_ASN1_TYPE;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentSubjectPublicKeyInfo;
	return LDAP_SUCCESS;
}  /* GDecSubjectPublicKeyInfo*/


int
MatchingComponentExtensions ( char* oid, ComponentSyntaxInfo* csi_attr, ComponentSyntaxInfo* csi_assert ) {
	int rc;
	MatchingRule* mr;
	void* component1, *component2;
	AsnList *v1, *v2, t_list;


	if ( oid ) {
		mr = retrieve_matching_rule( oid, csi_attr->csi_comp_desc->cd_type_id);
		if ( mr ) return component_value_match( mr, csi_attr, csi_assert );
	}

	v1 = &((ComponentExtensions*)csi_attr)->comp_list;
	v2 = &((ComponentExtensions*)csi_assert)->comp_list;
	FOR_EACH_LIST_PAIR_ELMT(component1, component2, v1, v2)
	{
		if( MatchingComponentExtension(oid, (ComponentSyntaxInfo*)component1, (ComponentSyntaxInfo*)component2) == LDAP_COMPARE_FALSE) {
			return LDAP_COMPARE_FALSE;
		}
	} /* end of for */

	AsnListFirst( v1 );
	AsnListFirst( v2 );
	if( (!component1 && component2) || (component1 && !component2))
		return LDAP_COMPARE_FALSE;
	else
		return LDAP_COMPARE_TRUE;
}  /* BMatchingComponentExtensionsContent */

void*
ExtractingComponentExtensions ( void* mem_op, ComponentReference* cr, ComponentExtensions *comp )
{
	int count = 0;
	int total;
	AsnList *v = &comp->comp_list;
	ComponentInt *k;
	ComponentExtension *component;


	switch ( cr->cr_curr->ci_type ) {
	case LDAP_COMPREF_FROM_BEGINNING :
		count = cr->cr_curr->ci_val.ci_from_beginning;
		FOR_EACH_LIST_ELMT( component , v ) {
			if( --count == 0 ) {
				if( cr->cr_curr->ci_next == NULL )
					return component;
				else {
					cr->cr_curr = cr->cr_curr->ci_next;
					return 	ExtractingComponentExtension ( mem_op, cr, component );
				}
			}
		}
		break;
	case LDAP_COMPREF_FROM_END :
		total = AsnListCount ( v );
		count = cr->cr_curr->ci_val.ci_from_end;
		count = total + count +1;
		FOR_EACH_LIST_ELMT ( component, v ) {
			if( --count == 0 ) {
				if( cr->cr_curr->ci_next == NULL ) 
					return component;
				else {
					cr->cr_curr = cr->cr_curr->ci_next;
					return 	ExtractingComponentExtension ( mem_op, cr, component );
				}
			}
		}
		break;
	case LDAP_COMPREF_ALL :
		return comp;
	case LDAP_COMPREF_COUNT :
		k = (ComponentInt*)CompAlloc( mem_op, sizeof(ComponentInt));
		k->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
		k->comp_desc->cd_tag = (-1);
		k->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentInt;
		k->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentInt;
		k->comp_desc->cd_extract_i = (extract_component_from_id_func*)NULL;
		k->comp_desc->cd_type = ASN_BASIC;
		k->comp_desc->cd_type_id = BASICTYPE_INTEGER;
		k->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentInt;
		k->value = AsnListCount(v);
		return k;
	default :
		return NULL;
	}
}  /* ExtractingComponentExtensions */

int
BDecComponentExtensions PARAMS ((b, tagId0, elmtLen0, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
AsnTag tagId0 _AND_
AsnLen elmtLen0 _AND_
ComponentExtensions **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	int seqDone = FALSE;
	AsnLen totalElmtsLen1 = 0;
	AsnLen elmtLen1;
	AsnTag tagId1;
	int mandatoryElmtCount1 = 0;
	int old_mode = mode;
	int rc;
	ComponentExtensions *k, *t, c_temp;


	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
	AsnListInit(&k->comp_list,sizeof(ComponentExtension));
    for (totalElmtsLen1 = 0; (totalElmtsLen1 < elmtLen0) || (elmtLen0 == INDEFINITE_LEN);)
    {
        ComponentExtension **tmpVar;
    tagId1 = BDecTag (b, &totalElmtsLen1 );

    if ((tagId1 == EOC_TAG_ID) && (elmtLen0 == INDEFINITE_LEN))
    {
        BDEC_2ND_EOC_OCTET (b, &totalElmtsLen1 )
        break; /* got EOC so can exit this SET OF/SEQ OF's for loop*/
    }
    if ((tagId1 == MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE)))
    {
        elmtLen1 = BDecLen (b, &totalElmtsLen1 );
    tmpVar = (ComponentExtension**) CompAsnListAppend (mem_op,&k->comp_list);
	rc = BDecComponentExtension (mem_op, b, tagId1, elmtLen1, tmpVar, &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
    }  /* end of tag check if */
    else  /* wrong tag */
    {
         Asn1Error ("Unexpected Tag\n");
         return -1;
    }
    } /* end of for */

	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentExtensions*) CompAlloc( mem_op, sizeof(ComponentExtensions) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentExtensions ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentExtensions ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentExtensions;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = COMPOSITE_ASN1_TYPE;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentExtensions;
    (*bytesDecoded) += totalElmtsLen1;
	return LDAP_SUCCESS;
}  /* BDecExtensionsContent */

int
GDecComponentExtensions PARAMS (( mem_op,b, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
ComponentExtensions **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	char* peek_head,*peek_head2;
	int i, strLen,strLen2, rc, old_mode = mode;
	ComponentExtensions *k,*t, c_temp;


	int ElmtsLen1;
	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
	AsnListInit( &k->comp_list, sizeof( ComponentExtension ) );
	*bytesDecoded = 0;
	if( !(strLen = LocateNextGSERToken(mem_op,b, &peek_head, GSER_PEEK)) ){
		Asn1Error("Error during Reading { in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != '{'){
		Asn1Error("Missing { in encoded data");
		return LDAP_PROTOCOL_ERROR;
	}

	for (ElmtsLen1 = 0; ElmtsLen1 >= INDEFINITE_LEN; ElmtsLen1++)
	{
		ComponentExtension **tmpVar;
		if( !(strLen = LocateNextGSERToken(mem_op,b, &peek_head, GSER_NO_COPY)) ){
			Asn1Error("Error during Reading{ in encoding");
			return LDAP_PROTOCOL_ERROR;
		}
		if(*peek_head == '}') break;
		if( !(*peek_head == '{' || *peek_head ==',') ) {
			return LDAP_PROTOCOL_ERROR;
		}
		tmpVar = (ComponentExtension**) CompAsnListAppend (mem_op, &k->comp_list);
		if ( tmpVar == NULL ) {
			Asn1Error("Error during Reading{ in encoding");
			return LDAP_PROTOCOL_ERROR;
		}
		rc = 	GDecComponentExtension (mem_op, b, tmpVar, bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	} /* end of for */

	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentExtensions*) CompAlloc( mem_op, sizeof(ComponentExtensions) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentExtensions ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentExtensions ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentExtensions;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = COMPOSITE_ASN1_TYPE;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentExtensions;
	return LDAP_SUCCESS;
}  /* GDecExtensionsContent */


int
MatchingComponentRelativeDistinguishedName ( char* oid, ComponentSyntaxInfo* csi_attr, ComponentSyntaxInfo* csi_assert ) {
	int rc;
	MatchingRule* mr;
	void* component1, *component2;
	AsnList *v1, *v2, t_list;


	if ( oid ) {
		mr = retrieve_matching_rule( oid, csi_attr->csi_comp_desc->cd_type_id);
		if ( mr ) return component_value_match( mr, csi_attr, csi_assert );
	}

	v1 = &((ComponentRelativeDistinguishedName*)csi_attr)->comp_list;
	v2 = &((ComponentRelativeDistinguishedName*)csi_assert)->comp_list;
	AsnListInit( &t_list, 0 );
	if( AsnListCount( v1 ) != AsnListCount( v2 ) )
		return LDAP_COMPARE_FALSE;
	FOR_EACH_LIST_ELMT (component1, v1)
	{
		FOR_EACH_LIST_ELMT(component2, v2)
		{
			if( MatchingComponentAttributeTypeAndValue(oid, (ComponentSyntaxInfo*)component1,(ComponentSyntaxInfo*)component2) == LDAP_COMPARE_TRUE ) {
			AsnElmtMove( v2, &t_list );
			   break;
			}
		} /* end of inner for */
	} /* end of outer for */

	if( AsnListCount( v2 ) == 0 )
		 rc = LDAP_COMPARE_TRUE;
	else
		 rc = LDAP_COMPARE_FALSE;
	AsnListMove( &t_list, v2 );
	AsnListFirst( v1 );
	AsnListFirst( v2 );
	return rc;
}  /* BMatchingComponentRelativeDistinguishedNameContent */

void*
ExtractingComponentRelativeDistinguishedName ( void* mem_op, ComponentReference* cr, ComponentRelativeDistinguishedName *comp )
{
	int count = 0;
	int total;
	AsnList *v = &comp->comp_list;
	ComponentInt *k;
	ComponentAttributeTypeAndValue *component;


	switch ( cr->cr_curr->ci_type ) {
	case LDAP_COMPREF_FROM_BEGINNING :
		count = cr->cr_curr->ci_val.ci_from_beginning;
		FOR_EACH_LIST_ELMT( component , v ) {
			if( --count == 0 ) {
				if( cr->cr_curr->ci_next == NULL )
					return component;
				else {
					cr->cr_curr = cr->cr_curr->ci_next;
					return 	ExtractingComponentAttributeTypeAndValue ( mem_op, cr, component );
				}
			}
		}
		break;
	case LDAP_COMPREF_FROM_END :
		total = AsnListCount ( v );
		count = cr->cr_curr->ci_val.ci_from_end;
		count = total + count +1;
		FOR_EACH_LIST_ELMT ( component, v ) {
			if( --count == 0 ) {
				if( cr->cr_curr->ci_next == NULL )
					return component;
				else {
					cr->cr_curr = cr->cr_curr->ci_next;
					return 	ExtractingComponentAttributeTypeAndValue ( mem_op, cr, component );
				}
			}
		}
		break;
	case LDAP_COMPREF_ALL :
		return comp;
	case LDAP_COMPREF_COUNT :
		k = (ComponentInt*)CompAlloc( mem_op, sizeof(ComponentInt));
		k->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
		k->comp_desc->cd_tag = (-1);
		k->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentInt;
		k->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentInt;
		k->comp_desc->cd_extract_i = (extract_component_from_id_func*)NULL;
		k->comp_desc->cd_type = ASN_BASIC;
		k->comp_desc->cd_type_id = BASICTYPE_INTEGER;
		k->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentInt;
		k->value = AsnListCount(v);
		return k;
	default :
		return NULL;
	}
}  /* ExtractingComponentRelativeDistinguishedName */

int
BDecComponentRelativeDistinguishedName PARAMS ((b, tagId0, elmtLen0, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
AsnTag tagId0 _AND_
AsnLen elmtLen0 _AND_
ComponentRelativeDistinguishedName **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	int seqDone = FALSE;
	AsnLen totalElmtsLen1 = 0;
	AsnLen elmtLen1;
	AsnTag tagId1;
	int mandatoryElmtCount1 = 0;
	int old_mode = mode;
	int rc;
	ComponentRelativeDistinguishedName *k, *t, c_temp;


	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
	AsnListInit(&k->comp_list,sizeof(ComponentAttributeTypeAndValue));
    for (totalElmtsLen1 = 0; (totalElmtsLen1 < elmtLen0) || (elmtLen0 == INDEFINITE_LEN);)
    {
        ComponentAttributeTypeAndValue **tmpVar;
    tagId1 = BDecTag (b, &totalElmtsLen1 );

    if ((tagId1 == EOC_TAG_ID) && (elmtLen0 == INDEFINITE_LEN))
    {
        BDEC_2ND_EOC_OCTET (b, &totalElmtsLen1 )
        break; /* got EOC so can exit this SET OF/SEQ OF's for loop*/
    }
    if ((tagId1 == MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE)))
    {
        elmtLen1 = BDecLen (b, &totalElmtsLen1 );
    tmpVar = (ComponentAttributeTypeAndValue**) CompAsnListAppend (mem_op,&k->comp_list);
	rc = BDecComponentAttributeTypeAndValue (mem_op, b, tagId1, elmtLen1, tmpVar, &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
    }  /* end of tag check if */
    else  /* wrong tag */
    {
         Asn1Error ("Unexpected Tag\n");
         return -1;
    }
    } /* end of for */

	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentRelativeDistinguishedName*) CompAlloc( mem_op, sizeof(ComponentRelativeDistinguishedName) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}

	t->comp_desc->cd_gser_encoder = (encoder_func*)NULL;
	t->comp_desc->cd_ber_encoder = (encoder_func*)NULL;
	t->comp_desc->cd_ldap_encoder = (encoder_func*)ConvertRDN2RFC2253;
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentRelativeDistinguishedName ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentRelativeDistinguishedName ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentRelativeDistinguishedName;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = RelativeDistinguishedName;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentRelativeDistinguishedName;
    (*bytesDecoded) += totalElmtsLen1;
	return LDAP_SUCCESS;
}  /* BDecRelativeDistinguishedNameContent */

int
GDecComponentRelativeDistinguishedName PARAMS (( mem_op,b, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
ComponentRelativeDistinguishedName **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	char* peek_head,*peek_head2;
	int i, strLen,strLen2, rc, old_mode = mode;
	ComponentRelativeDistinguishedName *k,*t, c_temp;


	int ElmtsLen1;
	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
	AsnListInit( &k->comp_list, sizeof( ComponentAttributeTypeAndValue ) );
	*bytesDecoded = 0;
	if( !(strLen = LocateNextGSERToken(mem_op,b, &peek_head, GSER_PEEK)) ){
		Asn1Error("Error during Reading { in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != '{'){
		Asn1Error("Missing { in encoded data");
		return LDAP_PROTOCOL_ERROR;
	}

	for (ElmtsLen1 = 0; ElmtsLen1 >= INDEFINITE_LEN; ElmtsLen1++)
	{
		ComponentAttributeTypeAndValue **tmpVar;
		if( !(strLen = LocateNextGSERToken(mem_op,b, &peek_head, GSER_NO_COPY)) ){
			Asn1Error("Error during Reading{ in encoding");
			return LDAP_PROTOCOL_ERROR;
		}
		if(*peek_head == '}') break;
		if( !(*peek_head == '{' || *peek_head ==',') ) {
			return LDAP_PROTOCOL_ERROR;
		}
		tmpVar = (ComponentAttributeTypeAndValue**) CompAsnListAppend (mem_op, &k->comp_list);
		if ( tmpVar == NULL ) {
			Asn1Error("Error during Reading{ in encoding");
			return LDAP_PROTOCOL_ERROR;
		}
		rc = 	GDecComponentAttributeTypeAndValue (mem_op, b, tmpVar, bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	} /* end of for */

	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentRelativeDistinguishedName*) CompAlloc( mem_op, sizeof(ComponentRelativeDistinguishedName) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentRelativeDistinguishedName ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentRelativeDistinguishedName ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentRelativeDistinguishedName;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = RelativeDistinguishedName;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentRelativeDistinguishedName;
	return LDAP_SUCCESS;
}  /* GDecRelativeDistinguishedNameContent */


int
MatchingComponentRDNSequence ( char* oid, ComponentSyntaxInfo* csi_attr, ComponentSyntaxInfo* csi_assert ) {
	int rc;
	MatchingRule* mr;
	void* component1, *component2;
	AsnList *v1, *v2, t_list;


	if ( oid ) {
		mr = retrieve_matching_rule( oid, csi_attr->csi_comp_desc->cd_type_id);
		if ( mr ) return component_value_match( mr, csi_attr, csi_assert );
	}

	v1 = &((ComponentRDNSequence*)csi_attr)->comp_list;
	v2 = &((ComponentRDNSequence*)csi_assert)->comp_list;
	FOR_EACH_LIST_PAIR_ELMT(component1, component2, v1, v2)
	{
		if( MatchingComponentRelativeDistinguishedName(oid, (ComponentSyntaxInfo*)component1, (ComponentSyntaxInfo*)component2) == LDAP_COMPARE_FALSE) {
			return LDAP_COMPARE_FALSE;
		}
	} /* end of for */

	AsnListFirst( v1 );
	AsnListFirst( v2 );
	if( (!component1 && component2) || (component1 && !component2))
		return LDAP_COMPARE_FALSE;
	else
		return LDAP_COMPARE_TRUE;
}  /* BMatchingComponentRDNSequenceContent */

void*
ExtractingComponentRDNSequence ( void* mem_op, ComponentReference* cr, ComponentRDNSequence *comp )
{
	int count = 0;
	int total;
	AsnList *v = &comp->comp_list;
	ComponentInt *k;
	ComponentRelativeDistinguishedName *component;


	switch ( cr->cr_curr->ci_type ) {
	case LDAP_COMPREF_FROM_BEGINNING :
		count = cr->cr_curr->ci_val.ci_from_beginning;
		FOR_EACH_LIST_ELMT( component , v ) {
			if( --count == 0 ) {
				if( cr->cr_curr->ci_next == NULL )
					return component;
				else {
					cr->cr_curr = cr->cr_curr->ci_next;
					return 	ExtractingComponentRelativeDistinguishedName ( mem_op, cr, component );
				}
			}
		}
		break;
	case LDAP_COMPREF_FROM_END :
		total = AsnListCount ( v );
		count = cr->cr_curr->ci_val.ci_from_end;
		count = total + count +1;
		FOR_EACH_LIST_ELMT ( component, v ) {
			if( --count == 0 ) {
				if( cr->cr_curr->ci_next == NULL ) 
					return component;
				else {
					cr->cr_curr = cr->cr_curr->ci_next;
					return 	ExtractingComponentRelativeDistinguishedName ( mem_op, cr, component );
				}
			}
		}
		break;
	case LDAP_COMPREF_ALL :
		return comp;
	case LDAP_COMPREF_COUNT :
		k = (ComponentInt*)CompAlloc( mem_op, sizeof(ComponentInt));
		k->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
		k->comp_desc->cd_tag = (-1);
		k->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentInt;
		k->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentInt;
		k->comp_desc->cd_extract_i = (extract_component_from_id_func*)NULL;
		k->comp_desc->cd_type = ASN_BASIC;
		k->comp_desc->cd_type_id = BASICTYPE_INTEGER;
		k->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentInt;
		k->value = AsnListCount(v);
		return k;
	default :
		return NULL;
	}
}  /* ExtractingComponentRDNSequence */

int
BDecComponentRDNSequence PARAMS ((b, tagId0, elmtLen0, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
AsnTag tagId0 _AND_
AsnLen elmtLen0 _AND_
ComponentRDNSequence **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	int seqDone = FALSE;
	AsnLen totalElmtsLen1 = 0;
	AsnLen elmtLen1;
	AsnTag tagId1;
	int mandatoryElmtCount1 = 0;
	int old_mode = mode;
	int rc;
	ComponentRDNSequence *k, *t, c_temp;


	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
	AsnListInit(&k->comp_list,sizeof(ComponentRelativeDistinguishedName));
    for (totalElmtsLen1 = 0; (totalElmtsLen1 < elmtLen0) || (elmtLen0 == INDEFINITE_LEN);)
    {
        ComponentRelativeDistinguishedName **tmpVar;
    tagId1 = BDecTag (b, &totalElmtsLen1 );

    if ((tagId1 == EOC_TAG_ID) && (elmtLen0 == INDEFINITE_LEN))
    {
        BDEC_2ND_EOC_OCTET (b, &totalElmtsLen1 )
        break; /* got EOC so can exit this SET OF/SEQ OF's for loop*/
    }
    if ((tagId1 == MAKE_TAG_ID (UNIV, CONS, SET_TAG_CODE)))
    {
        elmtLen1 = BDecLen (b, &totalElmtsLen1 );
    tmpVar = (ComponentRelativeDistinguishedName**) CompAsnListAppend (mem_op,&k->comp_list);
	rc = BDecComponentRelativeDistinguishedName (mem_op, b, tagId1, elmtLen1, tmpVar, &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
    }  /* end of tag check if */
    else  /* wrong tag */
    {
         Asn1Error ("Unexpected Tag\n");
         return -1;
    }
    } /* end of for */

	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentRDNSequence*) CompAlloc( mem_op, sizeof(ComponentRDNSequence) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}

	t->comp_desc->cd_gser_encoder = (encoder_func*)NULL;
	t->comp_desc->cd_ber_encoder = (encoder_func*)NULL;
	t->comp_desc->cd_ldap_encoder = (encoder_func*) ConvertRDNSequence2RFC2253;
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentRDNSequence ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentRDNSequence ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentRDNSequence;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = RDNSequence;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentRDNSequence;
    (*bytesDecoded) += totalElmtsLen1;
	return LDAP_SUCCESS;
}  /* BDecRDNSequenceContent */

int
GDecComponentRDNSequence PARAMS (( mem_op,b, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
ComponentRDNSequence **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	char* peek_head,*peek_head2;
	int i, strLen,strLen2, rc, old_mode = mode;
	ComponentRDNSequence *k,*t, c_temp;


	int ElmtsLen1;
	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
	AsnListInit( &k->comp_list, sizeof( ComponentRelativeDistinguishedName ) );
	*bytesDecoded = 0;
	if( !(strLen = LocateNextGSERToken(mem_op,b, &peek_head, GSER_PEEK)) ){
		Asn1Error("Error during Reading { in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != '{'){
		Asn1Error("Missing { in encoded data");
		return LDAP_PROTOCOL_ERROR;
	}

	for (ElmtsLen1 = 0; ElmtsLen1 >= INDEFINITE_LEN; ElmtsLen1++)
	{
		ComponentRelativeDistinguishedName **tmpVar;
		if( !(strLen = LocateNextGSERToken(mem_op,b, &peek_head, GSER_NO_COPY)) ){
			Asn1Error("Error during Reading{ in encoding");
			return LDAP_PROTOCOL_ERROR;
		}
		if(*peek_head == '}') break;
		if( !(*peek_head == '{' || *peek_head ==',') ) {
			return LDAP_PROTOCOL_ERROR;
		}
		tmpVar = (ComponentRelativeDistinguishedName**) CompAsnListAppend (mem_op, &k->comp_list);
		if ( tmpVar == NULL ) {
			Asn1Error("Error during Reading{ in encoding");
			return LDAP_PROTOCOL_ERROR;
		}
		rc = 	GDecComponentRelativeDistinguishedName (mem_op, b, tmpVar, bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	} /* end of for */

	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentRDNSequence*) CompAlloc( mem_op, sizeof(ComponentRDNSequence) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_gser_encoder = (encoder_func*)NULL;
	t->comp_desc->cd_ber_encoder = (encoder_func*)NULL;
	t->comp_desc->cd_ldap_encoder = (encoder_func*)ConvertRDNSequence2RFC2253;
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentRDNSequence ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentRDNSequence ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentRDNSequence;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = RDNSequence ;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentRDNSequence;
	return LDAP_SUCCESS;
}  /* GDecRDNSequenceContent */


int
MatchingComponentName ( char* oid, ComponentSyntaxInfo* csi_attr, ComponentSyntaxInfo* csi_assert ) {
	int rc;
	MatchingRule* mr;
	ComponentName *v1, *v2;


	v1 = (ComponentName*)csi_attr;
	v2 = (ComponentName*)csi_assert;
	if ( oid ) {
		mr = retrieve_matching_rule( oid, csi_attr->csi_comp_desc->cd_type_id);
		if ( mr ) return component_value_match( mr, csi_attr, csi_assert );
	}

	if( (v1->choiceId != v2->choiceId ) )
		return LDAP_COMPARE_FALSE;
	switch( v1->choiceId )
	{
	   case NAME_RDNSEQUENCE :
		rc = 	MatchingComponentRDNSequence ( oid, (ComponentSyntaxInfo*)(v1->a.rdnSequence), (ComponentSyntaxInfo*)(v2->a.rdnSequence) );
		break;
	default : 
		 return LDAP_PROTOCOL_ERROR;
	}
	return rc;
}  /* BMatchingComponentNameContent */

void*
ExtractingComponentName ( void* mem_op, ComponentReference* cr, ComponentName *comp )
{


	if( (comp->choiceId) ==  NAME_RDNSEQUENCE &&
		 (( comp->a.rdnSequence->identifier.bv_val && strncmp(comp->a.rdnSequence->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0) ||
		 ( strncmp(comp->a.rdnSequence->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0))) {
		if ( cr->cr_curr->ci_next == NULL )
			return (comp->a.rdnSequence);
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentRDNSequence ( mem_op, cr, (comp->a.rdnSequence) );
		};
	}
	return NULL;
}  /* ExtractingComponentName */

int
BDecComponentName PARAMS ((b, tagId0, elmtLen0, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
AsnTag tagId0 _AND_
AsnLen elmtLen0 _AND_
ComponentName **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	int seqDone = FALSE;
	AsnLen totalElmtsLen1 = 0;
	AsnLen elmtLen1;
	AsnTag tagId1;
	int mandatoryElmtCount1 = 0;
	int old_mode = mode;
	int rc;
	ComponentName *k, *t, c_temp;


	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
    switch (tagId0)
    {
       case MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE):
        (k->choiceId) = NAME_RDNSEQUENCE;
	rc = BDecComponentRDNSequence (mem_op, b, tagId0, elmtLen0, (&k->a.rdnSequence), &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->a.rdnSequence)->identifier.bv_val = (k->a.rdnSequence)->id_buf;
		(k->a.rdnSequence)->identifier.bv_len = strlen("rdnSequence");
		strcpy( (k->a.rdnSequence)->identifier.bv_val, "rdnSequence");
    break;

    default:
        Asn1Error ("ERROR - unexpected tag in CHOICE\n");
        return -1;
        break;
    } /* end switch */
	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentName*) CompAlloc( mem_op, sizeof(ComponentName) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentName ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentName ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentName;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = COMPOSITE_ASN1_TYPE;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentName;
    (*bytesDecoded) += totalElmtsLen1;
	return LDAP_SUCCESS;
}  /* BDecNameContent */

int
GDecComponentName PARAMS (( mem_op,b, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
ComponentName **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	char* peek_head,*peek_head2;
	int i, strLen,strLen2, rc, old_mode = mode;
	ComponentName *k,*t, c_temp;


	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(strLen2 = LocateNextGSERToken(mem_op,b,&peek_head2,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head2 != ':'){
		Asn1Error("Missing : in encoded data");
		return LDAP_PROTOCOL_ERROR;
	}
	if( strncmp("rdnSequence",peek_head, strlen("rdnSequence")) == 0){
		(k->choiceId) = NAME_RDNSEQUENCE;
		rc = 	GDecComponentRDNSequence (mem_op, b, (&k->a.rdnSequence), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->a.rdnSequence)->identifier.bv_val = peek_head;
		(k->a.rdnSequence)->identifier.bv_len = strLen;
	}
	else {
		Asn1Error("Undefined Identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentName*) CompAlloc( mem_op, sizeof(ComponentName) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentName ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentName ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentName;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = COMPOSITE_ASN1_TYPE;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentName;
	return LDAP_SUCCESS;
}  /* GDecNameContent */


int
MatchingComponentTBSCertificate ( char* oid, ComponentSyntaxInfo* csi_attr, ComponentSyntaxInfo* csi_assert ) {
	int rc;
	MatchingRule* mr;

	if ( oid ) {
		mr = retrieve_matching_rule( oid, csi_attr->csi_comp_desc->cd_type_id);
		if ( mr ) return component_value_match( mr, csi_attr, csi_assert );
	}

	rc = 1;
	rc =	MatchingComponentVersion ( oid, (ComponentSyntaxInfo*)((ComponentTBSCertificate*)csi_attr)->version, (ComponentSyntaxInfo*)((ComponentTBSCertificate*)csi_assert)->version );
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	rc =	MatchingComponentCertificateSerialNumber ( oid, (ComponentSyntaxInfo*)&((ComponentTBSCertificate*)csi_attr)->serialNumber, (ComponentSyntaxInfo*)&((ComponentTBSCertificate*)csi_assert)->serialNumber );
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	rc =	MatchingComponentAlgorithmIdentifier ( oid, (ComponentSyntaxInfo*)((ComponentTBSCertificate*)csi_attr)->signature, (ComponentSyntaxInfo*)((ComponentTBSCertificate*)csi_assert)->signature );
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	rc =	MatchingComponentName ( oid, (ComponentSyntaxInfo*)((ComponentTBSCertificate*)csi_attr)->issuer, (ComponentSyntaxInfo*)((ComponentTBSCertificate*)csi_assert)->issuer );
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	rc =	MatchingComponentValidity ( oid, (ComponentSyntaxInfo*)((ComponentTBSCertificate*)csi_attr)->validity, (ComponentSyntaxInfo*)((ComponentTBSCertificate*)csi_assert)->validity );
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	rc =	MatchingComponentName ( oid, (ComponentSyntaxInfo*)((ComponentTBSCertificate*)csi_attr)->subject, (ComponentSyntaxInfo*)((ComponentTBSCertificate*)csi_assert)->subject );
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	rc =	MatchingComponentSubjectPublicKeyInfo ( oid, (ComponentSyntaxInfo*)((ComponentTBSCertificate*)csi_attr)->subjectPublicKeyInfo, (ComponentSyntaxInfo*)((ComponentTBSCertificate*)csi_assert)->subjectPublicKeyInfo );
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	rc =	MatchingComponentUniqueIdentifier ( oid, (ComponentSyntaxInfo*)&((ComponentTBSCertificate*)csi_attr)->issuerUniqueIdentifier, (ComponentSyntaxInfo*)&((ComponentTBSCertificate*)csi_assert)->issuerUniqueIdentifier );
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	rc =	MatchingComponentUniqueIdentifier ( oid, (ComponentSyntaxInfo*)&((ComponentTBSCertificate*)csi_attr)->subjectUniqueIdentifier, (ComponentSyntaxInfo*)&((ComponentTBSCertificate*)csi_assert)->subjectUniqueIdentifier );
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	if(COMPONENTNOT_NULL( ((ComponentTBSCertificate*)csi_attr)->extensions ) ) {
	rc =	MatchingComponentExtensions ( oid, (ComponentSyntaxInfo*)((ComponentTBSCertificate*)csi_attr)->extensions, (ComponentSyntaxInfo*)((ComponentTBSCertificate*)csi_assert)->extensions );
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	}
	return LDAP_COMPARE_TRUE;
}  /* BMatchingComponentTBSCertificate */

void*
ExtractingComponentTBSCertificate ( void* mem_op, ComponentReference* cr, ComponentTBSCertificate *comp )
{

	if ( ( comp->version->identifier.bv_val && strncmp(comp->version->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->version->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
			return comp->version;
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentVersion ( mem_op, cr, comp->version );
		}
	}
	if ( ( comp->serialNumber.identifier.bv_val && strncmp(comp->serialNumber.identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->serialNumber.id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
		return &comp->serialNumber;
		else
		return NULL;
	}
	if ( ( comp->signature->identifier.bv_val && strncmp(comp->signature->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->signature->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
			return comp->signature;
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentAlgorithmIdentifier ( mem_op, cr, comp->signature );
		}
	}
	if ( ( comp->issuer->identifier.bv_val && strncmp(comp->issuer->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->issuer->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
			return comp->issuer;
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentName ( mem_op, cr, comp->issuer );
		}
	}
	if ( ( comp->validity->identifier.bv_val && strncmp(comp->validity->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->validity->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
			return comp->validity;
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentValidity ( mem_op, cr, comp->validity );
		}
	}
	if ( ( comp->subject->identifier.bv_val && strncmp(comp->subject->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->subject->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
			return comp->subject;
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentName ( mem_op, cr, comp->subject );
		}
	}
	if ( ( comp->subjectPublicKeyInfo->identifier.bv_val && strncmp(comp->subjectPublicKeyInfo->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->subjectPublicKeyInfo->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
			return comp->subjectPublicKeyInfo;
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentSubjectPublicKeyInfo ( mem_op, cr, comp->subjectPublicKeyInfo );
		}
	}
	if ( ( comp->issuerUniqueIdentifier.identifier.bv_val && strncmp(comp->issuerUniqueIdentifier.identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->issuerUniqueIdentifier.id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
		return &comp->issuerUniqueIdentifier;
	else if ( cr->cr_curr->ci_next->ci_type == LDAP_COMPREF_CONTENT) {
			cr->cr_curr = cr->cr_curr->ci_next;
		return &comp->issuerUniqueIdentifier;
	 } else {
		return NULL;
		}
	}
	if ( ( comp->subjectUniqueIdentifier.identifier.bv_val && strncmp(comp->subjectUniqueIdentifier.identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->subjectUniqueIdentifier.id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
		return &comp->subjectUniqueIdentifier;
	else if ( cr->cr_curr->ci_next->ci_type == LDAP_COMPREF_CONTENT) {
			cr->cr_curr = cr->cr_curr->ci_next;
		return &comp->subjectUniqueIdentifier;
	 } else {
		return NULL;
		}
	}
	if ( ( comp->extensions->identifier.bv_val && strncmp(comp->extensions->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->extensions->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
			return comp->extensions;
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentExtensions ( mem_op, cr, comp->extensions );
		}
	}
	return NULL;
}  /* ExtractingComponentTBSCertificate */

int
BDecComponentTBSCertificate PARAMS ((b, tagId0, elmtLen0, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
AsnTag tagId0 _AND_
AsnLen elmtLen0 _AND_
ComponentTBSCertificate **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	int seqDone = FALSE;
	AsnLen totalElmtsLen1 = 0;
	AsnLen elmtLen1;
	AsnTag tagId1;
	int mandatoryElmtCount1 = 0;
	AsnLen totalElmtsLen2 = 0;
	AsnLen elmtLen2;
	AsnTag tagId2;
	int old_mode = mode;
	int rc;
	ComponentTBSCertificate *k, *t, c_temp;


	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
    tagId1 = BDecTag (b, &totalElmtsLen1 );

    if (((tagId1 == MAKE_TAG_ID (CNTX, CONS, 0))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
        tagId2 = BDecTag (b, &totalElmtsLen1 );

    if (tagId2 != MAKE_TAG_ID (UNIV, PRIM, INTEGER_TAG_CODE))
    {
         Asn1Error ("Unexpected Tag\n");
         return -1;
    }

    elmtLen2 = BDecLen (b, &totalElmtsLen1 );
	rc = BDecComponentVersion (mem_op, b, tagId2, elmtLen2, (&k->version), &totalElmtsLen1, DEC_ALLOC_MODE_0 );
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->version)->identifier.bv_val = (k->version)->id_buf;
		(k->version)->identifier.bv_len = strlen("version");
		strcpy( (k->version)->identifier.bv_val, "version");
	if (elmtLen1 == INDEFINITE_LEN)
        BDecEoc (b, &totalElmtsLen1 );
    tagId1 = BDecTag (b, &totalElmtsLen1);
    }


    if (((tagId1 == MAKE_TAG_ID (UNIV, PRIM, INTEGER_TAG_CODE))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
	rc = BDecComponentCertificateSerialNumber (mem_op, b, tagId1, elmtLen1, (&k->serialNumber), &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(&k->serialNumber)->identifier.bv_val = (&k->serialNumber)->id_buf;
		(&k->serialNumber)->identifier.bv_len = strlen("serialNumber");
		strcpy( (&k->serialNumber)->identifier.bv_val, "serialNumber");
    tagId1 = BDecTag (b, &totalElmtsLen1);
    }
    else
        return -1;



    if (((tagId1 == MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
	rc = BDecComponentAlgorithmIdentifier (mem_op, b, tagId1, elmtLen1, (&k->signature), &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->signature)->identifier.bv_val = (k->signature)->id_buf;
		(k->signature)->identifier.bv_len = strlen("signature");
		strcpy( (k->signature)->identifier.bv_val, "signature");
    tagId1 = BDecTag (b, &totalElmtsLen1);
    }
    else
        return -1;



    if (((tagId1 == MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))))
    {
        elmtLen1 = BDecLen (b, &totalElmtsLen1 );
	rc = BDecComponentName (mem_op, b, tagId1, elmtLen1, (&k->issuer), &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->issuer)->identifier.bv_val = (k->issuer)->id_buf;
		(k->issuer)->identifier.bv_len = strlen("issuer");
		strcpy( (k->issuer)->identifier.bv_val, "issuer");
    tagId1 = BDecTag (b, &totalElmtsLen1);
    }
    else
        return -1;



    if (((tagId1 == MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
	rc = BDecComponentValidity (mem_op, b, tagId1, elmtLen1, (&k->validity), &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->validity)->identifier.bv_val = (k->validity)->id_buf;
		(k->validity)->identifier.bv_len = strlen("validity");
		strcpy( (k->validity)->identifier.bv_val, "validity");
    tagId1 = BDecTag (b, &totalElmtsLen1);
    }
    else
        return -1;



    if (((tagId1 == MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))))
    {
        elmtLen1 = BDecLen (b, &totalElmtsLen1 );
	rc = BDecComponentName (mem_op, b, tagId1, elmtLen1, (&k->subject), &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->subject)->identifier.bv_val = (k->subject)->id_buf;
		(k->subject)->identifier.bv_len = strlen("subject");
		strcpy( (k->subject)->identifier.bv_val, "subject");
    tagId1 = BDecTag (b, &totalElmtsLen1);
    }
    else
        return -1;



    if (((tagId1 == MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
	rc = BDecComponentSubjectPublicKeyInfo (mem_op, b, tagId1, elmtLen1, (&k->subjectPublicKeyInfo), &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->subjectPublicKeyInfo)->identifier.bv_val = (k->subjectPublicKeyInfo)->id_buf;
		(k->subjectPublicKeyInfo)->identifier.bv_len = strlen("subjectPublicKeyInfo");
		strcpy( (k->subjectPublicKeyInfo)->identifier.bv_val, "subjectPublicKeyInfo");
    if ((elmtLen0 != INDEFINITE_LEN) && (totalElmtsLen1 == elmtLen0))
        seqDone = TRUE;
    else
    {
        tagId1 = BDecTag (b, &totalElmtsLen1 );

         if ((elmtLen0 == INDEFINITE_LEN) && (tagId1 == EOC_TAG_ID))
        {
            BDEC_2ND_EOC_OCTET (b, &totalElmtsLen1 )
            seqDone = TRUE;
        }
    }
    }
    else
        return -1;



    if ((!seqDone) && ((tagId1 == MAKE_TAG_ID (CNTX, PRIM, 1)) ||
(tagId1 == MAKE_TAG_ID (CNTX, CONS, 1))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
	rc = BDecComponentUniqueIdentifier (mem_op, b, tagId1, elmtLen1, (&k->issuerUniqueIdentifier), &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(&k->issuerUniqueIdentifier)->identifier.bv_val = (&k->issuerUniqueIdentifier)->id_buf;
		(&k->issuerUniqueIdentifier)->identifier.bv_len = strlen("issuerUniqueIdentifier");
		strcpy( (&k->issuerUniqueIdentifier)->identifier.bv_val, "issuerUniqueIdentifier");
    if ((elmtLen0 != INDEFINITE_LEN) && (totalElmtsLen1 == elmtLen0))
        seqDone = TRUE;
    else
    {
        tagId1 = BDecTag (b, &totalElmtsLen1 );

         if ((elmtLen0 == INDEFINITE_LEN) && (tagId1 == EOC_TAG_ID))
        {
            BDEC_2ND_EOC_OCTET (b, &totalElmtsLen1 )
            seqDone = TRUE;
        }
    }
    }


    if ((!seqDone) && ((tagId1 == MAKE_TAG_ID (CNTX, PRIM, 2)) ||
(tagId1 == MAKE_TAG_ID (CNTX, CONS, 2))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
	rc = BDecComponentUniqueIdentifier (mem_op, b, tagId1, elmtLen1, (&k->subjectUniqueIdentifier), &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(&k->subjectUniqueIdentifier)->identifier.bv_val = (&k->subjectUniqueIdentifier)->id_buf;
		(&k->subjectUniqueIdentifier)->identifier.bv_len = strlen("subjectUniqueIdentifier");
		strcpy( (&k->subjectUniqueIdentifier)->identifier.bv_val, "subjectUniqueIdentifier");
    if ((elmtLen0 != INDEFINITE_LEN) && (totalElmtsLen1 == elmtLen0))
        seqDone = TRUE;
    else
    {
        tagId1 = BDecTag (b, &totalElmtsLen1 );

         if ((elmtLen0 == INDEFINITE_LEN) && (tagId1 == EOC_TAG_ID))
        {
            BDEC_2ND_EOC_OCTET (b, &totalElmtsLen1 )
            seqDone = TRUE;
        }
    }
    }


    if ((!seqDone) && ((tagId1 == MAKE_TAG_ID (CNTX, CONS, 3))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
        tagId2 = BDecTag (b, &totalElmtsLen1 );

    if (tagId2 != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))
    {
         Asn1Error ("Unexpected Tag\n");
         return -1;
    }

    elmtLen2 = BDecLen (b, &totalElmtsLen1 );
	rc = BDecComponentExtensions (mem_op, b, tagId2, elmtLen2, (&k->extensions), &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->extensions)->identifier.bv_val = (k->extensions)->id_buf;
		(k->extensions)->identifier.bv_len = strlen("extensions");
		strcpy( (k->extensions)->identifier.bv_val, "extensions");
	if (elmtLen1 == INDEFINITE_LEN)
        BDecEoc (b, &totalElmtsLen1 );
        seqDone = TRUE;
        if (elmtLen0 == INDEFINITE_LEN)
            BDecEoc (b, &totalElmtsLen1 );
        else if (totalElmtsLen1 != elmtLen0)
        return -1;

    }


    if (!seqDone)
        return -1;

	if(!COMPONENTNOT_NULL ((k->version)))
	{
(k->version) = CompAlloc( mem_op, sizeof(ComponentVersion));
		(k->version)->identifier.bv_val = (k->version)->id_buf;
		(k->version)->identifier.bv_len = strlen("version");
		strcpy( (k->version)->identifier.bv_val, "version");
	(k->version)->value = 0;
	}
	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentTBSCertificate*) CompAlloc( mem_op, sizeof(ComponentTBSCertificate) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentTBSCertificate ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentTBSCertificate ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentTBSCertificate;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = COMPOSITE_ASN1_TYPE;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentTBSCertificate;
    (*bytesDecoded) += totalElmtsLen1;
	return LDAP_SUCCESS;
}  /* BDecTBSCertificate*/

int
GDecComponentTBSCertificate PARAMS (( mem_op,b, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
ComponentTBSCertificate **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	char* peek_head,*peek_head2;
	int i, strLen,strLen2, rc, old_mode = mode;
	ComponentTBSCertificate *k,*t, c_temp;


	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
	*bytesDecoded = 0;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading { in encoded data");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != '{'){
		Asn1Error("Missing { in encoded data");
		return LDAP_PROTOCOL_ERROR;
	}

	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	if ( strncmp( peek_head, "version", strlen("version") ) == 0 ) {
		rc = 	GDecComponentVersion (mem_op, b, (&k->version), bytesDecoded, DEC_ALLOC_MODE_0 );
		if ( rc != LDAP_SUCCESS ) return rc;
	( k->version)->identifier.bv_val = peek_head;
	( k->version)->identifier.bv_len = strLen;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading , ");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != ','){
		Asn1Error("Missing , in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
	  Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	}
	else {
(k->version) = CompAlloc( mem_op, sizeof(ComponentVersion));
			(k->version)->value = 0;
	}
	if ( strncmp( peek_head, "serialNumber", strlen("serialNumber") ) == 0 ) {
		rc = 	GDecComponentCertificateSerialNumber (mem_op, b, (&k->serialNumber), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	(&k->serialNumber)->identifier.bv_val = peek_head;
	(&k->serialNumber)->identifier.bv_len = strLen;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading , ");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != ','){
		Asn1Error("Missing , in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
	  Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	}
	if ( strncmp( peek_head, "signature", strlen("signature") ) == 0 ) {
		rc = 	GDecComponentAlgorithmIdentifier (mem_op, b, (&k->signature), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	( k->signature)->identifier.bv_val = peek_head;
	( k->signature)->identifier.bv_len = strLen;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading , ");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != ','){
		Asn1Error("Missing , in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
	  Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	}
	if ( strncmp( peek_head, "issuer", strlen("issuer") ) == 0 ) {
		rc = 	GDecComponentName (mem_op, b, (&k->issuer), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	( k->issuer)->identifier.bv_val = peek_head;
	( k->issuer)->identifier.bv_len = strLen;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading , ");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != ','){
		Asn1Error("Missing , in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
	  Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	}
	if ( strncmp( peek_head, "validity", strlen("validity") ) == 0 ) {
		rc = 	GDecComponentValidity (mem_op, b, (&k->validity), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	( k->validity)->identifier.bv_val = peek_head;
	( k->validity)->identifier.bv_len = strLen;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading , ");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != ','){
		Asn1Error("Missing , in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
	  Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	}
	if ( strncmp( peek_head, "subject", strlen("subject") ) == 0 ) {
		rc = 	GDecComponentName (mem_op, b, (&k->subject), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	( k->subject)->identifier.bv_val = peek_head;
	( k->subject)->identifier.bv_len = strLen;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading , ");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != ','){
		Asn1Error("Missing , in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
	  Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	}
	if ( strncmp( peek_head, "subjectPublicKeyInfo", strlen("subjectPublicKeyInfo") ) == 0 ) {
		rc = 	GDecComponentSubjectPublicKeyInfo (mem_op, b, (&k->subjectPublicKeyInfo), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	( k->subjectPublicKeyInfo)->identifier.bv_val = peek_head;
	( k->subjectPublicKeyInfo)->identifier.bv_len = strLen;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading , ");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != ','){
		Asn1Error("Missing , in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
	  Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	}
	if ( strncmp( peek_head, "issuerUniqueIdentifier", strlen("issuerUniqueIdentifier") ) == 0 ) {
		rc = 	GDecComponentUniqueIdentifier (mem_op, b, (&k->issuerUniqueIdentifier), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	(&k->issuerUniqueIdentifier)->identifier.bv_val = peek_head;
	(&k->issuerUniqueIdentifier)->identifier.bv_len = strLen;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading , ");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != ','){
		Asn1Error("Missing , in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
	  Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	}
	if ( strncmp( peek_head, "subjectUniqueIdentifier", strlen("subjectUniqueIdentifier") ) == 0 ) {
		rc = 	GDecComponentUniqueIdentifier (mem_op, b, (&k->subjectUniqueIdentifier), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	(&k->subjectUniqueIdentifier)->identifier.bv_val = peek_head;
	(&k->subjectUniqueIdentifier)->identifier.bv_len = strLen;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading , ");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != ','){
		Asn1Error("Missing , in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
	  Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	}
	if ( strncmp( peek_head, "extensions", strlen("extensions") ) == 0 ) {
		rc = 	GDecComponentExtensions (mem_op, b, (&k->extensions), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	( k->extensions)->identifier.bv_val = peek_head;
	( k->extensions)->identifier.bv_len = strLen;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ) {
		Asn1Error("Error during Reading } in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != '}'){
		Asn1Error("Missing } in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentTBSCertificate*) CompAlloc( mem_op, sizeof(ComponentTBSCertificate) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentTBSCertificate ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentTBSCertificate ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentTBSCertificate;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = COMPOSITE_ASN1_TYPE;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentTBSCertificate;
	return LDAP_SUCCESS;
}  /* GDecTBSCertificate*/


int
MatchingComponentCertificate ( char* oid, ComponentSyntaxInfo* csi_attr, ComponentSyntaxInfo* csi_assert ) {
	int rc;
	MatchingRule* mr;

	if ( oid ) {
		mr = retrieve_matching_rule( oid, csi_attr->csi_comp_desc->cd_type_id);
		if ( mr ) return component_value_match( mr, csi_attr, csi_assert );
	}

	rc = 1;
	rc =	MatchingComponentTBSCertificate ( oid, (ComponentSyntaxInfo*)((ComponentCertificate*)csi_attr)->toBeSigned, (ComponentSyntaxInfo*)((ComponentCertificate*)csi_assert)->toBeSigned );
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	rc =	MatchingComponentAlgorithmIdentifier ( oid, (ComponentSyntaxInfo*)((ComponentCertificate*)csi_attr)->signatureAlgorithm, (ComponentSyntaxInfo*)((ComponentCertificate*)csi_assert)->signatureAlgorithm );
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	rc =	MatchingComponentBits ( oid, (ComponentSyntaxInfo*)&((ComponentCertificate*)csi_attr)->signature, (ComponentSyntaxInfo*)&((ComponentCertificate*)csi_assert)->signature );
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	return LDAP_COMPARE_TRUE;
}  /* BMatchingComponentCertificate */

void*
ExtractingComponentCertificate ( void* mem_op, ComponentReference* cr, ComponentCertificate *comp )
{

	if ( ( comp->toBeSigned->identifier.bv_val && strncmp(comp->toBeSigned->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->toBeSigned->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
			return comp->toBeSigned;
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentTBSCertificate ( mem_op, cr, comp->toBeSigned );
		}
	}
	if ( ( comp->signatureAlgorithm->identifier.bv_val && strncmp(comp->signatureAlgorithm->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->signatureAlgorithm->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
			return comp->signatureAlgorithm;
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentAlgorithmIdentifier ( mem_op, cr, comp->signatureAlgorithm );
		}
	}
	if ( ( comp->signature.identifier.bv_val && strncmp(comp->signature.identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->signature.id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
		return &comp->signature;
	else if ( cr->cr_curr->ci_next->ci_type == LDAP_COMPREF_CONTENT) {
			cr->cr_curr = cr->cr_curr->ci_next;
		return &comp->signature;
	 } else {
		return NULL;
		}
	}
	return NULL;
}  /* ExtractingComponentCertificate */

int
BDecComponentCertificate PARAMS ((b, tagId0, elmtLen0, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
AsnTag tagId0 _AND_
AsnLen elmtLen0 _AND_
ComponentCertificate **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	int seqDone = FALSE;
	AsnLen totalElmtsLen1 = 0;
	AsnLen elmtLen1;
	AsnTag tagId1;
	int mandatoryElmtCount1 = 0;
	int old_mode = mode;
	int rc;
	ComponentCertificate *k, *t, c_temp;


	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
    tagId1 = BDecTag (b, &totalElmtsLen1 );

    if (((tagId1 == MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
	rc = BDecComponentTBSCertificate (mem_op, b, tagId1, elmtLen1, (&k->toBeSigned), &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->toBeSigned)->identifier.bv_val = (k->toBeSigned)->id_buf;
		(k->toBeSigned)->identifier.bv_len = strlen("toBeSigned");
		strcpy( (k->toBeSigned)->identifier.bv_val, "toBeSigned");
    tagId1 = BDecTag (b, &totalElmtsLen1);
    }
    else
        return -1;



    if (((tagId1 == MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
	rc = BDecComponentAlgorithmIdentifier (mem_op, b, tagId1, elmtLen1, (&k->signatureAlgorithm), &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->signatureAlgorithm)->identifier.bv_val = (k->signatureAlgorithm)->id_buf;
		(k->signatureAlgorithm)->identifier.bv_len = strlen("signatureAlgorithm");
		strcpy( (k->signatureAlgorithm)->identifier.bv_val, "signatureAlgorithm");
    tagId1 = BDecTag (b, &totalElmtsLen1);
    }
    else
        return -1;



    if (((tagId1 == MAKE_TAG_ID (UNIV, PRIM, BITSTRING_TAG_CODE)) ||
(tagId1 == MAKE_TAG_ID (UNIV, CONS, BITSTRING_TAG_CODE))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
	rc = BDecComponentBits (mem_op, b, tagId1, elmtLen1, (&k->signature), &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(&k->signature)->identifier.bv_val = (&k->signature)->id_buf;
		(&k->signature)->identifier.bv_len = strlen("signature");
		strcpy( (&k->signature)->identifier.bv_val, "signature");
        seqDone = TRUE;
        if (elmtLen0 == INDEFINITE_LEN)
            BDecEoc (b, &totalElmtsLen1 );
        else if (totalElmtsLen1 != elmtLen0)
        return -1;

    }
    else
        return -1;



    if (!seqDone)
        return -1;

	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentCertificate*) CompAlloc( mem_op, sizeof(ComponentCertificate) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentCertificate ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentCertificate ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentCertificate;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = COMPOSITE_ASN1_TYPE;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentCertificate;
    (*bytesDecoded) += totalElmtsLen1;
	return LDAP_SUCCESS;
}  /* BDecCertificate*/

int
GDecComponentCertificate PARAMS (( mem_op,b, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
ComponentCertificate **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	char* peek_head,*peek_head2;
	int i, strLen,strLen2, rc, old_mode = mode;
	ComponentCertificate *k,*t, c_temp;


	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
	*bytesDecoded = 0;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading { in encoded data");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != '{'){
		Asn1Error("Missing { in encoded data");
		return LDAP_PROTOCOL_ERROR;
	}

	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	if ( strncmp( peek_head, "toBeSigned", strlen("toBeSigned") ) == 0 ) {
		rc = 	GDecComponentTBSCertificate (mem_op, b, (&k->toBeSigned), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	( k->toBeSigned)->identifier.bv_val = peek_head;
	( k->toBeSigned)->identifier.bv_len = strLen;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading , ");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != ','){
		Asn1Error("Missing , in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
	  Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	}
	if ( strncmp( peek_head, "signatureAlgorithm", strlen("signatureAlgorithm") ) == 0 ) {
		rc = 	GDecComponentAlgorithmIdentifier (mem_op, b, (&k->signatureAlgorithm), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	( k->signatureAlgorithm)->identifier.bv_val = peek_head;
	( k->signatureAlgorithm)->identifier.bv_len = strLen;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading , ");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != ','){
		Asn1Error("Missing , in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
	  Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	}
	if ( strncmp( peek_head, "signature", strlen("signature") ) == 0 ) {
		rc = 	GDecComponentBits (mem_op, b, (&k->signature), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	(&k->signature)->identifier.bv_val = peek_head;
	(&k->signature)->identifier.bv_len = strLen;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ) {
		Asn1Error("Error during Reading } in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != '}'){
		Asn1Error("Missing } in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentCertificate*) CompAlloc( mem_op, sizeof(ComponentCertificate) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentCertificate ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentCertificate ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentCertificate;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = COMPOSITE_ASN1_TYPE;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentCertificate;
	return LDAP_SUCCESS;
}  /* GDecCertificate*/


