/* Generic setproctitle.h */
/* $OpenLDAP: pkg/ldap/include/ac/setproctitle.h,v 1.5.8.1 1999/09/10 20:25:23 kdz Exp $ */
/*
 * Copyright 1998,1999 The OpenLDAP Foundation, Redwood City, California, USA
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted only
 * as authorized by the OpenLDAP Public License.  A copy of this
 * license is available at http://www.OpenLDAP.org/license.html or
 * in file LICENSE in the top-level directory of the distribution.
 */

#ifndef _AC_SETPROCTITLE_H
#define _AC_SETPROCTITLE_H

#ifdef LDAP_PROCTITLE

#if defined( HAVE_LIBUTIL_H )
#	include <libutil.h>
#else
	/* use lutil version */
	LDAP_F(void) (setproctitle) LDAP_P((const char *fmt, ...)) \
	                            LDAP_GCCATTR((format(printf, 1, 2)));
	LDAP_F(int) Argc;
	LDAP_F(char) **Argv;
#endif

#endif /* LDAP_PROCTITLE */
#endif /* _AC_SETPROCTITLE_H */
